<?php $__env->startSection('title', __('locale.Backups')); ?>

<?php $__env->startSection('page-style'); ?>
  <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/fonts/fontawesome.scss', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.scss']); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
  <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/sweetalert2/sweetalert2.js']); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

  <!-- Striped Rows -->
  <div class="card">
    <h5 class="card-header"><?php echo e(__('locale.Backups')); ?></h5>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('site_Settings-create')): ?>
      <div class="d-flex">
        <a style="display: none" href="<?php echo e(url('admin/backup-full')); ?>" class="btn btn-sm btn-danger mr-1 mb-1  confirm-text"><i
            class="icon-base ti tabler-server"></i> <?php echo e(__('locale.Backup Full Project')); ?></a>
        <a style="display: none" href="<?php echo e(url('admin/backup-files')); ?>"
          class="btn btn-sm btn-warning mr-1 mb-1  confirm-text"><i class="icon-base ti tabler-server"></i>
          <?php echo e(__('locale.Backup Files')); ?></a>
        <button type="button" data-id="<?php echo e(url('admin/backup-database')); ?>"
          class="btn btn-sm btn-primary mr-1 mb-1  confirm-text"><i class="icon-base ti tabler-server"></i>
          <?php echo e(__('locale.Backup Database')); ?></button>
      </div>
    <?php endif; ?>
    <div class="table-responsive text-nowrap">
      <table class="table table-striped table-bordered table-hover">
        <thead>
          <tr>
            <th valign="middle">#</th>
            <th><?php echo e(__('locale.Name')); ?></th>
            <th><?php echo e(__('locale.Size')); ?></th>
            <th><?php echo e(__('locale.Date')); ?></th>
            <th><?php echo e(__('locale.Actions')); ?></th>
          </tr>
        </thead>
        <tbody class="table-border-bottom-0">
          <?php foreach ($backups as $key => $value): ?>
          <tr class="item">
            <td class="col1"><?php echo e($key + 1); ?></td>
            <td><?php echo e($value['file_name']); ?></td>
            <td><?php echo e(number_format($value['file_size'] / 1024, 2)); ?> KB</td>
            <td> <?php echo e($value['last_modified']); ?> </td>
            <td>
              <ul class="actions" style="display:flex;align-items:center;">
                <li style="display:table-cell;list-style: none">

                </li>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('site_Settings-create')): ?>
                  <button href="#" data-id="<?php echo e(url('admin/download_backup')); ?>/<?php echo e($value['file_name']); ?>"
                    class="btn btn-primary btn-sm  download-confirm"><i class="icon-base ti tabler-download"></i>
                    <?php echo e(__('locale.Download Backup')); ?></button>
                <?php endif; ?>

              </ul>
            </td>
          </tr>
          <?php endforeach ?>
        </tbody>
      </table>
    </div>
  </div>
  <!--/ Striped Rows -->

<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-script'); ?>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    $(function() {
      $('.confirm-text').on('click', function() {
        const $btn = $(this);
        var url = $(this).attr('data-id');
        Swal.fire({
          title: 'Are you sure?',
          text: "Are you sure? This will take some time",
          icon: 'warning',
          showCancelButton: true,
          confirmButtonText: 'Yes!',
          customClass: {
            confirmButton: 'btn btn-primary me-3',
            cancelButton: 'btn btn-label-secondary'
          },
          buttonsStyling: false
        }).then(function(result) {
          if (result.value) {
            $.ajax({
              url: url,
              beforeSend: function() {
                toggleButtonLoading($btn, true, 'Processing...');
              },
              success: function(data) {
                toggleButtonLoading($btn, false);
                const toastType = data.status == 200 ? 'bg-success' : 'bg-warning';
                window.showToast({
                  title: 'Backups 🛢️',
                  message: data.message,
                  type: toastType,
                  animation: 'animate__fadeInUp',
                  time: 'Just now',
                  delay: 3000
                });
                if (data.status == 400) {
                  setTimeout(function() { // wait for 5 secs(2)
                    window.location.reload(true); // then reload the page.(3)
                  }, 5000);
                  $('.confirm-text').removeAttr('disabled');
                } else {
                  $('.hides').hide();
                  $('.confirm-text').removeAttr('disabled');
                }
              },
              error: function(data, e, ts, et) {
                toggleButtonLoading($btn, false);
                console.log(data);
              }
            });
          }
        })
      });
    });
    $(function() {
      $('.download-confirm').on('click', function(event) {
        event.preventDefault();
        const $btn = $(this);
        var url = $(this).attr('data-id');
        Swal.fire({
          title: 'Are you sure?',
          text: "",
          type: 'success',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Yes!',
          confirmButtonClass: 'btn btn-primary',
          cancelButtonClass: 'btn btn-danger ml-1',
          buttonsStyling: false,
        }).then(function(result) {
          if (result.value) {
            $.ajax({
              url: url,
              beforeSend: function() {
                toggleButtonLoading($btn, true, 'Downloading...');
              },
              success: function() {
                toggleButtonLoading($btn, false);
                window.open(url, '_blank');
                window.showToast({
                  title: 'Backups 🛢️',
                  message: 'Download done successfully',
                  type: 'bg-success',
                  animation: 'animate__fadeInUp',
                  time: 'Just now',
                  delay: 3000
                });
              },
              error: function(data, e, ts, et) {
                console.log(data);
              }
            });
          }
        })
      });
    });
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/intellisensetech/public_html/topsyapp/resources/views/common/backups.blade.php ENDPATH**/ ?>