   <?php echo $__env->make('frontend.includes.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
   <!-- ========= Main Banner ======= -->
   <section id="main-banner">
     <?php
       $settings = \App\Models\Setting::whereIn('meta_key', [
           'driver_android_app_link',
           'driver_ios_app_link',
           'customer_android_app_link',
           'customer_ios_app_link',
       ])->pluck('meta_value', 'meta_key');
     ?>
     <div class="container">
       <div class="row">
         <div class="col-lg-8 offset-lg-2">
           <div class="main-banner-content wow fadeInLeft">
             <h1>Whatever You Need, <span>Delivered in Minutes.
               </span></h1>
             <p>From rides and food to groceries, medicines, and more — our app brings everything you need right to your
               doorstep. We’re here to make your everyday life simpler, faster, and stress-free. With just a few taps,
               enjoy quick, reliable deliveries and seamless service that fits your lifestyle. Because we don’t just
               deliver products — we deliver convenience.
             </p>
             <ul>
               <li><a href="<?php echo e($settings['customer_android_app_link']); ?>"><img
                     src="<?php echo e(asset('frontend/assets/img/google-play.png')); ?>" class="img-fluid"></a>
               </li>
               <li><a href="<?php echo e($settings['driver_ios_app_link']); ?>"><img
                     src="<?php echo e(asset('frontend/assets/img/app-store.png')); ?>" class="img-fluid"></a>
               </li>
             </ul>
           </div>
         </div>
       </div>
   </section>


   <!-- ========= About Us ======= -->
   <section id="aboutus-section">
     <div class="container">
       <div class="row">
         <div class="col-lg-6 col-sm-12">
           <div class="abt-img wow fadeInLeft">
             <img src="<?php echo e(asset('frontend/assets/img/abt-img.png')); ?>" class="img-fluid">
           </div>
         </div>
         <div class="col-lg-6 col-sm-12">
           <div class="abt-text-list wow fadeInRight">
             <h2>We Deliver Convenience — <span>Right to Your Doorstep.</span></h2>
             <p>We’re more than just a delivery app — we’re your city’s convenience partner.
               From booking rides to ordering food, groceries, medicines, and even sending parcels — we bring everything
               you need right to your doorstep, on time and with care.
             </p>
             <p>Our mission is simple: to make daily life easier, faster, and stress-free. Whether it’s a last-minute
               grocery run, a quick ride across town, or late-night food cravings, our app connects you with trusted
               drivers, riders, and local stores — all in one seamless platform.
             </p>

             <div class="read-more-btn">
               <a href="<?php echo e(url('about-us')); ?>" class="hvr-shutter-out-horizontal btn">Read More</a>
             </div>
           </div>
         </div>
       </div>
     </div>
   </section>


   <!-- ========= Our Categories ======= -->
   <section id="categories">
     <div class="container">
       <div class="row">
         <div class="col-lg-12">
           <div class="section-title mb-4 wow fadeInUp">
             <span>Awesome</span>
             <h2>OUR <span>CATEGORIES</span></h2>
           </div>
         </div>
       </div>
       <div class="row">
         <div class="col-lg-4 col-sm-6">
           <div class="categories-box wow fadeInUp">
             <div class="cat-info">
               <img src="<?php echo e(asset('frontend/assets/img/cat-1.png')); ?>" class="img-fluid" alt="categories">
               <h4>Book Rides</h4>
               <p>Need to get somewhere quickly? Book a ride in seconds! Enjoy safe, affordable, and comfortable trips
                 with trusted drivers — anytime, anywhere.
               </p>
             </div>
           </div>
         </div>
         <div class="col-lg-4 col-sm-6">
           <div class="categories-box wow fadeInUp">
             <div class="cat-info">
               <img src="<?php echo e(asset('frontend/assets/img/cat-2.png')); ?>" class="img-fluid" alt="categories">
               <h4>Food</h4>
               <p>Craving something delicious? From street food to fine dining, order your favorite meals from top
                 restaurants and get them delivered fresh and hot to your doorstep.
               </p>
             </div>
           </div>
         </div>
         <div class="col-lg-4 col-sm-6">
           <div class="categories-box wow fadeInUp">
             <div class="cat-info">
               <img src="<?php echo e(asset('frontend/assets/img/cat-3.png')); ?>" class="img-fluid" alt="categories">
               <h4>Medicine</h4>
               <p>Running low on essentials? Order medicines and health products with ease. Fast, reliable delivery to
                 keep your wellness uninterrupted.
               </p>
             </div>
           </div>
         </div>
         <div class="col-lg-4 col-sm-6">
           <div class="categories-box wow fadeInUp">
             <div class="cat-info">
               <img src="<?php echo e(asset('frontend/assets/img/cat-4.png')); ?>" class="img-fluid" alt="categories">
               <h4>Alcohol</h4>
               <p>Hosting a party or just want to unwind? Get your favorite drinks delivered to your home safely and
                 conveniently — no last-minute store runs needed.
               </p>
             </div>
           </div>
         </div>
         <div class="col-lg-4 col-sm-6">
           <div class="categories-box wow fadeInUp">
             <div class="cat-info">
               <img src="<?php echo e(asset('frontend/assets/img/cat-5.png')); ?>" class="img-fluid" alt="categories">
               <h4>Grocery</h4>
               <p>Skip the queues! Shop all your daily groceries and household needs with a few taps. Fresh produce,
                 snacks, and essentials delivered straight to you.
               </p>
             </div>
           </div>
         </div>
         <div class="col-lg-4 col-sm-6">
           <div class="categories-box wow fadeInUp">
             <div class="cat-info">
               <img src="<?php echo e(asset('frontend/assets/img/cat-6.png')); ?>" class="img-fluid" alt="categories">
               <h4>Parcel</h4>
               <p>Need to send something across town? Our parcel service ensures your packages are picked up and
                 delivered safely, quickly, and hassle-free.
               </p>
             </div>
           </div>
         </div>
       </div>
     </div>
   </section>

   <!-- ========= Download App ======= -->
   <section id="download-app">
     <div class="container">
       <div class="row">
         <div class="col-lg-6 col-sm-12">
           <div class="user-app-background wow fadeInLeft">
             <span>User App</span>
             <h2>Download <br><span><?php echo e(config('app.name')); ?> User</span> App</h2>
             <p>Download the User App and get everything delivered in minutes! From booking rides to ordering food,
               groceries, and medicines — manage it all in one place. Real-time tracking, quick payments, and effortless
               convenience right at your fingertips.
             </p>
             <ul>
               <li><a href="<?php echo e($settings['customer_android_app_link']); ?>" target="_blank"><img
                     src="<?php echo e(asset('frontend/assets/img/google-play.png')); ?>" class="img-fluid"></a></li>
               <li><a href="<?php echo e($settings['customer_ios_app_link']); ?>" target="_blank"><img
                     src="<?php echo e(asset('frontend/assets/img/app-store.png')); ?>" class="img-fluid"></a>
               </li>
             </ul>
           </div>
         </div>
         <div class="col-lg-6 col-sm-12">
           <div class="driver-app-background wow fadeInRight">
             <span>Driver App</span>
             <h2>Download <br><span><?php echo e(config('app.name')); ?> Driver</span> App</h2>
             <p>Download the Driver App and start earning today! Accept ride and delivery requests instantly, track
               routes easily, and enjoy fast payments. Flexible hours, more freedom, and steady income all in one
               powerful app built for drivers.
             </p>
             <ul>
               <li><a href="<?php echo e($settings['driver_android_app_link']); ?>" target="_blank"><img
                     src="<?php echo e(asset('frontend/assets/img/google-play.png')); ?>" class="img-fluid"></a></li>
               <li><a href="<?php echo e($settings['driver_ios_app_link']); ?>" target="_blank"><img
                     src="<?php echo e(asset('frontend/assets/img/app-store.png')); ?>" class="img-fluid"></a>
               </li>
             </ul>
           </div>
         </div>
       </div>
     </div>
   </section>


   <!-- ========= App Features ======= -->
   <section id="app-features">
     <div class="container">
       <div class="row">
         <div class="col-lg-12">
           <div class="section-title mb-4 wow fadeInUp">
             <span>Our Service</span>
             <h2>APP <span>FEATURES</span></h2>
           </div>
         </div>
       </div>
       <div class="row">
         <div class="col-lg-12">
           <div class="app-feature-list wow fadeInUp">
             <div id="myCarousel" class="owl-carousel owl-theme">
               <div class="item">
                 <div class="feature-item">
                   <img src="<?php echo e(asset('frontend/assets/img/feature-1.png')); ?>" class="img-fluid" alt="App Feature">
                   <h4>Easy to Use</h4>
                   <p>A simple, intuitive interface that lets you book rides or place orders in just a few taps.
                   </p>
                 </div>
               </div>
               <div class="item">
                 <div class="feature-item">
                   <img src="<?php echo e(asset('frontend/assets/img/feature-2.png')); ?>" class="img-fluid" alt="App Feature">
                   <h4>Professional Drivers</h4>
                   <p>Ride with experienced, well-trained drivers who value your safety and comfort.
                   </p>
                 </div>
               </div>
               <div class="item">
                 <div class="feature-item">
                   <img src="<?php echo e(asset('frontend/assets/img/feature-3.png')); ?>" class="img-fluid" alt="App Feature">
                   <h4>Secure Payments</h4>
                   <p>Enjoy hassle-free, encrypted transactions with multiple trusted payment options.
                   </p>
                 </div>
               </div>
               <div class="item">
                 <div class="feature-item">
                   <img src="<?php echo e(asset('frontend/assets/img/feature-5.png')); ?>" class="img-fluid" alt="App Feature">
                   <h4>Real-Time Tracking</h4>
                   <p>Track your driver or delivery live — from pickup to drop-off, stay updated every second.
                   </p>
                 </div>
               </div>
               <div class="item">
                 <div class="feature-item">
                   <img src="<?php echo e(asset('frontend/assets/img/feature-8.png')); ?>" class="img-fluid" alt="App Feature">
                   <h4>Customize Orders</h4>
                   <p>Add special instructions or preferences to make every delivery or ride fit your needs.
                   </p>
                 </div>
               </div>
               <div class="item">
                 <div class="feature-item">
                   <img src="<?php echo e(asset('frontend/assets/img/feature-6.png')); ?>" class="img-fluid" alt="App Feature">
                   <h4>Ratings & Reviews
                   </h4>
                   <p>Share your experience and check driver or vendor ratings before you book or order.
                   </p>
                 </div>
               </div>



             </div>
           </div>
         </div>
       </div>
     </div>
   </section>
   <?php echo $__env->make('frontend.includes.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home/intellisensetech/public_html/topsyapp/resources/views//frontend/index.blade.php ENDPATH**/ ?>