<?php $__env->startSection('title', __('locale.Order Details')); ?>

<?php $__env->startSection('vendor-style'); ?>
  <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/css/datatables.scss', 'resources/assets/vendor/libs/raty-js/raty-js.scss', 'resources/assets/vendor/scss/pages/app-invoice.scss']); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
  <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/js/datatables.js', 'resources/assets/vendor/libs/raty-js/raty-js.js', 'resources/assets/js/star-ratings.js']); ?>
<?php $__env->stopSection(); ?>
<style>
  .raty img {
    display: inline-block;
    vertical-align: middle;
    block-size: 1.2rem !important;
    font-size: 1.2rem !important;
    inline-size: 1.2rem !important;
  }

  .raty {
    display: inline-flex;
    align-items: center;
    gap: 0px !important;
  }
</style>
<style>
  @media print {
    #invoiceContent {
      width: 100%;
      padding: 0;
      margin: 0;
    }

    /* Force two columns side by side */
    #invoiceContent .col-xl-6,
    #invoiceContent .col-md-6 {
      width: 50% !important;
      flex: 0 0 50% !important;
      max-width: 50% !important;
      display: inline-block !important;
      vertical-align: top !important;
    }

    /* Fix row */
    #invoiceContent .row {
      display: flex !important;
      flex-wrap: nowrap !important;
      margin: 0 !important;
    }

    /* Hide buttons */
    .btn,
    .no-print {
      display: none !important;
    }
  }
</style>

<?php $__env->startSection('content'); ?>
  <?php
    $currency = $order->currency ?? Helper::setting('currency_symbol', 'currency');
  ?>
  <div
    class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-6 row-gap-4">
    <div class="d-flex flex-column justify-content-center">
      <div class="mb-1"><span class="h5"><?php echo e(__('locale.Order')); ?>

          #<?php echo e($order->order_id); ?> </span><span class="badge bg-label-success me-1 ms-2"><?php echo e($order->payment_status); ?></span>
        <span class="badge bg-label-info" id="orderStatus"><?php echo e($order->status); ?></span>
      </div>
      <p class="mb-0"><?php echo e($order->created_at->format('d, M')); ?><span id="orderYear">
          <?php echo e($order->created_at->format('Y')); ?></span>, <?php echo e($order->created_at->format('h:i A')); ?></p>
      <div class="read-only-ratings raty" data-read-only="true" data-score="<?php echo e($order->rating ?? 0); ?>" data-number="5">
      </div>
    </div>
    <div class="d-flex align-content-center flex-wrap gap-2">
      <div class="btn-group" id="dropdown-wrapper-<?php echo e($order->id); ?>">
        <button type="button" class="btn btn-primary" id="newStatus"><?php echo e($order->status ?? 'Placed'); ?></button>
        <?php if($order->status === 'Delivered'): ?>
        <?php else: ?>
          <button type="button" class="btn btn-primary dropdown-toggle dropdown-toggle-split" data-bs-toggle="dropdown"
            aria-expanded="false">
            <span class="visually-hidden">Toggle Dropdown</span>
          </button>
          <ul class="dropdown-menu">
            <?php

              $allStatuses = [
                  'Placed',
                  'Accepted',
                  'Preparing',
                  'Ready',
                  'Dispatched',
                  'Out for Delivery',
                  'Delivered',
                  'Cancelled',
              ];
              $performedStatuses = array_unique(array_merge(['Placed'], $performedStatuses));
            ?>

            <?php
              $nextStatus = null;
              foreach ($allStatuses as $status) {
                  // Hide Delivered if order has a ride
                  if ($status === 'Delivered' && $order->ride) {
                      continue;
                  }
                  // Hide Cancelled if Accepted already performed
                  if ($status === 'Cancelled' && in_array('Accepted', $performedStatuses)) {
                      continue;
                  }
                  // Skip already performed statuses
                  if (in_array($status, $performedStatuses)) {
                      continue;
                  }
                  // First valid next status
                  $nextStatus = $status;
                  break;
              }
            ?>
            <?php if($nextStatus): ?>
              <li>
                <a class="dropdown-item change-order-status" href="javascript:void(0);" data-id="<?php echo e($order->id); ?>"
                  data-status="<?php echo e($nextStatus); ?>">
                  <?php echo e($nextStatus); ?>

                </a>
              </li>
            <?php endif; ?>

          </ul>
        <?php endif; ?>

      </div>

    </div>
  </div>

  <!-- Order Details Table -->

  <div class="row">
    <div class="col-12 col-lg-8">
      <div class="card mb-6">
        <div class="card-datatable">
          <table class="datatables-order-details table mb-0">
            <thead>
              <tr>

                <th><?php echo e(__('Image')); ?></th>
                <th class="w-50"><?php echo e(__('locale.Products')); ?></th>
                <th class="w-25"><?php echo e(__('locale.Price')); ?></th>
                <th class="w-25"><?php echo e(__('locale.Qty')); ?></th>
                <th><?php echo e(__('locale.Total')); ?></th>
              </tr>
            </thead>
            <tbody>
              <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>

                  <td>
                    <div class="d-flex justify-content-start align-items-center mb-6"> <?php $img=$item->product?->image?->file ?? ''; ?>
                      <img src="<?php echo e(url('storage/' . $img)); ?>" style="width:35px; height:35px" alt="Avatar"
                        class="me-1"
                        onerror="this.onerror=null;this.src='<?php echo e(asset('assets/img/placeholder.jpg')); ?>';" />

                    </div>
                  </td>
                  <td class="w-50">
                    <?php echo e($item->name ?? 'N/A'); ?>

                  </td>
                  <td class="w-25"><?php echo e($currency); ?><?php echo e(number_format($item->price, 2)); ?></td>
                  <td class="w-25"><?php echo e($item->quantity); ?></td>
                  <td><?php echo e($currency); ?><?php echo e(number_format($item->price * $item->quantity, 2)); ?></td>
                </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
          </table>

          <div class="d-flex justify-content-end align-items-center m-6 mb-2">
            <div class="order-calculations">
              <div class="d-flex justify-content-start mb-2">
                <span class="w-px-100 text-heading"><?php echo e(__('locale.Subtotal')); ?>:</span>
                <h6 class="mb-0"><?php echo e($currency); ?><?php echo e(number_format($order->subtotal, 2)); ?></h6>
              </div>
              <div class="d-flex justify-content-start mb-2">
                <span class="w-px-100 text-heading"><?php echo e(__('locale.Discount')); ?>:</span>
                <h6 class="mb-0 text-primary"><?php echo e($currency); ?><?php echo e(number_format($order->discount ?? 0, 2)); ?></h6>
              </div>
              <div class="d-flex justify-content-start mb-2">
                <span class="w-px-100 text-heading"><?php echo e(__('locale.Shipping')); ?>:</span>
                <h6 class="mb-0 text-success"><?php echo e($currency); ?><?php echo e(number_format($order->shipping ?? 0, 2)); ?>

                </h6>
              </div>
              <div class="d-flex justify-content-start mb-2">
                <span class="w-px-100 text-heading"><?php echo e(__('locale.Tax')); ?>:</span>
                <h6 class="mb-0 text-success"><?php echo e($currency); ?><?php echo e(number_format($order->tax ?? 0, 2)); ?></h6>
              </div>
              <div class="d-flex justify-content-start">
                <h6 class="w-px-100 mb-0"><?php echo e(__('locale.Total')); ?>:</h6>
                <h6 class="mb-0"><?php echo e($currency); ?><?php echo e(number_format($order->grand_total, 2)); ?></h6>
              </div>
            </div>
          </div>
        </div>

      </div>
      <div class="card mb-6">
        <div class="card-header">
          <h5 class="card-title m-0"><?php echo e(__('locale.Shipping Activity')); ?></h5>
        </div>
        <div class="card-body pt-1">
          <ul class="timeline pb-0 mb-0">
            <?php $__empty_1 = true; $__currentLoopData = $order->statusLogs->sortBy('created_at'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
              <li
                class="timeline-item timeline-item-transparent <?php echo e($loop->last ? 'border-transparent pb-0' : 'border-primary'); ?>">
                <span
                  class="timeline-point <?php echo e($loop->last ? 'timeline-point-secondary' : 'timeline-point-primary'); ?>"></span>
                <div class="timeline-event <?php echo e($loop->last ? 'pb-0' : ''); ?>">
                  <div class="timeline-header">
                    <h6 class="mb-0 text-capitalize"><?php echo e(str_replace('_', ' ', $log->status)); ?></h6>
                    <small class="text-body-secondary">
                      <?php echo e($log->created_at->format('l h:i A')); ?>

                    </small>
                  </div>
                  <p class="mt-3 mb-0">
                    <?php echo e(Helper::getStatusMessage($log->status)); ?>

                  </p>
                </div>
              </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
              <li class="timeline-item timeline-item-transparent border-transparent pb-0">
                <span class="timeline-point timeline-point-secondary"></span>
                <div class="timeline-event pb-0">
                  <div class="timeline-header">
                    <h6 class="mb-0"><?php echo e(__('locale.No Status Updates')); ?></h6>
                  </div>
                </div>
              </li>
            <?php endif; ?>
          </ul>
        </div>
      </div>

    </div>
    <div class="col-12 col-lg-4">
      <?php if(
          $order->status == 'Ready' ||
              $order->status == 'Dispatched' ||
              $order->status == 'Out for Delivery' ||
              $order->status == 'Delivered'): ?>
        <!-- Invoice Actions -->
        <div class="col-xl-12 col-md-12 col-12 mb-4 invoice-actions">
          <div class="card">
            <div class="card-body">
              <button class="btn btn-primary d-grid w-100 mb-4" data-bs-toggle="offcanvas"
                data-bs-target="#sendInvoiceOffcanvas">
                <span class="d-flex align-items-center justify-content-center text-nowrap"><i
                    class="icon-base ti tabler-send icon-xs me-2"></i>Send Invoice</span>
              </button>
              <button class="btn btn-label-info d-grid w-100 mb-4" id="downloadInvoiceBtn"> <span
                  class="d-flex align-items-center justify-content-center text-nowrap"><i
                    class="icon-base ti tabler-download icon-xs me-2"></i>Download</span></button>
              <div class="d-flex mb-0">
                <button class="btn btn-label-warning d-grid w-100 mb-4" id="printInvoiceBtn">
                  <span class="d-flex align-items-center justify-content-center text-nowrap"> <i
                      class="icon-base ti tabler-printer icon-xs me-2"></i>Print </span></button>
              </div>
            </div>
          </div>
        </div>
      <?php endif; ?>
      <!-- /Invoice Actions -->
      <?php if(auth()->user()->user_type != 'Store'): ?>
        <div class="card mb-6">
          <div class="card-header">
            <h5 class="card-title m-0"><i class="icon-base ti tabler-building-warehouse icon-lg"></i>
              <?php echo e(__('locale.Store Details')); ?>

            </h5>
          </div>
          <div class="card-body">
            <div class="d-flex justify-content-start align-items-center mb-2">
              <div class="d-flex flex-column">
                <span class="h5 mb-1 text-primary"><?php echo e($order->store->user->name); ?> </span>
                <p class="mb-0"><?php echo e($order->store->address); ?>, <?php echo e($order->store->city); ?></p>
              </div>
            </div>

            <div class="d-flex justify-content-between">
              <h6 class="mb-1"><?php echo e(__('locale.Contact info')); ?></h6>
            </div>

            <p class="mb-1"><?php echo e(__('locale.Email')); ?>: <?php echo e($order->store?->user?->email ?? 'N/A'); ?></p>
            <p class="mb-0"><?php echo e(__('locale.Phone')); ?>:
              <?php echo e($order->store?->user?->dial_code ?? 'N/A'); ?><?php echo e($order->store?->user?->phone ?? 'N/A'); ?></p>
          </div>

        </div>
      <?php endif; ?>
      <div class="card mb-6">
        <div class="card-header">
          <h5 class="card-title m-0"><i class="icon-base ti tabler-user icon-lg"></i>
            <?php echo e(__('locale.Customer details')); ?>

          </h5>
        </div>
        <div class="card-body">
          <div class="d-flex justify-content-start align-items-center mb-6">
            <div class="avatar me-3">
              <img
                src="<?php echo e($order->user->profile_photo_path ? asset('storage/' . $order->user->profile_photo_path) : asset('assets/img/placeholder.jpg')); ?>"
                alt="Avatar" class="rounded-circle"
                onerror="this.onerror=null;this.src='<?php echo e(asset('assets/img/placeholder.jpg')); ?>';" />
            </div>
            <div class="d-flex flex-column">
              <a href="<?php echo e(url('users/' . $order->user->id)); ?>" class="text-body text-nowrap">
                <h6 class="mb-0"><?php echo e($order->user->name ?? 'N/A'); ?></h6>
              </a>
              <span><?php echo e(__('locale.Customer ID')); ?>: #<?php echo e($order->user->id); ?></span>
            </div>
          </div>

          <div class="d-flex justify-content-between">
            <h6 class="mb-1"><?php echo e(__('locale.Contact info')); ?></h6>
          </div>

          <p class="mb-1"><?php echo e(__('locale.Email')); ?>: <?php echo e($order->user->email ?? 'N/A'); ?></p>
          <p class="mb-0"><?php echo e(__('locale.Phone')); ?>: <?php echo e($order->user->phone ?? 'N/A'); ?></p>
        </div>

      </div>

      <?php
        $address = is_array($order->address) ? $order->address : json_decode($order->address, true);
      ?>


      <div class="card mb-6">
        <div class="card-header d-flex justify-content-between">
          <h5 class="card-title m-0"> <i class="icon-base ti tabler-address-book icon-lg"></i>
            <?php echo e(__('locale.Shipping Address')); ?></h5>
          <h6 class="m-0">
          </h6>
        </div>
        <div class="card-body">
          <?php if(!empty($address)): ?>
            <p class="mb-0">
              <?php echo e($address['name'] ?? ''); ?><br />
              <?php echo e($address['address'] ?? ''); ?><br />
              <?php echo e($address['city'] ?? ''); ?> - <?php echo e($address['postcode'] ?? ''); ?><br />
              <?php echo e($address['state'] ?? ''); ?><br />
              <?php echo e($address['country'] ?? ''); ?>

            </p>
          <?php else: ?>
            <p class="mb-0 text-muted"><?php echo e(__('locale.No address available.')); ?></p>
          <?php endif; ?>
        </div>
      </div>
      <div class="card mb-6">
        <div class="card-header d-flex justify-content-between">
          <h5 class="card-title m-0"> <i class="icon-base ti tabler-credit-card-pay icon-lg"></i>
            <?php echo e(__('locale.Platform Commission')); ?></h5>
        </div>

        <div class="card-body">
          <h4 class="badge bg-label-info mb-4"><?php echo e($order->currency); ?> <?php echo e($order->platform_commission); ?></h4>

        </div>

      </div>

      <div class="card mb-6">
        <div class="card-header d-flex justify-content-between">
          <h5 class="card-title m-0"> <i class="icon-base ti tabler-credit-card-pay icon-lg"></i>
            <?php echo e(__('locale.Payment Details')); ?></h5>
        </div>

        <div class="card-body">
          <h4 class="badge bg-label-info mb-4"><?php echo e(__('locale.Payment Type')); ?>: <?php echo e($order->payment_type); ?></h4>
          <?php if($order->transaction): ?>
            <p class="mb-2"><?php echo e(__('locale.Txn ID')); ?>: <?php echo e($order->transaction->txn_id ?? 'N/A'); ?></p>
            <p class="mb-2"><?php echo e(__('locale.Payment Type')); ?>: <?php echo e($order->transaction->payment_mode ?? 'N/A'); ?></p>
            <p class="mb-0"><?php echo e(__('locale.Amount')); ?>:
              <?php echo e($order->transaction->currency ?? $currency); ?><?php echo e($order->transaction->amount ?? 0); ?></p>
          <?php endif; ?>
        </div>

      </div>



    </div>
  </div>
  <div class="row invoice-preview d-none" id="invoiceContent">
    <?php echo $__env->make('store.orders.invoice', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
  </div>
  <?php echo $__env->make('_partials/_offcanvas/offcanvas-send-invoice', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
  <!-- Modals -->

<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-script'); ?>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    $(document).on('click', '.change-order-status', function() {
      let orderId = $(this).data('id');
      let status = $(this).data('status');

      $.ajax({
        url: `${baseURL}/orders/${orderId}/status`,
        method: 'POST',
        data: {
          _token: '<?php echo e(csrf_token()); ?>',
          status: status
        },
        success: function(data) {
          const toastType = data.status == 200 ? 'bg-success' : 'bg-warning';
          window.showToast({
            title: 'Orders 🛒',
            message: data.message,
            type: toastType,
            animation: 'animate__fadeInUp',
            time: 'Just now',
            delay: 3000
          });
          if (Array.isArray(data.data[0])) {
            let performedStatuses = data.data[0];
            // Always include "Placed" as performed
            performedStatuses = Array.from(new Set(['Placed', ...performedStatuses]));

            const allStatuses = ['Placed', 'Accepted', 'Preparing', 'Ready', 'Dispatched', 'Out for Delivery',
              'Delivered', 'Cancelled'
            ];
            const newDropdown = allStatuses
              .filter(s => {
                // Hide Delivered if order has a ride
                if (s === 'Delivered' && data.order && data.order.ride) {
                  return false;
                }
                // Hide Cancelled if Accepted already performed
                if (s === 'Cancelled' && performedStatuses.includes('Accepted')) {
                  return false;
                }
                // Hide statuses already performed
                return !performedStatuses.includes(s);
              })
              .slice(0, 1) // keep only the first valid one o show only next status
              .map(s =>
                `<li><a class="dropdown-item change-order-status" href="javascript:void(0);" data-id="${orderId}" data-status="${s}">${s}</a></li>`
              )
              .join('');
            $(`#dropdown-wrapper-${orderId} .dropdown-menu`).html(newDropdown);
            $('#newStatus').text(status);
            $('#orderStatus').text(status);
          }
        },
        error: function(xhr) {
          console.log(xhr.responseJSON);
        }
      });
    });
  </script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
  <script src="https://html2canvas.hertzen.com/dist/html2canvas.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.9.2/html2pdf.bundle.min.js"></script>

  <script>
    document.getElementById('printInvoiceBtn').addEventListener('click', function() {
      const invoice = document.getElementById('invoiceContent').outerHTML;

      // Open a new temporary window
      const printWindow = window.open('', '_blank', 'width=1000,height=800');

      printWindow.document.write(`
    <html>
      <head>
        <title>Invoice</title>
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
        <style>
          body { margin: 20px; }
          .d-none { display: block !important; } /* make sure hidden invoice shows */
          @media print {
            .btn, .no-print { display: none !important; }
            /* Keep Invoice To / Bill To side by side */
            .row > .col-xl-6, .row > .col-md-6 {
              width: 50% !important;
              flex: 0 0 50% !important;
              max-width: 50% !important;
              display: inline-block !important;
              vertical-align: top !important;
            }
            .row {
              display: flex !important;
              flex-wrap: nowrap !important;
              margin: 0 !important;
            }
          }
        </style>
      </head>
      <body>
        ${invoice}
      </body>
    </html>
  `);

      printWindow.document.close();

      // Wait until content is fully loaded
      printWindow.onload = function() {
        printWindow.focus();
        printWindow.print();
        printWindow.close();
      };
    });

    // Download Invoice as PDF
    document.getElementById('downloadInvoiceBtn').addEventListener('click', async function() {
      const {
        jsPDF
      } = window.jspdf;
      const invoice = document.getElementById('invoiceContent');

      // Make hidden content visible for canvas capture
      invoice.classList.remove('d-none');

      // Capture invoice as canvas
      const canvas = await html2canvas(invoice, {
        scale: 2, // higher scale = better quality
        useCORS: true,
      });

      const imgData = canvas.toDataURL('image/png');
      const pdf = new jsPDF('p', 'mm', 'a4');
      const pdfWidth = pdf.internal.pageSize.getWidth();
      const pdfHeight = (canvas.height * pdfWidth) / canvas.width;

      pdf.addImage(imgData, 'PNG', 0, 0, pdfWidth, pdfHeight);
      pdf.save('invoice.pdf');

      // Hide invoice again
      invoice.classList.add('d-none');
    });




    document.addEventListener('DOMContentLoaded', function() {
      const sendInvoiceForm = document.getElementById('sendInvoiceForm');
      const offcanvas = document.getElementById('sendInvoiceOffcanvas');

      // Fill "To", subject and message dynamically
      offcanvas.addEventListener('show.bs.offcanvas', function() {
        const userEmail = '<?php echo e($order->user->email); ?>';
        const orderId = '<?php echo e($order->order_id); ?>';
        const totalAmount = '<?php echo e($currency); ?><?php echo e(number_format($order->grand_total, 2)); ?>';
        const customerName = '<?php echo e($order->user->name); ?>';

        document.getElementById('invoice-to').value = userEmail;

        document.getElementById('invoice-message').value =
          `Dear ${customerName},\n\n` +
          `Thank you for your order (ID: ${orderId}). We truly appreciate your business.\n` +
          `Please find your invoice for the total amount of ${totalAmount} attached.\n\n` +
          `Thank you for choosing us!`;

        document.getElementById('invoice-subject').value =
          `Invoice for Order #${orderId} - ${customerName} - Amount: ${totalAmount}`;
      });
      $(document).on('click', '#sendInvoiceForm button[type="submit"]', function() {
        $btn = $(this);
      });
      sendInvoiceForm.addEventListener('submit', async function(e) {
        e.preventDefault();
        toggleButtonLoading($btn, true, 'Sending...');
        try {
          const invoiceElement = document.getElementById('invoiceContent');
          invoiceElement.classList.remove('d-none');
          invoiceElement.style.display = 'block';
          // Generate PDF using html2pdf.js
          const opt = {
            margin: 5,
            filename: `invoice-<?php echo e($order->order_id); ?>.pdf`,
            image: {
              type: 'jpeg',
              quality: 0.98
            },
            html2canvas: {
              scale: 2
            },
            jsPDF: {
              unit: 'mm',
              format: 'a4',
              orientation: 'p'
            }
          };

          const pdfBlob = await html2pdf().set(opt).from(invoiceElement).outputPdf('blob');

          // Prepare form data
          const formData = new FormData();
          formData.append('_token', document.querySelector('meta[name="csrf-token"]').getAttribute('content'));
          formData.append('to', document.getElementById('invoice-to').value);
          formData.append('subject', document.getElementById('invoice-subject').value);
          formData.append('message', document.getElementById('invoice-message').value);
          formData.append('file', pdfBlob, `invoice-<?php echo e($order->order_id); ?>.pdf`);

          // Send invoice via fetch
          const res = await fetch(`${baseURL}/send-invoice`, {
            method: 'POST',
            body: formData
          });

          const data = await res.json();
          toggleButtonLoading($btn, false);
          const toastType = data.status === 200 ? 'bg-success' : 'bg-warning';
          window.showToast({
            title: 'Order Invoice 🛒',
            message: data.message,
            type: toastType,
            animation: 'animate__fadeInUp',
            time: 'Just now',
            delay: 3000
          });

          const offcanvasInstance = bootstrap.Offcanvas.getInstance(offcanvas);
          offcanvasInstance.hide();

        } catch (err) {
          toggleButtonLoading($btn, false);
          console.error('Invoice PDF generation/send error:', err);
          window.showToast({
            title: 'Order Invoice 🛒',
            message: 'Invoice PDF generation/send error:',
            type: 'bg-danger',
            animation: 'animate__fadeInUp',
            time: 'Just now',
            delay: 3000
          });
        }
      });
    });
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/intellisensetech/public_html/topsyapp/resources/views//store/orders/show.blade.php ENDPATH**/ ?>