<?php
  use Illuminate\Support\Facades\Auth;
  use Illuminate\Support\Facades\Route;
?>

<!--  Brand demo (display only for navbar-full and hide on below xl) -->
<?php if(isset($navbarFull)): ?>
  <div class="navbar-brand app-brand demo d-none d-xl-flex py-0 me-4 ms-0">
    <a href="<?php echo e(url('/')); ?>" class="app-brand-link">
      <span class="app-brand-logo demo"><?php echo $__env->make('_partials.macros', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?></span>
      <span class="app-brand-text demo menu-text fw-bold"><?php echo e(config('app.name')); ?></span>
    </a>

    <!-- Display menu close icon only for horizontal-menu with navbar-full -->
    <?php if(isset($menuHorizontal)): ?>
      <a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large ms-auto d-xl-none">
        <i class="icon-base ti tabler-x icon-sm d-flex align-items-center justify-content-center"></i>
      </a>
    <?php endif; ?>
  </div>
<?php endif; ?>

<!-- ! Not required for layout-without-menu -->
<?php if(!isset($navbarHideToggle)): ?>
  <div
    class="layout-menu-toggle navbar-nav align-items-xl-center me-4 me-xl-0<?php echo e(isset($menuHorizontal) ? ' d-xl-none ' : ''); ?> <?php echo e(isset($contentNavbar) ? ' d-xl-none ' : ''); ?>">
    <a class="nav-item nav-link px-0 me-xl-6" href="javascript:void(0)">
      <i class="icon-base ti tabler-menu-2 icon-md"></i>
    </a>
  </div>
<?php endif; ?>

<div class="navbar-nav-right d-flex align-items-center justify-content-end" id="navbar-collapse">
  <?php if(auth()->user()->user_type == 'Store'): ?>
    <?php $store=\App\Models\Store::where('user_id',auth()->id())->first(); ?>
    <label class="switch switch-square switch-lg">
      <input type="checkbox" class="switch-input changestatus" data-id="<?php echo e($store->id); ?>"
        data-status="<?php echo e($store->is_active); ?>" data-url="<?php echo e(url('store/store-status')); ?>"
        <?php if($store->is_active == 1): ?> checked <?php endif; ?>>
      <span class="switch-toggle-slider">
        <span class="switch-on">
          <i class="icon-base ti tabler-check"></i>
        </span>
        <span class="switch-off">
          <i class="icon-base ti tabler-x"></i>
        </span>
      </span>
      <span class="switch-label"
        title="<?php if($store->is_active == 1): ?> Accepting Order <?php else: ?> Not Accepting Order <?php endif; ?>">
        <?php if($store->is_active == 1): ?>
          <?php echo e(__('locale.Online')); ?>

        <?php else: ?>
          <?php echo e(__('locale.Offline')); ?>

        <?php endif; ?>
      </span>
    </label>


  <?php endif; ?>
  <ul class="navbar-nav flex-row align-items-center ms-md-auto">
    <!-- Language -->
    <li class="nav-item dropdown-language dropdown">
      <a class="nav-link dropdown-toggle hide-arrow btn btn-icon btn-text-secondary rounded-pill"
        href="javascript:void(0);" data-bs-toggle="dropdown">
        <i class="icon-base ti tabler-language icon-22px text-heading"></i>
      </a>
      <ul class="dropdown-menu dropdown-menu-end">
        <li>
          <a class="dropdown-item <?php echo e(app()->getLocale() === 'en' ? 'active' : ''); ?>"
            href="<?php echo e(url($adminConfigData['prefix'] . 'lang/en')); ?>" data-language="en" data-text-direction="ltr">
            <span>English</span>
          </a>
        </li>
      </ul>
    </li>
    <!--/ Language -->

    <?php if($configData['hasCustomizer'] == true): ?>
      <!-- Style Switcher -->
      <li class="nav-item dropdown">
        <a class="nav-link dropdown-toggle hide-arrow btn btn-icon btn-text-secondary rounded-pill" id="nav-theme"
          href="javascript:void(0);" data-bs-toggle="dropdown">
          <i class="icon-base ti tabler-sun icon-22px theme-icon-active text-heading"></i>
          <span class="d-none ms-2" id="nav-theme-text"><?php echo e(__('locale.Toggle theme')); ?></span>
        </a>
        <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="nav-theme-text">
          <li>
            <button type="button" class="dropdown-item align-items-center active" data-bs-theme-value="light"
              aria-pressed="false">
              <span><i class="icon-base ti tabler-sun icon-22px me-3"
                  data-icon="sun"></i><?php echo e(__('locale.Light')); ?></span>
            </button>
          </li>
          <li>
            <button type="button" class="dropdown-item align-items-center" data-bs-theme-value="dark"
              aria-pressed="true">
              <span><i class="icon-base ti tabler-moon-stars icon-22px me-3"
                  data-icon="moon-stars"></i><?php echo e(__('locale.Dark')); ?></span>
            </button>
          </li>
          <li>
            <button type="button" class="dropdown-item align-items-center" data-bs-theme-value="system"
              aria-pressed="false">
              <span><i class="icon-base ti tabler-device-desktop-analytics icon-22px me-3"
                  data-icon="device-desktop-analytics"></i><?php echo e(__('locale.System')); ?></span>
            </button>
          </li>
        </ul>
      </li>
      <!-- / Style Switcher-->
    <?php endif; ?>

    <?php if(auth()->user()->user_type == 'Admin'): ?>
      <!-- Quick links  -->
      <li class="nav-item dropdown-shortcuts navbar-dropdown dropdown">
        <a class="nav-link dropdown-toggle hide-arrow btn btn-icon btn-text-secondary rounded-pill"
          href="javascript:void(0);" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="false">
          <i class="icon-base ti tabler-layout-grid-add icon-22px text-heading"></i>
        </a>
        <div class="dropdown-menu dropdown-menu-end p-0">
          <div class="dropdown-shortcuts-list scrollable-container">
            <div class="row row-bordered overflow-visible g-0">
              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('event-list')): ?>
                <div class="dropdown-shortcuts-item col">
                  <span class="dropdown-shortcuts-icon rounded-circle mb-3">
                    <i class="icon-base ti tabler-calendar icon-26px text-heading"></i>
                  </span>
                  <a href="<?php echo e(url($adminConfigData['prefix'] . 'calendar')); ?>"
                    class="stretched-link"><?php echo e(__('locale.Calendar')); ?></a>
                  <small><?php echo e(__('locale.Events & Holidays')); ?></small>
                </div>
              <?php endif; ?>
              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('chat-list')): ?>
                <div class="dropdown-shortcuts-item col">
                  <span class="dropdown-shortcuts-icon rounded-circle mb-3">
                    <i class="icon-base ti tabler-message-circle-user icon-26px text-heading"></i>
                  </span>
                  <a href="<?php echo e(url($adminConfigData['prefix'] . 'chat')); ?>"
                    class="stretched-link"><?php echo e(__('locale.Chat')); ?> <span class="badge rounded-pill badge-outline-success"
                      id="chatCounter"></span></a>

                  <small><?php echo e(__('locale.User chat')); ?></small>
                </div>
              <?php endif; ?>
            </div>

            <div class="row row-bordered overflow-visible g-0">
              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('notification-list')): ?>
                <div class="dropdown-shortcuts-item col">
                  <span class="dropdown-shortcuts-icon rounded-circle mb-3">
                    <i class="icon-base ti tabler-mail icon-26px text-heading"></i>
                  </span>
                  <a href="<?php echo e(url($adminConfigData['prefix'] . 'email')); ?>"
                    class="stretched-link"><?php echo e(__('locale.Email')); ?></a>
                  <small><?php echo e(__('locale.Email & Notifications')); ?></small>
                </div>
              <?php endif; ?>
              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('role-list')): ?>
                <div class="dropdown-shortcuts-item col">
                  <span class="dropdown-shortcuts-icon rounded-circle mb-3">
                    <i class="icon-base ti tabler-users icon-26px text-heading"></i>
                  </span>
                  <a href="<?php echo e(url($adminConfigData['prefix'] . 'roles')); ?>"
                    class="stretched-link"><?php echo e(__('locale.Role Management')); ?></a>
                  <small><?php echo e(__('locale.Permission')); ?></small>
                </div>
              <?php endif; ?>
            </div>

            <div class="row row-bordered overflow-visible g-0">
              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('kanban-list')): ?>
                <div class="dropdown-shortcuts-item col d-none">
                  <span class="dropdown-shortcuts-icon rounded-circle mb-3">
                    <i class="icon-base ti tabler-device-desktop-analytics icon-26px text-heading"></i>
                  </span>
                  <a href="<?php echo e(url($adminConfigData['prefix'] . 'kanban')); ?>"
                    class="stretched-link"><?php echo e(__('locale.kanban')); ?></a>
                  <small><?php echo e(__('locale.Admin Notes')); ?></small>
                </div>
              <?php endif; ?>
              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('data-list')): ?>
                <div class="dropdown-shortcuts-item col">
                  <span class="dropdown-shortcuts-icon rounded-circle mb-3">
                    <i class="icon-base ti tabler-settings icon-26px text-heading"></i>
                  </span>
                  <a href="<?php echo e(url($adminConfigData['prefix'] . 'settings')); ?>"
                    class="stretched-link"><?php echo e(__('locale.Setting')); ?></a>
                  <small><?php echo e(__('locale.Account Settings')); ?></small>
                </div>
              <?php endif; ?>
            </div>

          </div>
        </div>
      </li>
      <!-- Quick links -->
    <?php endif; ?>


    <!-- Notification -->
    <li class="nav-item dropdown-notifications navbar-dropdown dropdown me-3 me-xl-2">
      <a class="nav-link dropdown-toggle hide-arrow btn btn-icon btn-text-secondary rounded-pill"
        href="javascript:void(0);" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="false">
        <span class="position-relative">
          <i class="icon-base ti tabler-bell icon-22px text-heading"></i>
          <?php if(Auth::check() && count($adminConfigData['notifications']) > 0): ?>
            <span class="badge rounded-pill bg-danger badge-dot badge-notifications border"></span>
          <?php endif; ?>
        </span>
      </a>
      <ul class="dropdown-menu dropdown-menu-end p-0">
        <li class="dropdown-menu-header border-bottom">
          <div class="dropdown-header d-flex align-items-center py-3">
            <h6 class="mb-0 me-auto"><?php echo e(__('locale.Notifications')); ?></h6>
            <div class="d-flex align-items-center h6 mb-0">
              <?php if(Auth::check() && count($adminConfigData['notifications']) > 0): ?>
                <span
                  class="badge bg-label-primary me-2 notificationCount"><?php echo e(count($adminConfigData['notifications'])); ?>

                  <?php echo e(__('locale.New')); ?></span>
                <a href="javascript:void(0)" class="dropdown-notifications-all p-2 btn btn-icon"
                  data-bs-toggle="tooltip" data-bs-placement="top" title="Mark all as read"><i
                    class="icon-base ti tabler-mail-opened text-heading"></i></a>
              <?php endif; ?>

            </div>
          </div>
        </li>
        <li class="dropdown-notifications-list scrollable-container">
          <ul class="list-group list-group-flush">
            <?php if(Auth::check()): ?>
              <?php $__empty_1 = true; $__currentLoopData = $adminConfigData['notifications']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <li class="list-group-item list-group-item-action dropdown-notifications-item">
                  <div class="d-flex">
                    <div class="flex-shrink-0 me-3">
                      <div class="avatar">
                        <img
                          src="<?php echo e(Auth::user() ? Auth::user()->profile_photo_url : asset('assets/img/placeholder.jpg')); ?>"
                          alt class="rounded-circle" />
                      </div>
                    </div>
                    <div class="flex-grow-1">
                      <h6 class="small mb-1"><?php echo e($notification->data['head']); ?></h6>
                      <small class="mb-1 d-block text-body"><?php echo e($notification->data['body']); ?></small>
                      <small
                        class="text-body-secondary"><?php echo e(\Carbon\Carbon::parse($notification->created_at)->diffForHumans()); ?></small>
                    </div>
                    <div class="flex-shrink-0 dropdown-notifications-actions">
                      <a href="<?php echo e(url($adminConfigData['prefix'] . $notification->data['url'])); ?>"
                        class="dropdown-notifications-read <?php echo e($notification->data['color']); ?>"><i
                          class="<?php echo e($notification->data['class']); ?>"></i></a>
                    </div>
                  </div>
                </li>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <li class="list-group-item list-group-item-action dropdown-notifications-item">
                  <div class="d-flex">
                    <div class="flex-grow-1">
                      <h6 class="small mb-1"><?php echo e(__('locale.No New Notification')); ?></h6>
                    </div>
                  </div>
                </li>
              <?php endif; ?>
            <?php endif; ?>
          </ul>
        </li>
        <li class="border-top">
          <div class="d-grid p-4">
            <a class="btn btn-primary btn-sm d-flex" href="<?php echo e(url($adminConfigData['prefix'] . 'notifications')); ?>">
              <span class="align-middle"><?php echo e(__('locale.View all notifications')); ?></span>
            </a>
          </div>
        </li>
      </ul>
    </li>
    <!--/ Notification -->
    <!-- User -->
    <li class="nav-item navbar-dropdown dropdown-user dropdown">
      <a class="nav-link dropdown-toggle hide-arrow p-0" href="javascript:void(0);" data-bs-toggle="dropdown">
        <div class="avatar avatar-online">
          <img src="<?php echo e(Auth::user() ? Auth::user()->profile_photo_url : asset('assets/img/placeholder.jpg')); ?>" alt
            class="rounded-circle" />
        </div>
      </a>
      <ul class="dropdown-menu dropdown-menu-end">
        <li>
          <a class="dropdown-item mt-0"
            href="<?php echo e(Route::has('profile.show') ? route('profile.show') : url('pages/profile-user')); ?>">
            <div class="d-flex align-items-center">
              <div class="flex-shrink-0 me-2">
                <div class="avatar avatar-online">
                  <img
                    src="<?php echo e(Auth::user() ? Auth::user()->profile_photo_url : asset('assets/img/placeholder.jpg')); ?>"
                    alt class="rounded-circle" />
                </div>
              </div>
              <div class="flex-grow-1">
                <h6 class="mb-0">
                  <?php if(Auth::check()): ?>
                    <?php echo e(Auth::user()->name); ?>

                  <?php else: ?>
                    John Doe
                  <?php endif; ?>
                </h6>
                <small class="text-body-secondary">
                  <?php if(Auth::check()): ?>
                    <?php echo e(Auth::user()->user_type); ?>

                  <?php endif; ?>
                </small>
              </div>
            </div>
          </a>
        </li>
        <li>
          <div class="dropdown-divider my-1 mx-n2"></div>
        </li>
        <li>
          <a class="dropdown-item"
            href="<?php echo e(Route::has('profile.show') ? route('profile.show') : url('pages/profile-user')); ?>">
            <i class="icon-base ti tabler-user me-3 icon-md"></i><span
              class="align-middle"><?php echo e(__('locale.My Profile')); ?></span> </a>
        </li>
        <?php if(Auth::check() && Laravel\Jetstream\Jetstream::hasApiFeatures()): ?>
          <li>
            <a class="dropdown-item" href="<?php echo e(route('api-tokens.index')); ?>">
              <i class="icon-base ti tabler-settings me-3 icon-md"></i><span
                class="align-middle"><?php echo e(__('locale.API Tokens')); ?></span>
            </a>
          </li>
        <?php endif; ?>

        <?php if(Auth::User() && Laravel\Jetstream\Jetstream::hasTeamFeatures()): ?>
          <li>
            <div class="dropdown-divider my-1 mx-n2"></div>
          </li>
          <li>
            <h6 class="dropdown-header"><?php echo e(__('locale.Manage Team')); ?></h6>
          </li>
          <li>
            <div class="dropdown-divider my-1"></div>
          </li>
          <li>
            <a class="dropdown-item"
              href="<?php echo e(Auth::user() ? route('teams.show', Auth::user()->currentTeam->id) : 'javascript:void(0)'); ?>">
              <i class="icon-base bx bx-cog icon-md me-3"></i><span><?php echo e(__('locale.Team Settings')); ?></span>
            </a>
          </li>
          <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', Laravel\Jetstream\Jetstream::newTeamModel())): ?>
            <li>
              <a class="dropdown-item" href="<?php echo e(route('teams.create')); ?>">
                <i class="icon-base bx bx-user icon-md me-3"></i><span><?php echo e(__('locale.Create New Team')); ?></span>
              </a>
            </li>
          <?php endif; ?>
          <?php if(Auth::user()->allTeams()->count() > 1): ?>
            <li>
              <div class="dropdown-divider my-1"></div>
            </li>
            <li>
              <h6 class="dropdown-header"><?php echo e(__('locale.Switch Teams')); ?></h6>
            </li>
            <li>
              <div class="dropdown-divider my-1"></div>
            </li>
          <?php endif; ?>
          <?php if(Auth::user()): ?>
            <?php $__currentLoopData = Auth::user()->allTeams(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $team): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              

              
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          <?php endif; ?>
        <?php endif; ?>
        <li>
          <div class="dropdown-divider my-1 mx-n2"></div>
        </li>
        <?php if(Auth::check()): ?>
          <li>
            <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
              onclick="event.preventDefault(); handleLogout(); ">
              <!-- document.getElementById('logout-form').submit(); -->
              <i class="icon-base bx bx-power-off icon-md me-3"></i><span><?php echo e(__('locale.Logout')); ?></span>
            </a>
          </li>
          <form method="POST" id="logout-form" action="<?php echo e(url($adminConfigData['prefix'] . 'logout')); ?>">
            <?php echo csrf_field(); ?>
          </form>
        <?php else: ?>
          <li>
            <div class="d-grid px-2 pt-2 pb-1">
              <a class="btn btn-sm btn-danger d-flex"
                href="<?php echo e(Route::has('login') ? route('login') : url('auth/login-basic')); ?>" target="_blank">
                <small class="align-middle"><?php echo e(__('locale.Login')); ?></small>
                <i class="icon-base ti tabler-login ms-2 icon-14px"></i>
              </a>
            </div>
          </li>
        <?php endif; ?>
      </ul>
    </li>
    <!--/ User -->
  </ul>
</div>
<?php /**PATH /home/intellisensetech/public_html/topsyapp/resources/views/layouts/sections/navbar/navbar-partial.blade.php ENDPATH**/ ?>