  <!-- ========= Footer ======= -->
  <footer>
    <?php
      $settings = \App\Models\Setting::whereIn('meta_key', [
          'contact_number',
          'email',
          'address',
          'twitter',
          'facebook',
          'linkdin',
          'instagram',
          'driver_android_app_link',
          'driver_ios_app_link',
          'customer_android_app_link',
          'customer_ios_app_link',
      ])->pluck('meta_value', 'meta_key');
    ?>
    <div class="container">
      <div class="row">
        <div class="col-lg-4 col-sm-6">
          <div class="footer-company-info">
            <img src="<?php echo e(asset('frontend/assets/img/logo.png')); ?>" class="img-fluid" alt="footer">
            <p>Whatever You Need, Delivered in Minutes.
            </p>
            <div class="footer-social">
              <ul>
                <li><a href="<?php echo e($settings['facebook']); ?>"><i class="fa-brands fa-facebook-f"></i></a></li>
                <li><a href="<?php echo e($settings['instagram']); ?>"><i class="fa-brands fa-instagram"></i></a></li>
                <li><a href="<?php echo e($settings['twitter']); ?>"><i class="fa-brands fa-x-twitter"></i></a></li>
                <li><a href="<?php echo e($settings['linkdin']); ?>"><i class="fa-brands fa-linkedin-in"></i></a></li>
              </ul>
            </div>
          </div>
        </div>
        <div class="col-lg-2 col-sm-6">
          <div class="footer-section pl-10">
            <h4>Navigation</h4>
            <ul>
              <li><a href="<?php echo e(url('/')); ?>">Home</a></li>
              <li><a href="<?php echo e(url('about-us')); ?>">About Us</a></li>
              <li><a href="<?php echo e(url('app-feature')); ?>">App Features</a></li>
              <li><a href="<?php echo e(url('download-app')); ?>">Download App</a></li>
              <li><a href="<?php echo e(url('contact-us')); ?>">Contact Us</a></li>
            </ul>
          </div>
        </div>
        <div class="col-lg-3 col-sm-6">
          <div class="footer-section">
            <h4>Get in Touch</h4>
            <div class="main-location-div">
              <div class="location-div">
                <div class="contact-icon">
                  <i class="fa-solid fa-location-dot"></i>
                </div>
                <div class="contact-text">
                  <p><?php echo e($settings['address']); ?></p>
                </div>
              </div>
              <div class="location-div">
                <div class="contact-icon">
                  <i class="fa-solid fa-envelope"></i>
                </div>
                <div class="contact-text">
                  <p><?php echo e($settings['email']); ?></p>
                </div>
              </div>
              <div class="location-div">
                <div class="contact-icon">
                  <i class="fa-solid fa-phone-volume"></i>
                </div>
                <div class="contact-text">
                  <p><?php echo e($settings['contact_number']); ?></p>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="col-lg-3 col-sm-6">
          <div class="footer-section">
            <h4>Download App</h4>
            <div class="user-app-footer">
              <p><?php echo e(config('app.name')); ?> APP USER</p>
              <ul>
                <li><a href="<?php echo e($settings['customer_android_app_link']); ?>" target="_blank"><img
                      src="<?php echo e(asset('frontend/assets/img/google-play.png')); ?>" class="img-fluid"></a></li>
                <li><a href="<?php echo e($settings['customer_ios_app_link']); ?>" target="_blank"><img
                      src="<?php echo e(asset('frontend/assets/img/app-store.png')); ?>" class="img-fluid"></a>
                </li>
              </ul>
            </div>
            <div class="user-app-footer">
              <p><?php echo e(config('app.name')); ?> APP DRIVER</p>
              <ul>
                <li><a href="<?php echo e($settings['driver_android_app_link']); ?>" target="_blank"><img
                      src="<?php echo e(asset('frontend/assets/img/google-play.png')); ?>" class="img-fluid"></a></li>
                <li><a href="<?php echo e($settings['driver_ios_app_link']); ?>" target="_blank"><img
                      src="<?php echo e(asset('frontend/assets/img/app-store.png')); ?>" class="img-fluid"></a></li>
              </ul>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div id="copyright">
      <div class="container">
        <div class="row">
          <div class="col-lg-8 col-sm-6">
            <div class="copyright-text">
              <p>&copy; 2025 <?php echo e(config('app.name')); ?> All Rights Reserved</p>
            </div>
          </div>
          <div class="col-lg-4 col-sm-6">
            <div class="copyright-link">
              <ul>
                <li><a href="<?php echo e(url('privacy-policy')); ?>">Terms & Conditions</a></li>
                <li><a href="<?php echo e(url('terms-and-conditions')); ?>">Privacy Policy</a></li>
              </ul>
            </div>
          </div>
        </div>
      </div>
    </div>
  </footer>


  <!-- ========= Back To Top  ======= -->

  <div class="scroll-top-wrapper ">
    <span class="scroll-top-inner">
      <i class="fa fa-2x fa-arrow-circle-up"></i>
    </span>
  </div>


  <!-- ========= Jquery ======= -->
  <script src="<?php echo e(asset('frontend/assets/js/jquery.js')); ?>"></script>

  <!-- ========= Main Jquery ======= -->
  <script src="<?php echo e(asset('frontend/assets/js/main.js')); ?>"></script>

  <!-- ========= Custom ======= -->
  <script src="<?php echo e(asset('frontend/assets/js/wow.min.js')); ?>"></script>

  <!-- ========= Custom ======= -->
  <script src="<?php echo e(asset('frontend/assets/js/custom.js')); ?>"></script>

  <!-- ========= Custom ======= -->
  <script src="<?php echo e(asset('frontend/assets/js/owl.carousel.min.js')); ?>"></script>


  </body>

  </html>
<?php /**PATH /home/intellisensetech/public_html/topsyapp/resources/views/frontend/includes/footer.blade.php ENDPATH**/ ?>