<?php $__env->startSection('title', __('locale.Settings')); ?>

<!-- Vendor Styles -->
<?php $__env->startSection('vendor-style'); ?>
  <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/flatpickr/flatpickr.scss', 'resources/assets/vendor/libs/select2/select2.scss']); ?>
<?php $__env->stopSection(); ?>

<!-- Vendor Scripts -->
<?php $__env->startSection('vendor-script'); ?>
  <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/cleave-zen/cleave-zen.js', 'resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js', 'resources/assets/vendor/libs/select2/select2.js']); ?>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('content'); ?>

  <!-- Form with Tabs -->
  <div class="row">
    <div class="col">
      <h6 class="mt-6"><?php echo e(__('locale.Settings')); ?></h6>
      <div class="card mb-6">
        <div class="card-header px-0 pt-0">
          <div class="nav-align-top">
            <ul class="nav nav-tabs" role="tablist">
              <li class="nav-item">
                <button type="button" class="nav-link active" data-bs-toggle="tab" data-bs-target="#form-tabs-personal"
                  aria-controls="form-tabs-personal" role="tab" aria-selected="true"><span
                    class="icon-base ti tabler-settings icon-lg d-sm-none"></span><span
                    class="d-none d-sm-block"><?php echo e(__('locale.Site Settings')); ?></span></button>
              </li>
              <li class="nav-item">
                <button type="button" class="nav-link" data-bs-toggle="tab" data-bs-target="#form-tabs-price"
                  aria-controls="form-tabs-price" role="tab" aria-selected="false"><span
                    class="icon-base ti tabler-credit-card icon-lg d-sm-none"></span><span class="d-none d-sm-block">
                    <?php echo e(__('locale.Price')); ?> <?php echo e(__('locale.Settings')); ?></span></button>
              </li>
              <li class="nav-item">
                <button type="button" class="nav-link" data-bs-toggle="tab" data-bs-target="#form-tabs-account"
                  aria-controls="form-tabs-account" role="tab" aria-selected="false"><span
                    class="icon-base ti tabler-user-cog icon-lg d-sm-none"></span><span class="d-none d-sm-block">
                    <?php echo e(__('locale.Details')); ?></span></button>
              </li>
              <li class="nav-item">
                <button type="button" class="nav-link" data-bs-toggle="tab" data-bs-target="#form-tabs-referral"
                  aria-controls="form-tabs-referral" role="tab" aria-selected="false"><span
                    class="icon-base ti tabler-folder-symlink icon-lg d-sm-none"></span><span
                    class="d-none d-sm-block"><?php echo e(__('locale.Referral Settings')); ?></span></button>
              </li>
              <li class="nav-item">
                <button type="button" class="nav-link" data-bs-toggle="tab" data-bs-target="#form-tabs-social"
                  aria-controls="form-tabs-social" role="tab" aria-selected="false"><span
                    class="icon-base ti tabler-link icon-lg d-sm-none"></span><span
                    class="d-none d-sm-block"><?php echo e(__('locale.Social Links')); ?></span></button>
              </li>
              <li class="nav-item">
                <button type="button" class="nav-link" data-bs-toggle="tab" data-bs-target="#form-tabs-app"
                  aria-controls="form-tabs-app" role="tab" aria-selected="false"><span
                    class="icon-base ti tabler-link icon-lg d-sm-none"></span><span
                    class="d-none d-sm-block"><?php echo e(__('locale.App Links')); ?></span></button>
              </li>

            </ul>
          </div>
        </div>

        <div class="card-body">
          <div class="tab-content p-0">
            <!-- Personal Info -->
            <div class="tab-pane fade active show" id="form-tabs-personal" role="tabpanel">
              <form method="POST" enctype="multipart/form-data" id="upload_form">
                <?php echo e(csrf_field()); ?>

                <div class="row g-6">
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label text-sm-start"
                        for="formtabs-first-name"><?php echo e(__('locale.Currency Symbol')); ?></label>
                      <div class="col-sm-12">
                        <input type="text" id="formtabs-first-name" class="form-control" placeholder=""
                          name="currency_symbol" value="<?php echo e($data['currency_symbol']); ?>" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label text-sm-start"
                        for="formtabs-driver_commission"><?php echo e(__('locale.Driver Commission')); ?>(%)</label>
                      <div class="col-sm-12">
                        <input type="number" id="formtabs-driver_commission" class="form-control" placeholder=""
                          name="driver_commission" value="<?php echo e($data['driver_commission']); ?>" />
                      </div>
                    </div>
                  </div>

                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label text-sm-start"
                        for="formtabs-driver_request_simultaneously"><?php echo e(__('locale.Driver Request Simultaneously')); ?></label>
                      <div class="col-sm-12">
                        <input type="number" id="formtabs-driver_request_simultaneously" class="form-control"
                          placeholder="" name="driver_request_simultaneously"
                          value="<?php echo e($data['driver_request_simultaneously']); ?>" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label text-sm-start"
                        for="formtabs-driver_response_timeout_seconds"><?php echo e(__('locale.Driver Response Timeout')); ?>(Seconds)</label>
                      <div class="col-sm-12">
                        <input type="number" id="formtabs-driver_response_timeout_seconds" class="form-control"
                          placeholder="" name="driver_response_timeout_seconds"
                          value="<?php echo e($data['driver_response_timeout_seconds']); ?>" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label text-sm-start"
                        for="formtabs-request_time_minutes"><?php echo e(__('locale.Ride Request Timeout')); ?>(Minutes)</label>
                      <div class="col-sm-12">
                        <input type="number" id="formtabs-request_time_minutes" class="form-control" placeholder=""
                          name="request_time_minutes" value="<?php echo e($data['request_time_minutes']); ?>" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label text-sm-start" for="formtabs-tax"><?php echo e(__('locale.Tax')); ?>(%)</label>
                      <div class="col-sm-12">
                        <input type="number" id="formtabs-tax" class="form-control" placeholder="" name="tax"
                          value="<?php echo e($data['tax']); ?>" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label text-sm-start"
                        for="formtabs-tax"><?php echo e(__('locale.Driver Waiting Time Start After')); ?> (Minutes)</label>
                      <div class="col-sm-12">
                        <input type="number" id="formtabs-tax" class="form-control" placeholder=""
                          name="driver_waiting_time_start_after"
                          value="<?php echo e($data['driver_waiting_time_start_after']); ?>" />
                      </div>
                    </div>
                  </div>

                  <div class="col-md-6 select2-primary d-none">
                    <div class="row">
                      <label class="col-sm-3 col-form-label text-sm-end"
                        for="formtabs-language"><?php echo e(__('locale.Language')); ?></label>
                      <div class="col-sm-9">
                        <select id="formtabs-language" class="select2 form-select" multiple>
                          <option value="en" selected>English</option>
                          <option value="fr" selected>French</option>
                          <option value="de">German</option>
                          <option value="pt">Portuguese</option>
                        </select>
                      </div>
                    </div>
                  </div>

                </div>
                <div class="row mt-6">
                  <div class="col-md-12 text-end">
                    <div class="row justify-content-end">
                      <div class="col-sm-12">
                        <input type="hidden" name="type" value="site_setting">
                        <button type="submit" class="btn btn-primary me-4"><?php echo e(__('locale.Submit')); ?></button>
                        <button type="reset" class="btn btn-label-secondary"><?php echo e(__('locale.Cancel')); ?></button>
                      </div>
                    </div>
                  </div>
                </div>
              </form>
            </div>
            <!-- Price Details -->
            <div class="tab-pane fade" id="form-tabs-price" role="tabpanel">
              <form method="POST" enctype="multipart/form-data" id="upload_form_price">
                <?php echo e(csrf_field()); ?>

                <div class="row g-6">
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label text-sm-start" for="formtabs-tax"><?php echo e(__('locale.Bad Weather')); ?>

                        (<?php echo e(__('locale.Price Hike Multiplier')); ?>)</label>
                      <div class="col-sm-12">
                        <input type="number" step="0.01" id="formtabs-tax" class="form-control"
                          name="bad_weather" value="<?php echo e($data['bad_weather']); ?>" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label text-sm-start"
                        for="formtabs-tax"><?php echo e(__('locale.Demand Level High')); ?>

                        (<?php echo e(__('locale.Price Hike Multiplier')); ?>)</label>
                      <div class="col-sm-12">
                        <input type="number" step="0.01" id="formtabs-tax" class="form-control"
                          name="demand_level_high" value="<?php echo e($data['demand_level_high']); ?>" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label text-sm-start"
                        for="formtabs-tax"><?php echo e(__('locale.Demand Level Medium')); ?>

                        (<?php echo e(__('locale.Price Hike Multiplier')); ?>)</label>
                      <div class="col-sm-12">
                        <input type="number" step="0.01" id="formtabs-tax" class="form-control"
                          name="demand_level_medium" value="<?php echo e($data['demand_level_medium']); ?>" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label text-sm-start" for="formtabs-tax"><?php echo e(__('locale.Busy Areas')); ?>

                        (<?php echo e(__('locale.Price Hike Multiplier')); ?>)</label>
                      <div class="col-sm-12">
                        <input type="number" step="0.01" id="formtabs-tax" class="form-control" name="busy_areas"
                          value="<?php echo e($data['busy_areas']); ?>" />
                      </div>
                    </div>
                  </div>

                </div>
                <button type="button" class="btn btn-primary mt-4" data-bs-toggle="modal"
                  data-bs-target="#siteDocsModal">
                  <i class="icon-base ti tabler-book icon-lg"></i> Site Documentation
                </button>
                <div class="row mt-6">

                  <div class="col-md-12 text-end">
                    <div class="row justify-content-end">
                      <div class="col-sm-12">
                        <input type="hidden" name="type" value="site_setting">
                        <button type="submit" class="btn btn-primary me-4"><?php echo e(__('locale.Submit')); ?></button>
                        <button type="reset" class="btn btn-label-secondary"><?php echo e(__('locale.Cancel')); ?></button>
                      </div>
                    </div>
                  </div>
                </div>
              </form>
            </div>
            <!-- Account Details -->
            <div class="tab-pane fade" id="form-tabs-account" role="tabpanel">
              <form method="POST" enctype="multipart/form-data" id="upload_form_account">
                <?php echo e(csrf_field()); ?>

                <div class="row g-6">
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-sm-3 col-form-label text-sm-end"
                        for="formtabs-contact"><?php echo e(__('locale.Contact Number')); ?></label>
                      <div class="col-sm-9">
                        <input type="text" id="formtabs-contact" class="form-control" placeholder=""
                          name="contact_number" value="<?php echo e($data['contact_number']); ?>" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-sm-3 col-form-label text-sm-end"
                        for="formtabs-email"><?php echo e(__('locale.Email')); ?></label>
                      <div class="col-sm-9">
                        <input type="email" id="formtabs-email" class="form-control" placeholder="" name="email"
                          value="<?php echo e($data['email']); ?>" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-sm-3 col-form-label text-sm-end"
                        for="formtabs-address"><?php echo e(__('locale.Address')); ?></label>
                      <div class="col-sm-9">
                        <input type="text" id="formtabs-address" class="form-control" placeholder=""
                          aria-label="" name="address" value="<?php echo e($data['address']); ?>" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-sm-3 col-form-label text-sm-end"
                        for="formtabs-website"><?php echo e(__('locale.Website')); ?></label>
                      <div class="col-sm-9">
                        <input type="text" id="formtabs-website" class="form-control phone-mask" placeholder=""
                          aria-label="" name="website" value="<?php echo e($data['website']); ?>" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-sm-3 col-form-label text-sm-end"
                        for="formtabs-bank"><?php echo e(__('locale.Bank Details')); ?></label>
                      <div class="col-sm-9">
                        <input type="text" id="formtabs-bank" class="form-control" placeholder=""
                          name="bank_details" value="<?php echo e($data['bank_details']); ?>" />
                      </div>
                    </div>
                  </div>

                </div>
                <div class="row mt-6">
                  <div class="col-md-12 text-end">
                    <div class="row justify-content-end">
                      <div class="col-sm-12">
                        <input type="hidden" name="type" value="site_setting">
                        <button type="submit" class="btn btn-primary me-4"><?php echo e(__('locale.Submit')); ?></button>
                        <button type="reset" class="btn btn-label-secondary"><?php echo e(__('locale.Cancel')); ?></button>
                      </div>
                    </div>
                  </div>
                </div>
              </form>
            </div>
            <!-- Referral Settngs -->
            <div class="tab-pane fade" id="form-tabs-referral" role="tabpanel">
              <form method="POST" enctype="multipart/form-data" id="referral">
                <?php echo e(csrf_field()); ?>

                <div class="row g-6">
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label"
                        for="formtabs-daa"><?php echo e(__('locale.Mininum Orders For Driver To Get Amount')); ?></label>
                      <div class="col-sm-12">
                        <input type="number" id="formtabs-daa" class="form-control" placeholder=""
                          name="driver_min_order" value="<?php echo e($data['driver_min_order']); ?>" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label" for="formtabs-dia"><?php echo e(__('locale.Driver Refer Amount')); ?></label>
                      <div class="col-sm-12">
                        <input type="number" id="formtabs-dia" class="form-control" placeholder=""
                          name="driver_refer_amount" value="<?php echo e($data['driver_refer_amount']); ?>" />
                      </div>
                    </div>
                  </div>

                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label"
                        for="formtabs-caa"><?php echo e(__('locale.Mininum Orders For Customer To Get Amount')); ?></label>
                      <div class="col-sm-12">
                        <input type="number" id="formtabs-caa" class="form-control" placeholder=""
                          name="customer_min_order" value="<?php echo e($data['customer_min_order']); ?>" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label" for="formtabs-cia"><?php echo e(__('locale.Customer Refer Amount')); ?></label>
                      <div class="col-sm-12">
                        <input type="number" id="formtabs-cia" class="form-control" placeholder=""
                          name="customer_refer_amount" value="<?php echo e($data['customer_refer_amount']); ?>" />
                      </div>
                    </div>
                  </div>

                </div>
                <div class="row mt-6">
                  <div class="col-md-12 text-end">
                    <div class="row justify-content-end">
                      <div class="col-sm-12">
                        <input type="hidden" name="type" value="referral">
                        <button type="submit" class="btn btn-primary me-4"><?php echo e(__('locale.Submit')); ?></button>
                        <button type="reset" class="btn btn-label-secondary"><?php echo e(__('locale.Cancel')); ?></button>
                      </div>
                    </div>
                  </div>
                </div>
              </form>
            </div>
            <!-- Social Links -->
            <div class="tab-pane fade" id="form-tabs-social" role="tabpanel">
              <form method="POST" enctype="multipart/form-data" id="social">
                <?php echo e(csrf_field()); ?>

                <div class="row g-6">
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-sm-3 col-form-label text-sm-end"
                        for="formtabs-twitter"><?php echo e(__('locale.Twitter')); ?></label>
                      <div class="col-sm-9">
                        <input type="text" id="formtabs-twitter" class="form-control"
                          placeholder="https://twitter.com/" name="twitter" value="<?php echo e($data['twitter']); ?>" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-sm-3 col-form-label text-sm-end"
                        for="formtabs-facebook"><?php echo e(__('locale.Facebook')); ?></label>
                      <div class="col-sm-9">
                        <input type="text" id="formtabs-facebook" class="form-control"
                          placeholder="https://facebook.com/" name="facebook" value="<?php echo e($data['facebook']); ?>" />
                      </div>
                    </div>
                  </div>

                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-sm-3 col-form-label text-sm-end"
                        for="formtabs-linkedin"><?php echo e(__('locale.Linkedin')); ?></label>
                      <div class="col-sm-9">
                        <input type="text" id="formtabs-linkedin" class="form-control"
                          placeholder="https://linkedin.com/" name="linkdin" value="<?php echo e($data['linkdin']); ?>" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-sm-3 col-form-label text-sm-end"
                        for="formtabs-instagram"><?php echo e(__('locale.Instagram')); ?></label>
                      <div class="col-sm-9">
                        <input type="text" id="formtabs-instagram" class="form-control"
                          placeholder="https://instagram.com/" name="instagram" value="<?php echo e($data['instagram']); ?>" />
                      </div>
                    </div>
                  </div>

                </div>
                <div class="row mt-6">
                  <div class="col-md-12 text-end">
                    <div class="row justify-content-end">
                      <div class="col-sm-12">
                        <input type="hidden" name="type" value="social_links">
                        <button type="submit" class="btn btn-primary me-4"><?php echo e(__('locale.Submit')); ?></button>
                        <button type="reset" class="btn btn-label-secondary"><?php echo e(__('locale.Cancel')); ?></button>
                      </div>
                    </div>
                  </div>
                </div>
              </form>
            </div>
            <!-- App Links -->
            <div class="tab-pane fade" id="form-tabs-app" role="tabpanel">
              <form method="POST" enctype="multipart/form-data" id="app">
                <?php echo e(csrf_field()); ?>

                <div class="row g-6">
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label"
                        for="formtabs-daa"><?php echo e(__('locale.Driver Android App Link')); ?></label>
                      <div class="col-sm-12">
                        <input type="text" id="formtabs-daa" class="form-control" placeholder=""
                          name="driver_android_app_link" value="<?php echo e($data['driver_android_app_link']); ?>" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label" for="formtabs-dia"><?php echo e(__('locale.Driver iOS App Link')); ?></label>
                      <div class="col-sm-12">
                        <input type="text" id="formtabs-dia" class="form-control" placeholder=""
                          name="driver_ios_app_link" value="<?php echo e($data['driver_ios_app_link']); ?>" />
                      </div>
                    </div>
                  </div>

                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label"
                        for="formtabs-caa"><?php echo e(__('locale.Customer Android App Link')); ?></label>
                      <div class="col-sm-12">
                        <input type="text" id="formtabs-caa" class="form-control" placeholder=""
                          name="customer_android_app_link" value="<?php echo e($data['customer_android_app_link']); ?>" />
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="row">
                      <label class="col-form-label" for="formtabs-cia"><?php echo e(__('locale.Customer iOS App Link')); ?></label>
                      <div class="col-sm-12">
                        <input type="text" id="formtabs-cia" class="form-control" placeholder=""
                          name="customer_ios_app_link" value="<?php echo e($data['customer_ios_app_link']); ?>" />
                      </div>
                    </div>
                  </div>

                </div>
                <div class="row mt-6">
                  <div class="col-md-12 text-end">
                    <div class="row justify-content-end">
                      <div class="col-sm-12">
                        <input type="hidden" name="type" value="app_links">
                        <button type="submit" class="btn btn-primary me-4"><?php echo e(__('locale.Submit')); ?></button>
                        <button type="reset" class="btn btn-label-secondary"><?php echo e(__('locale.Cancel')); ?></button>
                      </div>
                    </div>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <?php echo $__env->make('_partials._modals.modal-site-settings', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>;
  <?php echo $__env->make('_partials._modals.modal-developer-password', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>;
<?php $__env->stopSection(); ?>
<!-- Page Scripts -->
<?php $__env->startSection('page-script'); ?>
  <?php echo app('Illuminate\Foundation\Vite')([]); ?>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    $(document).ready(function() {
      initCountryDrop("#formtabs-contact");
    })

    $(function() {
      let $btn = null;

      // Track the clicked submit button
      $(document).on('click',
        '#upload_form button[type="submit"], #developerPasswordError#upload_form_price button[type="submit"], #social button[type="submit"], #upload_form_account button[type="submit"], #app button[type="submit"], #referral button[type="submit"]',
        function() {
          $btn = $(this);
        });

      // Handle form submission
      $('#upload_form, #upload_form_price, #social, #upload_form_account, #app, #referral').on('submit', function(
        event) {
        event.preventDefault();
        const form = this;
        // Only add developer password confirmation for #upload_form
        if ($(form).attr('id') === 'upload_form' || $(form).attr('id') === 'upload_form_price') {
          $.get(`${baseURL}/developer-password/check`, function(data) {
            if (data.attempts_left <= 0) {
              window.showToast({
                title: 'Settings ⚙️',
                message: 'Too many attempts. Please wait before trying again.',
                type: 'bg-danger',
                animation: 'animate__fadeInUp',
                time: 'Just now',
                delay: 3000
              });
              $('#developerPasswordModal').modal('hide');
              toggleButtonLoading($btn, false);
            } else {
              $('#developerPasswordModal').modal('show');
            }
          });

          $('#developerPasswordError').hide();
          $('#developer_password').val('');

          // Handle modal confirm click
          $('#submitWithPassword').off('click').on('click', function() {
            const password = $('#developer_password').val().trim();

            if (!password) {
              $('#developerPasswordError').text('Password is required').show();
              return;
            }

            // AJAX check developer password
            $.ajax({
              type: 'POST',
              url: `${baseURL}/check-developer-password`,
              headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              },
              data: {
                developer_password: password
              },
              dataType: 'JSON',
              success: function(res) {
                if (res.valid) {
                  submitFormWithAjax(form, $btn); // Submit the form after password check
                } else {}
              },
              error: function() {}
            });
          });

          return; // Prevent default submission until password confirmed
        }

        // Other forms without password check
        submitFormWithAjax(form, $btn);
      });

      // Reusable AJAX submit function
      function submitFormWithAjax(form, $btn) {
        $.ajax({
          type: 'POST',
          url: `${baseURL}/postSiteSetting`,
          headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          data: new FormData(form),
          dataType: 'JSON',
          contentType: false,
          cache: false,
          processData: false,
          beforeSend: function() {
            toggleButtonLoading($btn, true, 'Saving...');
          },
          success: function(data) {
            $('#developerPasswordModal').modal('hide');
            toggleButtonLoading($btn, false);
            window.showToast({
              title: 'Settings ⚙️',
              message: data.message,
              type: 'bg-success',
              animation: 'animate__fadeInUp',
              time: 'Just now',
              delay: 3000
            });
          },
          error: function(data) {
            toggleButtonLoading($btn, false);
            console.log(data);
          }
        });
      }
    });
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/intellisensetech/public_html/topsyapp/resources/views/common/site-settings.blade.php ENDPATH**/ ?>