<?php $__env->startSection('title', __('locale.Stores')); ?>

<!-- Vendor Styles -->
<?php $__env->startSection('vendor-style'); ?>
  <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/css/datatables.scss']); ?>
<?php $__env->stopSection(); ?>

<!-- Vendor Scripts -->
<?php $__env->startSection('vendor-script'); ?>
  <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/js/datatables.js', 'resources/assets/vendor/libs/raty-js/raty-js.js']); ?>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('content'); ?>
  <div class="row g-6 mb-6">
    <div class="col-sm-6 col-xl-3">
      <div class="card">
        <div class="card-body">
          <div class="d-flex align-items-start justify-content-between">
            <div class="content-left">
              <span class="text-heading"><?php echo e(__('locale.Stores')); ?></span>
              <div class="d-flex align-items-center my-1">
                <h4 class="mb-0 me-2"><?php echo e($totalUser); ?></h4>
                <p class="text-success mb-0">(<?php echo e($totalUser > 0 ? round(($totalUser / $totalUser) * 100, 2) : 0); ?>%)</p>
              </div>
              <small class="mb-0"><?php echo e(__('locale.Total')); ?> <?php echo e(__('locale.Stores')); ?></small>
            </div>
            <div class="avatar">
              <span class="avatar-initial rounded bg-label-primary">
                <i class="icon-base ti tabler-users icon-26px"></i>
              </span>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="col-sm-6 col-xl-3">
      <div class="card">
        <div class="card-body">
          <div class="d-flex align-items-start justify-content-between">
            <div class="content-left">
              <span class="text-heading"><?php echo e(__('locale.Active')); ?> <?php echo e(__('locale.Stores')); ?></span>
              <div class="d-flex align-items-center my-1">
                <h4 class="mb-0 me-2"><?php echo e($verified); ?></h4>
                <p class="text-success mb-0">(<?php echo e($totalUser > 0 ? round(($verified / $totalUser) * 100, 2) : 0); ?>%)</p>
              </div>
              <small class="mb-0"><?php echo e(__('locale.Recent analytics')); ?> </small>
            </div>
            <div class="avatar">
              <span class="avatar-initial rounded bg-label-success">
                <i class="icon-base ti tabler-user-plus icon-26px"></i>
              </span>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="col-sm-6 col-xl-3">
      <div class="card">
        <div class="card-body">
          <div class="d-flex align-items-start justify-content-between">
            <div class="content-left">
              <span class="text-heading"><?php echo e(__('locale.Disabled')); ?> <?php echo e(__('locale.Stores')); ?></span>
              <div class="d-flex align-items-center my-1">
                <h4 class="mb-0 me-2"><?php echo e($userDisabled); ?></h4>
                <p class="text-danger mb-0">(<?php echo e($totalUser > 0 ? round(($userDisabled / $totalUser) * 100, 2) : 0); ?>%)
                </p>
              </div>
              <small class="mb-0"><?php echo e(__('locale.Recent analytics')); ?></small>
            </div>
            <div class="avatar">
              <span class="avatar-initial rounded bg-label-danger">
                <i class="icon-base ti tabler-user-minus icon-26px"></i>
              </span>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="col-sm-6 col-xl-3">
      <div class="card">
        <div class="card-body">
          <div class="d-flex align-items-start justify-content-between">
            <div class="content-left">
              <span class="text-heading"><?php echo e(__('locale.Verification Pending')); ?></span>
              <div class="d-flex align-items-center my-1">
                <h4 class="mb-0 me-2"><?php echo e($notVerified); ?></h4>
                <p class="text-danger mb-0">(<?php echo e($totalUser > 0 ? round(($notVerified / $totalUser) * 100, 2) : 0); ?>%)</p>
              </div>
              <small class="mb-0"><?php echo e(__('locale.Recent analytics')); ?></small>
            </div>
            <div class="avatar">
              <span class="avatar-initial rounded bg-label-warning">
                <i class="icon-base ti tabler-user-search icon-26px"></i>
              </span>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <!-- Users List Table -->
  <div class="card">
    <div class="card-header border-bottom">
      <h5 class="card-title mb-0"><?php echo e(__('locale.Search Filter')); ?></h5>
    </div>
    <div class="card-datatable">
      <div class="row p-3">
        <div class="col-md-6">
          <label for="filter_verified" class="form-label"><?php echo e(__('locale.Store Verified')); ?></label>
          <select id="filter_verified" class="form-select">
            <option value=""><?php echo e(__('locale.All')); ?></option>
            <option value="1"><?php echo e(__('locale.Verified')); ?></option> <!-- true -->
            <option value="0"><?php echo e(__('locale.Not Verified')); ?></option> <!-- false -->
          </select>
        </div>

        <div class="col-md-6">
          <label for="filter_status" class="form-label"><?php echo e(__('locale.Status')); ?></label>
          <select id="filter_status" class="form-select">
            <option value=""><?php echo e(__('locale.All')); ?></option>
            <option value="1"><?php echo e(__('locale.Active')); ?></option>
            <option value="0"><?php echo e(__('locale.Inactive')); ?></option>
          </select>
        </div>

      </div>
      <table class="datatables-users table border-top">
        <thead>
          <tr>
            <th></th>
            <th><?php echo e(__('locale.ID')); ?></th>
            <th><?php echo e(__('locale.Store')); ?></th>
            <th><?php echo e(__('locale.Email')); ?></th>
            <th><?php echo e(__('locale.Verified')); ?></th>
            <th><?php echo e(__('locale.Actions')); ?></th>
          </tr>
        </thead>
      </table>
    </div>

  </div>
  <div id="modal-container"></div>
  <?php echo $__env->make('_partials/_modals/modal-password', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php $__env->stopSection(); ?>
<!-- Page Scripts -->
<?php $__env->startSection('page-script'); ?>
  <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/js/stores.js']); ?>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    $(document).ready(function() {
      initCountryDrop("#add-user-contact");
    })

    function initCountryDrop(id) {
      var input = document.querySelector(id);
      window.intlTelInput(input, {
        separateDialCode: false,
        autoHideDialCode: false,
        nationalMode: false,
        initialCountry: "IN",
        geoIpLookup: function(success, failure) {
          $.get("https://ipinfo.io", function() {}, "jsonp").always(function(resp) {
            var countryCode = (resp && resp.country) ? resp.country : "";
            success(countryCode);
          });
        },
      });
    }

    $(document).on('click', '.approveAccount', function() {
      const userId = $(this).data('id');
      $.ajax({
        url: `${baseURL}/stores/${userId}/details`, // adjust route as needed
        type: 'GET',
        success: function(modalHtml) {
          $('#modal-container').html(modalHtml); // inject modal into DOM
          const modal = new bootstrap.Modal(document.getElementById('onboardingHorizontalSlideModal'));
          modal.show();
        },
        error: function(err) {
          console.error('Failed to fetch store details', err);
        }
      });
    });


    // Approve handler
    $(document).on('click', '#approve-store-btn', function() {
      const storeId = $('#approve-store-id').val();
      const table = $('.datatables-users').DataTable();
      if (!storeId) return;

      Swal.fire({
        title: 'Are you sure?',
        text: 'You are about to approve this store.',
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'Approve',
        cancelButtonText: 'Cancel',
        reverseButtons: true
      }).then(result => {
        if (result.isConfirmed) {
          $.ajax({
            url: `${baseURL}/stores/${storeId}/status`,
            method: 'POST',
            data: {
              _token: '<?php echo e(csrf_token()); ?>',
              _method: 'POST',
              status: '1'
            },
            success: function(response) {
              const model = response.data;
              Swal.fire('Approved!', response.message || 'Store has been approved.', 'success');
              $(`#approve-${model.id}`).replaceWith(
                `<i class="icon-base ti fs-4 tabler-shield-check text-success"></i>`);

              /*   const existingRow = table.row(`#trRow-${model.id}`);
                if (existingRow.node()) {
                  existingRow.data(model).draw(false);
                } */
              $('#onboardingHorizontalSlideModal').modal('hide');
              // Optionally refresh DataTable or UI
            },
            error: function() {
              Swal.fire('Error', 'Failed to approve store.', 'error');
            }
          });
        }
      });
    });

    // Reject handler
    $(document).on('click', '#reject-store-btn', function() {
      const storeId = $('#approve-store-id').val();
      const table = $('.datatables-users').DataTable();
      if (!storeId) return;

      Swal.fire({
        title: 'Reject this store?',
        text: 'This action cannot be undone.',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Reject',
        cancelButtonText: 'Cancel',
        reverseButtons: true
      }).then(result => {
        if (result.isConfirmed) {
          $.ajax({
            url: `${baseURL}/stores/${storeId}/status`,
            method: 'POST',
            data: {
              _token: '<?php echo e(csrf_token()); ?>',
              _method: 'POST',
              status: '0'
            },
            success: function(response) {
              Swal.fire('Rejected!', response.message || 'Store has been rejected.', 'success');
              const model = response.data;
              table.row(`#trRow-${model.id}`).remove().draw(false);
              $('#onboardingHorizontalSlideModal').modal('hide');
              // Optionally refresh DataTable or UI
            },
            error: function() {
              Swal.fire('Error', 'Failed to reject store.', 'error');
            }
          });
        }
      });
    });

    (function() {
      // Animation Dropdown
      const animationDropdown = document.querySelector('#animation-dropdown'),
        animationModal = document.querySelector('#animationModal');
      if (animationDropdown) {
        animationDropdown.onchange = function() {
          animationModal.classList = '';
          animationModal.classList.add('modal', 'animate__animated', this.value);
        };
      }

      // Function to get and auto play youTube video
      const autoPlayYouTubeModal = function() {
        const modalTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="modal"]'));
        modalTriggerList.map(function(modalTriggerEl) {
          modalTriggerEl.onclick = function() {
            const theModal = this.getAttribute('data-bs-target'),
              videoSRC = this.getAttribute('data-theVideo'),
              videoSRCauto = `${videoSRC}?autoplay=1`,
              modalVideo = document.querySelector(`${theModal} iframe`);
            if (modalVideo) {
              modalVideo.setAttribute('src', videoSRCauto);
            }
          };
        });
      };

      // Calling function on load
      autoPlayYouTubeModal();

      // Onboarding modal carousel height animation
      document.querySelectorAll('.carousel').forEach(carousel => {
        carousel.addEventListener('slide.bs.carousel', event => {
          // Ensure next slide exists
          if (!event.relatedTarget) {
            console.error('Next slide not found');
            return;
          }
          // Use requestAnimationFrame to wait for render
          requestAnimationFrame(() => {
            // Force reflow
            void event.relatedTarget.offsetHeight;
            const nextHeight = Math.max(
              event.relatedTarget.offsetHeight,
              event.relatedTarget.scrollHeight,
              event.relatedTarget.getBoundingClientRect().height
            );
            const carouselParent = carousel.querySelector('.active.carousel-item').parentElement;
            // Animate only if we have valid heights
            if (nextHeight > 0 && carouselParent) {
              carouselParent.animate([{
                height: carouselParent.offsetHeight + 'px'
              }, {
                height: nextHeight + 'px'
              }], {
                duration: 500,
                easing: 'ease',
                fill: 'forwards'
              });
            }
          });
        });
      });
    })();
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/intellisensetech/public_html/topsyapp/resources/views/admin/stores/index.blade.php ENDPATH**/ ?>