<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\RateLimiter;
use App\Http\Controllers\admin\SettingController;
use App\Http\Controllers\admin\HomeController;
use App\Http\Controllers\LanguageController;
use App\Http\Controllers\admin\ChatAppController;
use App\Http\Controllers\admin\CalenderAppController;
use App\Http\Controllers\admin\NotificationController;
use App\Http\Controllers\admin\EmailAppController;
use App\Http\Controllers\admin\KanbanController;
use App\Http\Controllers\admin\RoleController;
use App\Http\Controllers\admin\UserController;
use App\Http\Controllers\admin\FaqController;
use App\Http\Controllers\admin\ContactController;
use App\Http\Controllers\admin\CategoryController;
use App\Http\Controllers\admin\ParcelCategoryController;
use App\Http\Controllers\admin\VehicleController;
use App\Http\Controllers\admin\VehicleCategoryController;
use App\Http\Controllers\admin\VehicleBrandController;
use App\Http\Controllers\admin\VehicleModelController;
use App\Http\Controllers\admin\BannerController;
use App\Http\Controllers\admin\CountryController;
use App\Http\Controllers\admin\DriverController;
use App\Http\Controllers\admin\CouponController;
use App\Http\Controllers\admin\StoreController;
use App\Http\Controllers\admin\ProductController;
use App\Http\Controllers\admin\OrderController;
use App\Http\Controllers\admin\TransactionController;
use App\Http\Controllers\admin\WithdrawalRequestController;
use App\Http\Controllers\admin\RideController;
use App\Http\Controllers\admin\PackageController;
use App\Http\Controllers\admin\ReviewController;
use App\Http\Controllers\admin\SosAlertController;
use App\Http\Controllers\admin\ReferralController;
use App\Http\Controllers\admin\CarController;
use App\Http\Controllers\admin\RentalController;
use App\Http\Controllers\admin\InstallmentController;
use App\Http\Controllers\admin\DeliveryChargeController;
use App\Http\Controllers\admin\RidePricingRuleController;
use App\Http\Controllers\admin\WalletTransactionController;
use App\Http\Controllers\admin\WalletController;
use App\Http\Controllers\SubscriptionController;
use App\Http\Controllers\FrontendController;


Route::get('/clear-cache', function () {
  Artisan::call('config:clear');
  Artisan::call('cache:clear');
  Artisan::call('config:cache');
  Artisan::call('view:clear');
  return 'Cache Clear Successfully'; //Return anything
});
//create symlink
Route::get('/symlink', function () {
  $exitCode = Artisan::call('storage:link');
  return 'Symlink Created Successfully'; //Return anything
});

Route::group(['prefix' => 'admin', 'middleware' => ['admin', 'auth:web', 'locale']], function () {

  Route::get('/cleanup-images', function () {
    $exitCode = Artisan::call('images:cleanup');
    return response()->json(['message' => 'Images cleanup completed', 'exitCode' => $exitCode]);
  });
  Route::post('check-developer-password', [SettingController::class, 'checkDeveloperPassword'])->name('check.developer.password');
  Route::get('/developer-password/check', function () {
    $key = strtolower('developer-password|' . request()->ip());
    $attemptsLeft = max(0, 3
      - RateLimiter::attempts($key));
    return response()->json(['attempts_left' => $attemptsLeft]);
  });
  Route::post('/logout', [HomeController::class, 'logout'])->name('admin.logout');

  //dashboard
  Route::get('', [HomeController::class, 'dashboard'])->name('admin.dashboard');
  Route::prefix('dashboard')->group(function () {
    Route::get('', [HomeController::class, 'dashboard'])->name('admin.dashboard');
    Route::get('/orders-last-week', [HomeController::class, 'getOrdersLastWeek']);
    Route::get('/sales-last-year', [HomeController::class, 'getSalesLastYear']);
    Route::get('/rides-data', [HomeController::class, 'getRidesDashboardData']);
    Route::get('/earning-reports', [HomeController::class, 'getEarningReports']);
    Route::get('/sales-last-six-months', [HomeController::class, 'salesLastSixMonths']);
    Route::get('/support-tracker', [HomeController::class, 'getSupportTracker']);
  });



  //locale Route
  Route::get('lang/{locale}', [LanguageController::class, 'swap']);

  //notifications
  Route::prefix('notifications')->group(function () {
    Route::get('/{type?}', [NotificationController::class, 'index']);
    Route::post('/mark-read', [NotificationController::class, 'markRead'])->name('notifications.markRead');
    Route::post('/mark-all-read', [NotificationController::class, 'markAllRead'])->name('notifications.markAllRead');
    Route::post('/delete', [NotificationController::class, 'delete'])->name('notifications.delete');
  });

  //calendar
  Route::prefix('calendar')->group(function () {
    Route::get('/', [CalenderAppController::class, 'index'])->name('calendar');
    Route::get('/events', [CalenderAppController::class, 'list']);
    Route::post('/event', [CalenderAppController::class, 'store']);       // Add
    Route::put('/event/{id}', [CalenderAppController::class, 'update']);  // Update
    Route::delete('/event/{id}', [CalenderAppController::class, 'destroy']); // Delete
  });

  //chat
  Route::prefix('chat')->group(function () {
    Route::get('/unreadMesg/{convo_id}', [ChatAppController::class, 'unreadMesg']);
    Route::get('/', [ChatAppController::class, 'chatApp'])->name('chat');
    Route::get('/list/{userid?}/{coversationid?}/{load?}/{myUserId?}', [ChatAppController::class, 'chat']);
    Route::get('/start/{id}', [ChatAppController::class, 'chatStart']);
    Route::post('/sendmessage', [ChatAppController::class, 'sendMessage']);
    Route::post('/image-send', [ChatAppController::class, 'sendImage']);
    Route::get('/block-user/{convoid}/{status}', [ChatAppController::class, 'chatBlock']);
    Route::get('/clear/{convoid}', [ChatAppController::class, 'chatClear']);
  });

  //email
  Route::prefix('email')->group(function () {
    Route::get('/{type?}', [EmailAppController::class, 'index'])->name('email');
    Route::get('getUsers/{id}', [EmailAppController::class, 'getUsers']);
    Route::post('sendEmails', [EmailAppController::class, 'sendEmail']);
    Route::post('changeStatus/{status}', [EmailAppController::class, 'changeStatus']);
    Route::post('/bookmark', [EmailAppController::class, 'toggleBookmark']);
    Route::post('delete', [EmailAppController::class, 'destroy']);
  });

  Route::prefix('kanban')->group(function () {
    Route::get('/', [KanbanController::class, 'index'])->name('kanban');
    Route::get('/data', [KanbanController::class, 'fetch']);
    Route::post('/board', [KanbanController::class, 'storeBoard']);
    Route::delete('/board/{slug}', [KanbanController::class, 'deleteBoard']);
    Route::post('/task', [KanbanController::class, 'storeTask']);
    Route::post('/task/{id}', [KanbanController::class, 'updateTask']);
    Route::delete('/task/{id}', [KanbanController::class, 'deleteTask']);
  });

  //roles
  Route::prefix('roles')->group(function () {
    Route::post('/edit/{id}', [RoleController::class, 'update']);
    Route::post('/store-user', [RoleController::class, 'addUser'])->name('roles.user.store');
    Route::post('/update-user/{id}', [RoleController::class, 'updateUser'])->name('roles.user.update');
    Route::get('/admin-list', [RoleController::class, 'userList']);
  });
  Route::resource('roles', RoleController::class);

  //users
  Route::prefix('users')->group(function () {
    Route::post('/changestatus', [UserController::class, 'changeStatus']);
    Route::post('/set-password', [UserController::class, 'setPassword'])->name('users.setPassword');
    Route::get('/user-list', [UserController::class, 'userListAll']);
  });
  Route::resource('users', UserController::class);

  //drivers
  Route::post('drivers/{id}/status', [DriverController::class, 'changeStatus']);
  Route::get('drivers/{id}/details', [DriverController::class, 'showDetails']);
  Route::get('drivers-maps', [DriverController::class, 'driverMaps'])->name('drivers.map');
  Route::get('driver-list', [DriverController::class, 'driverListAll']);
  Route::resource('drivers', DriverController::class);

  //settings
  Route::get('help', [SettingController::class, 'help'])->name('help');
  Route::get('about-us', [SettingController::class, 'aboutUs'])->name('about_us');
  Route::get('terms', [SettingController::class, 'terms'])->name('terms');
  Route::get('privacy-policy', [SettingController::class, 'privacyPolicy'])->name('privacy_policy');
  Route::post('postSetting', [SettingController::class, 'postSetting']);
  Route::get('settings', [SettingController::class, 'siteSettings'])->name('settings');
  Route::post('postSiteSetting', [SettingController::class, 'postSiteSetting']);

  //tickets
  Route::get('ticket-list-all', [ContactController::class, 'ticketListAll']);
  Route::get('close-tickets', [ContactController::class, 'close']);
  Route::post('tickets/changestatus', [ContactController::class, 'changeStatus']);
  Route::resource('tickets', ContactController::class);

  //faqs
  Route::get('faqs-list', [FaqController::class, 'faqListAll']);
  Route::post('faqs/changestatus', [FaqController::class, 'changeStatus']);
  Route::resource('faqs', FaqController::class);

  //categories
  Route::get('sub-categories', [CategoryController::class, 'subCategory'])->name('categories.sub');
  Route::get('categories-dropdown', [CategoryController::class, 'categoryDropdown']);
  Route::get('categories/{id}/subcategories', [CategoryController::class, 'subcategories']);
  Route::get('categories-list', [CategoryController::class, 'categoryListAll']);
  Route::post('categories/changestatus', [CategoryController::class, 'changeStatus']);
  Route::resource('categories', CategoryController::class);

  //parcel categories
  Route::get('parcel-categories/{id}/subcategories', [ParcelCategoryController::class, 'subcategories']);
  Route::get('parcel-categories-list', [ParcelCategoryController::class, 'categoryListAll']);
  Route::post('parcel-categories/changestatus', [ParcelCategoryController::class, 'changeStatus']);
  Route::resource('parcel-categories', ParcelCategoryController::class);

  //vehicles
  Route::get('vehicles-list', [VehicleController::class, 'vehicleListAll']);
  Route::resource('vehicles', VehicleController::class);

  //vehicle categories
  Route::get('vehicle-categories-type', [VehicleCategoryController::class, 'categoryType'])->name('vehicle-categories-type');
  Route::get('vehicle-categories/dropdown', [VehicleCategoryController::class, 'categories']);
  Route::post('vehicle-categories/country-prices/store', [VehicleCategoryController::class, 'storePrice'])->name('country-vehicle-category.store');
  Route::get('vehicle-categories/{category}/country-prices', [VehicleCategoryController::class, 'getCountryPrices']);
  Route::get('vehicle-categories/{category}/country-prices-chart', [VehicleCategoryController::class, 'getCountryPricesRule']);
  Route::get('vehicle-categories/{id}/subcategories', [VehicleCategoryController::class, 'subcategories']);
  Route::get('vehicle-categories-list', [VehicleCategoryController::class, 'categoryListAll']);
  Route::post('vehicle-categories/changestatus', [VehicleCategoryController::class, 'changeStatus']);
  Route::resource('vehicle-categories', VehicleCategoryController::class);

  //vehicle brands
  Route::get('vehicle-brands-dropdown', [VehicleBrandController::class, 'brandDropdown']);
  Route::get('vehicle-brands-list', [VehicleBrandController::class, 'brandListAll']);
  Route::post('vehicle-brands/changestatus', [VehicleBrandController::class, 'changeStatus']);
  Route::resource('vehicle-brands', VehicleBrandController::class);

  //vehicle models
  Route::get('vehicle-models-dropdown', [VehicleModelController::class, 'modelDropdown']);
  Route::get('vehicle-models-list', [VehicleModelController::class, 'modelListAll']);
  Route::post('vehicle-models/changestatus', [VehicleModelController::class, 'changeStatus']);
  Route::resource('vehicle-models', VehicleModelController::class);

  //country
  Route::get('countries-list', [CountryController::class, 'listAll']);
  Route::post('countries/changestatus', [CountryController::class, 'changeStatus']);
  Route::resource('countries', CountryController::class)->only('index', 'update');

  Route::get('vehicle-color-dropdown', [CountryController::class, 'colorDropdown']);
  Route::get('countries-dropdown', [CountryController::class, 'countries']);
  Route::get('states/{countryId}', [CountryController::class, 'states']);
  Route::get('cities/{stateId}', [CountryController::class, 'cities']);

  //banners
  Route::get('banners-list', [BannerController::class, 'bannerListAll']);
  Route::post('banners/changestatus', [BannerController::class, 'changeStatus']);
  Route::resource('banners', BannerController::class);

  //packages
  Route::get('packages-list', [PackageController::class, 'packageListAll']);
  Route::post('packages/changestatus', [PackageController::class, 'changeStatus']);
  Route::resource('packages', PackageController::class);

  //vehicle
  Route::get('vehicles-list', [VehicleController::class, 'vehicleListAll']);
  Route::post('vehicles/changestatus', [VehicleController::class, 'changeStatus']);
  Route::resource('vehicles', VehicleController::class);

  //stores
  Route::prefix('stores')->group(function () {
    Route::post('get-stores', [StoreController::class, 'getStores'])->name('get-stores');
    Route::post('changePopular', [StoreController::class, 'changePopular']);
    Route::post('{id}/status', [StoreController::class, 'changeStatus']);
    Route::get('{id}/details', [StoreController::class, 'showDetails']);
    Route::get('impersonate/{storeId}', [StoreController::class, 'impersonate'])->name('admin.impersonate');
  });
  Route::get('stores-maps', [StoreController::class, 'storeMaps']);
  Route::get('store-list', [StoreController::class, 'storeListAll']);
  Route::resource('stores', StoreController::class);

  //Coupons
  Route::post('coupons/get_form', [CouponController::class, 'get_coupon_form'])->name('coupons.get_coupon_form');
  Route::get('coupons-list', [CouponController::class, 'couponListAll']);
  Route::post('coupons/changestatus', [CouponController::class, 'changeStatus']);
  Route::resource('coupons', CouponController::class);

  //Products
  Route::post('get-products-by-category', [ProductController::class, 'getProductsByCategory'])->name('get_products_by_category');
  Route::post('get-products-by-store', [ProductController::class, 'getProductsByStore'])->name('get-products');
  Route::post('get_products_by_category', [ProductController::class, 'getProductsByCategory'])->name('products.get_products_by_category');
  Route::get('products-list', [ProductController::class, 'productListAll']);
  Route::post('products/changestatus', [ProductController::class, 'changeStatus']);
  Route::resource('products', ProductController::class);

  //transactions
  Route::get('transaction-list-all', [TransactionController::class, 'transactionListAll']);
  Route::post('transactions/changestatus', [TransactionController::class, 'changeStatus']);
  Route::resource('transactions', TransactionController::class);

  //rides
  Route::get('ride-list-all', [RideController::class, 'rideListAll']);
  Route::get('parcel', [RideController::class, 'parcel'])->name('rides.parcel');
  Route::get('delivery', [RideController::class, 'delivery'])->name('rides.delivery');
  Route::resource('rides', RideController::class);

  //Orders
  Route::get('drivers-active', [DriverController::class, 'activeDrivers']);
  Route::post('orders/{order}/assign-driver', [RideController::class, 'assignDriver']);
  Route::post('/orders/{id}/status', [OrderController::class, 'changeStatus']);
  Route::get('order-list', [OrderController::class, 'orderListAll']);
  Route::post('send-invoice', [OrderController::class, 'sendInvoice']);
  Route::resource('orders', OrderController::class);

  //wallets
  Route::get('withdrawal-list-all', [WithdrawalRequestController::class, 'withdrawalListAll']);
  Route::post('withdrawal_requests/changestatus', [WithdrawalRequestController::class, 'changeStatus']);
  Route::resource('withdrawal_requests', WithdrawalRequestController::class);

  //sos alerts
  Route::get('sos-list-all', [SosAlertController::class, 'sosListAll']);
  Route::resource('sos_alerts', SosAlertController::class);

  //referrals
  Route::get('referral-list-all', [ReferralController::class, 'referralListAll']);
  Route::resource('referrals', ReferralController::class);

  //cars
  Route::get('car-list-all', [CarController::class, 'carListAll']);
  Route::post('cars/changestatus', [CarController::class, 'changeStatus']);
  Route::resource('cars', CarController::class);

  //rentals
  Route::get('/rentals/{rentalId}/next-installment', [RentalController::class, 'nextInstallment']);
  Route::get('rental-list-all', [RentalController::class, 'rentalListAll']);
  Route::post('rentals/changestatus', [RentalController::class, 'changeStatus']);
  Route::resource('rentals', RentalController::class);

  //installments
  Route::get('installment-list-all', [InstallmentController::class, 'installmentListAll']);
  Route::resource('installments', InstallmentController::class);

  //delivery_charges
  Route::resource('delivery_charges', DeliveryChargeController::class);

  //ride pricing rules
  Route::resource('ride_pricing_rules', RidePricingRuleController::class);

  //wallet
  Route::get('wallet-list-all', [WalletController::class, 'walletListAll']);
  Route::get('wallets/stores', [WalletController::class, 'walletStores'])->name('wallets.stores');
  Route::get('wallets/drivers', [WalletController::class, 'walletDrivers'])->name('wallets.drivers');
  Route::post('wallets/clear-dues', [WalletController::class, 'clearDues'])->name('wallet.clear-dues');
  Route::post('wallets/clear-balance', [WalletController::class, 'clearBalance'])->name('wallet.clear-balance');

  //wallet history
  Route::get('wallets/settlements', [WalletTransactionController::class, 'walletSettlements'])->name('wallet.settlements');
  Route::get('wallet_transaction-list-all', [WalletTransactionController::class, 'transactionListAll']);
  Route::get('wallet-history/{id}/{userId}', [WalletTransactionController::class, 'walletHistory'])->name('wallet.history');
  Route::get('wallet-history/{user_id}', [WalletTransactionController::class, 'walletHistoryUser']);

  //reviews
  Route::get('review-list-all', [ReviewController::class, 'reviewListAll']);

  //web-push
  Route::post('save-subscription', [SettingController::class, 'saveSubscription']);

  //backups
  Route::get('backups', [SettingController::class, 'backups'])->name('backups');
  Route::get('download_backup/{id}', [SettingController::class, 'getDownload']);
  Route::get('backup-database', function () {
    try {
      Artisan::call('backup:run --only-db');
      return response()->json([
        'code' => 200,
        'message' => __('locale.Backup Done Successfully. It might take some time for completion'),
      ], 200);

    } catch (\Exception $e) {
      return response()->json([
        'code' => 500,
        'message' => 'Backup failed: ' . $e->getMessage(),
      ], 500);
    }
  });

  Route::get('backup-full', function () {
    Artisan::call('backup:run');
    $result['code'] = 200;
    $result['message'] = __('locale.Backup Done Successfully. It might take some time for completion');
    return $result;
  });

  Route::get('backup-files', function () {
    Artisan::call('backup:run --only-files');
    $result['code'] = 200;
    $result['message'] = __('locale.Backup Done Successfully. It might take some time for completion');
    return $result;
  });


});


Route::group(['prefix' => 'store', 'middleware' => ['store', 'auth:web', 'locale']], function () {

  Route::post('/logout', [HomeController::class, 'logout'])->name('admin.logout');

  //dashboard
  Route::get('', [HomeController::class, 'storeDashboard'])->name('store.dashboard');
  Route::prefix('dashboard')->group(function () {
    Route::get('', [HomeController::class, 'storeDashboard'])->name('store.dashboard');
    Route::get('/average-daily-sales', [HomeController::class, 'averageDailySales']);
  });

  Route::get('profile', [StoreController::class, 'profile'])->name('store.profile');
  Route::post('/store-status', [StoreController::class, 'storeStatus']);
  Route::post('stores/{id}', [StoreController::class, 'storeProfile']);
  Route::get('countries-dropdown', [CountryController::class, 'countries']);
  Route::get('states/{countryId}', [CountryController::class, 'states']);
  Route::get('cities/{stateId}', [CountryController::class, 'cities']);
  Route::get('availability', [StoreController::class, 'availability'])->name('store.availability');
  Route::post('availability-update', [StoreController::class, 'availabilityUpdate'])->name('store.availability.update');
  Route::get('impersonate/stop', [StoreController::class, 'stopImpersonate'])->name('store.impersonate.stop');
  Route::get('settings', [StoreController::class, 'settings'])->name('store.settings');
  Route::post('/store-payment-status/{type}', [StoreController::class, 'storePaymentStatus']);

  //locale Route
  Route::get('lang/{locale}', [LanguageController::class, 'swap']);

  //Products
  Route::prefix('products')->group(function () {
    Route::post('/upload-temp-image', [ProductController::class, 'uploadTempImage'])->name('product.upload.temp');
    Route::post('/delete-temp', [ProductController::class, 'deleteTemp']);
    Route::delete('/delete-image/{id}', [ProductController::class, 'deleteImage'])->name('product.image.delete');
    Route::post('/load-images', [ProductController::class, 'loadImages'])->name('product.images.load');
    Route::post('/changestatus', [ProductController::class, 'changeStatus']);
    Route::post('/changestock', [ProductController::class, 'changeStock']);
    Route::post('/by_category', [ProductController::class, 'getProductsByCategory'])->name('products.by_category');
  });
  Route::get('product-list', [ProductController::class, 'productListAll']);
  Route::resource('products', ProductController::class);

  //Orders
  Route::post('/orders/{id}/status', [OrderController::class, 'changeStatus']);
  Route::post('send-invoice', [OrderController::class, 'sendInvoice']);
  Route::get('order-list', [OrderController::class, 'orderListAll']);
  Route::resource('orders', OrderController::class);

  //wallets
  Route::get('withdrawal-list-all', [WithdrawalRequestController::class, 'withdrawalListAll']);
  Route::post('withdrawal_requests/changestatus', [WithdrawalRequestController::class, 'changeStatus']);
  Route::resource('withdrawal_requests', WithdrawalRequestController::class);

  //subscriptions
  Route::prefix('subscriptions')->group(function () {
    Route::post('', [SubscriptionController::class, 'subscribe'])->name('subscription.subscribe');
    Route::get('success', [SubscriptionController::class, 'success'])->name('subscription.success');
    ;
    Route::get('cancel', [SubscriptionController::class, 'cancell'])->name('subscription.cancel');
    Route::get('', [SubscriptionController::class, 'profile'])->name('subscription.profile');
    Route::post('cancel', [SubscriptionController::class, 'cancel'])->name('subscription.cancel');
    Route::get('stripe/add-card', [SubscriptionController::class, 'createSetupIntent']);
    Route::post('stripe/save-payment-method', [SubscriptionController::class, 'savePaymentMethod'])->name('stripe.save-payment-method');
    Route::delete('stripe/delete-card/{paymentMethodId}', [SubscriptionController::class, 'deleteCard'])->name('stripe.delete-card');
    Route::post('/stripe/set-default/{paymentMethodId}', [SubscriptionController::class, 'savePaymentMethod'])->name('stripe.set-default');
    Route::post('/update-package', [SubscriptionController::class, 'updatePackage'])->name('update.package');
  });

  //reviews
  Route::get('review-list-all', [ReviewController::class, 'reviewListAll']);
  Route::post('reviews/changestatus', [ReviewController::class, 'changeStatus']);
  Route::resource('reviews', ReviewController::class);

  //wallet transactions
  Route::get('wallet_transaction-list-all', [WalletTransactionController::class, 'transactionListAll']);
  Route::resource('wallet_transactions', WalletTransactionController::class);

  //notifications
  Route::prefix('notifications')->group(function () {
    Route::get('/{type?}', [NotificationController::class, 'index']);
    Route::post('/mark-read', [NotificationController::class, 'markRead'])->name('notifications.markRead');
    Route::post('/mark-all-read', [NotificationController::class, 'markAllRead'])->name('notifications.markAllRead');
    Route::post('/delete', [NotificationController::class, 'delete'])->name('notifications.delete');
  });

});

// Main Page Route
Route::group(['prefix' => '', 'middleware' => ['redirectAuthenticated']], function () {
  Route::get('login', [HomeController::class, 'login'])->name('login');
});

Route::group(['prefix' => ''], function () {
  Route::get('home', [FrontendController::class, 'index']);   //change to index for landing page
  Route::get('/', [FrontendController::class, 'index'])->name('index');
  Route::get('about-us', [FrontendController::class, 'aboutUs'])->name('about-us');
  Route::get('contact-us', [FrontendController::class, 'contactUs'])->name('contact-us');
  Route::get('download-app', [FrontendController::class, 'downloadApp'])->name('download-app');
  Route::get('app-feature', [FrontendController::class, 'appFeature'])->name('app-feature');
  Route::post('send-contact-ticket', [FrontendController::class, 'createTicket'])->name('createTicket');
  Route::get('privacy-policy', [SettingController::class, 'getPrivacyPolicy'])->name('privacyPolicy');
  Route::get('terms-and-conditions', [SettingController::class, 'getTerms'])->name('terms');
  Route::get('paystack-message/{txnId?}', [HomeController::class, 'paymentMessage']);
});
