<?php
use Illuminate\Support\Facades\Route;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Broadcast;
use App\Http\Controllers\WebviewController;
use App\Http\Controllers\API\ForgotPasswordController;
use App\Http\Controllers\API\UserController;
use App\Http\Controllers\API\ApiController;
use App\Http\Controllers\API\DriverController;
use App\Http\Controllers\API\ChatAppController;
use App\Http\Controllers\API\RideController;
use App\Http\Controllers\API\DeliveryController;
use App\Http\Controllers\API\CartController;
use App\Http\Controllers\API\OrderController;
use App\Http\Controllers\API\WalletController;
use App\Http\Controllers\API\ParcelController;
use App\Http\Controllers\API\PaymentController;
use App\Http\Controllers\API\PaystackController;

Route::fallback(function () {
  return response()->json([
    'data' => [],
    'success' => false,
    'status' => 404,
    'message' => 'Invalid Route'
  ]);
});

Route::post('broadcasting/auth', function (Request $request) {
  return Broadcast::auth($request);
})->middleware('auth:sanctum');

Route::group(['middleware' => ['api', 'auth:sanctum', 'checkUserStatus', 'verified']], function () {
  Route::get('logout', [UserController::class, 'signout']);
  Route::get('delete-account', [UserController::class, 'deleteAccount']);
  Route::post('change-password', [UserController::class, 'changePassword']);
  Route::get('get-profile', [UserController::class, 'getProfile']);
  Route::get('user-details/{id}', [UserController::class, 'userDetail']);
  Route::post('update-profile', [UserController::class, 'updateProfile']);

  //notifications
  Route::get('notifications', [UserController::class, 'notifications']);
  Route::get('read-notifications', [UserController::class, 'notificationsRead']);
  Route::get('single-notification/{id}', [UserController::class, 'singleNotification']);

  //address
  Route::get('address-list', [UserController::class, 'addressList']);
  Route::post('add-address', [UserController::class, 'addAddress']);
  Route::post('edit-address', [UserController::class, 'addAddress']);
  Route::post('delete-address', [UserController::class, 'deleteAddress']);
  Route::post('set-default-address', [UserController::class, 'setDefaultAddress']);

  //payment methods
  Route::get('payment-methods', [UserController::class, 'paymentMethods']);
  Route::post('add-card', [UserController::class, 'addCard']);
  Route::post('delete-payment-method', [UserController::class, 'deletePaymentMethod']);
  Route::post('set-default-payment-method', [UserController::class, 'setDefaultPaymentMethod']);

  //drivers
  Route::post('drivers', [DriverController::class, 'getDrivers']);
  Route::middleware(['blockIfHighDues:1'])
    ->group(function () {
      Route::post('vehicle-type-parcel-booking', [DriverController::class, 'getVehicleTypes']);
      Route::post('vehicle-type-ride-booking', [DriverController::class, 'getVehicleTypes']);
    });
  Route::post('apply-ride-coupon', [DriverController::class, 'applyCoupon']);
  Route::post('remove-ride-coupon', [DriverController::class, 'removeCoupon']);

  Route::post('driver-register', [DriverController::class, 'register']);
  Route::post('driver-status', [DriverController::class, 'activeStatus']);

  //rides
  Route::get('rides', [RideController::class, 'index']);
  Route::post('request-ride', [RideController::class, 'requestRide']);
  Route::post('cancel-ride-request', [RideController::class, 'cancelRideRequest']);
  Route::post('start-ride/{ride_id}', [RideController::class, 'rideStart']);
  Route::post('ride-end/{ride_id}', [RideController::class, 'rideEnd']);
  Route::post('ride-complete/{ride_id}', [RideController::class, 'rideComplete']);
  Route::post('mark-delivered/{ride_id}', [RideController::class, 'markDelivered']);
  Route::post('ride/{ride_id}', [RideController::class, 'rideDetail']);
  Route::post('cancel-ride', [RideController::class, 'cancelRide']);
  Route::get('sos-alert', [RideController::class, 'sosAlertList']);
  Route::post('sos-alert-add', [RideController::class, 'sosAlertAdd']);
  Route::post('sos-alert', [RideController::class, 'sosAlert']);
  Route::post('sos-alert-delete', [RideController::class, 'sosAlertDelete']);
  Route::post('review/{ride_id}', [RideController::class, 'review']);
  Route::post('update-location', [RideController::class, 'updateLocation']);
  Route::get('ride-last-location/{rideId}', [RideController::class, 'lastDriverLocation']);
  Route::get('get-current-ride', [RideController::class, 'driverCurrentRide']);
  Route::get('get-current-ride-user', [RideController::class, 'userCurrentRide']);
  Route::post('rate-user/{ride_id}', [RideController::class, 'rateUser']);
  Route::post('waiting_time', [RideController::class, 'waitingTime']);
  Route::middleware(['blockIfHighDues:1000'])
    ->group(function () {
      Route::get('get-ride-request', [RideController::class, 'rideRequestDriver']);
      Route::post('driver-response', [RideController::class, 'respondToRequest']);
      Route::post('ride-status', [RideController::class, 'rideStatus']);
    });

  //chat
  Route::get('start-chat/{user_id}/{convo_id?}', [ChatAppController::class, 'chatStart']);
  Route::post('reply-message/{message_id}', [ChatAppController::class, 'replyMessage']);
  Route::get('readMesg/{convo_id}', [ChatAppController::class, 'unreadMesg']);
  Route::get('countUnreadMesg', [ChatAppController::class, 'countUnreadMesg']);
  Route::get('clear-chat/{convo_id}', [ChatAppController::class, 'chatClear']);
  Route::get('delete-message/{id}', [ChatAppController::class, 'messageDelete']);
  Route::post('send-message', [ChatAppController::class, 'sendMessage']);
  Route::get('chats', [ChatAppController::class, 'index']);

  //delivery
  Route::get('categories', [DeliveryController::class, 'categories']);
  Route::post('dashboard', [DeliveryController::class, 'dashboard']);
  Route::post('dashboard-category', [DeliveryController::class, 'categoryDashboard']);
  Route::post('favorite', [DeliveryController::class, 'toggleStoreFavorite']);
  Route::post('store-details/{id}', [DeliveryController::class, 'storeDetail']);
  Route::get('store-popup-details/{id}', [DeliveryController::class, 'storePopupDetail']);
  Route::post('products/{storeId}', [DeliveryController::class, 'productList']);
  Route::post('product-detail/{id}', [DeliveryController::class, 'productDetail']);
  Route::post('favorite-product', [DeliveryController::class, 'toggleProductFavorite']);

  //cart
  Route::post('add-cart', [CartController::class, 'addCart']);
  Route::post('cart-list', [CartController::class, 'cartList']);
  Route::get('cart-clear', [CartController::class, 'clearCart']);
  Route::post('set-address', [CartController::class, 'setAddress']);
  Route::post('set-payment-method', [CartController::class, 'setPayment']);
  Route::post('apply-coupon', [CartController::class, 'applyCoupon']);
  Route::post('remove-coupon', [CartController::class, 'removeCoupon']);

  //order
  Route::post('place-order', [OrderController::class, 'placeOrder']);
  Route::post('order-history', [OrderController::class, 'orderHistory']);
  Route::get('order-details/{id}', [OrderController::class, 'orderDetail']);
  Route::get('order-feedback/{id}', [OrderController::class, 'getOrderFeedback']);
  Route::post('order-feedback/{id}', [OrderController::class, 'orderFeedback']);
  Route::get('order-invoice/{id}', [OrderController::class, 'downloadOrderInvoice']);

  //wallet
  Route::post('withdrawal-request', [WalletController::class, 'WithdrawalRequest']);
  Route::post('withdrawal-list', [WalletController::class, 'WithdrawalList']);
  Route::post('wallet', [WalletController::class, 'walletList']);

  //Parcel
  Route::get('parcel-specifications', [ParcelController::class, 'parcelSpecifications']);
  Route::post('request-parcel-ride', [ParcelController::class, 'requestParcelRide']);
  Route::get('parcel-history', [ParcelController::class, 'parcelHistory']);
  Route::post('parcel-detail/{id}', [ParcelController::class, 'parcelDetail']);

  //online payments
  Route::post('wallet/add', [PaymentController::class, 'addWallet']);
  Route::post('orders/pay', [PaymentController::class, 'payOrder']);
  Route::post('rides/pay', [PaymentController::class, 'payRide']);

  Route::post('paystack/wallet/add', [PaystackController::class, 'addWallet']);
  Route::post('paystack/orders/pay', [PaystackController::class, 'payOrder']);
  Route::post('paystack/rides/pay', [PaystackController::class, 'payRide']);

  //wallet payments
  Route::post('orders/wallet', [PaymentController::class, 'walletOrder']);
  Route::post('rides/wallet', [PaymentController::class, 'walletRide']);

});

Route::group(['middleware' => ['api']], function () {
  Route::get('email/verify/{id}/{hash}', [UserController::class, 'verify'])->middleware(['signed'])->name('verification.verify');
  Route::post('email/verification-notification', [UserController::class, 'resend'])->name('verification.send');
  Route::post('password/forgot', [ForgotPasswordController::class, 'sendResetLink']);
  Route::post('password/reset', [ForgotPasswordController::class, 'resetPassword']);
  Route::post('phone-email-check', [UserController::class, 'phoneEmailCheck']);
  Route::post('register', [UserController::class, 'register']);
  Route::post('login', [UserController::class, 'login']);
  Route::post('splash/{id?}', [UserController::class, 'splash']);
  Route::post('send-otp', [UserController::class, 'sendOtp']);

  //country/state/city
  Route::get('countries', [ApiController::class, 'countries']);
  Route::get('states/{country_id}', [ApiController::class, 'states']);
  Route::get('cities/{state_id}', [ApiController::class, 'cities']);

  //vehicle Dropdowns
  Route::get('vehicle-categories/dropdown', [ApiController::class, 'categories']);
  Route::get('vehicle-brands-dropdown', [ApiController::class, 'brandDropdown']);
  Route::post('vehicle-models-dropdown', [ApiController::class, 'modelDropdown']);
  Route::get('vehicle-color-dropdown', [ApiController::class, 'colorDropdown']);

  //support tickets
  Route::post('tickets', [ApiController::class, 'createTicket']);
  Route::get('tickets', [ApiController::class, 'getTickets']);
  Route::get('customer-support', [ApiController::class, 'support']);
  //Route::get('faqs', [ApiController::class, 'faqs']);

  //webviews
  Route::get('about-us', [WebviewController::class, 'about']);
  Route::get('privacy-policy', [WebviewController::class, 'privacy']);
  Route::get('terms', [WebviewController::class, 'term']);
  Route::get('faqs', [WebviewController::class, 'faqs']);

  //webhooks and callbacks  set in paystack gateway
  Route::get('wallet-callback', [PaystackController::class, 'walletCallback'])->name('wallet.callback');
  Route::get('order-callback', [PaystackController::class, 'orderCallback'])->name('order.callback');
  Route::get('ride-callback', [PaystackController::class, 'rideCallback'])->name('ride.callback');
  Route::get('wallet/webhook', [PaystackController::class, 'walletWebhook']);
  Route::get('order/webhook', [PaystackController::class, 'orderWebhook']);
  Route::get('ride/webhook', [PaystackController::class, 'rideWebhook']);
});
