@extends('layouts/layoutMaster')

@section('title', __('locale.Reviews'))

@section('vendor-style')
  @vite(['resources/assets/css/datatables.scss', 'resources/assets/vendor/libs/apex-charts/apex-charts.scss', 'resources/assets/vendor/libs/raty-js/raty-js.scss'])
@endsection

@section('vendor-script')
  @vite(['resources/assets/js/datatables.js', 'resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/apex-charts/apexcharts.js', 'resources/assets/vendor/libs/raty-js/raty-js.js'])
@endsection

@section('page-style')
  @vite('resources/assets/vendor/scss/pages/app-ecommerce.scss')
@endsection

@section('page-script')
  <script>
    window.reviewData = @json($reviewData['weeklyReviewCounts']);
    window.permissions = {
      reviewableType: @json('store')
    };
  </script>
  @vite(['resources/assets/js/reviews.js'])
@endsection

@section('content')
  <div class="row mb-6 g-6">
    {{-- Left: Rating Summary --}}
    <div class="col-md-6">
      <div class="card h-100">
        <div class="card-body row widget-separator g-0">
          {{-- Left side with main rating --}}
          <div class="col-sm-5 border-shift border-end pe-sm-6">
            <h3 class="text-primary d-flex align-items-center gap-2 mb-2">
              {{ number_format($reviewData['avg_rating'], 2) }}
              <i class="icon-base ti tabler-star-filled icon-32px"></i>
            </h3>
            <p class="h6 mb-2">{{ __('locale.Total') }} {{ $reviewData['total_reviews'] }} {{ __('locale.Reviews') }}</p>
            <p class="pe-2 mb-2">{{ __('locale.All reviews are from genuine customers') }}</p>
            <span class="badge bg-label-primary mb-4 mb-sm-0">
              +{{ $reviewData['new_reviews'] }} {{ __('locale.This week') }}
            </span>
            <hr class="d-sm-none" />
          </div>

          {{-- Right side with star progress --}}
          <div class="col-sm-7 gap-2 text-nowrap d-flex flex-column justify-content-between ps-sm-6 pt-2 py-sm-2">
            @foreach (range(5, 1) as $star)
              <div class="d-flex align-items-center gap-2">
                <small>{{ $star }} Star</small>
                <div class="progress w-100 bg-label-primary" style="height:8px;">
                  <div class="progress-bar bg-primary" role="progressbar"
                    style="width: {{ $reviewData['progress'][$star]['percent'] ?? 0 }}%"
                    aria-valuenow="{{ $reviewData['progress'][$star]['percent'] ?? 0 }}" aria-valuemin="0"
                    aria-valuemax="100">
                  </div>
                </div>
                <small class="w-px-20 text-end">{{ $reviewData['progress'][$star]['count'] ?? 0 }}</small>
              </div>
            @endforeach
          </div>
        </div>
      </div>
    </div>

    {{-- Right: Weekly Statistics --}}
    <div class="col-md-6">
      <div class="card h-100">
        <div class="card-body row">
          <div class="col-sm-5">
            <div class="mb-12">
              <h5 class="mb-2 text-nowrap">{{ __('locale.Reviews statistics') }}</h5>
              <p class="mb-0">
                <span class="me-2">{{ $reviewData['new_reviews'] }} {{ __('locale.New reviews') }}</span>
                <span class="badge bg-label-success">
                  +{{ $reviewData['total_reviews'] > 0
                      ? round(($reviewData['new_reviews'] / $reviewData['total_reviews']) * 100, 1)
                      : 0 }}%
                </span>
              </p>
            </div>

            @php
              $positiveReviews =
                  ($reviewData['progress'][5]['count'] ?? 0) + ($reviewData['progress'][4]['count'] ?? 0);
              $positivePercentage =
                  $reviewData['total_reviews'] > 0
                      ? round(($positiveReviews / $reviewData['total_reviews']) * 100, 1)
                      : 0;
            @endphp

            <div>
              <h6 class="mb-2 fw-normal">
                <span class="text-success me-1">{{ $positivePercentage }}%</span>
                {{ __('locale.Positive reviews') }}
              </h6>
              <small>{{ __('locale.Weekly Report') }}</small>
            </div>
          </div>

          {{-- Placeholder for Chart --}}
          <div class="col-sm-7 d-flex justify-content-sm-end align-items-end">
            <div id="reviewsChart"></div>
          </div>
        </div>
      </div>
    </div>
  </div>


  <!-- review List Table -->
  <div class="card">
    <div class="card-datatable table-responsive">
      <table class="datatables-review table border-top">
        <thead>
          <tr>
            <th></th>
            <th></th>
            <th>{{ __('locale.Product') }}</th>
            <th class="text-nowrap">{{ __('locale.Reviewer') }}</th>
            <th>{{ __('locale.Review') }}</th>
            <th>{{ __('locale.Date') }}</th>
            <th class="text-nowrap">{{ __('locale.Status') }}</th>
            <th>{{ __('locale.Actions') }}</th>
          </tr>
        </thead>
      </table>
    </div>
  </div>

@endsection
