@extends('layouts/layoutMaster')

@section('title', __('locale.Products'))

@section('vendor-style')
  @vite(['resources/assets/css/datatables.scss'])
@endsection

@section('vendor-script')
  @vite(['resources/assets/js/datatables.js'])
@endsection

@section('page-script')
  @vite(['resources/assets/js/products.js'])
@endsection

@section('content')
  <!-- Product List Widget -->
  <div class="card mb-6">
    <div class="card-widget-separator-wrapper">
      <div class="card-body card-widget-separator p-2">
        <div class="row gy-4 gy-sm-1">
          <div class="col-sm-6 col-lg-4">
            <div class="d-flex justify-content-between align-items-start card-widget-1 border-end pb-4 pb-sm-0">
              <div>
                <p class="mb-1">{{ __('locale.Total Products') }}</p>
                <h4 class="mb-1 text-primary">{{ $totalProduct }}</h4>
              </div>
              <span class="avatar me-sm-6">
                <span class="avatar-initial rounded"><i
                    class="icon-base ti tabler-brand-producthunt icon-28px text-heading"></i></span>
              </span>
            </div>
          </div>
          <div class="col-sm-6 col-lg-4">
            <div class="d-flex justify-content-between align-items-start card-widget-2 border-end pb-4 pb-sm-0">
              <div>
                <p class="mb-1">{{ __('locale.Publish Products') }}</p>
                <h4 class="mb-1 text-success">{{ $enabled }}</h4>

              </div>
              <span class="avatar p-2 me-lg-6">
                <span class="avatar-initial rounded"><i
                    class="icon-base ti tabler-smart-home icon-28px text-heading"></i></span>
              </span>
            </div>
          </div>
          <div class="col-sm-6 col-lg-4">
            <div class="d-flex justify-content-between align-items-start border-end pb-4 pb-sm-0 card-widget-3">
              <div>
                <p class="mb-1">{{ __('locale.Disabled Products') }}</p>
                <h4 class="mb-1 text-danger">{{ $disabled }}</h4>
              </div>
              <span class="avatar p-2 me-sm-6">
                <span class="avatar-initial rounded"><i
                    class="icon-base ti tabler-label-off icon-28px text-heading"></i></span>
              </span>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Product List Table -->
  <div class="card">
    <div class="card-header border-bottom">
      <h5 class="card-title d-none">{{ __('locale.Filter') }}</h5>
      <div class="d-flex justify-content-between align-items-center row pt-0 gap-6 gap-md-0 g-md-6">
        <div class="col-md-3 parent_category">
          <label for="ParentCategory" class="form-label">{{ __('locale.Category') }}</label>
          <select id="ParentCategory" class="form-select">
            <option value="">{{ __('locale.All') }}</option>
            @foreach ($parentCategories as $id => $parent)
              <option value="{{ $parent }}">{{ $parent }}</option>
            @endforeach
          </select>
        </div>
        <div class="col-md-3 product_category">
          <label for="ProductCategory" class="form-label">{{ __('locale.Sub Category') }}</label>
          <select id="ProductCategory" class="form-select">
            <option value="">{{ __('locale.All') }}</option>
            @foreach ($categories as $id => $category)
              <option value="{{ $category }}">{{ $category }}</option>
            @endforeach
          </select>
        </div>
        <div class="col-md-3 product_stock">
          <label for="ProductStock" class="form-label">{{ __('locale.Stock') }}</label>
          <select id="ProductStock" class="form-select">
            <option value="">{{ __('locale.All') }}</option>
            <option value="1">{{ __('locale.In Stock') }}</option> <!-- true -->
            <option value="0">{{ __('locale.Out of Stock') }}</option> <!-- false -->
          </select>
        </div>
        <div class="col-md-3 product_status">
          <label for="ProductStatus" class="form-label">{{ __('locale.Status') }}</label>
          <select id="ProductStatus" class="form-select">
            <option value="">{{ __('locale.All') }}</option>
            <option value="1">{{ __('locale.Published') }}</option> <!-- true -->
            <option value="0">{{ __('locale.Not Published') }}</option> <!-- false -->
          </select>
        </div>
      </div>
    </div>
    <div class="card-datatable">
      <table class="datatables-products table">
        <thead class="border-top">
          <tr>
            <th></th>
            <th></th>
            <th>{{ __('locale.Product') }}</th>
            <th>{{ __('locale.Category') }}</th>
            <th>{{ __('locale.Stock') }}</th>
            <th>{{ __('locale.Sku') }}</th>
            <th>{{ __('locale.Price') }}</th>
            <th></th>
            <th>{{ __('locale.Status') }}</th>
            <th>{{ __('locale.Actions') }}</th>
          </tr>
        </thead>
      </table>
    </div>
  </div>

@endsection
