<!-- Invoice -->
<div class="col-xl-12 col-md-12
  col-12 mb-md-0 mb-6">
  <div class="card invoice-preview-card p-sm-12 p-6">
    <div class="card-body invoice-preview-header rounded">
      <div
        class="d-flex justify-content-between flex-xl-row flex-md-column flex-sm-row flex-column align-items-xl-center align-items-md-start align-items-sm-center align-items-start">
        <div class="mb-xl-0 mb-6 text-heading">
          <div class="d-flex svg-illustration mb-6 gap-2 align-items-center">
            <span class="app-brand-logo demo">@include('_partials.macros')</span>
            <span class="app-brand-text fw-bold fs-4 ms-50">{{ config('app.name') }}</span>
          </div>
          <p class="mb-2">{{ $order->store->user->name }}</p>
          <p class="mb-2">{{ $order->store->address }}, {{ $order->store->state }}, {{ $order->store->city }}</p>
          <p class="mb-0">
            {{ $order->store?->dial_code_contact ?? '' }}{{ $order->store?->contact_person_phone ?? '' }}</p>
        </div>
        <div>
          <h5 class="mb-6"> #{{ $order->order_id }}</h5>
          <div class="mb-1 text-heading">

            <span class="fw-medium">{{ $order->created_at->format('d, M') }}<span id="orderYear">
                {{ $order->created_at->format('Y') }}</span></span>
          </div>
          <div class="text-heading">

            <span class="fw-medium">{{ $order->created_at->format('h:i A') }}</span>
          </div>
        </div>
      </div>
    </div>
    <div class="card-body px-0">
      <div class="row">
        <div class="col-xl-6 col-md-12 col-sm-7 col-12 mb-xl-0 mb-md-6 mb-sm-0 mb-6">
          <h6>{{ __('locale.Invoice To') }}:</h6>
          <p class="mb-1">{{ $order->user->name }}</p>
          <p class="mb-1">{{ $order->user->dial_code }}{{ $order->user->phone }}</p>
          <p class="mb-0">{{ $order->user->email }}</p>
        </div>
        @php
          $address = is_array($order->address) ? $order->address : json_decode($order->address, true);
        @endphp
        <div class="col-xl-6 col-md-12 col-sm-5 col-12">
          <div class="mb-0 d-flex flex-column align-items-end pe-4">

            <p>
              <span style="size:16px;font-weight:900"> {{ __('locale.Bill To') }}:</span></br>
              {{ $address['name'] ?? '' }}<br />
              {{ $address['address'] ?? '' }}<br />
              {{ $address['city'] ?? '' }},{{ $address['state'] ?? '' }}</br>
              {{ $address['country'] ?? '' }}</br>
              {{ $address['postcode'] ?? '' }}
            </p>
          </div>
        </div>
      </div>
    </div>
    <div class="table-responsive border border-bottom-0 border-top-0 rounded">
      <table class="table m-0">
        <thead>
          <tr>

            <th>{{ __('Image') }}</th>
            <th class="w-50">{{ __('locale.Products') }}</th>
            <th class="w-25">{{ __('locale.Price') }}</th>
            <th class="w-25">{{ __('locale.Qty') }}</th>
            <th>{{ __('locale.Total') }}</th>
          </tr>
        </thead>
        <tbody>
          @foreach ($order->items as $item)
            <tr>

              <td>
                <div class="d-flex justify-content-start align-items-center mb-6"> @php $img=$item->product?->image?->file ?? ''; @endphp
                  <img src="{{ url('storage/' . $img) }}" style="width:35px; height:35px" alt="Avatar" class="me-1"
                    onerror="this.onerror=null;this.src='{{ asset('assets/img/placeholder.jpg') }}';" />

                </div>
              </td>
              <td class="w-50">
                {{ $item->name ?? 'N/A' }}
              </td>
              <td class="w-25">{{ $currency }}{{ number_format($item->price, 2) }}</td>
              <td class="w-25">{{ $item->quantity }}</td>
              <td>{{ $currency }}{{ number_format($item->price * $item->quantity, 2) }}</td>
            </tr>
          @endforeach
        </tbody>
      </table>
    </div>
    <div class="table-responsive">
      <table class="table m-0 table-borderless">
        <tbody>
          <tr>
            <td class="align-top pe-6 ps-0 py-6 text-body">
              <p class="mb-1">
                <span>{{ $order->store?->contact_person_name ?? '' }}</span>
              </p>
              <span>{{ __('locale.Thanks for your business') }}</span>
            </td>
            <td class="px-0 py-6 w-px-100">
              <p class="mb-2">{{ __('locale.Subtotal') }}:</p>
              <p class="mb-2">{{ __('locale.Discount') }}:</p>
              <p class="mb-2">{{ __('locale.Shipping') }}:</p>
              <p class="mb-2 border-bottom pb-2">{{ __('locale.Tax') }}:</p>
              <p class="mb-0">{{ __('locale.Total') }}:</p>
            </td>
            <td class="text-end px-0 py-6 w-px-100 fw-medium text-heading">
              <p class="fw-medium mb-2">{{ $currency }}{{ number_format($order->subtotal, 2) }}</p>
              <p class="fw-medium mb-2">{{ $currency }}{{ number_format($order->discount ?? 0, 2) }}</p>
              <p class="fw-medium mb-2">{{ $currency }}{{ number_format($order->shipping ?? 0, 2) }}</p>
              <p class="fw-medium mb-2 border-bottom pb-2">
                {{ $currency }}{{ number_format($order->tax ?? 0, 2) }}</p>
              <p class="fw-medium mb-0">{{ $currency }}{{ number_format($order->grand_total, 2) }}</p>
            </td>
          </tr>
        </tbody>
      </table>
    </div>

    <hr class="mt-0 mb-6" />
    <div class="card-body p-0">
      <div class="row">
        <div class="col-12">
          <span class="fw-medium text-heading">{{ __('locale.Note') }}:</span>
          <span>It was a pleasure working with you and your team. We truly appreciate your business and hope to serve
            you again on future orders. Thank you for choosing us!</span>
        </div>
      </div>
    </div>
  </div>
</div>
<!-- /Invoice -->
