@extends('layouts/layoutMaster')

@section('title', __('locale.Orders'))

@section('vendor-style')
  @vite(['resources/assets/css/datatables.scss'])
@endsection

@section('vendor-script')
  @vite(['resources/assets/js/datatables.js', 'resources/assets/vendor/libs/raty-js/raty-js.js'])
@endsection

@section('content')
  <!-- Order List Widget -->

  <div class="card mb-6">
    <div class="card-widget-separator-wrapper">
      <div class="card-body card-widget-separator">
        <div class="row gy-4 gy-sm-1">
          <div class="col-sm-6 col-lg-3">
            <div class="d-flex justify-content-between align-items-start card-widget-1 border-end pb-4 pb-sm-0">
              <div>
                <h4 class="mb-0 text-primary">{{ $totalOrder }}</h4>
                <p class="mb-0">{{ __('locale.Total Orders') }}</p>
              </div>
              <span class="avatar me-sm-6">
                <span class="avatar-initial bg-label-secondary rounded text-heading">
                  <i class="icon-base ti tabler-calendar-stats icon-26px text-heading"></i>
                </span>
              </span>
            </div>
            <hr class="d-none d-sm-block d-lg-none me-6" />
          </div>
          <div class="col-sm-6 col-lg-3">
            <div class="d-flex justify-content-between align-items-start card-widget-2 border-end pb-4 pb-sm-0">
              <div>
                <h4 class="mb-0 text-success">{{ $completed }}</h4>
                <p class="mb-0">{{ __('locale.Completed') }}</p>
              </div>
              <span class="avatar p-2 me-lg-6">
                <span class="avatar-initial bg-label-secondary rounded"><i
                    class="icon-base ti tabler-checks icon-26px text-heading"></i></span>
              </span>
            </div>
            <hr class="d-none d-sm-block d-lg-none" />
          </div>
          <div class="col-sm-6 col-lg-3">
            <div class="d-flex justify-content-between align-items-start border-end pb-4 pb-sm-0 card-widget-3">
              <div>
                <h4 class="mb-0 text-warning">{{ $pendingPayments }}</h4>
                <p class="mb-0">{{ __('locale.Pending Payment') }}</p>
              </div>
              <span class="avatar p-2 me-sm-6">
                <span class="avatar-initial bg-label-secondary rounded"><i
                    class="icon-base ti tabler-wallet icon-26px text-heading"></i></span>
              </span>
            </div>
          </div>
          <div class="col-sm-6 col-lg-3">
            <div class="d-flex justify-content-between align-items-start">
              <div>
                <h4 class="mb-0 text-danger">{{ $cancelled }}</h4>
                <p class="mb-0">{{ __('locale.Cancelled') }}</p>
              </div>
              <span class="avatar p-2">
                <span class="avatar-initial bg-label-secondary rounded"><i
                    class="icon-base ti tabler-alert-octagon icon-26px text-heading"></i></span>
              </span>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Order List Table -->
  <div class="card">
    <div class="card-header border-bottom">
      <h5 class="card-title d-none">{{ __('locale.Filter') }}</h5>
      <div class="d-flex justify-content-between align-items-center row pt-0 gap-6 gap-md-0 g-md-6">
        <div class="col-md-3 customer">
          <label for="ParentCategory" class="form-label">{{ __('locale.Customers') }}</label>
          <select id="Customer" class="select2 form-select">
            <option value="">{{ __('locale.All') }}</option>
            @foreach ($customers as $id => $name)
              <option value="{{ $id }}">{{ $name }}</option>
            @endforeach
          </select>
        </div>
        <div class="col-md-3 order_status"></div>
        <div class="col-md-3 payment_status"></div>
        <div class="col-md-3 payment_type"></div>
      </div>
    </div>
    <div class="card-datatable table-responsive">
      <table class="datatables-order table border-top">
        <thead>
          <tr>
            <th></th>
            <th></th>
            <th>{{ __('locale.Order') }}</th>
            <th>{{ __('locale.Date') }}</th>
            <th>{{ __('locale.Customers') }}</th>
            <th>{{ __('locale.Payment') }}</th>
            <th>{{ __('locale.Status') }}</th>
            <th>{{ __('locale.Type') }}</th>
            <th>{{ __('locale.Actions') }}</th>
          </tr>
        </thead>
      </table>
    </div>
  </div>
  @include('_partials/_modals/modal-prescription')
  @include('_partials/_modals/modal-assign-driver')
@endsection
@section('page-script')
  @vite(['resources/assets/js/orders.js'])
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    $(document).on('click', '.assignDriver', function() {
      let orderId = $(this).data('order-id');
      $('#order_id').val(orderId);
      // Open modal
      $('#assignDriverModal').modal('show');
      // Load drivers into select
      $.ajax({
        url: `${baseURL}/drivers-active`,
        type: 'GET',
        success: function(response) {
          let options = '<option value="">-- Select Driver --</option>';
          if (response.data.length > 0) {
            response.data.forEach(driver => {
              options +=
                `<option value="${driver.id}">${driver.user.name} (${driver.user.dial_code}${driver.user.phone})</option>`;
            });
          }
          $('#driverSelect').html(options);
        }
      });
    });

    // Submit form to assign driver
    $(function() {
      const table = $('.datatables-order').DataTable();
      let $btn = null;

      $(document).on('click', '#upload_form button[type="submit"]', function() {
        $btn = $(this);
      });
      $('#assignDriverForm').on('submit', function(e) {
        e.preventDefault();
        let orderId = $('#order_id').val();
        let driverId = $('#driverSelect').val();
        if (!driverId) {
          alert('Please select a driver');
          return;
        }
        $.ajax({
          url: `${baseURL}/orders/${orderId}/assign-driver`,
          type: 'POST',
          data: {
            _token: $('meta[name="csrf-token"]').attr('content'),
            driver_id: driverId
          },
          beforeSend: function() {
            toggleButtonLoading($btn, true, 'Assigning...');
          },
          success: function(data) {
            if (data.status === 200 && data.data) {
              $('#assignDriverModal').modal('hide');
              $('.hideCar-' + orderId).hide();
            }
            toggleButtonLoading($btn, false);
            const toastType = data.status == 200 ? 'bg-success' : 'bg-warning';
            window.showToast({
              title: 'Order 🛒',
              message: data.message,
              type: toastType,
              animation: 'animate__fadeInUp',
              time: 'Just now',
              delay: 3000
            });
          },
          error: function(xhr) {
            toggleButtonLoading($btn, false);
            console.log(xhr.responseJSON);
          }
        });
      });
    });
  </script>
@endsection
