@extends('layouts/layoutMaster')

@section('title', __('locale.Availability'))

@section('vendor-style')
  @vite(['resources/assets/vendor/libs/select2/select2.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.scss'])
@endsection

@section('vendor-script')
  @vite(['resources/assets/vendor/libs/select2/select2.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.js'])
@endsection

@section('page-script')
  <script>
    document.addEventListener("DOMContentLoaded", function() {
      // Init flatpickr time pickers
      for (let i = 0; i <= 6; i++) {
        flatpickr(`#datetimepicker${i}, #datetimepicker_ch${i}`, {
          enableTime: true,
          noCalendar: true,
          dateFormat: "h:i K",
          time_24hr: false
        });
      }

      // Init Select2
      $('.select2').select2({
        theme: 'bootstrap-5',
        width: '100%'
      });

      // Toggle business hours display
      const toggleBusinessHours = (val) => {
        document.getElementById('business_hours_div')
          .style.display = (val == 0) ? 'block' : 'none';
      };

      toggleBusinessHours(document.querySelector('select[name="always_open"]').value);

      document.querySelector('select[name="always_open"]').addEventListener('change', function() {
        toggleBusinessHours(this.value);
      });

      // Live badge color/status update
      document.querySelectorAll('.day-status').forEach(select => {
        select.addEventListener('change', function() {
          const badge = this.closest('.row').querySelector('.day-badge');
          if (this.value == "1") {
            badge.classList.remove('bg-danger');
            badge.classList.add('bg-success');
            badge.textContent = 'Open';
          } else {
            badge.classList.remove('bg-success');
            badge.classList.add('bg-danger');
            badge.textContent = 'Closed';
          }
        });
      });

      const form = document.getElementById('availabilityForm');
      let $btn = null;

      $(document).on('click', '#availabilityForm button[type="submit"]', function() {
        $btn = $(this);
      });
      form.addEventListener('submit', function(e) {
        e.preventDefault();
        toggleButtonLoading($btn, true, 'Saving...');
        let formData = new FormData(form);
        fetch(form.action, {
            method: 'POST',
            headers: {
              'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            },
            body: formData
          })
          .then(response => response.json())
          .then(data => {
            if (data.status === 200 && data.data) {

            }
            toggleButtonLoading($btn, false);
            const toastType = data.status == 200 ? 'bg-success' : 'bg-warning';
            window.showToast({
              title: 'Categories 🗂️',
              message: data.message,
              type: toastType,
              animation: 'animate__fadeInUp',
              time: 'Just now',
              delay: 3000
            });
          })
          .catch(err => {
            console.error(err);
            alert('Request failed.');
          });
      });
    });
  </script>
@endsection

@section('content')
  @php
    // Define default week days with empty hours if no record exists
    $defaultDays = [
        ['day' => 'Monday', 'status' => 0, 'start_time' => '', 'end_time' => ''],
        ['day' => 'Tuesday', 'status' => 0, 'start_time' => '', 'end_time' => ''],
        ['day' => 'Wednesday', 'status' => 0, 'start_time' => '', 'end_time' => ''],
        ['day' => 'Thursday', 'status' => 0, 'start_time' => '', 'end_time' => ''],
        ['day' => 'Friday', 'status' => 0, 'start_time' => '', 'end_time' => ''],
        ['day' => 'Saturday', 'status' => 0, 'start_time' => '', 'end_time' => ''],
        ['day' => 'Sunday', 'status' => 0, 'start_time' => '', 'end_time' => ''],
    ];

    // If editing, replace defaults with saved values
    $businessHours =
        isset($store['businessHours']) && count($store['businessHours']) > 0 ? $store['businessHours'] : $defaultDays;
  @endphp

  <div class="container-xxl">
    <form id="availabilityForm" action="{{ route('store.availability.update') }}" method="POST" class="needs-validation"
      novalidate>
      @csrf

      <div class="card shadow-sm">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h4 class="card-title mb-0">{{ __('locale.Availability') }}</h4>
        </div>

        <div class="card-body">
          <!-- Always open / custom hours -->
          <div class="mb-4">
            <label class="form-label fw-semibold">{{ __('locale.Business Hours Mode') }}</label>
            <select name="always_open" class="form-select">
              <option value="0" {{ $store->always_open == 0 ? 'selected' : '' }}>Custom Hours</option>
              <option value="1" {{ $store->always_open == 1 ? 'selected' : '' }}>Always Open</option>
            </select>
          </div>

          <!-- Business hours -->
          <div id="business_hours_div" style="display:none">
            @foreach ($businessHours as $key => $value)
              <div class="row align-items-center g-3 mb-3 border-bottom pb-2">
                <!-- Day label with status badge -->
                <div class="col-md-2 d-flex align-items-center">
                  <span class="fw-bold">{{ $value['day'] }}</span>
                  <span class="badge ms-2 day-badge {{ ($value['status'] ?? 0) == 1 ? 'bg-success' : 'bg-danger' }}">
                    {{ ($value['status'] ?? 0) == 1 ? 'Open' : 'Closed' }}
                  </span>
                </div>

                <!-- Status select -->
                <div class="col-md-3">
                  <select name="d{{ $key }}_status" class="form-select day-status">
                    <option value="0" {{ ($value['status'] ?? 0) == 0 ? 'selected' : '' }}>Closed</option>
                    <option value="1" {{ ($value['status'] ?? 0) == 1 ? 'selected' : '' }}>Open</option>
                  </select>
                </div>

                <!-- Start time -->
                <div class="col-md-3">
                  <div class="input-group">
                    <input type="text" id="datetimepicker{{ $key }}" name="d{{ $key }}_OH"
                      value="{{ $value['start_time'] ?? '' }}" class="form-control" placeholder="Start Time">
                    <span class="input-group-text"><i class="icon-base ti tabler-clock icon-xs"></i></span>
                  </div>
                </div>

                <!-- Close time -->
                <div class="col-md-3">
                  <div class="input-group">
                    <input type="text" id="datetimepicker_ch{{ $key }}" name="d{{ $key }}_CH"
                      value="{{ $value['end_time'] ?? '' }}" class="form-control" placeholder="Close Time">
                    <span class="input-group-text"><i class="icon-base ti tabler-clock icon-xs"></i></span>
                  </div>
                </div>
              </div>
            @endforeach

          </div>
        </div>

        <div class="card-footer text-end">
          <button type="submit" class="btn btn-primary">
            <i class="bi bi-save me-1"></i> {{ __('locale.Save') }}
          </button>
        </div>
      </div>
    </form>
  </div>
@endsection
