@extends('layouts/layoutMaster')
@section('title', 'Dashboard - CRM')
@section('content')
  <style>
    [data-bs-theme="dark"] .justify-between .text-gray-900 {
      color: #f1f1f1 !important;
      /* Light text in dark mode */
    }

    [data-bs-theme="dark"] .justify-between .text-gray-600 {
      color: #b1afaf !important;
      /* Dark background in dark mode */
    }
  </style>

  <div>
    <div class="max-w-7xl mx-auto py-10 sm:px-6 lg:px-8">
      @if (Laravel\Fortify\Features::canUpdateProfileInformation())
        @livewire('profile.update-profile-information-form')

        <x-section-border />
      @endif

      @if (Laravel\Fortify\Features::enabled(Laravel\Fortify\Features::updatePasswords()))
        <div class="mt-10 sm:mt-0">
          @livewire('profile.update-password-form')
        </div>

        <x-section-border />
      @endif

      @if (Laravel\Fortify\Features::canManageTwoFactorAuthentication())
        <div class="mt-10 sm:mt-0">
          @livewire('profile.two-factor-authentication-form')
        </div>

        <x-section-border />
      @endif

      <div class="mt-10 sm:mt-0">
        @livewire('profile.logout-other-browser-sessions-form')
      </div>

      @if (Laravel\Jetstream\Jetstream::hasAccountDeletionFeatures())
        <x-section-border />

        <div class="mt-10 sm:mt-0">
          @livewire('profile.delete-user-form')
        </div>
      @endif
    </div>
  </div>
@endsection
