@php
  use Illuminate\Support\Facades\Route;
@endphp
<style>
  /* Hide the dot when icon is present */
  .menu .menu-sub>.menu-item.has-icon>.menu-link::before {
    content: none;
    display: none;
  }

  /* Remove the space reserved for ::before */
  .menu .menu-sub>.menu-item.has-icon>.menu-link {
    padding-inline-start: 1.5rem;
    /* Or whatever matches items without the dot */
  }

  /* Keep padding for items without icon (i.e., with dot) */
  .menu .menu-sub>.menu-item:not(.has-icon)>.menu-link {
    padding-inline-start: 2.5rem;
    /* Adjust based on how much space the dot takes */
  }
</style>
<ul class="menu-sub">

  @if (isset($menu))
    @foreach ($menu as $submenu)
      {{-- active menu method --}}
      @php
        $activeClass = null;
        $active = $configData['layout'] === 'vertical' ? 'active open' : 'active';
        $currentRouteName = Route::currentRouteName();

        if ($currentRouteName === $submenu->slug) {
            $activeClass = 'active';
        } elseif (isset($submenu->submenu)) {
            if (gettype($submenu->slug) === 'array') {
                foreach ($submenu->slug as $slug) {
                    if (str_contains($currentRouteName, $slug) and strpos($currentRouteName, $slug) === 0) {
                        $activeClass = $active;
                    }
                }
            } else {
                if (
                    str_contains($currentRouteName, $submenu->slug) and
                    strpos($currentRouteName, $submenu->slug) === 0
                ) {
                    $activeClass = $active;
                }
            }
        }
      @endphp
      @if (empty($submenu->role) || auth()->user()->can($submenu->role))
        <li class="menu-item {{ $activeClass }} {{ isset($submenu->icon) ? 'has-icon' : '' }}">
          <a href="{{ isset($submenu->url) ? url($adminConfigData['prefix'] . $submenu->url) : 'javascript:void(0)' }}"
            class="{{ isset($submenu->submenu) ? 'menu-link menu-toggle' : 'menu-link' }}"
            @if (isset($submenu->target) and !empty($submenu->target)) target="_blank" @endif>
            @if (isset($submenu->icon))
              <i class="{{ $submenu->icon }}"></i>
            @endif
            <div>{{ isset($submenu->name) ? __('locale.' . $submenu->name) : '' }}</div>
            @if ($submenu->name === 'Chat')
              <span class="badge bg-success rounded-pill ms-auto"
                id="chatMessageCount">{{ $submenu->badge[1] ?? '' }}</span>
            @endif
            @isset($submenu->badge)
              @if ($submenu->name != 'Chat')
                <div class="badge bg-{{ $submenu->badge[0] }} rounded-pill ms-auto">{{ $submenu->badge[1] }}</div>
              @endif
            @endisset
          </a>

          {{-- submenu --}}
          @if (isset($submenu->submenu))
            @include('layouts.sections.menu.submenu', ['menu' => $submenu->submenu])
          @endif
        </li>
      @endif
    @endforeach
  @endif
</ul>
