     @include('frontend.includes.header')
     <!-- ========= Breadcrumb ======= -->
     <section id="breadcrumb">
       <div class="container">
         <div class="row">
           <div class="col-lg-8 col-sm-6">
             <div class="breadcrumb-link">
               <h4>DOWNLOAD APP</h4>
             </div>
           </div>
           <div class="col-lg-4 col-sm-6">
             <div class="breadcrumb-anchor">
               <ul>
                 <li><a href="{{ url('') }}">Home</a></li>
                 <li>
                   <p>Download App</p>
                 </li>
               </ul>
             </div>
           </div>
         </div>
       </div>
     </section>


     <!-- ========= Our Categories ======= -->
     <section id="categories">
       @php
         $settings = \App\Models\Setting::whereIn('meta_key', [
             'driver_android_app_link',
             'driver_ios_app_link',
             'customer_android_app_link',
             'customer_ios_app_link',
         ])->pluck('meta_value', 'meta_key');
       @endphp
       <div class="container">
         <div class="row">
           <div class="col-lg-7 col-sm-6 order-2 order-lg-1">
             <div class="app-screen-text">
               <h2>Download <br><span>{{ config('app.name') }} User App</span></h2>
               <p>Download the User App and get everything delivered in minutes! From booking rides to ordering food,
                 groceries, and medicines — manage it all in one place. Real-time tracking, quick payments, and
                 effortless convenience right at your fingertips.
               </p>
               <ul>
                 <li><a href="{{ $settings['customer_android_app_link'] }}" target="_blank"><img
                       src="{{ asset('frontend/assets/img/google-play.png') }}" class="img-fluid"></a>
                 </li>
                 <li><a href="{{ $settings['customer_ios_app_link'] }}" target="_blank"><img
                       src="{{ asset('frontend/assets/img/app-store.png') }}" class="img-fluid"></a></li>
               </ul>
             </div>
           </div>
           <div class="col-lg-5 col-sm-6 order-1 order-lg-2">
             <div class="app-screen">
               <img src="{{ asset('frontend/assets/img/user-app-screen.png') }}" class="img-fluid" alt="playstore">
             </div>
           </div>
         </div>
         <div class="row">
           <div class="col-lg-5 col-sm-6">
             <div class="app-screen-driver">
               <img src="{{ asset('frontend/assets/img/user-app-screen.png') }}" class="img-fluid" alt="playstore">
             </div>
           </div>
           <div class="col-lg-7 col-sm-6">
             <div class="app-screen-text">
               <h2>Download <br><span>{{ config('app.name') }} Driver App</span></h2>
               <p>Download the Driver App and start earning today! Accept ride and delivery requests instantly, track
                 routes easily, and enjoy fast payments. Flexible hours, more freedom, and steady income all in one
                 powerful app built for drivers.
               </p>
               <ul class="">
                 <li><a href="{{ $settings['driver_android_app_link'] }}" target="_blank"><img
                       src="{{ asset('frontend/assets/img/google-play.png') }}" class="img-fluid"></a>
                 </li>
                 <li><a href="{{ $settings['driver_ios_app_link'] }}" target="_blank"><img
                       src="{{ asset('frontend/assets/img/app-store.png') }}" class="img-fluid"></a></li>
               </ul>
             </div>
           </div>
         </div>
       </div>
     </section>
     @include('frontend.includes.footer')
