    @include('frontend.includes.header')
    <!-- ========= Breadcrumb ======= -->
    <section id="breadcrumb">
      <div class="container">
        <div class="row">
          <div class="col-lg-8 col-sm-6">
            <div class="breadcrumb-link">
              <h4>CONTACT US</h4>
            </div>
          </div>
          <div class="col-lg-4 col-sm-6">
            <div class="breadcrumb-anchor">
              <ul>
                <li><a href="{{ url('') }}">Home</a></li>
                <li>
                  <p>Contact Us</p>
                </li>
              </ul>
            </div>
          </div>
        </div>
      </div>
    </section>


    <!-- ========= Our Categories ======= -->
    <section id="categories">
      @php
        $settings = \App\Models\Setting::whereIn('meta_key', [
            'contact_number',
            'email',
            'address',
            'twitter',
            'facebook',
            'linkdin',
            'instagram',
            'driver_android_app_link',
            'driver_ios_app_link',
            'customer_android_app_link',
            'customer_ios_app_link',
        ])->pluck('meta_value', 'meta_key');
      @endphp
      <div class="container">
        <div class="row">
          <div class="col-lg-12">
            <div class="section-title mb-4">
              <span>Contact Us</span>
              <h2>GET IN <span>TOUCH</span></h2>
              <p> Have questions about our rides or delivery services? We're here to help you 24/7.
                Reach out to our support team for bookings, driver assistance, or any other inquiries.
                Let's make your journey smooth and reliable.</p>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-lg-3 col-sm-6">
            <div class="contact-page-info">
              <i class="fa-solid fa-location-dot"></i>
              <h4>Our Location</h4>
              <p>{{ $settings['address'] }}</p>
            </div>
          </div>
          <div class="col-lg-3 col-sm-6">
            <div class="contact-page-info">
              <i class="fa-solid fa-phone-volume"></i>
              <h4>Phone Number</h4>
              <p>{{ $settings['contact_number'] }}</p>
            </div>
          </div>
          <div class="col-lg-3 col-sm-6">
            <div class="contact-page-info">
              <i class="fa-solid fa-envelope"></i>
              <h4>Email Address</h4>
              <p>{{ $settings['email'] }}</p>
            </div>
          </div>
          <div class="col-lg-3 col-sm-6">
            <div class="contact-page-info">
              <h4>Follow Us On:</h4>
              <div class="social-media-contact">
                <ul>
                  <li><a href="{{ $settings['facebook'] }}"><i class="fa-brands fa-facebook-f"></i></a></li>
                  <li><a href="{{ $settings['instagram'] }}"><i class="fa-brands fa-instagram"></i></a></li>
                  <li><a href="{{ $settings['twitter'] }}"><i class="fa-brands fa-x-twitter"></i></a></li>
                  <li><a href="{{ $settings['linkdin'] }}"><i class="fa-brands fa-linkedin-in"></i></a></li>
                </ul>
              </div>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-lg-6 col-sm-6">
            <div class="form-box-contact">
              @include('_partials.flashMessage')
              <form method="POST" id="contact-us" action="{{ url('send-contact-ticket') }}">
                {{ csrf_field() }}
                <div class="mb-4">
                  <label for="exampleInput" class="form-label">Full Name</label>
                  <input type="text" name="person_name" class="form-control" id="exampleInput"
                    aria-describedby="emailHelp" placeholder="Eg.John Doe" required>
                </div>
                <div class="mb-4">
                  <label for="exampleInputEmail1" class="form-label">Email address</label>
                  <input type="email" name="person_email" class="form-control" id="exampleInputEmail1"
                    aria-describedby="emailHelp" placeholder="Eg.johndoe@gmail.com" required>
                </div>
                <div class="mb-4">
                  <label for="exampleInputPassword1" class="form-label">Mobile Number</label>
                  <input type="text" name="phone" class="form-control" id="exampleInputPassword1"
                    placeholder="Eg.123-456-7890" required>
                </div>
                <div class="mb-4">
                  <label for="exampleInputSubject" class="form-label">Subject</label>
                  <input type="text" name="subject" class="form-control" id="exampleInputSubject"
                    aria-describedby="emailHelp" required>
                </div>
                <div class="mb-4">
                  <label for="exampleInputt" class="form-label">Message</label>
                  <textarea name="message" rows="3" class="form-control" placeholder="Type Here...." required></textarea>
                </div>
                <div class="read-more-btn">
                  <!-- Hidden input to store reCAPTCHA token -->
                  <input type="hidden" name="recaptcha_token" id="recaptchaToken">
                  <button class="hvr-shutter-out-horizontal btn">Send Message</button>
                </div>
              </form>
            </div>
          </div>
          <div class="col-lg-6 col-sm-6">
            <div class="map-location">
              <iframe
                src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d193596.26002810575!2d-74.14431235114544!3d40.69728463488439!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x89c24fa5d33f083b%3A0xc80b8f06e177fe62!2sNew%20York%2C%20NY%2C%20USA!5e0!3m2!1sen!2sin!4v1760596578441!5m2!1sen!2sin"
                width="100%" height="500" style="border:0;" allowfullscreen="" loading="lazy"
                referrerpolicy="no-referrer-when-downgrade"></iframe>
            </div>
          </div>
        </div>
      </div>
    </section>
    <script src="https://www.google.com/recaptcha/api.js?render={{ config('services.google.RECAPTCHA_SITE_KEY') }}">
    </script>
    <script>
      document.getElementById('contact-us').addEventListener('submit', function(e) {
        e.preventDefault(); // prevent immediate submit
        grecaptcha.ready(function() {
          grecaptcha.execute('{{ config('services.google.RECAPTCHA_SITE_KEY') }}', {
              action: 'contact_form'
            })
            .then(function(token) {
              document.getElementById('recaptchaToken').value = token;
              e.target.submit(); // submit form after token is set
            });
        });
      });
    </script>
    @include('frontend.includes.footer')
