@extends('layouts/layoutMaster')

@section('title', __('locale.Backups'))

@section('page-style')
  @vite(['resources/assets/vendor/fonts/fontawesome.scss', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.scss'])
@endsection

@section('vendor-script')
  @vite(['resources/assets/vendor/libs/sweetalert2/sweetalert2.js'])
@endsection

@section('content')

  <!-- Striped Rows -->
  <div class="card">
    <h5 class="card-header">{{ __('locale.Backups') }}</h5>
    @can('site_Settings-create')
      <div class="d-flex">
        <a style="display: none" href="{{ url('admin/backup-full') }}" class="btn btn-sm btn-danger mr-1 mb-1  confirm-text"><i
            class="icon-base ti tabler-server"></i> {{ __('locale.Backup Full Project') }}</a>
        <a style="display: none" href="{{ url('admin/backup-files') }}"
          class="btn btn-sm btn-warning mr-1 mb-1  confirm-text"><i class="icon-base ti tabler-server"></i>
          {{ __('locale.Backup Files') }}</a>
        <button type="button" data-id="{{ url('admin/backup-database') }}"
          class="btn btn-sm btn-primary mr-1 mb-1  confirm-text"><i class="icon-base ti tabler-server"></i>
          {{ __('locale.Backup Database') }}</button>
      </div>
    @endcan
    <div class="table-responsive text-nowrap">
      <table class="table table-striped table-bordered table-hover">
        <thead>
          <tr>
            <th valign="middle">#</th>
            <th>{{ __('locale.Name') }}</th>
            <th>{{ __('locale.Size') }}</th>
            <th>{{ __('locale.Date') }}</th>
            <th>{{ __('locale.Actions') }}</th>
          </tr>
        </thead>
        <tbody class="table-border-bottom-0">
          <?php foreach ($backups as $key => $value): ?>
          <tr class="item">
            <td class="col1">{{ $key + 1 }}</td>
            <td>{{ $value['file_name'] }}</td>
            <td>{{ number_format($value['file_size'] / 1024, 2) }} KB</td>
            <td> {{ $value['last_modified'] }} </td>
            <td>
              <ul class="actions" style="display:flex;align-items:center;">
                <li style="display:table-cell;list-style: none">

                </li>
                @can('site_Settings-create')
                  <button href="#" data-id="{{ url('admin/download_backup') }}/{{ $value['file_name'] }}"
                    class="btn btn-primary btn-sm  download-confirm"><i class="icon-base ti tabler-download"></i>
                    {{ __('locale.Download Backup') }}</button>
                @endcan

              </ul>
            </td>
          </tr>
          <?php endforeach ?>
        </tbody>
      </table>
    </div>
  </div>
  <!--/ Striped Rows -->

@endsection
@section('page-script')
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    $(function() {
      $('.confirm-text').on('click', function() {
        const $btn = $(this);
        var url = $(this).attr('data-id');
        Swal.fire({
          title: 'Are you sure?',
          text: "Are you sure? This will take some time",
          icon: 'warning',
          showCancelButton: true,
          confirmButtonText: 'Yes!',
          customClass: {
            confirmButton: 'btn btn-primary me-3',
            cancelButton: 'btn btn-label-secondary'
          },
          buttonsStyling: false
        }).then(function(result) {
          if (result.value) {
            $.ajax({
              url: url,
              beforeSend: function() {
                toggleButtonLoading($btn, true, 'Processing...');
              },
              success: function(data) {
                toggleButtonLoading($btn, false);
                const toastType = data.status == 200 ? 'bg-success' : 'bg-warning';
                window.showToast({
                  title: 'Backups 🛢️',
                  message: data.message,
                  type: toastType,
                  animation: 'animate__fadeInUp',
                  time: 'Just now',
                  delay: 3000
                });
                if (data.status == 400) {
                  setTimeout(function() { // wait for 5 secs(2)
                    window.location.reload(true); // then reload the page.(3)
                  }, 5000);
                  $('.confirm-text').removeAttr('disabled');
                } else {
                  $('.hides').hide();
                  $('.confirm-text').removeAttr('disabled');
                }
              },
              error: function(data, e, ts, et) {
                toggleButtonLoading($btn, false);
                console.log(data);
              }
            });
          }
        })
      });
    });
    $(function() {
      $('.download-confirm').on('click', function(event) {
        event.preventDefault();
        const $btn = $(this);
        var url = $(this).attr('data-id');
        Swal.fire({
          title: 'Are you sure?',
          text: "",
          type: 'success',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Yes!',
          confirmButtonClass: 'btn btn-primary',
          cancelButtonClass: 'btn btn-danger ml-1',
          buttonsStyling: false,
        }).then(function(result) {
          if (result.value) {
            $.ajax({
              url: url,
              beforeSend: function() {
                toggleButtonLoading($btn, true, 'Downloading...');
              },
              success: function() {
                toggleButtonLoading($btn, false);
                window.open(url, '_blank');
                window.showToast({
                  title: 'Backups 🛢️',
                  message: 'Download done successfully',
                  type: 'bg-success',
                  animation: 'animate__fadeInUp',
                  time: 'Just now',
                  delay: 3000
                });
              },
              error: function(data, e, ts, et) {
                console.log(data);
              }
            });
          }
        })
      });
    });
  </script>
@endsection
