@extends('layouts/layoutMaster')

@section('title', 'Kanban - Apps')

@section('vendor-style')
  @vite(['resources/assets/vendor/libs/jkanban/jkanban.scss', 'resources/assets/vendor/libs/select2/select2.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss', 'resources/assets/vendor/libs/quill/typography.scss', 'resources/assets/vendor/libs/quill/katex.scss', 'resources/assets/vendor/libs/quill/editor.scss'])
@endsection

@section('page-style')
  @vite('resources/assets/vendor/scss/pages/app-kanban.scss')
@endsection

@section('vendor-script')
  @vite(['resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js', 'resources/assets/vendor/libs/select2/select2.js', 'resources/assets/vendor/libs/jkanban/jkanban.js', 'resources/assets/vendor/libs/quill/katex.js', 'resources/assets/vendor/libs/quill/quill.js'])
@endsection

@section('page-script')
  @vite('resources/assets/js/app-kanban.js')
  <script>
    window.permissions = {
      canDeletekanban: @json(auth()->user()->can('kanban-delete')),
      canCreatekanban: @json(auth()->user()->can('kanban-create')),
      canEditkanban: @json(auth()->user()->can('kanban-edit'))
    };
  </script>

@endsection

@section('content')
  <div class="app-kanban">

    <!-- Add new board -->
    @can('kanban-create')
      <div class="row">
        <div class="col-12">
          <form class="kanban-add-new-board">
            <label class="kanban-add-board-btn" for="kanban-add-board-input">
              <i class="icon-base ti tabler-plus"></i>
              <span class="align-middle">{{ __('locale.Add new') }}</span>
            </label>
            <input type="text" class="form-control w-px-250 kanban-add-board-input mb-4 d-none"
              placeholder="Add Board Title" id="kanban-add-board-input" required />
            <div class="mb-4 kanban-add-board-input d-none">
              <button class="btn btn-primary btn-sm me-4">{{ __('locale.Add') }}</button>
              <button type="button"
                class="btn btn-label-secondary btn-sm kanban-add-board-cancel-btn">{{ __('locale.Cancel') }}</button>
            </div>
          </form>
        </div>
      </div>
    @endcan

    <!-- Kanban Wrapper -->
    <div class="kanban-wrapper"></div>

    <!-- Edit Task Offcanvas -->
    <div class="offcanvas offcanvas-end kanban-update-item-sidebar">
      <div class="offcanvas-header border-bottom">
        <h5 class="offcanvas-title">{{ __('locale.Edit Task') }}</h5>
        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
      </div>
      <div class="offcanvas-body pt-0">
        <ul class="nav nav-tabs mb-5">
          <li class="nav-item">
            <button class="nav-link active" data-bs-toggle="tab"
              data-bs-target="#tab-update">{{ __('locale.Edit') }}</button>
          </li>
          <li class="nav-item d-none">
            <button class="nav-link" data-bs-toggle="tab"
              data-bs-target="#tab-activity">{{ __('locale.Activity') }}</button>
          </li>
        </ul>
        <div class="tab-content">
          <div class="tab-pane fade show active" id="tab-update">
            <form>
              <!-- title, due-date, label, assigned, attachments, comment -->
              <div class="mb-5">
                <label for="title" class="form-label">{{ __('locale.Title') }}</label>
                <input type="text" id="title" class="form-control" placeholder="Enter Title" />
              </div>
              <div class="mb-5">
                <label for="due-date" class="form-label">{{ __('locale.Due Date') }}</label>
                <input type="text" id="due-date" class="form-control" placeholder="Enter Due Date" />
              </div>
              <div class="mb-5">
                <label for="label" class="form-label">{{ __('locale.Label') }}</label>
                <select id="label" class="select2 form-select">
                  <option data-color="bg-label-success" value="Notes">Notes</option>
                  <option data-color="bg-label-warning" value="Images">Images</option>
                  <option data-color="bg-label-info" value="Info">Info</option>
                  <option data-color="bg-label-danger" value="UX">UX</option>
                  <option data-color="bg-label-secondary" value="App">App</option>
                  <option data-color="bg-label-primary" value="Charts & Maps">Charts & Maps</option>
                </select>
              </div>
              <div class="mb-5 d-none">
                <label class="form-label">{{ __('locale.Assigned') }}</label>
                <div class="assigned d-flex flex-wrap"></div>
              </div>
              <div class="mb-5">
                <label for="attachments" class="form-label">{{ __('locale.Attachments') }}</label>
                <input type="file" id="attachments" class="form-control" accept="image/*" />
              </div>
              <div class="mb-5">
                <label class="form-label">{{ __('locale.Comment') }}</label>
                <div class="comment-editor border-bottom-0"></div>
                <div class="comment-toolbar text-end mb-3">
                  <button class="ql-bold"></button><button class="ql-italic"></button>
                  <button class="ql-underline"></button><button class="ql-link"></button>
                  <button class="ql-image"></button>
                </div>
              </div>
              <div class="d-flex gap-3">
                <button type="button" class="btn btn-primary btn-update">{{ __('locale.Update') }}</button>
                <button type="button" class="btn btn-danger btn-delete-task d-none">{{ __('locale.Delete') }}</button>
              </div>
            </form>
          </div>
          <div class="tab-pane fade text-heading" id="tab-activity" role="tabpanel">
            {{-- Activity feed here... --}}
          </div>
        </div>
      </div>
    </div>

  </div>
@endsection
