@extends('layouts/layoutMaster')

@section('title', __('locale.Chat'))

@section('vendor-style')
  @vite('resources/assets/vendor/libs/maxLength/maxLength.scss')
@endsection

@section('page-style')
  @vite('resources/assets/vendor/scss/pages/app-chat.scss')
  <style>
    .app-chat .app-chat-history .chat-history-body {
      overflow: auto;
      block-size: calc(100vh - 21rem);
      padding-block: 1.5rem;
      padding-inline: 1.5rem;
    }

    /* Hide copy/download icons inside reply preview only */
    .reply-preview-container .reply-text .copyIcons {
      display: none;
      /* hide copy/download in reply preview */
    }

    /* Reply preview box */
    .reply-preview-container .reply-preview-content {
      display: flex;
      justify-content: space-between;
      align-items: flex-start;
      background-color: #f6f6f8;
      border-left: 4px solid #2ecc71;
      border-radius: 6px;
      padding: 6px 10px;
      font-size: 0.85rem;
      max-height: 120px;
      overflow: hidden;
    }

    .reply-preview-container .reply-text {
      max-width: 90%;
      display: flex;
      flex-direction: column;
      gap: 4px;
      white-space: normal;
      overflow: hidden;
    }

    /* Make images/videos small inside reply */
    .reply-preview-container .reply-text img,
    .reply-preview-container .reply-text video {
      max-height: 40px;
      /* small height */
      max-width: 40px;
      /* maintain square */
      object-fit: cover;
      border-radius: 4px;
    }

    .reply-preview-container .text-end {
      right: 30px;
      position: absolute;
      bottom: 2px;
    }

    .copyIcons {
      bottom: 5px;
      position: absolute;
    }

    .chat-message-text {
      position: relative;
    }


    .chat-message-text img {
      max-height: 200px;
    }

    .highlight-reply {
      outline: 3px solid #2ecc71;
      outline-offset: 3px;
      border-radius: 8px;
      transition: outline 0.3s ease-in-out;
      background-color: rgba(46, 204, 113, 0.05);
      /* subtle tint */
    }

    .chat-contact-list-item a {
      padding: 6px 10px;
      min-height: 55px;
      /* compact */
    }

    .chat-contact-info h6,
    .chat-contact-info small {
      line-height: 1.1;
    }

    .chat-contact-status {
      display: block;
      white-space: nowrap;
      overflow: hidden;
      text-overflow: ellipsis;
    }

    .badge-notifications {
      font-size: 0.65rem;
      padding: 0.25em 0.4em;
    }

    .app-chat .app-chat-contacts .sidebar-body .chat-contact-list li.chat-contact-list-item {
      display: -ms-flexbox;
      display: flex;
      -ms-flex-pack: justify;
      justify-content: space-between;
      border-radius: 0.375rem;
      cursor: pointer;
      margin-block: 0.25rem;
      margin-inline: 0.75rem;
      padding-block: 0.128rem;
      padding-inline: 0.25rem;
    }
  </style>

@endsection

@section('content')
  <div class="app-chat card overflow-hidden">
    <div class="row g-0">
      <!-- Sidebar Left -->
      <div class="col app-chat-sidebar-left app-sidebar overflow-hidden" id="app-chat-sidebar-left">
        <div
          class="chat-sidebar-left-user sidebar-header d-flex flex-column justify-content-center align-items-center flex-wrap px-6 pt-12">
          <div class="avatar avatar-xl avatar-online chat-sidebar-avatar">
            <img src="{{ Auth::user() ? Auth::user()->profile_photo_url : asset('assets/img/default.png') }}" alt="Avatar"
              class="rounded-circle" />
          </div>
          <h5 class="mt-4 mb-0">{{ Auth::user()->name }}</h5>
          <span>{{ Auth::user()->getRoleNames() }}</span>
          <i class="icon-base ti tabler-x icon-lg cursor-pointer close-sidebar" data-bs-toggle="sidebar" data-overlay
            data-target="#app-chat-sidebar-left"></i>
        </div>
        <div class="sidebar-body px-6 pb-6">
          <div class="my-6">
            <div class="maxLength-wrapper">
              <label for="chat-sidebar-left-user-about"
                class="text-uppercase text-body-secondary mb-1">{{ __('locale.About') }}</label>
              <textarea id="chat-sidebar-left-user-about" class="form-control chat-sidebar-left-user-about maxLength-example"
                rows="3" maxlength="120">{{ Auth::user()->about }}</textarea>
              <small id="textarea-maxlength-info"></small>
            </div>
          </div>
          <div class="my-6 d-none">
            <p class="text-uppercase text-body-secondary mb-1">{{ __('locale.Status') }}</p>
            <div class="d-grid gap-2 pt-2 text-heading ms-2">
              <div class="form-check form-check-success">
                <input name="chat-user-status" class="form-check-input" type="radio" value="active" id="user-active"
                  checked />
                <label class="form-check-label" for="user-active">Online</label>
              </div>
              <div class="form-check form-check-warning">
                <input name="chat-user-status" class="form-check-input" type="radio" value="away" id="user-away" />
                <label class="form-check-label" for="user-away">Away</label>
              </div>
              <div class="form-check form-check-danger">
                <input name="chat-user-status" class="form-check-input" type="radio" value="busy" id="user-busy" />
                <label class="form-check-label" for="user-busy">Do not Disturb</label>
              </div>
              <div class="form-check form-check-secondary">
                <input name="chat-user-status" class="form-check-input" type="radio" value="offline"
                  id="user-offline" />
                <label class="form-check-label" for="user-offline">Offline</label>
              </div>
            </div>
          </div>
          <div class="my-6 d-none">
            <p class="text-uppercase text-body-secondary mb-1">{{ __('locale.Settings') }}</p>
            <ul class="list-unstyled d-grid gap-4 ms-2 pt-2 text-heading">
              <li class="d-flex justify-content-between align-items-center">
                <div>
                  <i class="icon-base ti tabler-lock icon-md me-1"></i>
                  <span class="align-middle">Two-step Verification</span>
                </div>
                <div class="form-check form-switch mb-0 me-1">
                  <input type="checkbox" class="form-check-input" checked />
                </div>
              </li>
              <li class="d-flex justify-content-between align-items-center">
                <div>
                  <i class="icon-base ti tabler-bell icon-md me-1"></i>
                  <span class="align-middle">Notification</span>
                </div>
                <div class="form-check form-switch mb-0 me-1">
                  <input type="checkbox" class="form-check-input" />
                </div>
              </li>
              <li>
                <i class="icon-base ti tabler-user-plus icon-md me-1"></i>
                <span class="align-middle">Invite Friends</span>
              </li>
              <li>
                <i class="icon-base ti tabler-trash icon-md me-1"></i>
                <span class="align-middle">Delete Account</span>
              </li>
            </ul>
          </div>
          <div class="d-flex mt-6 d-none">
            <a class="btn btn-primary w-100" data-bs-toggle="sidebar" data-overlay data-target="#app-chat-sidebar-left"
              href="{{ route('logout') }}"
              onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
              <i class='icon-base ti tabler-power'></i> Logout
            </a>
            <form method="POST" id="logout-form" action="{{ route('logout') }}">
              @csrf
            </form>
          </div>
        </div>
      </div>
      <!-- /Sidebar Left-->

      <!-- Chat & Contacts -->
      <div class="col app-chat-contacts app-sidebar flex-grow-0 overflow-hidden border-end" id="app-chat-contacts">
        <div class="sidebar-header h-px-75 px-5 border-bottom d-flex align-items-center">
          <div class="d-flex align-items-center me-6 me-lg-0">
            <div class="flex-shrink-0 avatar avatar-online me-4" data-bs-toggle="sidebar" data-overlay="app-overlay-ex"
              data-target="#app-chat-sidebar-left">
              <img class="user-avatar rounded-circle cursor-pointer"
                src="{{ Auth::user() ? Auth::user()->profile_photo_url : asset('images/default.png') }}" alt="Avatar" />
            </div>
            <div class="flex-grow-1 input-group input-group-merge">
              <span class="input-group-text" id="basic-addon-search31"><i
                  class="icon-base ti tabler-search icon-xs"></i></span>
              <input type="text" class="form-control chat-search-input" placeholder="Search..."
                aria-label="Search..." aria-describedby="basic-addon-search31" />
            </div>
          </div>
          <i class="icon-base ti tabler-x icon-lg cursor-pointer position-absolute top-50 end-0 translate-middle d-lg-none d-block"
            data-overlay data-bs-toggle="sidebar" data-target="#app-chat-contacts"></i>
        </div>
        <div class="sidebar-body">
          <!-- Chats -->
          <ul class="list-unstyled chat-contact-list py-2 mb-0" id="chat-list">
            <li class="chat-contact-list-item chat-contact-list-item-title mt-0">
              <h5 class="text-primary mb-0">{{ __('locale.Chats') }}</h5>
            </li>

            @forelse($users as $key => $value)
              <li class="chat-contact-list-item mb-1">
                <a data-user-id="{{ $value['user_id'] }}"
                  data-url="{{ url($adminConfigData['prefix'] . 'chat/list') }}/{{ $value['user_id'] }}/{{ $value['convo_id'] }}"
                  class="d-flex align-items-center click_me">
                  <div
                    class="flex-shrink-0 avatar @if ($value['block'] == 1) avatar-busy @else @if (\Illuminate\Support\Facades\Cache::has('user-is-online-' . $value['id'])) avatar-online @else avatar-offline @endif @endif">
                    <span class="badge bg-danger rounded-pill badge-notifications"
                      id="countConversation{{ $value['user_id'] }}">{{ $value['count'] }}</span>
                    <img src="{{ App\Models\User::find($value['user_id'])->profile_photo_url }}" alt="Avatar"
                      class="rounded-circle"
                      onerror='this.onerror=null; this.src="{{ asset('assets/img/default.png') }}"' />
                  </div>
                  <div class="chat-contact-info flex-grow-1 ms-4">
                    <div class="d-flex justify-content-between align-items-center">
                      <h6 class="chat-contact-name text-truncate m-0 fw-normal">{{ @$value['name'] }}</h6>
                      <small class="chat-contact-list-item-time">{{ @$value['last_time'] }} <br><span
                          style="font-size:11px">
                          {{ $value['last_date'] }} </span></small>
                    </div>
                    <small class="chat-contact-status text-truncate"> {!! \Illuminate\Support\Str::limit($value['last_message'], 25) !!}</small>

                  </div>
                </a>
              </li>
            @empty
              <li class="chat-contact-list-item chat-list-item-0 d-none">
                <h6 class="text-body-secondary mb-0">{{ __('locale.No Chats Found') }}</h6>
              </li>
            @endforelse
          </ul>
          <!-- Contacts -->
          <ul class="list-unstyled chat-contact-list mb-0 py-2" id="contact-list">
            <li class="chat-contact-list-item chat-contact-list-item-title mt-0">
              <h5 class="text-primary mb-0">{{ __('locale.Contacts') }}</h5>
            </li>
            @forelse($new_users as $key => $value)
              <li class="chat-contact-list-item mb-1">
                <a data-user-id="{{ $value['id'] }}"
                  data-url="{{ url($adminConfigData['prefix'] . 'chat/start') }}/{{ $value['id'] }}"
                  class="d-flex align-items-center click_me">
                  <div
                    class="flex-shrink-0 avatar @if ($value['block'] == 1) avatar-busy @else @if (\Illuminate\Support\Facades\Cache::has('user-is-online-' . $value['id'])) avatar-online @else avatar-offline @endif @endif">
                    <span class="badge bg-danger rounded-pill badge-notifications"
                      id="countConversation{{ $value['user_id'] }}">{{ $value['count'] }}</span>
                    <img src="{{ $value->profile_photo_url }}" alt="Avatar" class="rounded-circle"
                      onerror='this.onerror=null; this.src="{{ asset('assets/img/default.png') }}"' />
                  </div>
                  <div class="chat-contact-info flex-grow-1 ms-4">
                    <div class="d-flex justify-content-between align-items-center">
                      <h6 class="chat-contact-name text-truncate m-0 fw-normal">{{ @$value['name'] }}</h6>
                      <small class="chat-contact-list-item-time">{{ @$value['last_time'] }} <br><span
                          style="font-size:11px">
                          {{ $value['last_date'] }} </span></small>
                    </div>
                    <small class="chat-contact-status text-truncate"> {!! \Illuminate\Support\Str::limit($value['last_message'], 25) !!}</small>



                  </div>
                </a>
              </li>
            @empty
              <li class="chat-contact-list-item contact-list-item-0 d-none">
                <h6 class="text-body-secondary mb-0">{{ __('locale.No Contacts Found') }}</h6>
              </li>
            @endforelse

          </ul>
        </div>
      </div>
      <!-- /Chat contacts -->

      <!-- Chat conversation -->
      <div class="col app-chat-conversation d-flex align-items-center justify-content-center flex-column"
        id="app-chat-conversation">
        <div class="bg-label-primary p-8 rounded-circle">
          <i class="icon-base ti tabler-message-2 icon-50px"></i>
        </div>
        <p class="my-4">{{ __('locale.Select a contact to start a conversation.') }}</p>
        <button class="btn btn-primary app-chat-conversation-btn"
          id="app-chat-conversation-btn">{{ __('locale.Select Contact') }}</button>
      </div>
      <!-- /Chat conversation -->

      <!-- Chat History -->
      <div class="col app-chat-history d-none" id="app-chat-history" data-page="1" data-has-more="true"
        style="position:relative">
        <div id="active-chat">

        </div>
        <div class="reply-preview-container d-none mb-2 w-90" style="position: absolute;top:60px;width:100%">
          <div class="reply-preview-content p-2 rounded bg-light d-flex justify-content-between align-items-center">
            <div class="reply-text text-truncate" style="max-width:90%;"></div>
            <button type="button" class="btn-close btn-close-sm ms-2" aria-label="Close"></button>
          </div>
        </div>
        <!-- Chat message form -->
        <div class="chat-history-footer shadow-xs">

          <form id="chatForm" class="form-send-message d-flex justify-content-between align-items-center"
            action="javascript:void(0);" enctype="multipart/form-data">
            <input class="form-control message-input border-0 me-4 shadow-none" placeholder="Type your message here..."
              name="message" />

            <div class="message-actions d-flex align-items-center">
              <label for="attach-doc" class="form-label mb-0">
                <span class="btn btn-text-secondary btn-icon rounded-pill cursor-pointer mx-1">
                  <i class="icon-base ti tabler-paperclip icon-22px text-heading"></i>
                </span>
                <input accept="video/*,image/*" type="file" name="icon" id="attach-doc" hidden />
              </label>

              <button type="submit" class="btn btn-primary d-flex send-msg-btn">
                <span class="align-middle d-md-inline-block d-none">{{ __('locale.Send') }}</span>
                <i class="icon-base ti tabler-send icon-16px ms-md-2 ms-0"></i>
              </button>

              <input name="_token" value="{{ csrf_token() }}" type="hidden">
              <input type="hidden" name="userid" id="receiverid">
              <input type="hidden" name="conversationid" id="conversationid">
            </div>
          </form>
        </div>

      </div>
      <!-- /Chat History -->



      <div class="app-overlay"></div>

    </div>
  </div>
@endsection
@section('page-script')
  @vite('resources/assets/js/app-chat.js')
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script type="text/javascript">
    // Function to open chat for selected user
    const elements = {
      chatContactListItems: document.querySelectorAll('.click_me'),
      appChatConversation: document.getElementById('app-chat-conversation'),
      appChatHistory: document.getElementById('app-chat-history')
    };


    function openSelectedChat() {
      if (!selectedUserId) return;

      // Retry if elements.chatContactListItems is not ready yet
      if (!elements || !elements.chatContactListItems || elements.chatContactListItems.length === 0) {
        setTimeout(openSelectedChat, 100); // retry after 100ms
        return;
      }

      // Find the chat item
      const userItem = Array.from(elements.chatContactListItems).find(item => {
        return item.getAttribute('data-user-id') === selectedUserId;
      });

      if (userItem) {
        // Remove 'active' from all li parents
        document.querySelectorAll('.click_me').forEach(contact => {
          const parentLi = contact.closest('li');
          if (parentLi) parentLi.classList.remove('active');
        });

        // Add 'active' to the parent li of selected user
        const parentLi = userItem.closest('li');
        if (parentLi) parentLi.classList.add('active');

        elements.appChatConversation.classList.replace('d-flex', 'd-none');
        elements.appChatHistory.classList.replace('d-none', 'd-block');

        // Trigger AJAX call exactly like click
        userItem.dispatchEvent(new Event('click', {
          bubbles: true
        }));
      }
    }

    // Extract the click handler into a reusable function
    function openChat($elem) {
      const url = $elem.attr('data-url');
      isRtl = $('html').attr('data-textdirection') === 'rtl';
      $.ajax({
        url: url,
        success: function(data) {
          if (data.status == 400) {
            window.showToast({
              title: 'Chat 💬',
              message: data.message,
              type: 'bg-warning',
              animation: 'animate__fadeInUp',
              time: 'Just now',
              delay: 3000
            });
          } else {
            $('#active-chat').html(data.data);
            $('#receiverid').val(data.user_id);
            scrollChatToBottom();
            setupPusher(data.convo);
          }
        },
        error: function() {
          window.showToast({
            title: 'Chat 💬',
            message: 'Error in loading Chat',
            type: 'bg-warning',
            animation: 'animate__fadeInUp',
            time: 'Just now',
            delay: 3000
          });
        }
      });
    }

    // Helper to scroll chat
    function scrollChatToBottom() {
      const chatContainer = $(".chat-history-body");
      if (chatContainer.length) {
        chatContainer.animate({
          scrollTop: chatContainer[0].scrollHeight
        });
      }
    }

    // Setup Echo/Pusher
    function setupPusher(conversationId) {
      if (!conversationId || !window.Echo) return;

      window.Echo.private(`mc-chat-conversation.${conversationId}`)
        .notification(e => console.log('💬 Message event:', e))
        .listenForWhisper('MessageWasSent', e => console.log('🌀 Whispered event:', e))
        .listen('.Musonza\\Chat\\Eventing\\MessageWasSent', function(e) {
          appendChatMessage(e.message, authID, baseUrl, conversationId);
        });
    }

    // Run on page load
    document.addEventListener('DOMContentLoaded', function() {
      selectedUserId = "{{ $selectedUserId ?? '' }}";
      openSelectedChat();
    });

    // Keep existing click handler for manual clicks
    $(document).on("click", ".click_me", function(event) {
      event.preventDefault();
      openChat($(this));
    });


    function appendChatMessage(message, authID, assetBase, conversationId) {
      const isSender = message.sender.id == authID;
      const alignClass = isSender ? 'chat-message-right' : '';
      const avatarImg = message.sender.profile_photo_url ?? '/default.png';
      const attachmentPath = `${assetBase}/storage/Chat/${conversationId}/`;
      let body = '';

      // Determine message body type
      switch (message.type) {
        case 'reply': {
          const data = typeof message.data === 'string' ? JSON.parse(message.data) : message.data || {};
          const replyUserName = data.reply_to_user_name || 'Unknown';
          const replyText = data.reply_to_body || '';
          const replyMedia = data.reply_to_media || null;
          const replyType = data.reply_to_type || 'text';
          const replyId = data.reply_to_message_id || null;

          // Build quoted preview
          let quoted =
            `<div class="reply-preview p-1 rounded mb-1" style="background:#f6f6f8;border-left:4px solid #2ecc71;">`;
          quoted += `<p class="mb-1 text-dark"><b>${replyUserName}</b></p>`;

          if (replyMedia) {
            const ext = replyMedia.split('.').pop().toLowerCase();
            if (['mp4', 'webm', 'ogg'].includes(ext) || replyType.includes('video')) {
              quoted += `<video style="max-width:120px; max-height:80px; display:block;" controls>
                        <source src="${replyMedia}" type="video/mp4">Your browser does not support the video tag.
                       </video>`;
            } else if (['jpg', 'jpeg', 'png', 'gif', 'svg', 'webp'].includes(ext) || replyType.includes('image')) {
              quoted +=
                `<img src="${replyMedia}" style="max-width:120px; max-height:80px; display:block; border-radius:4px;" />`;
            } else {
              quoted += `<a href="${replyMedia}" target="_blank">${replyMedia.split('/').pop()}</a>`;
            }
          } else if (replyText) {
            quoted += `<p style="color:#555;font-size:13px;" class="mb-0">${replyText}</p>`;
          }

          if (replyId) {
            quoted =
              `<div class="replyClick" data-id="${replyId}" onclick="if(typeof scrollToMessage==='function'){scrollToMessage(${JSON.stringify(replyId)})}">${quoted}</div>`;
          }

          quoted += '</div>';

          // Reply message content
          body =
            `<div class="reply-wrapper" style="margin:8px 0;">${quoted}<div class="reply-main mt-2"><p class="mb-1">${$('<div>').text(message.body).html()}</p></div>`;

          // Footer: time + copy/download
          const time = new Date(message.created_at).toLocaleTimeString([], {
            hour: '2-digit',
            minute: '2-digit'
          });
          body += `<div class="d-flex justify-content-between align-items-center mt-2" style="font-size:12px;color:#999;">
                  <div class="reply-actions copyIcons">
                    <button class="copy-btn btn btn-sm" data-message-id="message-${message.id}" style="background:none;border:none;color:#999;margin-right:8px;">
                      <i class="icon-base ti tabler-copy"></i>
                    </button>`;
          if (replyMedia) {
            body +=
              `<a href="${replyMedia}" download style="color:#999;text-decoration:none;"><i class="icon-base ti tabler-download"></i></a>`;
          }
          body += `</div></div></div>`;
        }
        break;

        case 'attachment': {
          const file = message.data?.file_name ?? message.body;
          const fileType = message.data?.file_type ?? 'Image';
          const fileSrc = `${attachmentPath}${file}`;

          body += `<p class='mb-1'>${message.body}</p>`;

          if (fileType === 'Video') {
            body += `<video style='max-width:55%' controls><source src='${fileSrc}' type='video/mp4'></video>`;
          } else {
            body += `<img src='${fileSrc}' class='img-fluid rounded' alt='Attachment' />`;
          }

          body += `<div class='mt-1'>
                   <button class='copy-btn' data-message-id='message-${message.id}' style='background:none;border:none;color:#999;'>
                     <i class='icon-base ti tabler-copy'></i>
                   </button>
                   <a href='${fileSrc}' download style='background:none;border:none;color:#999;'>
                     <i class='icon-base ti tabler-download'></i>
                   </a>
                 </div>`;
        }
        break;

        case 'Image':
          body = `<img src='${attachmentPath}${message.body}' class='img-fluid rounded' alt='Image' />`;
          body += `<div class='mt-1'>
                   <a href='${fileSrc}' download style='background:none;border:none;color:#999;'>
                     <i class='icon-base ti tabler-download'></i>
                   </a>
                 </div>`;
          break;

        case 'Video':
          body =
            `<video style='max-width:55%' controls><source src='${attachmentPath}${message.body}' type='video/mp4'></video>`;
          body += `<div class='mt-1'>
                   <a href='${fileSrc}' download style='background:none;border:none;color:#999;'>
                     <i class='icon-base ti tabler-download'></i>
                   </a>
                 </div>`;
          break;

        default:
          body = `<p class='mb-0'>${$('<div>').text(message.body).html()}</p>`;
          body += `<div class='mt-1'>
                   <button class='copy-btn' data-message-id='message-${message.id}' style='background:none;border:none;color:#999;'>
                     <i class='icon-base ti tabler-copy'></i>
                   </button>
                 </div>`;
      }

      // Build final HTML
      const createdAt = new Date(message.created_at);
      const time = createdAt.toLocaleTimeString([], {
        hour: '2-digit',
        minute: '2-digit'
      });

      const html = `
    <li class="chat-message ${alignClass}">
      <div class="d-flex overflow-hidden" style="max-width: 75%; width: fit-content; min-width:35%">
        ${!isSender ? `
                                                                                                <div class="user-avatar flex-shrink-0 me-4">
                                                                                                  <div class="avatar avatar-sm">
                                                                                                    <img src="${avatarImg}" class="rounded-circle" alt="Avatar" />
                                                                                                  </div>
                                                                                                </div>` : ''
        }
        <div class="chat-message-wrapper flex-grow-1">
          <div class="chat-message-text mt-2">${body}<div class="text-${isSender ? 'end' : 'end'} text-body-secondary mt-0">
            <i class="icon-base ti tabler-checks icon-16px ${isSender ? 'text-muted' : 'd-none'} me-1"></i>
            <small>${time}</small>
          </div></div>
        </div>
        ${isSender ? `
                                                                                                <div class="user-avatar flex-shrink-0 ms-4">
                                                                                                  <div class="avatar avatar-sm">
                                                                                                    <img src="${avatarImg}" class="rounded-circle" alt="Avatar" />
                                                                                                  </div>
                                                                                                </div>` : ''
        }
      </div>
    </li>
  `;

      $('.chat-history').append(html);

      setTimeout(() => {
        const chatContainer = $(".chat-history-body");
        if (chatContainer.length) {
          chatContainer.animate({
            scrollTop: chatContainer[0].scrollHeight
          }, 300);
        }
      }, 50);
    }




    $(document).on("click", ".copy-btn", function() {
      // Get the message ID from the button's data attribute
      var messageId = $(this).data('message-id');

      // Get the text content of the message to copy
      var messageText = $('#' + messageId).text();

      // Create a temporary textarea to select and copy the text
      var tempTextArea = $('<textarea>');
      $('body').append(tempTextArea);
      tempTextArea.val(messageText).select();
      document.execCommand('copy');
      tempTextArea.remove();

      // Optional: Show a success message (e.g., tooltip or alert)
      window.showToast({
        title: 'Chat 💬',
        message: 'Message copied to clipboard!',
        type: 'bg-success',
        animation: 'animate__fadeInUp',
        time: 'Just now',
        delay: 3000
      });

    });

    // pagination in chat
    let currentPage = 1;
    const chatContainer = document.getElementById('app-chat-history');

    function loadMessages(conversationId, userId) {
      $.ajax({
        url: `${baseURL}/chat/list/${userId}/${conversationId}/load`,
        type: 'GET',
        data: {
          page: currentPage,
        },
        success: function(response) {
          if (response.data && response.load_data) {
            const $chatContainer = $('#userChats .chats');

            // Save the current scroll height
            const initialScrollHeight = $chatContainer[0].scrollHeight;

            // Prepend new messages
            $chatContainer.prepend(response.data);

            // Calculate new scroll height and maintain user position
            const newScrollHeight = $chatContainer[0].scrollHeight;
            const scrollOffset = newScrollHeight - initialScrollHeight;
            $chatContainer.scrollTop(scrollOffset);
          }
        },
        error: function(xhr, status, error) {
          console.log(xhr);
        }
      });
    }

    // Attach scroll event to native DOM element
    chatContainer.addEventListener('scroll', function() {
      if (chatContainer.scrollTop === 0) {
        currentPage++;
        const conversationId = document.getElementById('conversationid').value;
        const userId = document.getElementById('userid').value; // Dynamic
        loadMessages(conversationId, userId);
      }
    });
  </script>
@endsection
