@extends('layouts/layoutMaster')

@section('title', __('locale.Withdrawal Request'))

@section('vendor-style')
  @vite(['resources/assets/css/datatables.scss', 'resources/assets/vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.scss'])
@endsection

@section('vendor-script')
  @vite(['resources/assets/js/datatables.js', 'resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js'])
@endsection


@section('content')

  <!-- Product List Table -->
  <div class="card">
    <div class="card-header border-bottom">
      @if ($walletAmount)
        <button class="btn btn-primary" type="button"><span class="d-none d-sm-inline-block">{{ $currency }}<span
              id="walletAmount">{{ $walletAmount }}</span></span></button>
      @else
        <h5 class="card-title d-none">{{ __('locale.Filter') }}</h5>
      @endif
      <div class="d-flex justify-content-between align-items-center row pt-0 gap-6 gap-md-0 g-md-6">
        <div class="col-md-3 wallet_status"></div>
        <div class="col-md-3 userType">
          <label for="userType" class="form-label">{{ __('locale.Type') }}</label>
          <select id="userType" class="select2 form-select">
            <option value="">{{ __('locale.All') }}</option>
            <option value="user">{{ __('locale.User') }}</option>
            <option value="store">{{ __('locale.Store') }}</option>
            <option value="driver">{{ __('locale.Driver') }}</option>
          </select>
        </div>
        @if (!empty($customers))
          <div class="col-md-3 customer">
            <label for="Customers" class="form-label">{{ __('locale.Customers') }}</label>
            <select id="Customer" class="select2 form-select">
              <option value="">{{ __('locale.All') }}</option>
              @foreach ($customers as $id => $name)
                <option value="{{ $id }}">{{ $name }}</option>
              @endforeach
            </select>
          </div>
        @endif
        <div class="col-md-3 date_filter">
          <label for="bs-rangepicker-range" class="form-label">{{ __('locale.Date') }}</label>
          <input type="text" class="form-control" placeholder="YYYY-MM-DD to YYYY-MM-DD" id="bs-rangepicker-range" />
        </div>
      </div>
    </div>
    <div class="card-datatable">
      <table class="datatables-wallet table">
        <thead class="border-top">
          <tr>
            <th></th>
            <th></th>
            <th>{{ __('locale.User Details') }}</th>
            <th>{{ __('locale.Amount Details') }}</th>
            <th>{{ __('locale.Bank Detail') }}</th>
            <th>{{ __('locale.Note') }}</th>
            <th>{{ __('locale.Txn Detail') }}</th>
            <th>{{ __('locale.Status') }}</th>
            <th>{{ __('locale.Actions') }}</th>
          </tr>
        </thead>
      </table>
    </div>
  </div>
  <!-- Offcanvas to add new user -->
  <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasAddRequest" aria-labelledby="offcanvasAddRequestLabel">
    <div class="offcanvas-header border-bottom">
      <h5 id="offcanvasAddRequestLabel" class="offcanvas-title">{{ __('locale.Add Withdrawal Request') }}</h5>
      <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body mx-0 flex-grow-0 p-6 h-100">
      <form class="add-new-user pt-0" id="addNewRequestForm" method="POST"
        action="{{ route('withdrawal_requests.store') }}">
        {{ csrf_field() }}

        <div class="mb-6 form-control-validation">
          <label class="form-label" for="add-amount">{{ __('locale.Amount') }}</label>
          <input type="number" class="form-control" id="add-amount" name="amount" value="{{ $walletAmount }}"
            data-max="{{ $walletAmount }}" required />
        </div>
        <button type="submit" class="btn btn-primary me-3 data-submit">{{ __('locale.Submit') }}</button>
        <button type="reset" class="btn btn-label-danger"
          data-bs-dismiss="offcanvas">{{ __('locale.Cancel') }}</button>
      </form>
    </div>
  </div>
  @include('_partials/_modals/modal-cancel-wallet')
  @include('_partials/_modals/modal-accept-wallet')
@endsection
@section('page-script')
  @vite(['resources/assets/js/wallet.js', 'resources/assets/js/forms-pickers.js'])
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script type="text/javascript">
    $(document).on('click', '.cancel-modal', function() {
      $('#id_cancel').val($(this).data('id'));
      $('#status_cancel').val($(this).data('status'));
      $('#cancelWalletModal').modal('show');


    });
    $(document).on('click', '.accept-modal', function() {
      $('#id_accept').val($(this).data('id'));
      $('#status_accept').val($(this).data('status'));
      $('#acceptWalletModal').modal('show');
    });


    $('.modal-footer').on('click', '.CloseM', function(event) {
      event.preventDefault();
      id = $('#id_cancel').val();
      status = $('#status_cancel').val();
      admin_note = $('#modalNote').val();
      $.ajax({
        type: 'POST',
        url: `${baseURL}/withdrawal_requests/changestatus`,
        header: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        data: {
          '_method': 'POST',
          '_token': $('meta[name="csrf-token"]').attr('content'),
          'id': id,
          'status': status,
          'notes': admin_note,
        },
        success: function(data) {
          const toastType = data.status == 200 ? 'bg-success' : 'bg-warning';
          window.showToast({
            title: 'Withdrawal Request 👛',
            message: data.message,
            type: toastType,
            animation: 'animate__fadeInUp',
            time: 'Just now',
            delay: 3000
          });
          $('#cancelWalletModal').modal('hide');
          $('#status-' + data.data).replaceWith(
            `<button type="button" class="btn bg-label-danger waves-effect" id="status-${data.data}">${status}</button>`
          );
          $('.hide-' + data.data).hide();
        },
        error: function(data, e, ts, et) {
          console.log(data);
        }
      });
    });
    $('.modal-footer').on('click', '.CloseModel', function(event) {
      event.preventDefault();
      id = $('#id_accept').val();
      status = $('#status_accept').val();
      tran_fee = $('#tran_fee').val();
      txn_id = $('#txn_id').val();
      txn_detail = $('#txn_detail').val();
      var APP_URL = {!! json_encode(url('/')) !!};
      $.ajax({
        type: 'POST',
        url: `${baseURL}/withdrawal_requests/changestatus`,
        header: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        data: {
          '_method': 'POST',
          '_token': $('meta[name="csrf-token"]').attr('content'),
          'id': id,
          'status': status,
          'tran_fee': tran_fee,
          'txn_id': txn_id,
          'txn_detail': txn_detail,
        },
        success: function(data) {
          const toastType = data.status == 200 ? 'bg-success' : 'bg-warning';
          window.showToast({
            title: 'Withdrawal Request 👛',
            message: data.message,
            type: toastType,
            animation: 'animate__fadeInUp',
            time: 'Just now',
            delay: 3000
          });
          $('#acceptWalletModal').modal('hide');
          $('#status-' + data.data).replaceWith(
            `<button type="button" class="btn bg-label-success waves-effect" id="status-${data.data}">${status}</button>`
          );
          $('.hide-' + data.data).hide();

        },
        error: function(data, e, ts, et) {
          console.log(data);
        }
      });
    });
  </script>
@endsection
