@extends('layouts/layoutMaster')

@section('title', __('locale.Driver Dues'))

@section('vendor-style')
  @vite(['resources/assets/css/datatables.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss', 'resources/assets/vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.scss'])
@endsection

@section('vendor-script')
  @vite(['resources/assets/js/datatables.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js', 'resources/assets/vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js'])
@endsection


@section('content')
  <div class="row g-6 mb-6">
    <div class="col-sm-6 col-xl-6">
      <div class="card">
        <div class="card-body pb-0">
          <div class="d-flex align-items-start justify-content-between">
            <div class="content-left">
              @php
                $grandTotal = 0;
                foreach ($totals as $row) {
                    $grandTotal += ($row->total_balance ?? 0) + ($row->total_withdrawals ?? 0);
                    $currency = $row->currency;
                }
              @endphp

              <span class="text-heading">
                {{ __('locale.Amount To Be Paid') }}: {{ $currency }}{{ $grandTotal }}
              </span>
              @foreach ($totals as $row)
                <div class="d-flex align-items-center my-1">
                  <h4 class="mb-0 me-2 text-size-26">
                    {{ $row->currency }}{{ $row->total_balance ?? 0 }} <small>({{ __('locale.Wallet') }})</small>
                    @if ($row->total_withdrawals > 0)
                      +
                      {{ $row->currency }}{{ $row->total_withdrawals ?? 0 }}
                      <small>({{ __('locale.Withdrawal Request') }})</small>
                    @endif
                  </h4>
                </div>
              @endforeach
            </div>
            <div class="avatar">
              <span class="avatar-initial rounded bg-label-danger">
                <i class="icon-base ti tabler-credit-card-pay icon-26px"></i>
              </span>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="col-sm-6 col-xl-6">
      <div class="card">
        <div class="card-body pb-0">
          <div class="d-flex align-items-start justify-content-between">
            <div class="content-left">
              <span class="text-heading">{{ __('locale.Amount To Be Receive') }}</span>
              @foreach ($totals as $row)
                <div class="d-flex align-items-center my-1">
                  <h4 class="mb-0 me-2 text-size-26"> {{ $row->currency }}{{ $row->total_pending_dues ?? 0 }}</h4>
                </div>
              @endforeach
            </div>
            <div class="avatar">
              <span class="avatar-initial rounded bg-label-success">
                <i class="icon-base ti tabler-credit-card-refund icon-26px"></i>
              </span>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <!-- Product List Table -->
  <div class="card">
    <div class="card-datatable">
      <table class="datatables-wallet table">
        <thead class="border-top">
          <tr>
            <th></th>
            <th></th>
            <th>{{ __('locale.Driver Details') }}</th>
            <th>{{ __('locale.Amount To Be Paid') }}</th>
            <th>{{ __('locale.Amount To Be Receive') }}</th>
            <th>{{ __('locale.Actions') }}</th>
          </tr>
        </thead>
      </table>
    </div>
  </div>
  @include('_partials/_modals/modal-clear-dues')
  @include('_partials/_modals/modal-clear-balance')
@endsection
@section('page-script')
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    window.permissions = {
      ownerType: 'driver'
    };
  </script>
  @vite(['resources/assets/js/wallet_driver.js'])
@endsection
