@php
  $configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', __('locale.Vehicle Management'))

@section('vendor-style')
  @vite(['resources/assets/css/datatables.scss'])
@endsection

@section('vendor-script')
  @vite(['resources/assets/js/datatables.js'])
@endsection

@section('content')
  <div class="row g-6">
    <div class="col-12">
      <div class="card">
        <div class="card-datatable">
          <div class="row p-3">
            <div class="col-md-3">
              <label for="filter_parent" class="form-label">{{ __('locale.Parent Category') }}</label>
              <select id="filter_parent" class="form-select">
                <option value="">{{ __('locale.All') }}</option>
                @foreach ($parentCategories as $parent)
                  <option value="{{ $parent->id }}">{{ $parent->name }}</option>
                @endforeach
              </select>
            </div>

            <div class="col-md-3">
              <label for="filter_subcategory" class="form-label">{{ __('locale.Subcategory') }}</label>
              <select id="filter_subcategory" class="form-select">
                <option value="">{{ __('locale.All') }}</option>
              </select>
            </div>

            <div class="col-md-3">
              <label for="filter_brand" class="form-label">{{ __('locale.Brand') }}</label>
              <select id="filter_brand" class="form-select">
                <option value="">{{ __('locale.All') }}</option>
                @foreach ($brands as $brand)
                  <option value="{{ $brand->id }}">{{ $brand->name }}</option>
                @endforeach
              </select>
            </div>
            <div class="col-md-3">
              <label for="filter_model" class="form-label">{{ __('locale.Model') }}</label>
              <select id="filter_model" class="form-select">
                <option value="">{{ __('locale.All') }}</option>
                @foreach ($models as $model)
                  <option value="{{ $model->id }}">{{ $model->name }}</option>
                @endforeach
              </select>
            </div>

          </div>

          <table class="datatables-users table border-top">
            <thead>
              <tr>
                <th>#</th>
                <th>{{ __('locale.Image') }}</th>
                <th>{{ __('locale.Name') }}</th>
                <th>{{ __('locale.Category') }}</th>
                <th>{{ __('locale.Brand') }}</th>
                <th>{{ __('locale.Details') }}</th>
                <th>{{ __('locale.Status') }}</th>
                <th>{{ __('locale.Actions') }}</th>
              </tr>
            </thead>
          </table>
        </div>
      </div>
    </div>
  </div>
@endsection

@section('page-script')
  @vite(['resources/assets/js/vehicles.js'])
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    window.permissions = {
      canDeleteVehicle: @json(auth()->user()->can('vehicle-delete')),
      canEditVehicle: @json(auth()->user()->can('vehicle-edit')),
      canCreateVehicle: @json(auth()->user()->can('vehicle-create'))
    };
  </script>
@endsection
