@php
  $configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', __('locale.Vehicle Models'))

@section('vendor-style')
  @vite(['resources/assets/css/datatables.scss'])
@endsection

@section('vendor-script')
  @vite(['resources/assets/js/datatables.js'])
@endsection

@section('content')
  <div class="row g-6">
    <div class="col-12">
      <div class="card">
        <div class="card-datatable">
          <div class="row p-3">
            <div class="col-md-4">
              <label for="filter_parent" class="form-label">{{ __('locale.Parent Category') }}</label>
              <select id="filter_parent" class="form-select">
                <option value="">{{ __('locale.All') }}</option>
                @foreach ($parentCategories as $parent)
                  <option value="{{ $parent->id }}">{{ $parent->name }}</option>
                @endforeach
              </select>
            </div>

            <div class="col-md-4">
              <label for="filter_subcategory" class="form-label">{{ __('locale.Subcategory') }}</label>
              <select id="filter_subcategory" class="form-select">
                <option value="">{{ __('locale.All') }}</option>
              </select>
            </div>

            <div class="col-md-4">
              <label for="filter_brand" class="form-label">{{ __('locale.Brand') }}</label>
              <select id="filter_brand" class="form-select">
                <option value="">{{ __('locale.All') }}</option>
                @foreach ($brands as $brand)
                  <option value="{{ $brand->id }}">{{ $brand->name }}</option>
                @endforeach
              </select>
            </div>
          </div>

          <table class="datatables-users table border-top">
            <thead>
              <tr>
                <th>#</th>
                <th>{{ __('locale.Image') }}</th>
                <th>{{ __('locale.Name') }}</th>
                <th>{{ __('locale.Category') }}</th>
                <th></th>
                <th>{{ __('locale.Brand') }}</th>
                <th>{{ __('locale.Status') }}</th>
                <th>{{ __('locale.Actions') }}</th>
              </tr>
            </thead>
          </table>
        </div>
      </div>
    </div>
  </div>

  <!-- Offcanvas to add new model -->
  <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasAdd" aria-labelledby="offcanvasAddLabel">
    <div class="offcanvas-header border-bottom">
      <h5 id="offcanvasAddLabel" class="offcanvas-title">{{ __('locale.Add New Model') }}</h5>
      <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body mx-0 flex-grow-0 p-6 h-100">
      <form class="add-new-model pt-0" id="upload_form" method="POST" action="{{ route('vehicle-models.store') }}">
        @csrf
        <input type="hidden" name="id" id="model_id">
        <div class="mb-4">
          <label class="form-label">{{ __('locale.Name') }}</label>
          <input type="text" class="form-control" name="name" placeholder="{{ __('locale.Name') }}">
        </div>
        <div class="mb-4">
          <label class="form-label">{{ __('locale.Category') }}</label>
          <select name="vehicle_parent_id" id="parent_category" class="form-select" required>
            <option value="">{{ __('locale.Select Category') }}</option>
            @foreach ($parentCategories as $category)
              <option value="{{ $category->id }}">{{ $category->name }}</option>
            @endforeach
          </select>
        </div>

        <div class="mb-4">
          <label class="form-label">{{ __('locale.Subcategory') }}</label>
          <select name="vehicle_category_id" id="subcategory" class="form-select" required>
            <option value="">{{ __('locale.Select Subcategory') }}</option>
          </select>
        </div>

        <div class="mb-4">
          <label class="form-label">{{ __('locale.Brand') }}</label>
          <select name="vehicle_brand_id" id="brand" class="form-select" required>
            <option value="">{{ __('locale.Select Brand') }}</option>
            @foreach ($brands as $brand)
              <option value="{{ $brand->id }}">{{ $brand->name }}</option>
            @endforeach
          </select>
        </div>

        <div class="mb-4">
          <label class="form-label" for="model_image">{{ __('locale.Image') }}</label>
          <input type="file" class="form-control" name="image" id="model_image" accept="image/*">
          <div class="mt-2">
            <img id="preview_image" src="{{ asset('assets/img/placeholder.jpg') }}" alt="Preview" class="img-thumbnail"
              style="max-height: 60px; display: none;">
          </div>
        </div>

        <button type="submit" class="btn btn-primary me-3 data-submit">{{ __('locale.Submit') }}</button>
        <button type="reset" class="btn btn-label-danger"
          data-bs-dismiss="offcanvas">{{ __('locale.Cancel') }}</button>
      </form>
    </div>
  </div>

  <!-- Modal to edit model -->
  <div class="modal fade text-left model-edit-modal" id="inlineForm" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <form id="edit_form" method="POST">
          @csrf
          @method('PUT')
          <div class="modal-header">
            <h4 class="modal-title">{{ __('locale.Edit Model') }}</h4>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            <input type="hidden" name="id" id="id_edit">
            <div class="mb-4">
              <label class="form-label">{{ __('locale.Name') }}</label>
              <input type="text" name="name" id="name_edit" class="form-control"
                placeholder="{{ __('locale.Name') }}" required>
            </div>
            <div class="mb-4">
              <label class="form-label">{{ __('locale.Category') }}</label>
              <select name="vehicle_parent_id" id="edit_parent_category" class="form-select" required>
                <option value="">{{ __('locale.Select Category') }}</option>
                @foreach ($parentCategories as $category)
                  <option value="{{ $category->id }}">{{ $category->name }}</option>
                @endforeach
              </select>
            </div>

            <div class="mb-4">
              <label class="form-label">{{ __('locale.Subcategory') }}</label>
              <select name="vehicle_category_id" id="edit_subcategory" class="form-select" required>
                <option value="">{{ __('locale.Select Subcategory') }}</option>
              </select>
            </div>

            <div class="mb-4">
              <label class="form-label">{{ __('locale.Brand') }}</label>
              <select name="vehicle_brand_id" id="edit_brand" class="form-select" required>
                <option value="">{{ __('locale.Select Brand') }}</option>
                @foreach ($brands as $brand)
                  <option value="{{ $brand->id }}">{{ $brand->name }}</option>
                @endforeach
              </select>
            </div>

            <div class="mb-4">
              <label class="form-label" for="edit_model_image">{{ __('locale.Image') }}</label>
              <input type="file" class="form-control" name="image" id="edit_model_image" accept="image/*">
              <div class="mt-2">
                <img id="edit_preview_image" src="{{ asset('assets/img/placeholder.jpg') }}" alt="Preview"
                  class="img-thumbnail" style="max-height:60px; display: none;"
                  onerror="this.onerror=null;this.src='{{ url('assets/img/placeholder.jpg') }}';">
              </div>
            </div>

          </div>
          <div class="modal-footer">
            <button type="submit" class="btn btn-primary">{{ __('locale.Update') }}</button>
          </div>
        </form>
      </div>
    </div>
  </div>
  <div id="role-helper" data-add="{{ __('locale.Add New Model') }}"></div>
@endsection

@section('page-script')
  @vite(['resources/assets/js/vehicle-model.js'])
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    window.permissions = {
      canDeleteModel: @json(auth()->user()->can('vehicle-delete')),
      canEditModel: @json(auth()->user()->can('vehicle-edit')),
      canCreateModel: @json(auth()->user()->can('vehicle-create'))
    };
    // Preview for Add Model
    document.getElementById('model_image')?.addEventListener('change', function(e) {
      const img = document.getElementById('preview_image');
      const file = e.target.files[0];
      if (file) {
        img.src = URL.createObjectURL(file);
        img.style.display = 'block';
      } else {
        img.style.display = 'none';
      }
    });

    // Preview for Edit Model
    document.getElementById('edit_model_image')?.addEventListener('change', function(e) {
      const img = document.getElementById('edit_preview_image');
      const file = e.target.files[0];
      if (file) {
        img.src = URL.createObjectURL(file);
        img.style.display = 'block';
      } else {
        img.style.display = 'none';
      }
    });

    $(function() {
      const table = $('.datatables-users').DataTable();
      let $btn = null;

      $(document).on('click', '#upload_form button[type="submit"]', function() {
        $btn = $(this);
      });

      $('#upload_form').on('submit', function(event) {
        event.preventDefault();
        $.ajax({
          type: "POST",
          headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          url: `${baseURL}/vehicle-models`,
          data: new FormData(this),
          dataType: 'JSON',
          contentType: false,
          cache: false,
          processData: false,
          beforeSend: function() {
            toggleButtonLoading($btn, true, 'Saving...');
          },
          success: function(data) {
            if (data.status === 200 && data.data) {
              const model = data.data;
              const newRow = table.row.add(model).draw(false);
              $(newRow.node()).attr('id', `trRow-${model.id}`);
              table.order([0, 'desc']).draw(false);

              $('#upload_form')[0].reset();
              const offcanvasEl = document.getElementById('offcanvasAdd');
              const bsOffcanvas = bootstrap.Offcanvas.getInstance(offcanvasEl);
              if (bsOffcanvas) bsOffcanvas.hide();
            }
            toggleButtonLoading($btn, false);
            const toastType = data.status == 200 ? 'bg-success' : 'bg-warning';
            window.showToast({
              title: 'Models 🗂️',
              message: data.message,
              type: toastType,
              animation: 'animate__fadeInUp',
              time: 'Just now',
              delay: 3000
            });
          },
          error: function(xhr) {
            toggleButtonLoading($btn, false);
            console.log(xhr.responseJSON);
          }
        });
      });

      // Edit modal open
      $(document).on('click', '.edit-model-modal', function() {
        const parentId = $(this).data('vehicle_parent_id');
        const subCategoryId = $(this).data('vehicle_category_id');
        const brandId = $(this).data('vehicle_brand_id');
        const modelId = $(this).data('id');
        const modelName = $(this).data('name');

        $('#id_edit').val(modelId);
        $('#name_edit').val(modelName);
        $('#edit_brand').val(brandId).trigger('change');

        // Set parent category
        $('#edit_parent_category').val(parentId).trigger('change');
        // After subcategories are loaded via AJAX:
        fetch(`${baseURL}/vehicle-categories/${parentId}/subcategories`)
          .then(res => res.json())
          .then(data => {
            const $subcategory = $('#edit_subcategory');
            $subcategory.empty().append('<option value="">Select Subcategory</option>');

            data.forEach(item => {
              $subcategory.append(`<option value="${item.id}">${item.name}</option>`);
            });

            // ✅ Set the selected subcategory after loading
            $subcategory.val(subCategoryId).trigger('change');
          });
        const imageUrl = $(this).data('image');
        if (imageUrl) {
          $('#edit_preview_image').attr('src', imageUrl).show();
        } else {
          $('#edit_preview_image').hide();
        }
        $('#inlineForm').modal('show');
      });

      // Edit form submit
      $('#edit_form').on('submit', function(event) {
        event.preventDefault();
        const id = $('#id_edit').val();
        $.ajax({
          type: 'POST',
          url: `${baseURL}/vehicle-models/${id}`,
          headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          data: new FormData(this),
          dataType: 'JSON',
          contentType: false,
          cache: false,
          processData: false,
          beforeSend: function() {
            toggleButtonLoading($btn, true, 'Saving...');
          },
          success: function(data) {
            if (data.status === 200 && data.data) {
              const model = data.data;
              const existingRow = table.row(`#trRow-${model.id}`);
              if (existingRow.node()) {
                existingRow.data(model).draw(false);
              }
              $('#inlineForm').modal('hide');
            }
            toggleButtonLoading($btn, false);
            const toastType = data.status == 200 ? 'bg-success' : 'bg-warning';
            window.showToast({
              title: 'Models 🗂️',
              message: data.message,
              type: toastType,
              animation: 'animate__fadeInUp',
              time: 'Just now',
              delay: 3000
            });
          },
          error: function(xhr) {
            toggleButtonLoading($btn, false);
            console.log(xhr.responseJSON);
          }
        });
      });
    });

    // When parent category changes, load subcategories
    $('#parent_category, #edit_parent_category').on('change', function() {
      const parentId = $(this).val();
      console.log($(this).attr('id'));
      const target = $(this).attr('id') === 'parent_category' ? '#subcategory' : '#edit_subcategory';

      if (parentId) {
        fetch(`${baseURL}/vehicle-categories/${parentId}/subcategories`)
          .then(response => response.json())
          .then(data => {
            const $dropdown = $(target);
            $dropdown.empty().append('<option value="">Select Subcategory</option>');
            data.forEach(item => {
              $dropdown.append(`<option value="${item.id}">${item.name}</option>`);
            });
          })
          .catch(error => {
            console.error('Error fetching subcategories:', error);
          });
      }
    });
  </script>
@endsection
