@extends('layouts/layoutMaster')

@section('title', __('locale.User Details'))

@section('vendor-style')
  @vite(['resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss', 'resources/assets/vendor/libs/animate-css/animate.scss', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss', 'resources/assets/vendor/libs/select2/select2.scss', 'resources/assets/vendor/libs/@form-validation/form-validation.scss', 'resources/assets/vendor/libs/raty-js/raty-js.scss', 'resources/assets/vendor/libs/datatables-fixedheader-bs5/fixedheader.bootstrap5.scss'])
@endsection

@section('page-style')
  @vite('resources/assets/vendor/scss/pages/page-user-view.scss')
  <style>
    .collapse {
      visibility: visible !important;
    }

    .raty {
      display: inline-flex;
      align-items: center;
      gap: 2px;
    }

    .raty img {
      display: inline-block;
      vertical-align: middle;
    }

    .datatables-review .raty img {
      block-size: 0.8rem !important;
      font-size: 0.8rem !important;
      inline-size: 0.8rem !important;
    }

    .datatables-review .raty {
      display: inline-flex;
      align-items: center;
      gap: 0px !important;
    }

    .datatables-ride .raty img {
      block-size: 0.8rem !important;
      font-size: 0.8rem !important;
      inline-size: 0.8rem !important;
    }

    .datatables-ride .raty {
      display: inline-flex;
      align-items: center;
      gap: 0px !important;
    }

    .nav-align-top {
      flex-wrap: wrap;
    }
  </style>
@endsection

@section('vendor-script')
  @vite(['resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.js', 'resources/assets/vendor/libs/cleave-zen/cleave-zen.js', 'resources/assets/vendor/libs/select2/select2.js', 'resources/assets/vendor/libs/@form-validation/popular.js', 'resources/assets/vendor/libs/@form-validation/bootstrap5.js', 'resources/assets/vendor/libs/@form-validation/auto-focus.js', 'resources/assets/vendor/libs/apex-charts/apexcharts.js', 'resources/assets/vendor/libs/raty-js/raty-js.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js'])
@endsection

@section('content')
  <div class="row">
    <!-- User Sidebar -->
    <div class="col-xxl-3 col-xl-4 col-lg-5 order-1 order-md-0">
      <!-- User Card -->
      <div class="card mb-6">
        <div class="card-body pt-12">
          <div class="user-avatar-section">
            <div class=" d-flex align-items-center flex-column">
              <img class="img-fluid rounded mb-4" src="{{ asset($user->profile_photo_url) }}" height="120" width="120"
                alt="User avatar" />
              <div class="user-info text-center">
                <h5>{{ $user->name }}</h5>
                <span class="badge bg-label-secondary">{{ $user->user_type }}</span>
              </div>
            </div>
          </div>
          <div class="d-flex justify-content-around flex-wrap my-6 gap-0 gap-md-3 gap-lg-4">
            <div class="d-flex align-items-center me-5 gap-4">
              <div class="avatar">
                <div class="avatar-initial bg-label-primary rounded">
                  <i class="icon-base ti tabler-truck-delivery icon-lg"></i>
                </div>
              </div>
              <div>
                <h5 class="mb-0">{{ $orderCount }}</h5>
                <span>{{ __('locale.Orders') }}</span>
              </div>
            </div>
            <div class="d-flex align-items-center gap-4">
              <div class="avatar">
                <div class="avatar-initial bg-label-primary rounded">
                  <i class="icon-base ti tabler-briefcase icon-lg"></i>
                </div>
              </div>
              <div>
                <h5 class="mb-0">{{ $rideCount }}</h5>
                <span>{{ __('locale.Rides') }}</span>
              </div>
            </div>
          </div>
          <h5 class="pb-4 border-bottom mb-4">{{ __('locale.Details') }}</h5>
          <div class="info-container">
            <ul class="list-unstyled mb-6">
              <li class="mb-2">
                <span class="h6">{{ __('locale.Name') }}:</span>
                <span>{{ $user->name }}</span>
              </li>
              <li class="mb-2">
                <span class="h6">{{ __('locale.Email') }}:</span>
                <span>{{ $user->email }}</span>
              </li>
              <li class="mb-2">
                <span class="h6">{{ __('locale.Phone') }}:</span>
                <span>{{ $user->dial_code }} {{ $user->phone }}</span>
              </li>
              <li class="mb-2">
                <span class="h6">{{ __('locale.Status') }}:</span>
                <span>
                  @if ($user->status == 1)
                    <span class="badge bg-label-primary">{{ __('locale.Active') }}</span>
                  @else
                    <span class="badge bg-label-secondary">{{ __('locale.Inactive') }}</span>
                  @endif
                </span>
              </li>
              <li class="mb-2">
                <span class="h6">{{ __('locale.Account Verified') }}:</span>
                <span>
                  @if ($user->is_verified == 1)
                    <span class="badge bg-label-success">{{ __('locale.Verified') }}</span>
                  @else
                    <span class="badge bg-label-secondary">{{ __('locale.Not Verified') }}</span>
                  @endif
                </span>
              </li>
            </ul>
            <div class="row gy-6">
              <div class="col-xxl-12 col-sm-12 col-12">
                <div class="card">
                  <h5 class="card-header">{{ __('locale.Rating') }}</h5>
                  <div class="card-body">
                    <div class="read-only-ratings raty" data-read-only="true" data-score="{{ $user->rating ?? 0 }}"
                      data-number="5"></div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!-- /User Card -->
      <!-- Plan Card -->
      <div class="card mb-6 border border-2 border-primary rounded primary-shadow">
        <div class="card-body">
          <div class="d-flex justify-content-between align-items-start">
            <span class="badge bg-label-primary">{{ __('locale.Login Details') }}</span>
          </div>
          <ul class="list-unstyled g-2 my-6">
            <li class="mb-2">
              <span class="h6">{{ __('locale.Last Login') }}:</span>
              <span>{{ $user->last_seen }}</span>
            </li>
          </ul>
        </div>
      </div>
      <!-- /Plan Card -->
    </div>
    <!--/ User Sidebar -->

    <!-- User Content -->
    <div class="col-xxl-9 col-xl-8 col-lg-7 order-0 order-md-1">
      <!-- User Pills -->
      <div class="nav-align-top">
        <ul class="nav nav-tabs nav-fill" role="tablist">

          <li class="nav-item">
            <button type="button" class="nav-link active" role="tab" data-bs-toggle="tab"
              data-bs-target="#navs-justified-address" aria-controls="navs-justified-address" aria-selected="false">
              <span class="d-none d-sm-inline-flex align-items-center"><i
                  class="icon-base ti tabler-map-pin icon-sm me-1_5"></i>{{ __('locale.Address') }}</span>
              <i class="icon-base ti tabler-map-pin icon-sm d-sm-none"></i>
            </button>
          </li>
          <li class="nav-item">
            <button type="button" class="nav-link" role="tab" data-bs-toggle="tab"
              data-bs-target="#navs-justified-rides" aria-controls="navs-justified-rides" aria-selected="false">
              <span class="d-none d-sm-inline-flex align-items-center"><i
                  class="icon-base ti tabler-car icon-sm me-1_5"></i>{{ __('locale.Rides') }}</span>
              <i class="icon-base ti tabler-car icon-sm d-sm-none"></i>
            </button>
          </li>
          <li class="nav-item">
            <button type="button" class="nav-link" role="tab" data-bs-toggle="tab"
              data-bs-target="#navs-justified-parcel" aria-controls="navs-justified-parcel" aria-selected="false">
              <span class="d-none d-sm-inline-flex align-items-center"><i
                  class="icon-base ti tabler-truck-delivery icon-sm me-1_5"></i>{{ __('locale.Parcels') }}</span>
              <i class="icon-base ti tabler-truck-delivery icon-sm d-sm-none"></i>
            </button>
          </li>
          <li class="nav-item">
            <button type="button" class="nav-link" role="tab" data-bs-toggle="tab"
              data-bs-target="#navs-justified-orders" aria-controls="navs-justified-orders" aria-selected="false">
              <span class="d-none d-sm-inline-flex align-items-center"><i
                  class="icon-base ti tabler-basket-check icon-sm me-1_5"></i>{{ __('locale.Orders') }}</span>
              <i class="icon-base ti tabler-basket-check icon-sm d-sm-none"></i>
            </button>
          </li>
          <li class="nav-item">
            <button type="button" class="nav-link" role="tab" data-bs-toggle="tab"
              data-bs-target="#navs-justified-wallet" aria-controls="navs-justified-wallet" aria-selected="false">
              <span class="d-none d-sm-inline-flex align-items-center"><i
                  class="icon-base ti tabler-credit-card-pay icon-sm me-1_5"></i>{{ __('locale.Wallet History') }}</span>
              <i class="icon-base ti tabler-credit-card-pay icon-sm d-sm-none"></i>
            </button>
          </li>
          <li class="nav-item">
            <button type="button" class="nav-link" role="tab" data-bs-toggle="tab"
              data-bs-target="#navs-justified-reviews" aria-controls="navs-justified-reviews" aria-selected="false">
              <span class="d-none d-sm-inline-flex align-items-center"><i
                  class="icon-base ti tabler-star icon-sm me-1_5"></i>{{ __('locale.Reviews') }}</span>
              <i class="icon-base ti tabler-star icon-sm d-sm-none"></i>
            </button>
          </li>
        </ul>
      </div>
      <!--/ User Pills -->


      <div class="card mb-6">
        <div class="tab-content">
          <div class="tab-pane fade show active" id="navs-justified-address" role="tabpanel">
            <!-- Address accordion -->

            <div class="card card-action mb-6">
              <div class="card-header align-items-center py-6">
                <h5 class="card-action-title mb-0">{{ __('locale.Address Book') }}</h5>

              </div>
              <div class="card-body">
                <div class="accordion accordion-flush accordion-arrow-left" id="ecommerceBillingAccordionAddress">
                  @forelse ($user['addresses'] as $key => $address)
                    <div class="accordion-item border-bottom">
                      <div
                        class="accordion-header d-flex justify-content-between align-items-center flex-wrap flex-sm-nowrap"
                        id="headingHome{{ $key }}">
                        <a class="accordion-button collapsed" data-bs-toggle="collapse"
                          data-bs-target="#ecommerceBillingAddressHome{{ $key }}" aria-expanded="false"
                          aria-controls="headingHome{{ $key }}" role="button">
                          <span>
                            <span class="d-flex gap-2 align-items-baseline">
                              <span class="h6 mb-1">{{ $address->type }}</span>

                            </span>
                            <span class="mb-0">{{ $address->address }}</span>
                          </span>
                        </a>
                        <div class="d-flex gap-4 p-6 p-sm-0 pt-0 ms-1 ms-sm-0">
                          @if ($address->is_default == 1)
                            <span class="badge bg-label-success">{{ __('locale.Default Address') }}</span>
                          @endif
                        </div>
                      </div>
                      <div id="ecommerceBillingAddressHome{{ $key }}" class="accordion-collapse collapse"
                        data-bs-parent="#ecommerceBillingAccordionAddress{{ $key }}">
                        <div class="accordion-body ps-6 ms-1">
                          <h6 class="mb-1">{{ $address->city }}</h6>
                          <p class="mb-1">{{ $address->state }},</p>
                          <p class="mb-1">{{ $address->country }},</p>
                          <p class="mb-1">{{ $address->postcode }}</p>
                        </div>
                      </div>
                    </div>

                  @empty
                    <p>{{ __('locale.No Address saved yet.') }}</p>
                  @endforelse


                </div>
              </div>
            </div>
            <!-- Address accordion -->

            <!-- payment accordion -->
            <div class="card card-action mb-6">
              <div class="card-header align-items-center py-6">
                <h5 class="card-action-title mb-0">{{ __('locale.Payment Methods') }}</h5>
              </div>
              <div class="card-body">
                <div class="accordion accordion-flush accordion-arrow-left" id="ecommerceBillingAccordionPayment">
                  <?php $seen = []; ?>
                  @forelse ($paymentMethods as $card)
                    <?php
                $key = $card->card->brand . '|' . $card->card->last4 . '|' . $card->card->exp_month . '|' . $card->card->exp_year;
                if (!in_array($key, $seen)) {
                  $seen[] = $key;
              ?>
                    <div class="accordion-item border-bottom ">
                      <div
                        class="accordion-header d-flex justify-content-between align-items-center flex-wrap flex-sm-nowrap"
                        id="headingPaymentExpress{{ $key }}">
                        <a class="accordion-button collapsed" data-bs-toggle="collapse"
                          data-bs-target="#ecommerceBillingPaymentExpress{{ $key }}" aria-expanded="false"
                          aria-controls="headingPaymentExpress{{ $key }}" role="button">
                          <span class="accordion-button-information d-flex align-items-center gap-4">
                            <span class="accordion-button-image">
                              <img src="" class="img-fluid w-px-50 h-px-30" alt="american-express-card"
                                data-app-light-img="icons/payments/ae-light.png"
                                data-app-dark-img="icons/payments/ae-dark.png" />
                            </span>
                            <span>
                              <span class="d-flex gap-2 row-gap-0 flex-wrap align-items-baseline">
                                <img class="mb-2 img-fluid" style="height: 20px !important;"
                                  src="{{ asset('assets/img/payments/' . $card->card->brand . '.png') }}"
                                  alt="{{ ucfirst($card->card->brand) }}"
                                  onerror="this.onerror=null;this.src=`{{ asset('assets/img/placeholder.jpg') }}`;" />

                              </span>
                              <span class="mb-0">**** **** **** {{ $card->card->last4 }}</span>
                            </span>
                          </span>
                        </a>
                        @if ($card->id === $user->default_payment_method)
                          <div class="d-flex gap-4 p-6 p-sm-0 pt-0 ms-1 ms-sm-0">
                            <span class="badge bg-label-success mb-2 mb-sm-0">{{ __('locale.Primary') }}</span>
                          </div>
                        @endif
                      </div>
                      <div id="ecommerceBillingPaymentExpress{{ $key }}" class="accordion-collapse collapse"
                        aria-labelledby="headingPaymentExpress{{ $key }}"
                        data-bs-parent="#ecommerceBillingAccordionPayment{{ $key }}">
                        <div
                          class="accordion-body d-flex align-items-baseline flex-wrap flex-xl-nowrap flex-sm-nowrap flex-md-wrap">
                          <table class="table table-sm table-borderless text-nowrap small">
                            <tr>
                              <td class="w-50">{{ __('locale.Name') }}</td>
                              <td class="fw-medium text-heading">{{ $card->billing_details->name }}</td>
                            </tr>
                            <tr>
                              <td>{{ __('locale.Card Number') }}</td>
                              <td class="fw-medium text-heading">**** **** **** {{ $card->card->last4 }}</td>
                            </tr>
                            <tr>
                              <td>{{ __('locale.Expires') }}</td>
                              <td class="fw-medium text-heading">
                                {{ $card->card->exp_month }}/{{ $card->card->exp_year }}</td>
                            </tr>
                            <tr>
                              <td>{{ __('locale.CVC check') }}</td>
                              <td class="fw-medium text-heading d-flex align-items-center gap-2">
                                @if ($card->card?->checks?->cvc_check == 'pass')
                                  {{ __('locale.Passed') }} <span class="badge bg-label-success rounded-pill p-0"><i
                                      class="icon-base ti tabler-check icon-xs"></i></span>
                                @endif
                              </td>
                            </tr>

                          </table>
                          <table class="table table-sm table-borderless text-nowrap small">

                            <tr>
                              <td>{{ __('locale.Phone') }}</td>
                              <td class="fw-medium text-heading">{{ $card->billing_details->phone }}</td>
                            </tr>
                            <tr>
                              <td>{{ __('locale.Email') }}</td>
                              <td class="fw-medium text-heading">{{ $card->billing_details->email }}</td>
                            </tr>
                            <tr>
                              <td>{{ __('locale.Origin') }}</td>
                              <td class="fw-medium text-heading d-flex align-items-center gap-2">
                                {{ $card->billing_details?->address?->country }} <i
                                  class="fis fi fi-us rounded-circle me-2 icon-sm"> </i>
                              </td>
                            </tr>
                            <tr>

                              <td>{{ __('locale.ID') }}</td>
                              <td class="fw-medium text-heading">{{ $card->id }}</td>
                            </tr>

                          </table>

                        </div>
                      </div>
                    </div>
                    <?php } ?>
                  @empty
                    <p>{{ __('locale.No cards saved yet.') }}</p>
                  @endforelse

                </div>
              </div>
            </div>
          </div>

          <div class="tab-pane fade" id="navs-justified-rides" role="tabpanel">
            <div class="card-header border-bottom">
              <h5 class="card-title d-none">{{ __('locale.Filter') }}</h5>
              <div class="d-flex justify-content-between align-items-center row pt-0 gap-6 gap-md-0 g-md-6">
                <div class="col-md-6 driver"></div>
                <div class="col-md-6 customer d-none"></div>
                <div class="col-md-6 date_filter">
                  <input type="text" class="form-control" placeholder="YYYY-MM-DD to YYYY-MM-DD"
                    id="flatpickr-range" />
                </div>
                <div class="col-md-6 ride_type"></div>
                <div class="col-md-6 ride_status"></div>
              </div>
            </div>
            <div class="card-datatable table-responsive">
              <table class="datatables-ride table">
                <thead class="border-top">
                  <tr>
                    <th>{{ __('locale.ID') }}</th>
                    <th></th>
                    <th>{{ __('locale.User Details') }}</th>
                    <th>{{ __('locale.Ride Details') }}</th>
                    <th>{{ __('locale.Driver Details') }}</th>
                    <th>{{ __('locale.Txn Detail') }}</th>
                    <th>{{ __('locale.Address') }}</th>
                    <th>{{ __('locale.Status') }}</th>
                    <th>{{ __('locale.Actions') }}</th>
                  </tr>
                </thead>
              </table>
            </div>
          </div>

          <div class="tab-pane fade" id="navs-justified-parcel" role="tabpanel">
            <div class="card-header border-bottom">
              <h5 class="card-title d-none">{{ __('locale.Filter') }}</h5>
              <div class="d-flex justify-content-between align-items-center row pt-0 gap-6 gap-md-0 g-md-6">
                <div class="col-md-6 driver_parcel"></div>
                <div class="col-md-6 customer_parcel d-none"></div>
                <div class="col-md-6 date_filter_parcel">
                  <input type="text" class="form-control" placeholder="YYYY-MM-DD to YYYY-MM-DD"
                    id="flatpickr-range-parcel" />
                </div>
                <div class="col-md-6 ride_type_parcel"></div>
                <div class="col-md-6 ride_status_parcel"></div>
              </div>
            </div>
            <div class="card-datatable table-responsive">
              <table class="datatables-parcel table">
                <thead class="border-top">
                  <tr>
                    <th>{{ __('locale.ID') }}</th>
                    <th></th>
                    <th>{{ __('locale.User Details') }}</th>
                    <th>{{ __('locale.Details') }}</th>
                    <th>{{ __('locale.Driver Details') }}</th>
                    <th>{{ __('locale.Txn Detail') }}</th>
                    <th>{{ __('locale.Address') }}</th>
                    <th>{{ __('locale.Status') }}</th>
                    <th>{{ __('locale.Actions') }}</th>
                  </tr>
                </thead>
              </table>
            </div>
          </div>

          <div class="tab-pane fade" id="navs-justified-orders" role="tabpanel">

            <div class="card-header border-bottom">
              <h5 class="card-title d-none">{{ __('locale.Filter') }}</h5>
              <div class="d-flex justify-content-between align-items-center row pt-0 gap-6 gap-md-0 g-md-6">
                <div class="col-md-3 customer d-none"></div>
                <div class="col-md-4 order_status"></div>
                <div class="col-md-4 payment_status"></div>
                <div class="col-md-4 payment_type"></div>
              </div>
            </div>
            <div class="card-datatable table-responsive">
              <table class="datatables-order table border-top">
                <thead>
                  <tr>
                    <th></th>
                    <th></th>
                    <th>{{ __('locale.Order') }}</th>
                    <th>{{ __('locale.Date') }}</th>
                    <th>{{ __('locale.Customers') }}</th>
                    <th>{{ __('locale.Payment') }}</th>
                    <th>{{ __('locale.Status') }}</th>
                    <th>{{ __('locale.Type') }}</th>
                    <th>{{ __('locale.Actions') }}</th>
                  </tr>
                </thead>
              </table>
            </div>
          </div>

          <div class="tab-pane fade" id="navs-justified-wallet" role="tabpanel">
            <div class="card-header border-bottom">
              <h5 class="card-title d-none">{{ __('locale.Filter') }}</h5>
              <div class="d-flex justify-content-between align-items-center row pt-0 gap-6 gap-md-0 g-md-6">
                <div class="col-md-6 transaction_mode"></div>
                <div class="col-md-6 transaction_type"></div>
                <div class="col-md-3 transaction_status d-none"></div>
                <div class="col-md-6 date_filter d-none">
                  <input type="text" class="form-control" placeholder="YYYY-MM-DD to YYYY-MM-DD"
                    id="flatpickr-range" />
                </div>
              </div>
            </div>
            <div class="card-datatable table-responsive">
              <table class="datatables-transaction table">
                <thead class="border-top">
                  <tr>
                    <th></th>
                    <th></th>
                    <th>{{ __('locale.Details') }}</th>
                    <th>{{ __('locale.Date') }}</th>
                    <th>{{ __('locale.Amount Details') }}</th>
                    <th>{{ __('locale.Type') }}</th>
                    <th>{{ __('locale.Payment Mode') }}</th>
                    <th>{{ __('locale.Status') }}</th>
                    <th>{{ __('locale.Actions') }}</th>
                  </tr>
                </thead>
              </table>
            </div>
          </div>


          <div class="tab-pane fade" id="navs-justified-reviews" role="tabpanel">
            <div class="row mb-6 g-6">
              {{-- Left: Rating Summary --}}
              <div class="col-md-12">
                <div class="card h-100">
                  <div class="card-body row widget-separator g-0">
                    {{-- Left side with main rating --}}
                    <div class="col-sm-5 border-shift border-end pe-sm-6">
                      <h3 class="text-primary d-flex align-items-center gap-2 mb-2">
                        {{ number_format($reviewData['avg_rating'], 2) }}
                        <i class="icon-base ti tabler-star-filled icon-32px"></i>
                      </h3>
                      <p class="h6 mb-2">{{ __('locale.Total') }} {{ $reviewData['total_reviews'] }}
                        {{ __('locale.Reviews') }}</p>
                      <p class="pe-2 mb-2">{{ __('locale.All reviews are from genuine customers') }}</p>
                      <span class="badge bg-label-primary mb-4 mb-sm-0">
                        +{{ $reviewData['new_reviews'] }} {{ __('locale.This week') }}
                      </span>
                      <hr class="d-sm-none" />
                    </div>

                    {{-- Right side with star progress --}}
                    <div
                      class="col-sm-7 gap-2 text-nowrap d-flex flex-column justify-content-between ps-sm-6 pt-2 py-sm-2">
                      @foreach (range(5, 1) as $star)
                        <div class="d-flex align-items-center gap-2">
                          <small>{{ $star }} Star</small>
                          <div class="progress w-100 bg-label-primary" style="height:8px;">
                            <div class="progress-bar bg-primary" role="progressbar"
                              style="width: {{ $reviewData['progress'][$star]['percent'] ?? 0 }}%"
                              aria-valuenow="{{ $reviewData['progress'][$star]['percent'] ?? 0 }}" aria-valuemin="0"
                              aria-valuemax="100">
                            </div>
                          </div>
                          <small class="w-px-20 text-end">{{ $reviewData['progress'][$star]['count'] ?? 0 }}</small>
                        </div>
                      @endforeach
                    </div>
                  </div>
                </div>
              </div>

              {{-- Right: Weekly Statistics --}}
              <div class="col-md-12">
                <div class="card h-100">
                  <div class="card-body row">
                    <div class="col-sm-5">
                      <div class="mb-12">
                        <h5 class="mb-2 text-nowrap">{{ __('locale.Reviews statistics') }}</h5>
                        <p class="mb-0">
                          <span class="me-2">{{ $reviewData['new_reviews'] }} {{ __('locale.New reviews') }}</span>
                          <span class="badge bg-label-success">
                            +{{ $reviewData['total_reviews'] > 0
                                ? round(($reviewData['new_reviews'] / $reviewData['total_reviews']) * 100, 1)
                                : 0 }}%
                          </span>
                        </p>
                      </div>

                      @php
                        $positiveReviews =
                            ($reviewData['progress'][5]['count'] ?? 0) + ($reviewData['progress'][4]['count'] ?? 0);
                        $positivePercentage =
                            $reviewData['total_reviews'] > 0
                                ? round(($positiveReviews / $reviewData['total_reviews']) * 100, 1)
                                : 0;
                      @endphp

                      <div>
                        <h6 class="mb-2 fw-normal">
                          <span class="text-success me-1">{{ $positivePercentage }}%</span>
                          {{ __('locale.Positive reviews') }}
                        </h6>
                        <small>{{ __('locale.Weekly Report') }}</small>
                      </div>
                    </div>

                    {{-- Placeholder for Chart --}}
                    <div class="col-sm-7 d-flex justify-content-sm-end align-items-end">
                      <div id="reviewsChart"></div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <!-- review List Table -->
            <div class="card">
              <div class="card-datatable table-responsive">
                <table class="datatables-review table border-top">
                  <thead>
                    <tr>
                      <th></th>
                      <th></th>
                      <th>{{ __('locale.Product') }}</th>
                      <th class="text-nowrap">{{ __('locale.Reviewer') }}</th>
                      <th>{{ __('locale.Review') }}</th>
                      <th>{{ __('locale.Date') }}</th>
                      <th class="text-nowrap">{{ __('locale.Status') }}</th>
                      <th>{{ __('locale.Actions') }}</th>
                    </tr>
                  </thead>
                </table>
              </div>
            </div>
          </div>

        </div>
      </div>


    </div>
    <!--/ User Content -->
  </div>
  <!-- /Modal -->
  <div id="role-helper-transaction" data-query="wallet_id={{ $walletId ?? '' }}">
    <div id="role-helper" data-query="mtype[]=Ride">
      <div id="role-helper-parcel" data-query="mtype[]=Parcel">
      @endsection

      @section('page-script')
        <script>
          window.permissions = {
            UserId: @json(request()->segment(3)),
            reviewableId: @json(request()->segment(3)),
            reviewableType: @json('user')
          };
          window.reviewData = @json($reviewData['weeklyReviewCounts']);
        </script>
        @vite(['resources/assets/js/reviews.js', 'resources/assets/js/star-ratings.js', 'resources/assets/js/ride.js', 'resources/assets/js/parcel.js', 'resources/assets/js/forms-pickers.js', 'resources/assets/js/orders.js', 'resources/assets/js/wallet_transaction.js'])
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script>
          // Works for both <button> and <a> tabs
          $(document).on('click', 'button[data-bs-toggle="tab"][data-bs-target="#navs-justified-orders"]', function() {
            if ($.fn.DataTable.isDataTable('.datatables-order')) {
              // Reload data if table already exists
              $('.datatables-order').DataTable().ajax.reload(null, false);
            } else {
              // Init if not already initialized
              initOrderTable();
            }

            setTimeout(() => {
              $('.datatables-order').DataTable()
                .columns.adjust()
                .responsive.recalc()
                .draw(false);
            }, 50);
          });
          $(document).on('click', 'button[data-bs-toggle="tab"][data-bs-target="#navs-justified-rides"]', function() {
            if ($.fn.DataTable.isDataTable('.datatables-ride')) {
              // Reload data if table already exists
              $('.datatables-ride').DataTable().ajax.reload(null, false);
            } else {
              // Init if not already initialized
              initRideTable();
            }

            // Adjust columns after showing
            setTimeout(() => {
              $('.datatables-ride').DataTable()
                .columns.adjust()
                .responsive.recalc()
                .draw(false);
            }, 50);
          }); // Adjust columns after showing
          $(document).on('click', 'button[data-bs-toggle="tab"][data-bs-target="#navs-justified-parcel"]', function() {
            if ($.fn.DataTable.isDataTable('.datatables-parcel')) {
              // Reload data if table already exists
              $('.datatables-parcel').DataTable().ajax.reload(null, false);
            } else {
              // Init if not already initialized
              initParcelTable();
            }

            // Adjust columns after showing
            setTimeout(() => {
              $('.datatables-parcel').DataTable()
                .columns.adjust()
                .responsive.recalc()
                .draw(false);
            }, 50);
          }); // Adjust columns after showing
          $(document).on('click', 'button[data-bs-toggle="tab"][data-bs-target="#navs-justified-wallet"]', function() {
            if ($.fn.DataTable.isDataTable('.datatables-transaction')) {
              // Reload data if table already exists
              $('.datatables-transaction').DataTable().ajax.reload(null, false);
            } else {
              // Init if not already initialized
              initWalletTable();
            }

            // Adjust columns after showing
            setTimeout(() => {
              $('.datatables-transaction').DataTable()
                .columns.adjust()
                .responsive.recalc()
                .draw(false);
            }, 50);
          }); // Adjust columns after showing
          $(document).on('click', 'button[data-bs-toggle="tab"][data-bs-target="#navs-justified-reviews"]', function() {
            if ($.fn.DataTable.isDataTable('.datatables-review')) {
              // Reload data if table already exists
              $('.datatables-review').DataTable().ajax.reload(null, false);
            } else {

            }

            setTimeout(() => {
              $('.datatables-review').DataTable()
                .columns.adjust()
                .responsive.recalc()
                .draw(false);
            }, 50);
          });
        </script>
      @endsection
