@extends('layouts/layoutMaster')

@section('title', __('locale.Users'))

<!-- Vendor Styles -->
@section('vendor-style')
  @vite(['resources/assets/css/datatables.scss'])
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
  @vite(['resources/assets/js/datatables.js', 'resources/assets/vendor/libs/raty-js/raty-js.js'])
@endsection



@section('content')
  <div class="row g-6 mb-6">
    <div class="col-sm-6 col-xl-3">
      <div class="card">
        <div class="card-body">
          <div class="d-flex align-items-start justify-content-between">
            <div class="content-left">
              <span class="text-heading">{{ __('locale.Users') }}</span>
              <div class="d-flex align-items-center my-1">
                <h4 class="mb-0 me-2">{{ $totalUser }}</h4>
                <p class="text-success mb-0">({{ $totalUser > 0 ? round(($totalUser / $totalUser) * 100, 2) : 0 }}%)</p>
              </div>
              <small class="mb-0">{{ __('locale.Total') }} {{ __('locale.Users') }}</small>
            </div>
            <div class="avatar">
              <span class="avatar-initial rounded bg-label-primary">
                <i class="icon-base ti tabler-users icon-26px"></i>
              </span>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="col-sm-6 col-xl-3">
      <div class="card">
        <div class="card-body">
          <div class="d-flex align-items-start justify-content-between">
            <div class="content-left">
              <span class="text-heading">{{ __('locale.Verified') }} {{ __('locale.Users') }}</span>
              <div class="d-flex align-items-center my-1">
                <h4 class="mb-0 me-2">{{ $verified }}</h4>
                <p class="text-success mb-0">({{ $totalUser > 0 ? round(($verified / $totalUser) * 100, 2) : 0 }}%)</p>
              </div>
              <small class="mb-0">{{ __('locale.Recent analytics') }} </small>
            </div>
            <div class="avatar">
              <span class="avatar-initial rounded bg-label-success">
                <i class="icon-base ti tabler-user-plus icon-26px"></i>
              </span>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="col-sm-6 col-xl-3">
      <div class="card">
        <div class="card-body">
          <div class="d-flex align-items-start justify-content-between">
            <div class="content-left">
              <span class="text-heading">{{ __('locale.Disabled') }} {{ __('locale.Users') }}</span>
              <div class="d-flex align-items-center my-1">
                <h4 class="mb-0 me-2">{{ $userDisabled }}</h4>
                <p class="text-danger mb-0">({{ $totalUser > 0 ? round(($userDisabled / $totalUser) * 100, 2) : 0 }}%)
                </p>
              </div>
              <small class="mb-0">{{ __('locale.Recent analytics') }}</small>
            </div>
            <div class="avatar">
              <span class="avatar-initial rounded bg-label-danger">
                <i class="icon-base ti tabler-user-minus icon-26px"></i>
              </span>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="col-sm-6 col-xl-3">
      <div class="card">
        <div class="card-body">
          <div class="d-flex align-items-start justify-content-between">
            <div class="content-left">
              <span class="text-heading">{{ __('locale.Verification Pending') }}</span>
              <div class="d-flex align-items-center my-1">
                <h4 class="mb-0 me-2">{{ $notVerified }}</h4>
                <p class="text-danger mb-0">({{ $totalUser > 0 ? round(($notVerified / $totalUser) * 100, 2) : 0 }}%)</p>
              </div>
              <small class="mb-0">{{ __('locale.Recent analytics') }}</small>
            </div>
            <div class="avatar">
              <span class="avatar-initial rounded bg-label-warning">
                <i class="icon-base ti tabler-user-search icon-26px"></i>
              </span>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <!-- Users List Table -->
  <div class="card">
    <div class="card-header border-bottom">
      <h5 class="card-title mb-0 d-none">{{ __('locale.Search Filter') }}</h5>
      <div class="row p-0">
        <div class="col-md-6">
          <label for="filter_verified" class="form-label">{{ __('locale.User Verified') }}</label>
          <select id="filter_verified" class="form-select">
            <option value="">{{ __('locale.All') }}</option>
            <option value="1">{{ __('locale.Verified') }}</option> <!-- true -->
            <option value="0">{{ __('locale.Not Verified') }}</option> <!-- false -->
          </select>
        </div>

        <div class="col-md-6">
          <label for="filter_status" class="form-label">{{ __('locale.Status') }}</label>
          <select id="filter_status" class="form-select">
            <option value="">{{ __('locale.All') }}</option>
            <option value="1">{{ __('locale.Active') }}</option>
            <option value="0">{{ __('locale.Inactive') }}</option>
          </select>
        </div>

      </div>
    </div>
    <div class="card-datatable">
      <table class="datatables-users table border-top">
        <thead>
          <tr>
            <th></th>
            <th>{{ __('locale.ID') }}</th>
            <th>{{ __('locale.User') }}</th>
            <th>{{ __('locale.Email') }}</th>
            <th>{{ __('locale.Verified') }}</th>
            <th>{{ __('locale.Actions') }}</th>
          </tr>
        </thead>
      </table>
    </div>
    <!-- Offcanvas to add new user -->
    <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasAddUser" aria-labelledby="offcanvasAddUserLabel">
      <div class="offcanvas-header border-bottom">
        <h5 id="offcanvasAddUserLabel" class="offcanvas-title">{{ __('locale.Add User') }}</h5>
        <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
      </div>
      <div class="offcanvas-body mx-0 flex-grow-0 p-6 h-100">
        <form class="add-new-user pt-0" id="addNewUserForm" method="POST" action="{{ route('users.store') }}">
          {{ csrf_field() }}
          <input type="hidden" name="id" id="user_id">
          <input type="hidden" name="user_type" value="User">
          <div class="mb-6 form-control-validation">
            <label class="form-label" for="add-user-fullname">{{ __('locale.Full Name') }}</label>
            <input type="text" class="form-control" id="add-user-fullname" placeholder="John Doe" name="name"
              aria-label="John Doe" />
          </div>
          <div class="mb-6 form-control-validation">
            <label class="form-label" for="add-user-email">{{ __('locale.Email') }}</label>
            <input type="text" id="add-user-email" class="form-control" placeholder="john.doe@example.com"
              aria-label="john.doe@example.com" name="email" />
          </div>
          <div class="mb-6">
            <label class="form-label" for="add-user-contact">{{ __('locale.Contact Number') }}</label>
            <input type="text" id="add-user-contact" class="form-control phone-mask" placeholder="609 988 4411"
              aria-label="" name="phone" />
          </div>
          <div class="mb-6 form-group">
            <label class="form-label" for="add-user-password">{{ __('locale.Password') }}</label>
            <input type="password" id="add-user-password" class="form-control" placeholder="" name="password" />
          </div>
          <input type="hidden" id="dial_code" name="dial_code">
          <input type="hidden" name="dial_code_iso" id="country_iso">
          <button type="submit" class="btn btn-primary me-3 data-submit">{{ __('locale.Submit') }}</button>
          <button type="reset" class="btn btn-label-danger"
            data-bs-dismiss="offcanvas">{{ __('locale.Cancel') }}</button>
        </form>
      </div>
    </div>
  </div>
  @include('_partials/_modals/modal-password')
@endsection
<!-- Page Scripts -->
@section('page-script')
  @vite(['resources/assets/js/users.js'])
@endsection
