@extends('layouts/layoutMaster')

@section('title', __('locale.Transactions'))

@section('vendor-style')
  @vite(['resources/assets/css/datatables.scss', 'resources/assets/vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.scss'])
@endsection

@section('vendor-script')
  @vite(['resources/assets/js/datatables.js', 'resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js'])
@endsection


@section('content')

  <!-- Product List Table -->
  <div class="card">
    <div class="card-header border-bottom">
      <h5 class="card-title d-none">{{ __('locale.Filter') }}</h5>
      <div class="d-flex justify-content-between align-items-center row pt-0 gap-6 gap-md-0 g-md-6">
        <div class="col-md-3 transactionable_type"></div>
        <div class="col-md-3 transaction_status"></div>
        <div class="col-md-3 customer">
          <label for="Customers" class="form-label">{{ __('locale.Customers') }}</label>
          <select id="Customer" class="select2 form-select">
            <option value="">{{ __('locale.All') }}</option>
            @foreach ($customers as $id => $name)
              <option value="{{ $id }}">{{ $name }}</option>
            @endforeach
          </select>
        </div>
        <div class="col-md-3 date_filter">
          <label for="bs-rangepicker-range" class="form-label">{{ __('locale.Date') }}</label>
          <input type="text" class="form-control" placeholder="YYYY-MM-DD to YYYY-MM-DD" id="bs-rangepicker-range" />
        </div>
      </div>
    </div>
    <div class="card-datatable">
      <table class="dt-fixedheader table-bordered datatables-transaction table">
        <thead class="border-top">
          <tr>
            <th></th>
            <th></th>
            <th>{{ __('locale.User Details') }}</th>
            <th>{{ __('locale.Date') }}</th>
            <th>{{ __('locale.Amount') }}</th>
            <th>{{ __('locale.Txn Detail') }}</th>
            <th>{{ __('locale.Type') }}</th>
            <th>{{ __('locale.Status') }}</th>
            <th>{{ __('locale.Actions') }}</th>
          </tr>
        </thead>
      </table>
    </div>
  </div>
@endsection
@section('page-script')
  @vite(['resources/assets/js/transaction.js', 'resources/assets/js/forms-pickers.js'])
@endsection
