@extends('layouts/layoutMaster')

@section('title', __('locale.Add Store'))

<!-- Vendor Styles -->
@section('vendor-style')
  @vite(['resources/assets/vendor/libs/bs-stepper/bs-stepper.scss', 'resources/assets/vendor/libs/select2/select2.scss', 'resources/assets/vendor/libs/animate-css/animate.scss', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.scss', 'resources/assets/vendor/libs/@form-validation/form-validation.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss'])
  <style>
    .collapse {
      visibility: visible !important
    }

    /* Custom Google Maps InfoWindow Close Button */
    .gm-style-iw-d {
      padding: 8px !important;
      /* Ensure proper padding inside InfoWindow */
    }

    /* InfoWindow close button top-right */
    .gm-style-iw .gm-ui-hover-effect {
      position: absolute !important;
      top: 4px !important;
      right: 4px !important;
      width: 24px !important;
      height: 24px !important;
      opacity: 1 !important;
      background-color: #fff !important;
      border-radius: 50% !important;
      box-shadow: 0 1px 4px rgba(0, 0, 0, 0.3);
      cursor: pointer;
      z-index: 1000;
    }

    .gm-style-iw .gm-ui-hover-effect::after {
      content: '×';
      position: absolute;
      top: 50%;
      left: 50%;
      transform: translate(-50%, -50%);
      font-size: 16px;
      font-weight: bold;
      color: #000;
      pointer-events: none;
      /* allow click through */
    }
  </style>
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
  @vite(['resources/assets/vendor/libs/bs-stepper/bs-stepper.js', 'resources/assets/vendor/libs/select2/select2.js', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.js', 'resources/assets/vendor/libs/@form-validation/bootstrap5.js', 'resources/assets/vendor/libs/@form-validation/popular.js', 'resources/assets/vendor/libs/@form-validation/auto-focus.js', 'resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js'])
@endsection


@section('content')
  <meta name="google-maps-key" content="{{ config('services.google.maps_key') }}">
  <meta name="google-maps-id" content="{{ config('services.google.maps_id') }}">
  @php  $img=isset($store['user']) && $store['user']->profile_photo_path ? asset('storage/' . $store['user']->profile_photo_path) : asset('/assets/img/order.png'); @endphp
  <input type="hidden" id="customPinUrl" value="{{ $img }}">
  <!-- Modern -->
  <div class="row">
    <!-- Modern Icons Wizard -->
    <div class="col-12 mb-6">
      <div class="bs-stepper wizard-icons wizard-modern wizard-modern-icons-example mt-2">
        <div class="bs-stepper-header pt-0">
          <div class="step" data-target="#account-details-modern" data-step-index="0">
            <button type="button" class="step-trigger">
              <span class="bs-stepper-icon">
                <svg viewBox="0 0 54 54">
                  <use xlink:href="{{ asset('assets/svg/icons/form-wizard-account.svg#wizardAccount') }}">
                  </use>
                </svg>
              </span>
              <span class="bs-stepper-label">{{ __('locale.Store Details') }}</span>
            </button>
          </div>
          <div class="line">
            <i class="icon-base ti tabler-chevron-right"></i>
          </div>
          <div class="step" data-target="#personal-info-modern" data-step-index="1">
            <button type="button" class="step-trigger">
              <span class="bs-stepper-icon">
                <svg viewBox="0 0 54 54">
                  <use xlink:href="{{ asset('assets/svg/icons/form-wizard-address.svg#wizardAddress') }}">
                  </use>
                </svg>
              </span>
              <span class="bs-stepper-label">{{ __('locale.Address') }}</span>
            </button>
          </div>
          <div class="line">
            <i class="icon-base ti tabler-chevron-right"></i>
          </div>
          <div class="step" data-target="#address-modern" data-step-index="2">
            <button type="button" class="step-trigger">
              <span class="bs-stepper-icon">
                <svg viewBox="0 0 58 54">
                  <use xlink:href="{{ asset('assets/svg/icons/form-wizard-personal.svg#wizardPersonal') }}">
                  </use>
                </svg>
              </span>
              <span class="bs-stepper-label">{{ __('locale.Other Info.') }}</span>
            </button>
          </div>
          <div class="line">
            <i class="icon-base ti tabler-chevron-right"></i>
          </div>
          <div class="step" data-target="#social-links-modern" data-step-index="3">
            <button type="button" class="step-trigger">
              <span class="bs-stepper-icon">
                <svg viewBox="0 0 54 54">
                  <use xlink:href="{{ asset('assets/svg/icons/form-wizard-social-link.svg#wizardSocialLink') }}">
                  </use>
                </svg>
              </span>
              <span class="bs-stepper-label">{{ __('locale.Categories') }}</span>
            </button>
          </div>

        </div>
        <div class="bs-stepper-content">
          <form id="storeForm" enctype="multipart/form-data">
            @csrf
            <input type="hidden" name="id" id="store_id" value="{{ $store->id ?? '' }}">
            <input type="hidden" name="user_id" id="user_id" value="{{ $store['user']->id ?? '' }}">
            <!-- Step 1: Account Details -->
            <div id="account-details-modern" class="content">

              <div class="row g-6">
                <div class="col-sm-6">
                  <label class="form-label" for="full_name">{{ __('locale.Name') }}*</label>
                  <input type="text" class="form-control" id="full_name"
                    value="{{ $store['user']->name ?? '' }}"name="name" required>
                </div>
                <div class="col-sm-6">
                  <label class="form-label" for="phone">{{ __('locale.Contact Number') }}*</label>
                  <input type="text" class="form-control phone-mask" id="phone" name="phone"
                    value="{{ $store['user']->phone ?? '' }}" placeholder="9876543210" required>
                </div>
                <input type="hidden" id="dial_code" name="dial_code" value="{{ $store['user']->dial_code ?? '' }}">
                <input type="hidden" name="dial_code_iso" id="country_iso"
                  value="{{ $store['user']->dial_code_iso ?? '' }}">
                <div class="col-sm-6">
                  <label class="form-label" for="email">{{ __('locale.Email') }}*</label>
                  <input type="email" class="form-control" id="email" name="email"
                    value="{{ $store['user']->email ?? '' }}"placeholder="john@example.com" required>
                </div>
                <div class="col-sm-6">
                  <label class="form-label" for="store_image">{{ __('locale.Store Image') }}*</label>
                  <input type="file" class="form-control" id="store_image" name="store_image" accept="image/*"
                    @if (empty($store['user']) && empty($store['user']->profile_photo_path)) required @endif>
                  <img id="preview_image" class="img-thumbnail mt-2"
                    style="max-height:60px; {{ isset($store['user']) && $store['user']->profile_photo_path ? '' : 'display: none;' }}"
                    src="{{ isset($store['user']) && $store['user']->profile_photo_path ? asset('storage/' . $store['user']->profile_photo_path) : asset('assets/img/placeholder.jpg') }}"
                    onerror="this.src='{{ url('assets/img/placeholder.jpg') }}'">
                </div>
                @if (empty($store->id))
                  <div class="col-sm-6">
                    <label class="form-label" for="password">{{ __('locale.Password') }}*</label>
                    <input type="password" class="form-control" id="password" name="password" placeholder="********"
                      required>
                  </div>
                  <div class="col-sm-6">
                    <label class="form-label" for="password_confirmation">{{ __('locale.Confirm Password') }}*</label>
                    <input type="password" class="form-control" id="password_confirmation"
                      name="password_confirmation" placeholder="********" required>
                  </div>
                @endif
                <div class="col-12 d-flex justify-content-between">
                  <button class="btn btn-label-secondary btn-prev" type="button">
                    <i class="icon-base ti tabler-arrow-left icon-xs me-sm-2"></i>
                    <span class="align-middle d-sm-inline-block d-none">{{ __('locale.Previous') }}</span>
                  </button>
                  <button class="btn btn-primary btn-next" type="button"><span
                      class="align-middle d-sm-inline-block d-none me-sm-2">{{ __('locale.Next') }}</span> <i
                      class="icon-base ti tabler-arrow-right icon-xs"></i></button>
                </div>
              </div>
            </div>

            <!-- Step 2: Address -->
            <div id="personal-info-modern" class="content">

              <div class="row g-6">
                <div class="col-sm-6">
                  <label class="form-label" for="address">{{ __('locale.Address') }}*</label>
                  <div id="autocomplete-container">
                    <input type="text" class="form-control" id="address" value="{{ $store->address ?? '' }}"
                      name="address" required>
                  </div>
                </div>
                <div class="col-sm-6">
                  <label class="form-label" for="country">{{ __('locale.Country') }}*</label>
                  <select class="form-select" id="country" name="country" required></select>
                </div>
                <div class="col-sm-6">
                  <label class="form-label" for="state">{{ __('locale.State') }}*</label>
                  <select class="form-select" id="state" name="state" required></select>
                </div>
                <div class="col-sm-6">
                  <label class="form-label" for="city">{{ __('locale.City') }}*</label>
                  <select class="form-select" id="city" name="city" required></select>
                </div>
                <div class="col-sm-6">
                  <label class="form-label" for="landmark">{{ __('locale.Landmark') }}</label>
                  <input type="text" class="form-control" id="landmark" value="{{ $store->landmark ?? '' }}"
                    name="landmark">
                </div>
                <div class="col-sm-6">
                  <label class="form-label" for="postcode">{{ __('locale.Postcode') }}*</label>
                  <input type="text" class="form-control" id="postcode" value="{{ $store->postcode ?? '' }}"
                    name="postcode" required>
                </div>
                <div class="col-sm-6">
                  <label class="form-label" for="latitude">{{ __('locale.Latitude') }}</label>
                  <input type="text" class="form-control" id="latitude" value="{{ $store->latitude ?? '' }}"
                    name="latitude">
                </div>
                <div class="col-sm-6">
                  <label class="form-label" for="longitude">{{ __('locale.Longitude') }}</label>
                  <input type="text" class="form-control" id="longitude" value="{{ $store->longitude ?? '' }}"
                    name="longitude">
                </div>

                <div class="col-12">
                  <div id="map" style="height: 300px; border-radius: 8px;"></div>
                </div>
                <div class="col-12 d-flex justify-content-between">
                  <button class="btn btn-label-primary btn-prev" type="button">
                    <i class="icon-base ti tabler-arrow-left icon-xs me-sm-2"></i>
                    <span class="align-middle d-sm-inline-block d-none">{{ __('locale.Previous') }}</span>
                  </button>
                  <button class="btn btn-primary btn-next" type="button"><span
                      class="align-middle d-sm-inline-block d-none me-sm-2">{{ __('locale.Next') }}</span> <i
                      class="icon-base ti tabler-arrow-right icon-xs"></i></button>
                </div>
              </div>
            </div>

            <!-- Step 3: Store Info -->
            <div id="address-modern" class="content">

              <div class="row g-6">
                <div class="col-sm-6">
                  <label class="form-label" for="contact_person_name">{{ __('locale.Contact Person Name') }}*</label>
                  <input type="text" class="form-control" id="contact_person_name"
                    value="{{ $store->contact_person_name ?? '' }}" name="contact_person_name" placeholder=""
                    required>
                </div>
                <div class="col-sm-6">
                  <label class="form-label"
                    for="contact_person_phone">{{ __('locale.Contact Person Number') }}*</label>
                  <input type="text" class="form-control phone-mask" id="contact_person_phone"
                    name="contact_person_phone" value="{{ $store->contact_person_phone ?? '' }}"
                    placeholder="+91 9876543210" required>
                  <input type="hidden" id="dial_code_contact" name="dial_code_contact"
                    value="{{ $store->dial_code_contact ?? '' }}">
                  <input type="hidden" id="dial_code_contact_iso" name="dial_code_contact_iso"
                    value="{{ $store->dial_code_contact_iso ?? '' }}">
                </div>
                <div class="col-sm-6">
                  <label class="form-label" for="delivery_time">{{ __('locale.Delivery Time (Min)') }}*<small
                      class="text-primary"> -
                      {{ __('locale.Time to make order ready') }}</small></label>
                  <input type="number" class="form-control" id="delivery_time"
                    value="{{ $store->delivery_time ?? '' }}" name="delivery_time" required>
                </div>
                @if (auth()->user()->user_type == 'Admin')
                  <div class="col-sm-6">
                    <label class="form-label" for="service_tax">{{ __('locale.Service Tax') }}% *</label>
                    <input type="number" class="form-control" id="service_tax"
                      value="{{ $store->service_tax ?? '' }}" name="service_tax" required>
                  </div>
                  <div class="col-sm-6">
                    <label class="form-label" for="commission_charge">{{ __('locale.Commission Charge') }}% *</label>
                    <input type="number" class="form-control" id="commission_charge"
                      value="{{ $store->commission_charge ?? '' }}" name="commission_charge" required>
                  </div>
                @endif
                <div class="col-sm-6">
                  <label class="form-label" for="website">{{ __('locale.Website') }}</label>
                  <input type="text" class="form-control" id="website" value="{{ $store->website ?? '' }}"
                    name="website" placeholder="">
                </div>
                <div class="col-sm-12">
                  <label class="form-label"
                    for="website">{{ __('locale.Bank Details') }}/{{ __('locale.Mobile Payment') }}</label>
                  <input type="text" class="form-control" id="website"
                    value="{{ $store['user']->bank_details ?? '' }}" name="bank_details" placeholder="">
                </div>
                <div class="col-sm-12">
                  <label class="form-label" for="description">{{ __('locale.Description') }}*</label>
                  <textarea type="text" class="form-control" id="description" name="description" required> {{ $store->description ?? '' }}</textarea>
                </div>
                <div class="col-12 d-flex justify-content-between">
                  <button class="btn btn-label-primary btn-prev" type="button">
                    <i class="icon-base ti tabler-arrow-left icon-xs me-sm-2"></i>
                    <span class="align-middle d-sm-inline-block d-none">{{ __('locale.Previous') }}</span>
                  </button>
                  <button class="btn btn-primary btn-next" type="button"><span
                      class="align-middle d-sm-inline-block d-none me-sm-2">{{ __('locale.Next') }}</span> <i
                      class="icon-base ti tabler-arrow-right icon-xs"></i></button>
                </div>
              </div>
            </div>

            <!-- Step 4: Categories -->
            <div id="social-links-modern" class="content">
              <div class="row g-6">
                <!-- Checkboxes -->
                <div class="row row-bordered g-0">
                  <div class="col-md p-6">
                    <small class="fw-medium">{{ __('locale.Categories') }}</small>

                    @php
                      $selectedCategoryIds = isset($store) ? $store->categories->pluck('id')->toArray() ?? [] : [];
                      $lastParentIdAtDepth = [];
                      $groupedCategories = [];
                      $childIdsByParent = [];

                      foreach ($categories as $id => $name) {
                          $depth = substr_count($name, '—');
                          $cleanName = ltrim($name, '— ');
                          $parentId = $depth > 0 ? $lastParentIdAtDepth[$depth - 1] ?? null : null;
                          $lastParentIdAtDepth[$depth] = $id;
                          if ($parentId) {
                              $childIdsByParent[$parentId][] = $id;
                          }
                          $groupedCategories[] = [
                              'id' => $id,
                              'name' => $cleanName,
                              'depth' => $depth,
                              'parent_id' => $parentId,
                          ];
                      }

                    @endphp

                    <div class="accordion mt-4" id="accordionExample">
                      @foreach ($groupedCategories as $parent)
                        @php
                          // Check if any of this parent's children are selected
$hasSelectedChild = !empty(
    array_intersect($childIdsByParent[$parent['id']] ?? [], $selectedCategoryIds)
                          );
                          $isExpanded = $hasSelectedChild || $loop->first; // also open first by default
                        @endphp
                        @if ($parent['depth'] == 0)
                          <div class="accordion-item {{ $loop->first ? '' : '' }}">
                            <h2 class="accordion-header" id="heading{{ $parent['id'] }}">
                              <button type="button" class="accordion-button {{ $loop->first ? '' : 'collapsed' }}"
                                data-bs-toggle="collapse" data-bs-target="#accordion{{ $parent['id'] }}"
                                aria-expanded="{{ $isExpanded ? 'true' : 'false' }}"
                                aria-controls="accordion{{ $parent['id'] }} ">
                                <!--{{ $loop->first ? 'true' : 'false' }} -->
                                <input type="checkbox" class="form-check-input me-2 category-checkbox"
                                  data-id="{{ $parent['id'] }}" id="categoryCheckbox{{ $parent['id'] }}"
                                  data-parent-id="" name="categories[]" value="{{ $parent['id'] }}"
                                  {{ in_array($parent['id'], $selectedCategoryIds) ? 'checked' : '' }}>
                                {{ $parent['name'] }}
                              </button>
                            </h2>

                            <div id="accordion{{ $parent['id'] }}"
                              class="accordion-collapse collapse {{ $isExpanded ? 'show' : '' }}"
                              aria-labelledby="heading{{ $parent['id'] }}" data-bs-parent="#accordionExample">
                              <div class="accordion-body row">
                                @foreach ($groupedCategories as $child)
                                  @if ($child['parent_id'] === $parent['id'])
                                    <div class="col-md-4 mb-2">
                                      <div class="form-check ms-4">
                                        <input type="checkbox" class="form-check-input category-checkbox"
                                          data-id="{{ $child['id'] }}" data-parent-id="{{ $child['parent_id'] }}"
                                          id="categoryCheckbox{{ $child['id'] }}" name="categories[]"
                                          value="{{ $child['id'] }}"
                                          {{ in_array($child['id'], $selectedCategoryIds) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="categoryCheckbox{{ $child['id'] }}">
                                          {{ $child['name'] }}
                                        </label>
                                      </div>
                                    </div>
                                  @endif
                                @endforeach
                              </div>
                            </div>
                          </div>
                        @endif
                      @endforeach
                    </div>

                  </div>
                </div>
                <hr class="m-0" />

                <div class="col-12 d-flex justify-content-between">
                  <button class="btn btn-label-primary btn-prev" type="button">
                    <i class="icon-base ti tabler-arrow-left icon-xs me-sm-2"></i>
                    <span class="align-middle d-sm-inline-block d-none">{{ __('locale.Previous') }}</span>
                  </button>
                  <button class="btn btn-success btn-submit" type="button">{{ __('locale.Submit') }}</button>
                </div>
              </div>
            </div>

          </form>


        </div>
      </div>
    </div>
    <!-- /Modern Icons Wizard -->

  </div>
@endsection
<!-- Page Scripts -->
@section('page-script')
  @vite(['resources/assets/js/form-store.js', 'resources/assets/js/map.js'])
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    $(document).ready(function() {
      initCountryDrop('#phone', '#dial_code', '#country_iso');
      initCountryDrop("#contact_person_phone", "#dial_code_contact", "#dial_code_contact_iso");
    });



    function previewImage(input, targetId) {
      const file = input.files[0];
      const preview = document.getElementById(targetId);
      if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
          preview.src = e.target.result;
          preview.style.display = 'block';
        };
        reader.readAsDataURL(file);
      }
    }

    // Attach to all previewable file inputs
    $('#store_image').on('change', function() {
      previewImage(this, 'preview_image');
    });

    document.addEventListener('DOMContentLoaded', function() {
      const checkboxes = document.querySelectorAll('.category-checkbox');

      checkboxes.forEach(checkbox => {
        checkbox.addEventListener('change', function() {
          const currentId = this.dataset.id;
          const isChecked = this.checked;

          toggleChildren(currentId, isChecked);
        });
      });

      function toggleChildren(parentId, checked) {
        document.querySelectorAll(`.category-checkbox[data-parent-id="${parentId}"]`).forEach(child => {
          child.checked = checked;
          toggleChildren(child.dataset.id, checked);
        });
      }
    });

    $(function() {
      const selectedCountryId = {{ $store->country_id ?? 'null' }};
      const selectedStateId = {{ $store->state_id ?? 'null' }};
      const selectedCityId = {{ $store->city_id ?? 'null' }};

      // Load countries first
      $.get(`${baseURL}/countries-dropdown`, function(countries) {
        $('#country').empty().append(`<option value="">Select Country</option>`);
        if (Array.isArray(countries)) {
          countries.forEach(c => {
            const selected = c.id == selectedCountryId ? 'selected' : '';
            $('#country').append(`<option value="${c.id}" ${selected}>${c.name}</option>`);
          });

          if (selectedCountryId) {
            loadStates(selectedCountryId);
          }
        }
      }).fail(function(xhr, status, error) {
        console.error("Error loading countries:", error);
        console.log(xhr.responseText);
      });

      // Load states
      function loadStates(countryId) {
        $('#state').empty().append(`<option value="">Select State</option>`);
        $('#city').empty().append(`<option value="">Select City</option>`);

        $.get(`${baseURL}/states/${countryId}`, function(states) {
          if (Array.isArray(states)) {
            states.forEach(s => {
              const selected = s.id == selectedStateId ? 'selected' : '';
              $('#state').append(`<option value="${s.id}" ${selected}>${s.name}</option>`);
            });

            if (selectedStateId) {
              loadCities(selectedStateId);
            }
          }
        });
      }

      // Load cities
      function loadCities(stateId) {
        $('#city').empty().append(`<option value="">Select City</option>`);

        $.get(`${baseURL}/cities/${stateId}`, function(cities) {
          if (Array.isArray(cities)) {
            cities.forEach(c => {
              const selected = c.id == selectedCityId ? 'selected' : '';
              $('#city').append(`<option value="${c.id}" ${selected}>${c.name}</option>`);
            });
          }
        });
      }

      // Triggered when user changes country
      $('#country').on('change', function() {
        const countryId = $(this).val();
        if (countryId) {
          loadStates(countryId);
        } else {
          $('#state').empty().append(`<option value="">Select State</option>`);
          $('#city').empty().append(`<option value="">Select City</option>`);
        }
      });

      // Triggered when user changes state
      $('#state').on('change', function() {
        const stateId = $(this).val();
        if (stateId) {
          loadCities(stateId);
        } else {
          $('#city').empty().append(`<option value="">Select City</option>`);
        }
      });


    });
  </script>

@endsection
