@extends('layouts/layoutMaster')

@section('title', __('locale.Ride Details'))

@section('vendor-style')
  @vite(['resources/assets/css/datatables.scss', 'resources/assets/vendor/libs/raty-js/raty-js.scss', 'resources/assets/vendor/scss/pages/app-invoice.scss'])
@endsection

@section('vendor-script')
  @vite(['resources/assets/js/datatables.js', 'resources/assets/vendor/libs/raty-js/raty-js.js', 'resources/assets/js/star-ratings.js'])
@endsection
<style>
  .raty img {
    display: inline-block;
    vertical-align: middle;
    block-size: 1.2rem !important;
    font-size: 1.2rem !important;
    inline-size: 1.2rem !important;
  }

  .raty {
    display: inline-flex;
    align-items: center;
    gap: 0px !important;
  }
</style>

@section('content')
  @php
    $currency = $ride->currency ?? Helper::setting('currency_symbol', 'currency');
  @endphp

  <div class="row g-4">

    {{-- Ride Header --}}
    <div class="col-12">
      <div class="card mb-4">
        <div class="card-body d-flex justify-content-between align-items-center">
          <div>
            <h4 class="fw-bold">{{ __('locale.Ride ID') }}: <span class="fw-bold text-primary">#{{ $ride->ride_id }}</span>
              <span class="badge bg-label-info ms-4">{{ $ride->type }}</span>
            </h4>
            <p class="mb-0">{{ __('locale.Departure') }}:
              {{ \Carbon\Carbon::parse($ride->departure_time)->format('d M, Y h:i A') ?? 'N/A' }} |
              {{ __('locale.Arrival') }}:
              {{ \Carbon\Carbon::parse($ride->arrived_time)->format('d M, Y h:i A') ?? 'N/A' }}</p>
            <div class="read-only-ratings raty mt-1" data-read-only="true" data-score="{{ $ride->rating ?? 0 }}"
              data-number="5"></div>
          </div>
          <div class="text-end">
            <h5 class="badge bg-success">{{ $ride->status }}</h5>
          </div>
        </div>
      </div>
    </div>

    {{-- Ride Info --}}
    <div class="col-lg-8 col-12">
      <div class="card mb-4">
        <div class="card-header">
          <h5 class="card-title text-primary">{{ __('locale.Ride Information') }}</h5>
        </div>
        <div class="card-body">
          <p class="mb-1"><strong>{{ __('locale.Pickup Location') }}:</strong> {{ $ride->pickup_location }}</p>
          <p class="mb-1"><strong>{{ __('locale.Drop Location') }}:</strong> {{ $ride->drop_location }}</p>
          <p class="mb-1"><strong>{{ __('locale.Trip Distance') }}:</strong> {{ $ride->trip_distance }} km</p>
          <p class="mb-1"><strong>{{ __('locale.Trip Time') }}:</strong> {{ $ride->trip_time }} mins</p>
          <p class="mb-1"><strong>{{ __('locale.Fare') }}:</strong>
            {{ $currency }}{{ number_format($ride->fare, 2) }}</p>
          <p class="mb-1"><strong>{{ __('locale.Payment Type') }}:</strong> {{ $ride->payment_type }}</p>
          <p class="mb-1"><strong>{{ __('locale.Payment Status') }}:</strong>
            <span class="badge {{ $ride->payment_status == 'Paid' ? 'bg-success' : 'bg-warning' }}">
              {{ $ride->payment_status }}
            </span>
          </p>

          @if ($ride->type == 'parcel')
            <hr>
            <p class="mb-1"><strong>{{ __('locale.Sender Name') }}:</strong> {{ $ride->sender_name }}</p>
            <p class="mb-1"><strong>{{ __('locale.Receiver Name') }}:</strong> {{ $ride->receiver_name }}</p>
            <p class="mb-1"><strong>{{ __('locale.Receiver Phone') }}:</strong> {{ $ride->receiver_phone }}</p>
            <p class="mb-1"><strong>{{ __('locale.Parcel Category') }}:</strong>
              {{ $ride->parcel_category?->name ?? 'N/A' }}
            </p>
            <p class="mb-1"><strong>{{ __('locale.Package Details') }}:</strong> {{ $ride->package_details ?? 'N/A' }}
            </p>
            <p class="mb-1"><strong>{{ __('locale.Order ID') }}:</strong> {{ $ride->order_id ?? '-' }}</p>
            @if ($ride->cancelled_by)
              <p class="text-danger"><strong>{{ __('locale.Cancelled By') }}:</strong> {{ $ride->cancelled_by }} |
                {{ $ride->cancelled_message ?? '' }}</p>
            @endif
          @endif
        </div>
      </div>

      {{-- Ride Locations Map --}}
      <div class="card mb-6">
        <div class="card-header">
          <h5 class="card-title text-primary"><i class="icon-base ti tabler-map-pin icon-lg"></i>
            {{ __('locale.Ride Route') }}</h5>
        </div>
        <div class="card-body">
          <div id="rideMap" style="width: 100%; height: 400px;"></div>

          <!-- Route Info -->
          <div class="mt-3">
            <p><strong>{{ __('locale.Distance') }}:</strong> <span id="rideDistance">-</span></p>
            <p><strong>{{ __('locale.Estimated Time') }}:</strong> <span id="rideDuration">-</span></p>
          </div>

          <!-- Turn-by-turn Directions -->
          <div id="rideDirections" class="mt-2 d-none"></div>
        </div>
      </div>


      {{-- Invoice / Fare breakdown --}}
      @php
        $invoice = json_decode($ride->invoice_details, true) ?? [];
        $currency = $invoice['currency'] ?? '₹'; // fallback
      @endphp
      @if ($ride->type != 'Delivery')
        <div class="card mb-6">
          <div class="card-header">
            <h5 class="card-title text-primary"><i class="icon-base ti tabler-credit-card icon-lg"></i>
              {{ __('locale.Invoice Details') }}
              <span class="badge bg-info text-uppercase px-3 py-2" style="float:right">
                <i class="icon-base ti tabler-calendar icon-md"></i>
                {{ isset($invoice['invoice_date']) ? \Carbon\Carbon::parse($invoice['invoice_date'])->format('d M, Y h:i A') : '-' }}
              </span>
            </h5>

          </div>
          <div class="card-body">

            <div class="row mb-1">
              <div class="col-6 fw-bold">{{ __('locale.Invoice No') }}:</div>
              <div class="col-6">{{ $invoice['invoice_no'] ?? '-' }}</div>
            </div>

            <div class="row mb-1">
              <div class="col-6 fw-bold">{{ __('locale.Ride Cost') }}:</div>
              <div class="col-6">{{ $currency }}{{ number_format($invoice['old_fare'] ?? 0, 2) }}</div>
            </div>
            <div class="row mb-1">
              <div class="col-6 fw-bold">{{ __('locale.Taxes') }}:</div>
              <div class="col-6  text-success">{{ $currency }}{{ number_format($invoice['taxes'] ?? 0, 2) }}
              </div>
            </div>
            <div class="row mb-1">
              <div class="col-6 fw-bold">{{ __('locale.Waiting Charges') }}:</div>
              <div class="col-6  text-success">
                {{ $currency }}{{ number_format($invoice['waiting_charges'] ?? 0, 2) }}</div>
            </div>
            <div class="row mb-1">
              <div class="col-6 fw-bold">{{ __('locale.Subtotal') }}:</div>
              <div class="col-6 ">{{ $currency }}{{ number_format($invoice['sub_total'] ?? 0, 2) }}</div>
            </div>
            <div class="row mb-1">
              <div class="col-6 fw-bold">{{ __('locale.Discount') }}:</div>
              <div class="col-6  text-primary">
                {{ $currency }}{{ number_format($invoice['discount'] ?? 0, 2) }}</div>
            </div>
            <div class="row mt-2">
              <div class="col-6 fw-bold">{{ __('locale.Grand Total') }}:</div>
              <div class="col-6  fw-bold">{{ $currency }}{{ number_format($invoice['grand_total'] ?? 0, 2) }}
              </div>
            </div>
          </div>
        </div>
      @endif




    </div>

    {{-- Driver & User Details --}}
    <div class="col-lg-4 col-12">

      <div class="card mb-6">
        <div class="card-header">
          <h5 class="card-title m-0 text-primary"><i class="icon-base ti tabler-user icon-lg"></i>
            {{ __('locale.Driver Details') }}
          </h5>
        </div>
        <div class="card-body">
          <div class="d-flex justify-content-start align-items-center mb-6">
            <div class="avatar me-3">
              <img
                src="{{ $ride->driver?->user?->profile_photo_path ? asset('storage/' . $ride->driver?->user?->profile_photo_path) : asset('assets/img/placeholder.jpg') }}"
                alt="Avatar" class="rounded-circle"
                onerror="this.onerror=null;this.src='{{ asset('assets/img/placeholder.jpg') }}';" />
            </div>
            <div class="d-flex flex-column">
              <a href="{{ url('users/' . $ride->driver?->user?->id) }}" class="text-body text-nowrap">
                <h6 class="mb-0">{{ $ride->driver?->user?->name ?? 'N/A' }}</h6>
              </a>
              <span>{{ __('locale.Driver ID') }}: #{{ $ride->driver?->user?->id }}</span>
            </div>
          </div>

          <div class="d-flex justify-content-between">
            <h6 class="mb-1">{{ __('locale.Contact info') }}</h6>
          </div>

          <p class="mb-1">{{ __('locale.Email') }}: {{ $ride->driver?->user?->email ?? 'N/A' }}</p>
          <p class="mb-0">{{ __('locale.Phone') }}: {{ $ride->driver?->user?->phone ?? 'N/A' }}</p>
        </div>

      </div>

      <div class="card mb-6">
        <div class="card-header">
          <h5 class="card-title m-0 text-primary"><i class="icon-base ti tabler-user icon-lg"></i>
            {{ __('locale.Customer details') }}
          </h5>
        </div>
        <div class="card-body">
          <div class="d-flex justify-content-start align-items-center mb-6">
            <div class="avatar me-3">
              <img
                src="{{ $ride->user->profile_photo_path ? asset('storage/' . $ride->user->profile_photo_path) : asset('assets/img/placeholder.jpg') }}"
                alt="Avatar" class="rounded-circle"
                onerror="this.onerror=null;this.src='{{ asset('assets/img/placeholder.jpg') }}';" />
            </div>
            <div class="d-flex flex-column">
              <a href="{{ url('users/' . $ride->user->id) }}" class="text-body text-nowrap">
                <h6 class="mb-0">{{ $ride->user->name ?? 'N/A' }}</h6>
              </a>
              <span>{{ __('locale.Customer ID') }}: #{{ $ride->user->id }}</span>
            </div>
          </div>

          <div class="d-flex justify-content-between">
            <h6 class="mb-1">{{ __('locale.Contact info') }}</h6>
          </div>

          <p class="mb-1">{{ __('locale.Email') }}: {{ $ride->user->email ?? 'N/A' }}</p>
          <p class="mb-0">{{ __('locale.Phone') }}: {{ $ride->user->phone ?? 'N/A' }}</p>
        </div>

      </div>

      @if (isset($ride->platform_commission))
        <div class="card mb-6">
          <div class="card-body">
            <div class="row">
              <div class="col-12 fw-bold text-primary">{{ __('locale.Platform Commission') }}:</div>
              <div class="col-12">{{ $currency }}{{ number_format($ride->platform_commission, 2) }}
              </div>
            </div>
          </div>
        </div>
      @endif

    </div>

  </div>

@endsection

@section('page-script')
  <script>
    function initRideMap() {
      const pickup = {
        lat: parseFloat('{{ $ride->pickup_lat }}'),
        lng: parseFloat('{{ $ride->pickup_lng }}')
      };
      const drop = {
        lat: parseFloat('{{ $ride->drop_lat }}'),
        lng: parseFloat('{{ $ride->drop_lng }}')
      };

      // Initialize map
      const map = new google.maps.Map(document.getElementById("rideMap"), {
        center: pickup,
        zoom: 13
      });

      // Markers
      const pickupMarker = new google.maps.Marker({
        position: pickup,
        map: map,
        label: {
          text: "P",
          color: "white",
          fontWeight: "bold"
        },
        icon: {
          path: google.maps.SymbolPath.CIRCLE,
          scale: 10,
          fillColor: "#28a745",
          fillOpacity: 1,
          strokeWeight: 1,
          strokeColor: "#fff"
        }
      });

      const dropMarker = new google.maps.Marker({
        position: drop,
        map: map,
        label: {
          text: "D",
          color: "white",
          fontWeight: "bold"
        },
        icon: {
          path: google.maps.SymbolPath.CIRCLE,
          scale: 10,
          fillColor: "#dc3545",
          fillOpacity: 1,
          strokeWeight: 1,
          strokeColor: "#fff"
        }
      });

      // Directions service
      const directionsService = new google.maps.DirectionsService();
      const directionsRenderer = new google.maps.DirectionsRenderer({
        map: map,
        suppressMarkers: true,
        polylineOptions: {
          strokeColor: '#007bff',
          strokeWeight: 5
        }
      });

      directionsService.route({
        origin: pickup,
        destination: drop,
        travelMode: google.maps.TravelMode.DRIVING
      }, function(result, status) {
        if (status === 'OK') {
          directionsRenderer.setDirections(result);

          // Show distance & duration
          const route = result.routes[0].legs[0];
          document.getElementById('rideDistance').innerText = route.distance.text;
          document.getElementById('rideDuration').innerText = route.duration.text;

          // Show turn-by-turn directions
          const directionsDiv = document.getElementById('rideDirections');
          directionsDiv.innerHTML = '';
          route.steps.forEach((step, index) => {
            const div = document.createElement('div');
            div.classList.add('mb-1');
            div.innerHTML = `<strong>${index + 1}.</strong> ${step.instructions} (${step.distance.text})`;
            directionsDiv.appendChild(div);
          });

          // Fit bounds
          const bounds = new google.maps.LatLngBounds();
          bounds.extend(pickup);
          bounds.extend(drop);
          map.fitBounds(bounds);

        } else {
          console.error('Directions request failed due to ' + status);
        }
      });
    }

    window.addEventListener('load', initRideMap);
  </script>
  <script src="https://maps.googleapis.com/maps/api/js?key={{ config('services.google.maps_key') }}"></script>
@endsection
