@extends('layouts/layoutMaster')

@section('title', __('locale.Packages'))

@section('content')
  <div class="row">


    <!-- User Content -->
    <div class="col-xl-12 col-lg-12 order-0 order-md-1">
      @php
        use Illuminate\Support\Str;
        // Status
        $statusMeta =
            $package?->status == 1
                ? ['color' => 'success', 'text' => 'Enabled', 'icon' => 'circle-check']
                : ['color' => 'warning', 'text' => 'Disabled', 'icon' => 'xbox-x'];

      @endphp
      <div class="card mb-6">
        <div class="card">
          <div class="card-body row gy-6">
            <div class="col-12 col-md-12 col-lg-12">
              <div class="card h-100 shadow-none ">
                <div class="card-body">
                  {{-- Header --}}
                  <div class="d-flex justify-content-between align-items-start mb-3">
                    <h5 class="fw-bold mb-0 text-primary">

                      {{ $package?->name ?? '' }}
                    </h5>
                    <span class="badge bg-warning text-uppercase px-3 py-2">
                      <span>{{ __('locale.Price') }}:</span>
                      {{ \App\Helpers\Helpers::setting('currency_symbol', 'currency') }}{{ $package->price }}
                    </span>
                  </div>


                  {{-- Description --}}
                  @if ($package?->description)
                    <span class="text-muted">{{ __('locale.Description') }}:</span>
                    <h4 class="mb-3">{{ $package->description }}</h4>
                  @endif

                  {{-- Link Type & Status --}}
                  <div class="d-flex flex-wrap gap-2 mb-3">
                    <span class="badge bg-info px-3 py-2 d-flex align-items-center gap-1">
                      <i class="icon-base ti tabler-layout-board icon-md"></i> {{ __('locale.Duration') }}:
                      {{ $package['duration']?->name }}
                      {{ Str::plural($package['duration']?->weeks, $package['duration']?->name) }}
                    </span>

                    <span class="badge bg-{{ $statusMeta['color'] }} px-3 py-2 d-flex align-items-center gap-1">
                      <i class="icon-base ti tabler-{{ $statusMeta['icon'] }} icon-md"></i> {{ $statusMeta['text'] }}
                    </span>
                  </div>

                </div>
              </div>
            </div>

          </div>
        </div>

      </div>


    </div>
    <!--/ User Content -->
  </div>
  <!-- /Modal -->
@endsection
