@php
  $configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', __('locale.Packages'))

@section('vendor-style')
  @vite(['resources/assets/css/datatables.scss'])
@endsection

@section('vendor-script')
  @vite(['resources/assets/js/datatables.js'])
@endsection

@section('content')
  <div class="row g-6">
    <div class="col-12">
      <div class="card">
        <div class="card-datatable">
          <table class="datatables-users table border-top">
            <thead>
              <tr>
                <th>#</th>
                <th>{{ __('locale.Name') }}</th>
                <th>{{ __('locale.Duration') }}</th>
                <th>{{ __('locale.Price') }}</th>
                <th>{{ __('locale.Status') }}</th>
                <th></th>
                <th>{{ __('locale.Actions') }}</th>
              </tr>
            </thead>
          </table>
        </div>
      </div>
    </div>
  </div>

  <!-- Offcanvas to add new package -->
  <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasAdd" aria-labelledby="offcanvasAddLabel">
    <div class="offcanvas-header border-bottom">
      <h5 id="offcanvasAddLabel" class="offcanvas-title">{{ __('locale.Add New Package') }}</h5>
      <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body mx-0 flex-grow-0 p-6 h-100">
      <form id="upload_form" method="POST" action="{{ route('packages.store') }}">
        @csrf
        <input type="hidden" name="id" id="package_id">

        <div class="mb-3">
          <label class="form-label">{{ __('locale.Name') }}</label>
          <input type="text" class="form-control" name="name" placeholder="{{ __('locale.Name') }}" required>
        </div>

        <div class="mb-3">
          <label class="form-label">{{ __('locale.Description') }}</label>
          <textarea class="form-control" name="description" placeholder="{{ __('locale.Description') }}"></textarea>
        </div>

        <div class="mb-3">
          <label class="form-label">{{ __('locale.Duration') }}</label>
          <select name="duration_id" class="form-select">
            @foreach (\App\Models\Duration::where('status', 1)->get() as $key => $value)
              <option value="{{ $value->id }}">{{ $value->name }}
                {{ \Illuminate\Support\Str::plural($value->weeks, $value->name) }}</option>
            @endforeach
          </select>
        </div>

        <div class="mb-3">
          <label class="form-label">{{ __('locale.Price') }}</label>
          <input type="number" step="0.01" class="form-control" name="price">
        </div>

        <div class="mb-3">
          <label class="form-label">{{ __('locale.Status') }}</label>
          <select name="status" class="form-select">
            <option value="1">{{ __('locale.Active') }}</option>
            <option value="0">{{ __('locale.Inactive') }}</option>
          </select>
        </div>

        <div class="mb-3 d-none">
          <label class="form-label">{{ __('locale.Type') }}</label>
          <select name="type" class="form-select">
            <option value="Paid">{{ __('locale.Paid') }}</option>
            <option value="Free">{{ __('locale.Free') }}</option>

          </select>
        </div>
        <input type="hidden" name="type" value="Paid" />
        <div class="mb-3 d-none">
          <label class="form-label">{{ __('locale.iOS Subscription ID') }}</label>
          <input type="text" class="form-control" name="ios_subscription_id">
        </div>

        <div class="mb-3 d-none">
          <label class="form-label">{{ __('locale.Android Subscription ID') }}</label>
          <input type="text" class="form-control" name="android_subscription_id">
        </div>

        <button type="submit" class="btn btn-primary me-3">{{ __('locale.Submit') }}</button>
        <button type="reset" class="btn btn-label-danger"
          data-bs-dismiss="offcanvas">{{ __('locale.Cancel') }}</button>
      </form>
    </div>
  </div>

  <!-- Modal to edit package -->
  <div class="modal fade" id="inlineForm" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <form id="edit_form" method="POST">
          @csrf
          @method('PUT')
          <div class="modal-header">
            <h4 class="modal-title">{{ __('locale.Edit Package') }}</h4>
            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
          </div>
          <div class="modal-body">
            <input type="hidden" name="id" id="id_edit">

            <div class="mb-3">
              <label class="form-label">{{ __('locale.Name') }}</label>
              <input type="text" name="name" id="name_edit" class="form-control" required>
            </div>

            <div class="mb-3">
              <label class="form-label">{{ __('locale.Description') }}</label>
              <textarea name="description" id="description_edit" class="form-control"></textarea>
            </div>

            <div class="mb-3">
              <label class="form-label">{{ __('locale.Duration') }}</label>
              <select name="duration_id" id="duration_edit" class="form-select">
                @foreach (\App\Models\Duration::where('status', 1)->get() as $key => $value)
                  <option value="{{ $value->id }}">{{ $value->name }}
                    {{ \Illuminate\Support\Str::plural($value->weeks, $value->name) }}</option>
                @endforeach
              </select>
            </div>

            <div class="mb-3">
              <label class="form-label">{{ __('locale.Price') }}</label>
              <input type="number" step="0.01" name="price" id="price_edit" class="form-control">
            </div>

            <div class="mb-3">
              <label class="form-label">{{ __('locale.Status') }}</label>
              <select name="status" id="status_edit" class="form-select">
                <option value="1">{{ __('locale.Active') }}</option>
                <option value="0">{{ __('locale.Inactive') }}</option>
              </select>
            </div>

            <div class="mb-3 d-none">
              <label class="form-label">{{ __('locale.Type') }}</label>
              <select name="type" id="type_edit" class="form-select">
                <option value="Paid">{{ __('locale.Paid') }}</option>
                <option value="Free">{{ __('locale.Free') }}</option>

              </select>
            </div>

            <div class="mb-3 d-none">
              <label class="form-label">{{ __('locale.iOS Subscription ID') }}</label>
              <input type="text" name="ios_subscription_id" id="ios_subscription_id_edit" class="form-control">
            </div>

            <div class="mb-3 d-none">
              <label class="form-label">{{ __('locale.Android Subscription ID') }}</label>
              <input type="text" name="android_subscription_id" id="android_subscription_id_edit"
                class="form-control">
            </div>
          </div>

          <div class="modal-footer">
            <button type="submit" class="btn btn-primary">{{ __('locale.Update') }}</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <div id="role-helper" data-add="{{ __('locale.Add New Package') }}"></div>
@endsection

@section('page-script')
  @vite(['resources/assets/js/package.js'])
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    window.permissions = {
      canListPackage: @json(auth()->user()->can('package-list')),
      canDeletePackage: @json(auth()->user()->can('package-delete')),
      canEditPackage: @json(auth()->user()->can('package-edit')),
      canCreatePackage: @json(auth()->user()->can('package-create'))
    };
    // Preview for Add Package

    $(function() {
      const table = $('.datatables-users').DataTable();
      let $btn = null;

      // Add form submit
      $('#upload_form').on('submit', function(event) {
        event.preventDefault();
        $btn = $(this).find('button[type="submit"]');

        $.ajax({
          type: "POST",
          url: `${baseURL}/packages`,
          headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          data: new FormData(this),
          dataType: 'JSON',
          contentType: false,
          cache: false,
          processData: false,
          beforeSend: function() {
            toggleButtonLoading($btn, true, 'Saving...');
          },
          success: function(data) {
            if (data.status === 200 && data.data) {
              const pkg = data.data;
              const newRow = table.row.add(pkg).draw(false);
              $(newRow.node()).attr('id', `trRow-${pkg.id}`);
              table.order([0, 'desc']).draw(false);

              $('#upload_form')[0].reset();
              bootstrap.Offcanvas.getInstance(document.getElementById('offcanvasAdd')).hide();
            }
            toggleButtonLoading($btn, false);
            showToastMsg(data);
          },
          error: function(xhr) {
            toggleButtonLoading($btn, false);
            console.log(xhr.responseJSON);
          }
        });
      });

      // Open edit modal
      $(document).on('click', '.edit-package-modal', function() {
        $('#id_edit').val($(this).data('id'));
        $('#name_edit').val($(this).data('name'));
        $('#description_edit').val($(this).data('description'));
        $('#duration_edit').val($(this).data('duration_id'));
        $('#price_edit').val($(this).data('price'));
        $('#status_edit').val($(this).data('status'));
        $('#type_edit').val($(this).data('type'));
        $('#ios_subscription_id_edit').val($(this).data('ios_subscription_id'));
        $('#android_subscription_id_edit').val($(this).data('android_subscription_id'));
        $('#inlineForm').modal('show');
      });

      // Edit form submit
      $('#edit_form').on('submit', function(event) {
        event.preventDefault();
        $btn = $(this).find('button[type="submit"]');

        const id = $('#id_edit').val();
        $.ajax({
          type: 'POST',
          url: `${baseURL}/packages/${id}`,
          headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          data: new FormData(this),
          dataType: 'JSON',
          contentType: false,
          cache: false,
          processData: false,
          beforeSend: function() {
            toggleButtonLoading($btn, true, 'Updating...');
          },
          success: function(data) {
            if (data.status === 200 && data.data) {
              const pkg = data.data;
              const row = table.row(`#trRow-${pkg.id}`);
              if (row.node()) row.data(pkg).draw(false);
              $('#inlineForm').modal('hide');
            }
            toggleButtonLoading($btn, false);
            showToastMsg(data);
          },
          error: function(xhr) {
            toggleButtonLoading($btn, false);
            console.log(xhr.responseJSON);
          }
        });
      });

      function showToastMsg(data) {
        const toastType = data.status == 200 ? 'bg-success' : 'bg-warning';
        window.showToast({
          title: 'Packages 🗂️',
          message: data.message,
          type: toastType,
          animation: 'animate__fadeInUp',
          time: 'Just now',
          delay: 3000
        });
      }
    });
  </script>
@endsection
