@extends('layouts/layoutMaster')

@section('title', __('locale.Drivers On Map'))

<!-- Vendor Styles -->
@section('vendor-style')
  @vite(['resources/assets/vendor/libs/leaflet/leaflet.scss'])
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
  @vite(['resources/assets/vendor/libs/leaflet/leaflet.js'])
@endsection

@section('content')
  <div class="row gy-6">
    <div class="row p-0">
      <div class="col-md-6">
        <label for="filter_type" class="form-label">{{ __('locale.Type') }}</label>
        <select id="filter_type" class="form-select">
          <option value="" {{ request('type') == '' ? 'selected' : '' }}>{{ __('locale.All') }}</option>
          <option value="Ride" {{ request('type') == 'Ride' ? 'selected' : '' }}>{{ __('locale.Ride') }}</option>
          <option value="Delivery" {{ request('type') == 'Delivery' ? 'selected' : '' }}>{{ __('locale.Delivery') }}
          </option>
        </select>
      </div>
      <div class="col-md-6">
        <label for="filter_status" class="form-label">{{ __('locale.Status') }}</label>
        <select id="filter_status" class="form-select">
          <option value="" {{ request('status') === null ? 'selected' : '' }}>{{ __('locale.All') }}</option>
          <option value="1" {{ request('status') === '1' ? 'selected' : '' }}>{{ __('locale.Active') }}</option>
          <option value="0" {{ request('status') === '0' ? 'selected' : '' }}>{{ __('locale.Inactive') }}</option>
        </select>
      </div>

    </div>
    <!-- Drivers Control -->
    <div class="col-12">
      <div class="card">
        <h5 class="card-header">{{ __('locale.Drivers') }}</h5>
        <div class="card-body">
          <div id="driverMap" style="width: 100%; height: 80vh;"></div>
          <div class="leaflet-map d-none" id="layerControl"></div>
        </div>
      </div>
    </div>
    <!-- /Drivers Control -->
  </div>
@endsection
<!-- Page Scripts -->
@section('page-script')
  @vite([])
  <script src="https://maps.googleapis.com/maps/api/js?key={{ config('services.google.maps_key') }}"></script>
  <script>
    const driversData = @json($drivers); // from Laravel controller
    document.addEventListener('DOMContentLoaded', function() {
      const map = L.map('layerControl').setView([20.5937, 78.9629], 5); // Default India center

      // Base tile layer
      const osm = L.tileLayer('https://tile.openstreetmap.org/{z}/{x}/{y}.png', {
        maxZoom: 18,
        attribution: '© OpenStreetMap'
      }).addTo(map);
      const driversData = @json($drivers); // Laravel-passed driver data
      // Custom driver icon
      const carActiveIcon = L.icon({
        iconUrl: `${baseUrl}assets/img/carActive.png`, // active car icon
        iconSize: [32, 32],
        iconAnchor: [16, 32],
        popupAnchor: [0, -32]
      });

      const carInactiveIcon = L.icon({
        iconUrl: `${baseUrl}assets/img/car.png`, // inactive car icon
        iconSize: [32, 32],
        iconAnchor: [16, 32],
        popupAnchor: [0, -32]
      });
      const bikeActiveIcon = L.icon({
        iconUrl: `${baseUrl}assets/img/bikeActive.png`, // active car icon
        iconSize: [32, 32],
        iconAnchor: [16, 32],
        popupAnchor: [0, -32]
      });

      const bikeInactiveIcon = L.icon({
        iconUrl: `${baseUrl}assets/img/bike.png`, // inactive car icon
        iconSize: [32, 32],
        iconAnchor: [16, 32],
        popupAnchor: [0, -32]
      });



      if (Array.isArray(driversData) && driversData.length > 0) {
        const driverMarkers = [];

        driversData.forEach(driver => {
          if (driver.latitude && driver.longitude) {
            var driverIcon = carInactiveIcon;
            if (driver.type == 'Delivery') {
              var driverIcon = driver.is_active == 1 ? bikeActiveIcon : bikeInactiveIcon;
            } else {
              var driverIcon = driver.is_active == 1 ? carActiveIcon : carInactiveIcon;
            }
            const marker = L.marker([driver.latitude, driver.longitude], {
                icon: driverIcon
              })
              .bindPopup(`
              <strong>${driver.name}</strong><br>
               <small>${driver.phone ?? ''}</small><br>
              <small>${driver.email ?? ''}</small>
            `);
            driverMarkers.push(marker);
          }
        });

        const driversLayer = L.layerGroup(driverMarkers).addTo(map);

        // Adjust map to fit all markers
        const group = new L.featureGroup(driverMarkers);
        map.fitBounds(group.getBounds().pad(0.2));
      } else {
        // If no drivers, use current location
        map.locate({
          setView: true,
          maxZoom: 16
        });

        map.on('locationfound', function(e) {
          L.marker(e.latlng).addTo(map)
            .bindPopup('You are here').openPopup();
        });

        map.on('locationerror', function() {
          alert('Unable to access your location. Showing default center.');
        });
      }
    });

    document.addEventListener('DOMContentLoaded', function() {
      const driversData = @json($drivers); // Laravel-passed driver data

      // Map center default India
      const defaultCenter = {
        lat: 20.5937,
        lng: 78.9629
      };
      const map = new google.maps.Map(document.getElementById("driverMap"), {
        center: defaultCenter,
        zoom: 5
      });

      // Define icons
      const icons = {
        carActive: {
          url: '{{ asset('assets/img/carActive.png') }}',
          scaledSize: new google.maps.Size(32, 32)
        },
        carInactive: {
          url: '{{ asset('assets/img/car.png') }}',
          scaledSize: new google.maps.Size(32, 32)
        },
        bikeActive: {
          url: '{{ asset('assets/img/bikeActive.png') }}',
          scaledSize: new google.maps.Size(32, 32)
        },
        bikeInactive: {
          url: '{{ asset('assets/img/bike.png') }}',
          scaledSize: new google.maps.Size(32, 32)
        },
      };

      const markers = [];

      if (Array.isArray(driversData) && driversData.length > 0) {
        driversData.forEach(driver => {
          if (driver.latitude && driver.longitude) {
            let icon;
            if (driver.type === 'Delivery') {
              icon = driver.is_active == 1 ? icons.bikeActive : icons.bikeInactive;
            } else {
              icon = driver.is_active == 1 ? icons.carActive : icons.carInactive;
            }

            const marker = new google.maps.Marker({
              position: {
                lat: parseFloat(driver.latitude),
                lng: parseFloat(driver.longitude)
              },
              map: map,
              icon: icon,
              title: driver.name
            });

            const infoWindow = new google.maps.InfoWindow({
              content: `<strong>${driver.name}</strong><br>
                              <small>${driver.phone ?? ''}</small><br>
                              <small>${driver.email ?? ''}</small>`
            });

            marker.addListener('click', function() {
              infoWindow.open(map, marker);
            });

            markers.push(marker);
          }
        });

        // Fit map to all markers
        const bounds = new google.maps.LatLngBounds();
        markers.forEach(marker => bounds.extend(marker.getPosition()));
        map.fitBounds(bounds);

      } else {
        // If no drivers, try geolocation
        if (navigator.geolocation) {
          navigator.geolocation.getCurrentPosition(
            position => {
              const userPos = {
                lat: position.coords.latitude,
                lng: position.coords.longitude
              };
              map.setCenter(userPos);
              map.setZoom(16);

              new google.maps.Marker({
                position: userPos,
                map: map,
                title: 'You are here'
              });
            },
            () => alert('Unable to access your location. Showing default center.')
          );
        }
      }
    });

    document.addEventListener('DOMContentLoaded', function() {
      const filterType = document.getElementById('filter_type');
      const filterStatus = document.getElementById('filter_status');

      function updateURL() {
        const params = new URLSearchParams(window.location.search);

        // Set or remove filter_type param
        if (filterType.value) {
          params.set('type', filterType.value);
        } else {
          params.delete('type');
        }

        // Set or remove filter_status param
        if (filterStatus.value) {
          params.set('status', filterStatus.value);
        } else {
          params.delete('status');
        }

        // Update URL without reloading
        const newUrl = window.location.pathname + '?' + params.toString();
        window.history.replaceState({}, '', newUrl);

        // Optionally, reload page to fetch filtered data
        window.location.href = newUrl;
      }

      filterType.addEventListener('change', updateURL);
      filterStatus.addEventListener('change', updateURL);
    });
  </script>
@endsection
