@extends('layouts/layoutMaster')

@section('title', __('locale.Add Driver'))

<!-- Vendor Styles -->
@section('vendor-style')
  @vite(['resources/assets/vendor/libs/bs-stepper/bs-stepper.scss', 'resources/assets/vendor/libs/select2/select2.scss', 'resources/assets/vendor/libs/animate-css/animate.scss', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.scss', 'resources/assets/vendor/libs/@form-validation/form-validation.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss'])
  <style>
    .collapse {
      visibility: visible !important
    }

    /* Custom Google Maps InfoWindow Close Button */
    .gm-style-iw-d {
      padding: 8px !important;
      /* Ensure proper padding inside InfoWindow */
    }

    /* InfoWindow close button top-right */
    .gm-style-iw .gm-ui-hover-effect {
      position: absolute !important;
      top: 4px !important;
      right: 4px !important;
      width: 24px !important;
      height: 24px !important;
      opacity: 1 !important;
      background-color: #fff !important;
      border-radius: 50% !important;
      box-shadow: 0 1px 4px rgba(0, 0, 0, 0.3);
      cursor: pointer;
      z-index: 1000;
    }

    .gm-style-iw .gm-ui-hover-effect::after {
      content: '×';
      position: absolute;
      top: 50%;
      left: 50%;
      transform: translate(-50%, -50%);
      font-size: 16px;
      font-weight: bold;
      color: #000;
      pointer-events: none;
      /* allow click through */
    }
  </style>
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
  @vite(['resources/assets/vendor/libs/bs-stepper/bs-stepper.js', 'resources/assets/vendor/libs/select2/select2.js', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.js', 'resources/assets/vendor/libs/@form-validation/bootstrap5.js', 'resources/assets/vendor/libs/@form-validation/popular.js', 'resources/assets/vendor/libs/@form-validation/auto-focus.js', 'resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js'])
@endsection


@section('content')
  <meta name="google-maps-key" content="{{ config('services.google.maps_key') }}">
  <meta name="google-maps-id" content="{{ config('services.google.maps_id') }}">
  @php  $img=isset($driver['user']) && $driver['user']->profile_photo_path ? asset('storage/' . $driver['user']->profile_photo_path) : asset('/assets/img/car.png'); @endphp
  <input type="hidden" id="customPinUrl" value="{{ $img }}">
  <!-- Modern Icons Wizard -->
  <div class="col-12 mb-6">
    <div class="bs-stepper wizard-icons wizard-modern wizard-modern-icons-example mt-2">
      <div class="bs-stepper-header pt-0">
        <div class="step" data-target="#account-details-modern" data-step-index="0">
          <button type="button" class="step-trigger">
            <span class="bs-stepper-icon">
              <svg viewBox="0 0 54 54">
                <use xlink:href="{{ asset('assets/svg/icons/form-wizard-account.svg#wizardAccount') }}">
                </use>
              </svg>
            </span>
            <span class="bs-stepper-label">{{ __('locale.Account Details') }}</span>
          </button>
        </div>
        <div class="line">
          <i class="icon-base ti tabler-chevron-right"></i>
        </div>
        <div class="step" data-target="#personal-info-modern" data-step-index="1">
          <button type="button" class="step-trigger">
            <span class="bs-stepper-icon">
              <svg viewBox="0 0 54 54">
                <use xlink:href="{{ asset('assets/svg/icons/form-wizard-address.svg#wizardAddress') }}">
                </use>
              </svg>
            </span>
            <span class="bs-stepper-label">{{ __('locale.Address') }}</span>
          </button>
        </div>
        <div class="line">
          <i class="icon-base ti tabler-chevron-right"></i>
        </div>
        <div class="step" data-target="#address-modern" data-step-index="2">
          <button type="button" class="step-trigger">
            <span class="bs-stepper-icon">
              <svg viewBox="0 0 58 54">
                <use xlink:href="{{ asset('assets/svg/icons/form-wizard-personal.svg#wizardPersonal') }}">
                </use>
              </svg>
            </span>
            <span class="bs-stepper-label">{{ __('locale.Vehicle Details') }}</span>
          </button>
        </div>
        <div class="line">
          <i class="icon-base ti tabler-chevron-right"></i>
        </div>
        <div class="step" data-target="#social-links-modern" data-step-index="3">
          <button type="button" class="step-trigger">
            <span class="bs-stepper-icon">
              <svg viewBox="0 0 54 54">
                <use xlink:href="{{ asset('assets/svg/icons/form-wizard-social-link.svg#wizardSocialLink') }}">
                </use>
              </svg>
            </span>
            <span class="bs-stepper-label">{{ __('locale.Documents') }}</span>
          </button>
        </div>

      </div>
      <div class="bs-stepper-content">
        <form id="driverForm" enctype="multipart/form-data">
          @csrf
          <input type="hidden" name="id" id="driver_id" value="{{ $driver->id ?? '' }}">
          <input type="hidden" name="user_id" id="user_id" value="{{ $driver['user']->id ?? '' }}">
          <!-- Step 1: Account Details -->
          <div id="account-details-modern" class="content">

            <div class="row g-6">
              <div class="col-sm-6">
                <label class="form-label" for="full_name">{{ __('locale.Full Name') }}*</label>
                <input type="text" class="form-control" id="full_name"
                  value="{{ $driver['user']->name ?? '' }}"name="name" placeholder="John Doe" required>
              </div>
              <div class="col-sm-6">
                <label class="form-label" for="phone">{{ __('locale.Contact Number') }}*</label>
                <input type="text" class="form-control phone-mask" id="phone" name="phone"
                  value="{{ $driver['user']->phone ?? '' }}" placeholder="998 877 6655" required>
              </div>
              <input type="hidden" id="dial_code" name="dial_code" value="{{ $driver['user']->dial_code ?? '' }}">
              <input type="hidden" name="dial_code_iso" id="country_iso"
                value="{{ $driver['user']->dial_code_iso ?? '' }}">
              <div class="col-sm-6">
                <label class="form-label" for="email">{{ __('locale.Email') }}*</label>
                <input type="email" class="form-control" id="email" name="email"
                  value="{{ $driver['user']->email ?? '' }}"placeholder="john@example.com" required>
              </div>
              <div class="col-sm-6">
                <label class="form-label" for="dob">{{ __('locale.DOB') }}*</label>
                <input type="text" class="form-control flatpickr-validation" id="dob"
                  value="{{ $driver->dob ?? '' }}" name="dob" required>
              </div>
              <div class="col-sm-6">
                <label class="form-label" for="gender">{{ __('locale.Gender') }}*</label>
                <select class="form-select" id="gender" name="gender" required>
                  <option value="Male" {{ ($driver->gender ?? '') == 'Male' ? 'selected' : '' }}>Male</option>
                  <option value="Female" {{ ($driver->gender ?? '') == 'Female' ? 'selected' : '' }}>Female</option>
                  <option value="Other" {{ ($driver->gender ?? '') == 'Other' ? 'selected' : '' }}>Other</option>
                  <option value="N/A" {{ ($driver->gender ?? '') == 'N/A' ? 'selected' : '' }}>N/A</option>
                </select>
              </div>
              <div class="col-sm-6">
                <label class="form-label" for="type">{{ __('locale.Type') }}*</label>
                <select class="form-select" id="type" name="type" required>
                  <option value="Ride" {{ ($driver->type ?? '') == 'Ride' ? 'selected' : '' }}>Ride</option>
                  <option value="Delivery" {{ ($driver->type ?? '') == 'Delivery' ? 'selected' : '' }}>Delivery
                  </option>
                </select>
              </div>
              @if (empty($driver->id))
                <div class="col-sm-6">
                  <label class="form-label" for="password">{{ __('locale.Password') }}*</label>
                  <input type="password" class="form-control" id="password" name="password" placeholder="********"
                    required>
                </div>
                <div class="col-sm-6">
                  <label class="form-label" for="password_confirmation">{{ __('locale.Confirm Password') }}*</label>
                  <input type="password" class="form-control" id="password_confirmation" name="password_confirmation"
                    placeholder="********" required>
                </div>
              @endif
              <div class="col-12 d-flex justify-content-between">
                <button class="btn btn-label-secondary btn-prev" type="button">
                  <i class="icon-base ti tabler-arrow-left icon-xs me-sm-2"></i>
                  <span class="align-middle d-sm-inline-block d-none">{{ __('locale.Previous') }}</span>
                </button>
                <button class="btn btn-primary btn-next" type="button"><span
                    class="align-middle d-sm-inline-block d-none me-sm-2">{{ __('locale.Next') }}</span> <i
                    class="icon-base ti tabler-arrow-right icon-xs"></i></button>
              </div>
            </div>
          </div>

          <!-- Step 2: Address -->
          <div id="personal-info-modern" class="content">

            <div class="row g-6">
              <div class="col-sm-6">
                <label class="form-label" for="address">{{ __('locale.Address') }}*</label>
                <div id="autocomplete-container">
                  <input type="text" class="form-control" id="address" value="{{ $driver->address ?? '' }}"
                    name="address" required>
                </div>
              </div>
              <div class="col-sm-6">
                <label class="form-label" for="country">{{ __('locale.Country') }}*</label>
                <select class="form-select" id="country" name="country" required></select>
              </div>
              <div class="col-sm-6">
                <label class="form-label" for="state">{{ __('locale.State') }}*</label>
                <select class="form-select" id="state" name="state" required></select>
              </div>
              <div class="col-sm-6">
                <label class="form-label" for="city">{{ __('locale.City') }}*</label>
                <select class="form-select" id="city" name="city" required></select>
              </div>
              <div class="col-sm-6">
                <label class="form-label" for="landmark">{{ __('locale.Landmark') }}</label>
                <input type="text" class="form-control" id="landmark" value="{{ $driver->landmark ?? '' }}"
                  name="landmark">
              </div>
              <div class="col-sm-6">
                <label class="form-label" for="postcode">{{ __('locale.Postcode') }}*</label>
                <input type="text" class="form-control" id="postcode" value="{{ $driver->postcode ?? '' }}"
                  name="postcode" required>
              </div>
              <div class="col-sm-6">
                <label class="form-label" for="latitude">{{ __('locale.Latitude') }}</label>
                <input type="text" class="form-control" id="latitude" value="{{ $store->latitude ?? '' }}"
                  name="latitude">
              </div>
              <div class="col-sm-6">
                <label class="form-label" for="longitude">{{ __('locale.Longitude') }}</label>
                <input type="text" class="form-control" id="longitude" value="{{ $store->longitude ?? '' }}"
                  name="longitude">
              </div>
              <div class="col-sm-12">
                <label class="form-label"
                  for="website">{{ __('locale.Bank Details') }}/{{ __('locale.Mobile Payment') }}</label>
                <input type="text" class="form-control" id="website"
                  value="{{ $driver['user']->bank_details ?? '' }}" name="bank_details" placeholder="">
              </div>
              <div class="col-12">
                <div id="map" style="height: 300px; border-radius: 8px;"></div>
              </div>
              <div class="col-12 d-flex justify-content-between">
                <button class="btn btn-label-primary btn-prev" type="button">
                  <i class="icon-base ti tabler-arrow-left icon-xs me-sm-2"></i>
                  <span class="align-middle d-sm-inline-block d-none">{{ __('locale.Previous') }}</span>
                </button>
                <button class="btn btn-primary btn-next" type="button"><span
                    class="align-middle d-sm-inline-block d-none me-sm-2">{{ __('locale.Next') }}</span> <i
                    class="icon-base ti tabler-arrow-right icon-xs"></i></button>
              </div>
            </div>
          </div>

          <!-- Step 3: Vehicle Details -->
          <div id="address-modern" class="content">

            <div class="row g-6">
              <div class="col-sm-6">
                <label class="form-label" for="vehicle_parent_category_id">{{ __('locale.Vehicle Category') }}*</label>
                <select class="form-select" id="vehicle_parent_category_id" name="vehicle_parent_category_id"
                  required></select>
              </div>
              <div class="col-sm-6">
                <label class="form-label" for="vehicle_type_id">{{ __('locale.Vehicle Type') }}*</label>
                <select class="form-select" id="vehicle_category_id" name="vehicle_category_id" required></select>
              </div>
              <div class="col-sm-6">
                <label class="form-label" for="vehicle_brand_id">{{ __('locale.Vehicle Brand') }}*</label>
                <select class="form-select" id="vehicle_brand_id" name="vehicle_brand_id" required></select>
              </div>
              <div class="col-sm-6">
                <label class="form-label" for="vehicle_model_id">{{ __('locale.Vehicle Model') }}*</label>
                <select class="form-select" id="vehicle_model_id" name="vehicle_model_id" required></select>
              </div>
              <div class="col-sm-6">
                <label class="form-label" for="vehicle_color">{{ __('locale.Vehicle Color') }}*</label>
                <select class="form-select"id="vehicle_color" name="vehicle_color" required></select>
              </div>
              <div class="col-sm-6">
                <label class="form-label" for="vehicle_year">{{ __('locale.Vehicle Manufacturing Year') }}*</label>
                <input type="text" class="form-control" id="vehicle_year"
                  value="{{ $driver['vehicle']->vehicle_year ?? '' }} "name="vehicle_year" required>
              </div>
              <div class="col-sm-6">
                <label class="form-label" for="license_plate">{{ __('locale.License Plate Number') }}*</label>
                <input type="text" class="form-control" id="license_plate"
                  value="{{ $driver['vehicle']->license_plate ?? '' }}" name="license_plate" required>
              </div>
              <div class="col-sm-6">
                <label class="form-label" for="vehicle_image">{{ __('locale.Vehicle Image') }}*</label>
                <input type="file" class="form-control" id="vehicle_image" name="vehicle_image" accept="image/*"
                  @if (empty($driver['vehicle']) && empty($driver['vehicle']->vehicle_image)) required @endif>
                <img id="preview_image" class="img-thumbnail mt-2"
                  style="max-height:60px; {{ isset($driver) && $driver['vehicle']->vehicle_image ? '' : 'display: none;' }}"
                  src="{{ isset($driver['vehicle']) && $driver['vehicle']->vehicle_image ? asset('storage/' . $driver['vehicle']->vehicle_image) : asset('assets/img/placeholder.jpg') }}"
                  onerror="this.src='{{ url('assets/img/placeholder.jpg') }}'">

              </div>
              <div class="col-12 d-flex justify-content-between">
                <button class="btn btn-label-primary btn-prev" type="button">
                  <i class="icon-base ti tabler-arrow-left icon-xs me-sm-2"></i>
                  <span class="align-middle d-sm-inline-block d-none">{{ __('locale.Previous') }}</span>
                </button>
                <button class="btn btn-primary btn-next" type="button"><span
                    class="align-middle d-sm-inline-block d-none me-sm-2">{{ __('locale.Next') }}</span> <i
                    class="icon-base ti tabler-arrow-right icon-xs"></i></button>
              </div>
            </div>
          </div>

          <!-- Step 4: Documents -->
          <div id="social-links-modern" class="content">

            <div class="row g-6">
              <div class="col-sm-6">
                <label class="form-label" for="license_number">{{ __('locale.Driver License Number') }}*</label>
                <input type="text" class="form-control" id="license_number"
                  value="{{ $driver->license_number ?? '' }}" name="license_number" required>
              </div>
              <div class="col-sm-6">
                <label class="form-label" for="license_expiry">{{ __('locale.Driver License Expiry Date') }}*</label>
                <input type="text" class="form-control flatpickr-validation" id="license_expiry"
                  value="{{ $driver->license_expiry ?? '' }}" name="license_expiry" required>
              </div>
              <div class="col-sm-6">
                <label class="form-label"
                  for="registration_number">{{ __('locale.Vehicle Registration Number') }}*</label>
                <input type="text" class="form-control" id="registration_number"
                  value="{{ $driver['vehicle']->registration_number ?? '' }}" name="registration_number" required>
              </div>
              <div class="col-sm-6">
                <label class="form-label" for="license_image">{{ __('locale.Driver License Image') }}*</label>
                <input type="file" class="form-control" id="license_image" name="license_image" accept="image/*"
                  @if (empty($driver->license_image)) required @endif>
                <img id="preview_image_license" class="img-thumbnail mt-2"
                  style="max-height:60px; {{ isset($driver) && $driver->license_image ? '' : 'display: none;' }}"
                  src="{{ isset($driver) && $driver->license_image ? asset('storage/' . $driver->license_image) : asset('assets/img/placeholder.jpg') }}"
                  onerror="this.src='{{ url('assets/img/placeholder.jpg') }}'">
              </div>
              <div class="col-sm-6">
                <label class="form-label" for="insurance_image">{{ __('locale.Insurance Image') }}*</label>
                <input type="file" class="form-control" id="insurance_image" name="insurance_image"
                  accept="image/*" @if (empty($driver['vehicle']) && empty($driver['vehicle']->insurance_image)) required @endif>
                <img id="preview_image_insurance" class="img-thumbnail mt-2"
                  style="max-height:60px; {{ isset($driver) && $driver['vehicle']->insurance_image ? '' : 'display: none;' }}"
                  src="{{ isset($driver) && $driver['vehicle']->insurance_image ? asset('storage/' . $driver['vehicle']->insurance_image) : asset('assets/img/placeholder.jpg') }}"
                  onerror="this.src='{{ url('assets/img/placeholder.jpg') }}'">
              </div>
              <div class="col-sm-6">
                <label class="form-label" for="road_image">{{ __('locale.Road Worthiness') }}</label>
                <input type="file" class="form-control" id="road_image" name="road_worthiness_image"
                  accept="image/*">
                <img id="preview_image_road" class="img-thumbnail mt-2"
                  style="max-height:60px; {{ isset($driver) && $driver['vehicle']->road_worthiness_image ? '' : 'display: none;' }}"
                  src="{{ isset($driver) && $driver['vehicle']->road_worthiness_image ? asset('storage/' . $driver['vehicle']->road_worthiness_image) : asset('assets/img/placeholder.jpg') }}"
                  onerror="this.src='{{ url('assets/img/placeholder.jpg') }}'">
              </div>
              <div class="col-sm-6">
                <label class="form-label" for="registration_image">{{ __('locale.Vehicle Registration') }}*</label>
                <input type="file" class="form-control" id="registration_image" name="vehicle_registration_image"
                  accept="image/*" @if (empty($driver['vehicle']) && empty($driver['vehicle']->vehicle_registration_image)) required @endif>
                <img id="preview_image_registration" class="img-thumbnail mt-2"
                  style="max-height:60px; {{ isset($driver) && $driver['vehicle']->vehicle_registration_image ? '' : 'display: none;' }}"
                  src="{{ isset($driver) && $driver['vehicle']->vehicle_registration_image ? asset('storage/' . $driver['vehicle']->vehicle_registration_image) : asset('assets/img/placeholder.jpg') }}"
                  onerror="this.src='{{ url('assets/img/placeholder.jpg') }}'">
              </div>
              <div class="col-12 d-flex justify-content-between">
                <button class="btn btn-label-primary btn-prev" type="button">
                  <i class="icon-base ti tabler-arrow-left icon-xs me-sm-2"></i>
                  <span class="align-middle d-sm-inline-block d-none">{{ __('locale.Previous') }}</span>
                </button>
                <button class="btn btn-success btn-submit" type="button">{{ __('locale.Submit') }}</button>
              </div>
            </div>
          </div>

        </form>


      </div>
    </div>
  </div>
  <!-- /Modern Icons Wizard -->

  </div>
@endsection
<!-- Page Scripts -->
@section('page-script')
  @vite(['resources/assets/js/form-driver.js', 'resources/assets/js/map.js'])
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    //'resources/assets/js/forms-pickers.js'
    $(document).ready(function() {
      initCountryDrop('#phone', '#dial_code', '#country_iso');
    });


    function previewImage(input, targetId) {
      const file = input.files[0];
      const preview = document.getElementById(targetId);
      if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
          preview.src = e.target.result;
          preview.style.display = 'block';
        };
        reader.readAsDataURL(file);
      }
    }

    // Attach to all previewable file inputs
    $('#vehicle_image').on('change', function() {
      previewImage(this, 'preview_image');
    });
    $('#license_image').on('change', function() {
      previewImage(this, 'preview_image_license');
    });
    $('#insurance_image').on('change', function() {
      previewImage(this, 'preview_image_insurance');
    });
    $('#road_image').on('change', function() {
      previewImage(this, 'preview_image_road');
    });
    $('#vr_image').on('change', function() {
      previewImage(this, 'preview_image_vr');
    });
    $(function() {
      const selectedCountryId = {{ $driver->country_id ?? 'null' }};
      const selectedStateId = {{ $driver->state_id ?? 'null' }};
      const selectedCityId = {{ $driver->city_id ?? 'null' }};

      // Load countries first
      $.get(`${baseURL}/countries-dropdown`, function(countries) {
        $('#country').empty().append(`<option value="">Select Country</option>`);
        if (Array.isArray(countries)) {
          countries.forEach(c => {
            const selected = c.id == selectedCountryId ? 'selected' : '';
            $('#country').append(`<option value="${c.id}" ${selected}>${c.name}</option>`);
          });

          if (selectedCountryId) {
            loadStates(selectedCountryId);
          }
        }
      }).fail(function(xhr, status, error) {
        console.error("Error loading countries:", error);
        console.log(xhr.responseText);
      });

      // Load states
      function loadStates(countryId) {
        $('#state').empty().append(`<option value="">Select State</option>`);
        $('#city').empty().append(`<option value="">Select City</option>`);

        $.get(`${baseURL}/states/${countryId}`, function(states) {
          if (Array.isArray(states)) {
            states.forEach(s => {
              const selected = s.id == selectedStateId ? 'selected' : '';
              $('#state').append(`<option value="${s.id}" ${selected}>${s.name}</option>`);
            });

            if (selectedStateId) {
              loadCities(selectedStateId);
            }
          }
        });
      }

      // Load cities
      function loadCities(stateId) {
        $('#city').empty().append(`<option value="">Select City</option>`);

        $.get(`${baseURL}/cities/${stateId}`, function(cities) {
          if (Array.isArray(cities)) {
            cities.forEach(c => {
              const selected = c.id == selectedCityId ? 'selected' : '';
              $('#city').append(`<option value="${c.id}" ${selected}>${c.name}</option>`);
            });
          }
        });
      }

      // Triggered when user changes country
      $('#country').on('change', function() {
        const countryId = $(this).val();
        if (countryId) {
          loadStates(countryId);
        } else {
          $('#state').empty().append(`<option value="">Select State</option>`);
          $('#city').empty().append(`<option value="">Select City</option>`);
        }
      });

      // Triggered when user changes state
      $('#state').on('change', function() {
        const stateId = $(this).val();
        if (stateId) {
          loadCities(stateId);
        } else {
          $('#city').empty().append(`<option value="">Select City</option>`);
        }
      });


      const selectedVehicleParentCategoryId = {{ $driver['vehicle']->vehicle_parent_category_id ?? 'null' }};
      const selectedVehicleCategoryId = {{ $driver['vehicle']->vehicle_category_id ?? 'null' }};
      const selectedVehicleBrandId = {{ $driver['vehicle']->vehicle_brand_id ?? 'null' }};
      const selectedVehicleModelId = {{ $driver['vehicle']->vehicle_model_id ?? 'null' }};
      const selectedVehicleColorId = {{ $driver['vehicle']->vehicle_color ?? 'null' }};

      // Load parent categories
      function loadVehicleCategories(selectedVehicleParentCategoryId = null) {
        const type = $('#type').val();
        $.get(`${baseURL}/vehicle-categories/dropdown?type=${type}`, function(categories) {
          $('#vehicle_parent_category_id').empty().append(`<option value="">Select Category</option>`);
          if (Array.isArray(categories)) {
            categories.forEach(c => {
              const selected = c.id == selectedVehicleParentCategoryId ? 'selected' : '';
              $('#vehicle_parent_category_id').append(
                `<option value="${c.id}" ${selected}>${c.name}</option>`
              );
            });

            // If editing and parent selected, load subcategories
            if (selectedVehicleParentCategoryId) {
              loadSubCategories(selectedVehicleParentCategoryId);
            }
          }
        }).fail(function(xhr, status, error) {
          console.error("Error loading categories:", error);
          console.log(xhr.responseText);
        });
      }

      // Call once on page load if needed
      loadVehicleCategories(selectedVehicleParentCategoryId);

      // Bind to type change
      $('#type').on('change', function() {
        // Reset selected parent category on type change
        let selectedVehicleParentCategoryId = null;
        loadVehicleCategories(selectedVehicleParentCategoryId);
      });


      function loadSubCategories(categoryId) {
        $('#vehicle_category_id').empty().append(`<option value="">Select Type</option>`);
        $.get(`${baseURL}/vehicle-categories/${categoryId}/subcategories`, function(types) {
          if (Array.isArray(types)) {
            types.forEach(t => {
              const selected = t.id == selectedVehicleCategoryId ? 'selected' : '';
              $('#vehicle_category_id').append(`<option value="${t.id}" ${selected}>${t.name}</option>`);
            });
          }
        });
      }

      $('#vehicle_parent_category_id').on('change', function() {
        const categoryId = $(this).val();
        $('#vehicle_category_id').empty().append(`<option value="">Select Type</option>`);
        $('#vehicle_model_id').empty().append(`<option value="">Select Model</option>`);
        if (categoryId) {
          loadSubCategories(categoryId);
          loadVehicleModels();
        }
      });
      $('#vehicle_category_id').on('change', function() {
        $('#vehicle_model_id').empty().append(`<option value="">Select Model</option>`);
        loadVehicleModels();
      });

      // Load brands
      $.get(`${baseURL}/vehicle-brands-dropdown`, function(brands) {
        $('#vehicle_brand_id').empty().append(`<option value="">Select Brand</option>`);
        if (Array.isArray(brands)) {
          brands.forEach(b => {
            const selected = b.id == selectedVehicleBrandId ? 'selected' : '';
            $('#vehicle_brand_id').append(`<option value="${b.id}" ${selected}>${b.name}</option>`);
          });
        }
      }).fail(function(xhr, status, error) {
        console.error("Error loading brands:", error);
        console.log(xhr.responseText);
      });

      // If editing, load models for selected brand and category
      if (selectedVehicleBrandId && selectedVehicleCategoryId && selectedVehicleParentCategoryId) {
        loadVehicleModels();
      }

      // On brand or type change, load models
      $('#vehicle_brand_id, #vehicle_category_id').on('change', function() {
        loadVehicleModels();
      });

      if (selectedVehicleModelId) {
        loadVehicleModels();
      }
      /*
            function loadVehicleModels() {
              const brandId = $('#vehicle_brand_id').val();
              const categoryId = $('#vehicle_category_id').val();
              const parentCategoryId = $('#vehicle_parent_category_id').val();

              $('#vehicle_model_id').empty().append(`<option value="">Select Model</option>`);

              if (!brandId || !categoryId || !parentCategoryId) return;

              $.get(`${baseURL}/vehicle-models/${parentCategoryId}/${categoryId}/${brandId}`, function(models) {
                if (Array.isArray(models)) {
                  models.forEach(m => {
                    const selected = m.id == selectedVehicleModelId ? 'selected' : '';
                    $('#vehicle_model_id').append(`<option value="${m.id}" ${selected}>${m.name}</option>`);
                  });
                }
              });
            } */
      function loadVehicleModels() {
        const brandId = $('#vehicle_brand_id').val() ?? selectedVehicleBrandId;
        const categoryId = $('#vehicle_category_id').val() ?? selectedVehicleCategoryId;
        const parentCategoryId = $('#vehicle_parent_category_id').val() ?? selectedVehicleParentCategoryId;

        if (!brandId || !categoryId || !parentCategoryId) return;

        $.ajax({
          url: `${baseURL}/vehicle-models-dropdown`, // <-- your route URL
          method: 'GET',
          data: {
            vehicle_brand_id: brandId,
            vehicle_category_id: categoryId,
            vehicle_parent_category_id: parentCategoryId
          },
          success: function(response) {
            $('#vehicle_model_id').empty().append('<option value="">Select Model</option>');
            response.data.forEach(model => {
              const selected = model.id == selectedVehicleModelId ? 'selected' : '';
              $('#vehicle_model_id').append(
                `<option value="${model.id}" ${selected}>${model.name}</option>`);
            });
          },
          error: function(xhr) {
            console.error(xhr.responseText);
          }
        });
      }

      // Load colors
      $.get(`${baseURL}/vehicle-color-dropdown`, function(colors) {
        $('#vehicle_color').empty().append(`<option value="">Select Color</option>`);
        if (Array.isArray(colors)) {
          colors.forEach(c => {
            const selected = c.id == selectedVehicleColorId ? 'selected' : '';
            $('#vehicle_color').append(
              `<option value="${c.id}" ${selected} data-color="${c.code}">${c.name}</option>`);
          });
        }
      }).fail(function(xhr, status, error) {
        console.error("Error loading colors:", error);
        console.log(xhr.responseText);
      });

    });
    // Initialize Flatpickr
    document.addEventListener('DOMContentLoaded', function() {
      flatpickr('#license_expiry', {
        dateFormat: 'Y-m-d',
        minDate: 'today',
        allowInput: false,
        altInput: true,
        altFormat: 'F j, Y',
        dateFormat: 'Y-m-d',
        monthSelectorType: 'static',
        yearSelectorType: 'select',
      });

      flatpickr('#dob', {
        dateFormat: 'Y-m-d',
        maxDate: new Date(new Date().setFullYear(new Date().getFullYear() - 18)),
        altInput: true,
        altFormat: 'F j, Y',
        dateFormat: 'Y-m-d',
        monthSelectorType: 'static',
        yearSelectorType: 'select',

      });
    });

    $(function() {
      window.initColorSelect2('#vehicle_color');
    });

    const phoneMaskList = document.querySelectorAll('.phone-mask');

    if (phoneMaskList) {
      phoneMaskList.forEach(function(phoneMask) {
        phoneMask.addEventListener('input', event => {
          let input = event.target.value.replace(/[^+\d]/g, ''); // allow + and digits only
          input = input.substring(0, 10);
          // Format phone digits as 3-3-4
          let formattedPhone = input;
          if (input.length > 6) {
            formattedPhone = input.replace(/(\d{3})(\d{3})(\d{0,4})/, '$1 $2 $3');
          } else if (input.length > 3) {
            formattedPhone = input.replace(/(\d{3})(\d{0,3})/, '$1 $2');
          }

          phoneMask.value = formattedPhone.trim();
        });
      });
    }
  </script>
@endsection
