@extends('layouts/layoutMaster')

@section('title', __('locale.Coupons'))
@section('vendor-style')
  @vite(['resources/assets/css/datatables.scss'])
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
  @vite(['resources/assets/js/datatables.js'])
@endsection
@section('content')
  <div class="row">
    <div class="col-xl-12 col-lg-12 order-0 order-md-1">
      @php
        use Carbon\Carbon;

        $statusMeta =
            $coupon?->status == 1
                ? ['color' => 'success', 'text' => 'Enabled', 'icon' => 'circle-check']
                : ['color' => 'warning', 'text' => 'Disabled', 'icon' => 'xbox-x'];

        $rangeColor = 'secondary';
        $now = Carbon::now();
        if ($coupon->start_date && $coupon->end_date) {
            $start = Carbon::parse($coupon->start_date);
            $end = Carbon::parse($coupon->end_date);
            if ($now->between($start, $end)) {
                $rangeColor = 'success';
            } elseif ($now->lt($start)) {
                $rangeColor = 'warning';
            } else {
                $rangeColor = 'danger';
            }
        }

        $details = json_decode($coupon->details, true) ?? [];
        $baseDetail = $details[0] ?? [];

        $currency = \App\Helpers\Helpers::setting('currency_symbol', 'currency');
      @endphp

      <div class="card mb-6 border-0 shadow-sm">
        <div class="card-body row gy-6">
          <div class="col-12 col-md-12 col-lg-12">
            <div class="card h-100 shadow-none">
              <div class="card-body">

                {{-- Header --}}
                <div class="d-flex justify-content-between align-items-start mb-3">
                  <h5 class="fw-bold mb-0 text-primary">
                    {{ __('locale.Coupon Code') }}: {{ strtoupper($coupon?->code) }}
                  </h5>
                  <span class="badge bg-{{ $statusMeta['color'] }} text-uppercase px-3 py-2">
                    <i class="icon-base ti tabler-{{ $statusMeta['icon'] }} icon-md"></i> {{ $statusMeta['text'] }}
                  </span>
                </div>

                {{-- Coupon Info --}}
                <div class="row">
                  <div class="col">
                    <div class="card mb-4">
                      <div class="card-body">
                        <div class="row">
                          <div class="col-md-3">
                            <span class="text-muted">{{ __('locale.Type') }}</span>
                            <h5 class="mb-0 fw-semibold text-capitalize">{{ str_replace('_', ' ', $coupon->type) }}</h5>
                          </div>
                          <div class="col-md-3">
                            <span class="text-muted">{{ __('locale.Discount') }}</span>
                            <h5 class="mb-0 fw-semibold">
                              {{ $coupon->discount }}
                              {{ $coupon->discount_type == 'percent' ? '%' : $currency }}
                              </p>
                          </div>
                          <div class="col-md-3">
                            <span class="text-muted">{{ __('locale.Date') }}</span>
                            <p class="mb-0">
                              <span class="badge bg-{{ $rangeColor }}">
                                {{ $coupon->start_date ? Carbon::parse($coupon->start_date)->format('d M Y') : '--' }}
                                →
                                {{ $coupon->end_date ? Carbon::parse($coupon->end_date)->format('d M Y') : '--' }}
                              </span>
                            </p>
                          </div>
                          <div class="col-md-3">
                            <span class="text-muted">{{ __('locale.Usage Count') }}</span>
                            <h5 class="mb-0 fw-semibold">{{ $coupon->usage_count ?? 0 }}</p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>

                {{-- Usage Rules --}}
                @if (!empty($baseDetail))
                  <div class="row">
                    <div class="col">
                      <div class="card mb-4">
                        <div class="card-header d-flex justify-content-between align-items-center pb-0 pt-1">
                          <h6 class="fw-bold text-primary"> <i class="icon-base ti tabler-settings icon-md"></i>
                            {{ __('locale.Coupon Conditions') }}</h6>
                        </div>
                        <div class="card-body">
                          <div class="border rounded p-3 bg-light mt-4">
                            <div class="row">
                              <div class="col-md-3">
                                <span class="text-muted">{{ __('locale.Usage Type') }}</span>
                                <h5 class="mb-0 fw-semibold">
                                  {{ ucfirst($baseDetail['usage_type'] ?? 'unlimited') }}</p>
                              </div>
                              <div class="col-md-3">
                                <span class="  text-muted">{{ __('locale.Maximum Usage') }}</span>
                                <h5 class="mb-0 fw-semibold">{{ $baseDetail['maximum_usage'] ?? '∞' }}</p>
                              </div>
                              <div class="col-md-3">
                                <span class="  text-muted">{{ __('locale.Min Buy') }}</span>
                                <h5 class="mb-0 fw-semibold">
                                  {{ isset($baseDetail['min_buy']) && $baseDetail['min_buy'] ? $currency . $baseDetail['min_buy'] : '-' }}
                                  </p>
                              </div>
                              <div class="col-md-3">
                                <span class="  text-muted">{{ __('locale.Max Discount') }}</span>
                                <h5 class="mb-0 fw-semibold">
                                  {{ isset($baseDetail['max_discount']) && $baseDetail['max_discount'] ? $currency . $baseDetail['max_discount'] : '-' }}
                                  </p>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                @endif

                {{-- Extra Details by Type --}}
                @if (in_array($coupon->type, ['product_base', 'category_base']))
                  <div class="row">
                    <div class="col">
                      <div class="card mb-4">
                        <div class="card-header d-flex justify-content-between align-items-center pb-0 pt-1">
                          <h6 class="fw-bold text-primary mb-3"><i class="icon-base ti tabler-box icon-md"></i>
                            {{ __('locale.Applicable Products / Categories') }}</h6>
                        </div>
                        <div class="card-body">
                          <ul class="list-group">
                            @foreach ($details as $d)
                              @php
                                $category = isset($d['category_id'])
                                    ? \App\Models\Category::find($d['category_id'])
                                    : null;
                                $subcategory = isset($d['subcategory_id'])
                                    ? \App\Models\Category::find($d['subcategory_id'])
                                    : null;
                                $product = isset($d['product_id']) ? \App\Models\Product::find($d['product_id']) : null;
                              @endphp

                              @if ($category || $subcategory || $product)
                                <li class="list-group-item d-flex flex-column">
                                  @if ($category)
                                    <span>
                                      <i class="icon-base ti tabler-tag icon-md"></i>
                                      <small>{{ __('locale.Category') }}</small>:
                                      <strong>{{ $category->name }}</strong>
                                      @if ($subcategory)
                                        <span class="ms-1">
                                          --> <strong>{{ $subcategory->name }}</strong>
                                        </span>
                                      @endif
                                    </span>
                                  @endif



                                  @if ($product)
                                    <span class="ms-4 ps-4">
                                      <small>{{ __('locale.Product') }}</small>: <strong>{{ $product->title }}
                                        ({{ $product->sku }})
                                      </strong>
                                    </span>
                                  @endif
                                </li>
                              @endif
                            @endforeach
                          </ul>
                        </div>
                      </div>
                    </div>
                  </div>
                @elseif(in_array($coupon->type, ['customer_base', 'seller_base']))
                  <div class="row">
                    <div class="col">
                      <div class="card mb-4">
                        <div class="card-header d-flex justify-content-between align-items-center pb-0 pt-1">
                          <h6 class="fw-bold text-primary"><i class="icon-base ti tabler-users icon-md"></i>
                            @if ($coupon->type == 'seller_base')
                              {{ __('locale.Applicable Stores') }}
                            @else
                              {{ __('locale.Applicable Users') }}
                            @endif
                          </h6>
                        </div>
                        <div class="card-body table-responsive">
                          <table id="applicationTable"
                            class="datatables-ajax table table-bordered table-striped table-hover">
                            <thead class="table-light">
                              <tr>
                                <th>#</th>
                                <th>
                                  @if ($coupon->type == 'seller_base')
                                    {{ __('locale.Store') }}
                                  @else
                                    {{ __('locale.User') }}
                                  @endif
                                </th>
                                <th>{{ __('locale.Min Buy') }}</th>
                                <th>{{ __('locale.Max Discount') }}</th>
                              </tr>
                            </thead>
                            <tbody>
                              @foreach ($details as $i => $d)
                                @if (isset($d['user_id']))
                                  @php $user = \App\Models\User::find($d['user_id']); @endphp
                                  <tr>
                                    <td>{{ $i }}</td>
                                    <td>{{ $user?->name ?? 'N/A' }}</td>
                                    <td>{{ $currency }}{{ $d['min_buy'] ?? '-' }}</td>
                                    <td>{{ $currency }}{{ $d['max_discount'] ?? '-' }}</td>
                                  </tr>
                                @endif
                              @endforeach
                            </tbody>
                          </table>
                        </div>
                      </div>
                    </div>
                @endif

                {{-- Usage History Table --}}
                <div class="row">
                  <div class="col">
                    <div class="card mb-4">
                      <div class="card-header d-flex justify-content-between align-items-center pb-0 pt-1">
                        <h6 class="fw-bold text-primary"><i class="icon-base ti tabler-list icon-md"></i>
                          {{ __('locale.Coupon Usage History') }}</h6>
                      </div>
                      <div class="card-body table-responsive">

                        <table id="usageTable" class="datatables-ajax table table-bordered table-striped table-hover">
                          <thead class="table-light">
                            <tr>
                              <th>#</th>
                              <th>{{ __('locale.User') }}</th>
                              <th>{{ __('locale.Used On') }}</th>
                              <th>{{ __('locale.Discount Applied') }}</th>
                            </tr>
                          </thead>
                          <tbody>
                            @forelse($coupon['usage'] ?? [] as $index => $usage)
                              <tr>
                                <td>{{ $index + 1 }}</td>
                                <td>{{ $usage->user?->name ?? 'N/A' }}</td>
                                <td>{{ $usage->created_at->format('d M Y, h:i A') }}</td>
                                <td>
                                  {{ $currency }}{{ $usage->discount ?? 0 }}
                                </td>
                              </tr>
                            @empty
                            @endforelse
                          </tbody>
                        </table>
                      </div>
                    </div>
                  </div>



                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <!-- /Modal -->
@endsection
@section('page-script')
  @vite([])
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    $(document).ready(function() {
      $('#usageTable').DataTable({
        responsive: true,
        processing: true,
        columnDefs: [{
            orderable: false,
            targets: [3]
          }, // Actions column not sortable
        ],
        pageLength: 10, // Default rows per page
        lengthMenu: [5, 10, 25, 50, 100],
        language: {
          search: "_INPUT_",
          searchPlaceholder: "Search user...",
        },
        dom: "<'row mb-3'<'col-sm-12 col-md-6'l><'col-sm-12 col-md-6'f>>" +
          "<'table-responsive'tr>" +
          "<'row mt-3'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
      });

      $('#applicationTable').DataTable({
        responsive: true,
        processing: true,
        columnDefs: [{
            orderable: false,
            targets: [3]
          }, // Actions column not sortable
        ],
        pageLength: 10, // Default rows per page
        lengthMenu: [5, 10, 25, 50, 100],
        language: {
          search: "_INPUT_",
          searchPlaceholder: "Search user...",
        },
        dom: "<'row mb-3'<'col-sm-12 col-md-6'l><'col-sm-12 col-md-6'f>>" +
          "<'table-responsive'tr>" +
          "<'row mt-3'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
      });
    });
  </script>

@endsection
