<div class="panel-heading">
  @php
    $details = isset($coupon) ? json_decode($coupon->details, true) : '';
    $coupon_det = json_decode(@$coupon->details);
    $start = isset($coupon) ? date('Y-m-d', strtotime($coupon->start_date)) : '';
    $end = isset($coupon) ? date('Y-m-d', strtotime($coupon->end_date)) : '';
  @endphp
  <h3 class="panel-title">{{ __('locale.Product Base Coupon') }}</h3>
</div>
<div class="col-12">
  <div class="mb-1 row">
    <div class="col-sm-3">
      <label class="col-form-label" for="coupon_code">{{ __('locale.Coupon code') }}</label>
    </div>
    <div class="col-sm-9">
      <input type="text" placeholder="{{ __('locale.Coupon code') }}" id="coupon_code" name="coupon_code"
        value="{{ $coupon->code ?? '' }}" class="form-control" required>
    </div>
  </div>
</div>

<div class="product-choose-list">
  @if (is_array($details))
    @foreach ($details as $key => $detail)
      @if (!empty($detail['category_id']))
        @php
          $sub = $detail['category_id'] ?? null;
          $subc = $detail['subcategory_id'] ?? null;
        @endphp
        <div class="product-choose">
          <div class="col-12">
            <div class="mb-1 row">
              <div class="col-sm-3">
                <label class="col-form-label">{{ __('locale.Category') }}</label>
              </div>
              <div class="col-sm-9">
                <select class="form-control category_id demo-select2" name="category_ids[]" required>
                  <option value="">{{ __('locale.Choose Category') }}</option>
                  @foreach (\App\Models\Category::whereNull('parent_id')->get() as $key => $category)
                    <option value="{{ $category->id }}" {{ @$sub == $category->id ? 'selected' : '' }}>
                      {{ $category->name }}</option>
                  @endforeach
                </select>
              </div>
            </div>
          </div>

          <div class="col-12 subcategory" @if (\App\Models\Category::find($sub)?->parent_id != 0) style="display:none" @endif
            id="subcategory">
            <div class="mb-1 row">
              <div class="col-sm-3">
                <label class="col-form-label">{{ __('locale.Sub Category') }}</label>
              </div>
              <div class="col-sm-9">
                <select class="form-control subcategory_id demo-select2" name="subcategory_ids[]" required>

                  @foreach (\App\Models\Category::where('parent_id', $sub)->where('status', 1)->get() as $key => $subcategory)
                    <option value="{{ $subcategory->id }}" {{ $subc == $subcategory->id ? 'selected' : '' }}>
                      {{ $subcategory->name }}
                    </option>
                  @endforeach
                </select>
              </div>
            </div>
          </div>


          <div class="col-12">
            <div class="mb-1 row">
              <div class="col-sm-3">
                <label class="col-form-label">{{ __('locale.Product') }}</label>
              </div>
              <div class="col-sm-9">
                <select name="product_ids[]" class="form-control product_id demo-select2" required>
                  @foreach (\App\Models\Product::where('category_id', $subc)->get() as $key => $product)
                    <option value="{{ $product->id }}"
                      {{ ($detail['product_id'] ?? null) == $product->id ? 'selected' : '' }}>
                      {{ $product->title }}</option>
                  @endforeach
                </select>
              </div>
            </div>
          </div>

          <hr>
        </div>
      @endif
    @endforeach
  @else
    <p class="text-muted">No details found.</p>
  @endif
</div>
<div class="more hide" style="display:none">
  <div class="product-choose p-2" style="">
    <div class="col-12">
      <div class="mb-1 row">
        <div class="col-sm-3">
          <label class="col-form-label">{{ __('locale.Category') }}</label>
        </div>
        <div class="col-sm-9">
          <select class="form-control category_id" name="category_ids[]" onchange="get_subcategories_by_category(this)">
            <option value="">{{ __('locale.Choose Category') }}</option>
            @foreach (\App\Models\Category::whereNull('parent_id')->get() as $key => $category)
              <option value="{{ $category->id }}">{{ $category->name }}</option>
            @endforeach
          </select>
        </div>
      </div>
    </div>

    <div class="col-12 subcategory" style="display:none">
      <div class="mb-1 row">
        <div class="col-sm-3">
          <label class="col-form-label">{{ __('locale.Sub Category') }}</label>
        </div>
        <div class="col-sm-9">
          <select class="form-control subcategory_id " name="subcategory_ids[]"
            onchange="get_products_by_category(this)">
          </select>
        </div>
      </div>
    </div>

    <div class="col-12">
      <div class="mb-1 row">
        <div class="col-sm-3">
          <label class="col-form-label">{{ __('locale.Products') }}</label>
        </div>
        <div class="col-sm-9">
          <select name="product_ids[]" class="form-control product_id">

          </select>
        </div>
      </div>
    </div>
    <hr>
  </div>
</div>
<div class="text-right">
  <button class="btn btn-primary" type="button" name="button"
    onclick="appendNewProductChoose()">{{ __('locale.Add More') }}</button>
</div>
<br>
<div class="col-12">
  <div class="mb-1 row">
    <div class="col-sm-3">
      <label class="form-label" for="flatpickr-range">{{ __('locale.Date') }}</label>
    </div>
    <div class="col-sm-9">
      <input type="text" name="date" id="flatpickr-range"class="form-control flatpickr-range"
        placeholder="YYYY-MM-DD to YYYY-MM-DD" value="{{ $start && $end ? "$start to $end" : '' }}" />
    </div>
  </div>
</div>

<div class="col-12">
  <div class="mb-1 row">
    <div class="col-sm-3">
      <label class="col-form-label" for="name">{{ __('locale.Discount') }}</label>
    </div>
    <div class="col-sm-7">
      <input type="number" min="0" step="0.01" placeholder="{{ __('locale.Discount') }}"
        value="{{ $coupon->discount ?? '' }}" name="discount" class="form-control" required>
    </div>
    <div class="col-lg-2">
      <select class="form-control" name="discount_type" id="discountType">
        <option value="amount" @if ((!empty($coupon) && $coupon->discount_type == 'amount') || empty($coupon)) selected @endif>
          {{ \App\Helpers\Helpers::setting('currency_symbol', 'currency') }}</option>
        <option value="percent" @if (!empty($coupon) && $coupon->discount_type == 'percent') selected @endif>%</option>
      </select>
    </div>
  </div>
</div>
<div class="col-12" id="maxDiscountWrapper"
  style="display: {{ !empty($coupon) && $coupon->discount_type == 'percent' ? 'block' : 'none' }};">
  <div class="mb-1 row">
    <div class="col-sm-3">
      <label class="col-form-label">{{ __('locale.Maximum Discount Amount') }}</label>
    </div>
    <div class="col-sm-9">
      <input type="number" min="0" step="0.01" placeholder="{{ __('locale.Maximum Discount Amount') }}"
        name="max_discount" id="max_discount" class="form-control"
        value="{{ $coupon_det[0]?->max_discount ?? '' }}" required>
    </div>
  </div>
</div>
<div class="col-12">
  <div class="mb-1 row">
    <div class="col-sm-3">
      <label class="col-form-label">{{ __('locale.Coupon Usage') }}</label>
    </div>
    <div class="col-sm-9">
      <select class="form-control" name="usage_type" id="usageType">
        <option value="unlimited" @if (empty($coupon) || $coupon_det[0]?->usage_type == 'unlimited') selected @endif>
          {{ __('locale.Unlimited Usage') }}
        </option>
        <option value="limited" @if (!empty($coupon) && $coupon_det[0]?->usage_type == 'limited') selected @endif>
          {{ __('locale.Limited Usage') }}
        </option>
        <option value="per_user" @if (!empty($coupon) && $coupon_det[0]?->usage_type == 'per_user') selected @endif>
          {{ __('locale.Once Per User') }}
        </option>
      </select>
    </div>
  </div>
</div>

<div class="col-12" id="maxUsageWrapper" style="display: none;">
  <div class="mb-1 row">
    <div class="col-sm-3">
      <label class="col-form-label">{{ __('locale.Maximum Usages') }}</label>
    </div>
    <div class="col-sm-9">
      <input type="number" min="1" step="1" name="maximum_usage"id="maximum_usage"
        class="form-control" placeholder="{{ __('locale.Maximum Usages') }}"
        value="{{ $coupon_det[0]?->maximum_usage ?? '' }}">
    </div>
  </div>
</div>

@vite(['resources/assets/js/forms-pickers.js'])
<script type="text/javascript">
  $(document).ready(function() {
    $('.demo-select2').select2();
  });
</script>
<script type="text/javascript">
  function appendNewProductChoose() {
    $('.product-choose-list').append($('.more').html());
    $('.product-choose-list').find('.product-choose').last().find('.category_id').select2();
  }

  function get_subcategories_by_category(el) {
    var category_id = $(el).val();
    $(el).closest('.product-choose').find('.subcategory_id').html(null);
    $.get(`${baseURL}/categories/${category_id}/subcategories`, {
      _token: '{{ csrf_token() }}'
    }, function(data) {
      if (data.length > 0) {

        $(el).closest('.product-choose').find('.subcategory').show();
        $(el).closest('.product-choose').find('.subcategory_id').attr("required", true);
      } else {
        $(el).closest('.product-choose').find('.subcategory').hide();
        $(el).closest('.product-choose').find('.subcategory_id').attr("required", false);
        get_products_by_category(el);
      }
      $(el).closest('.product-choose').find('.subcategory_id').append($('<option>', {
        value: '',
        text: 'Choose Subcategory'
      }));
      for (var i = 0; i < data.length; i++) {
        $(el).closest('.product-choose').find('.subcategory_id').append($('<option>', {
          value: data[i].id,
          text: data[i].name
        }));
      }
      $(el).closest('.product-choose').find('.subcategory_id').select2();
      // get_subsubcategories_by_subcategory($(el).closest('.product-choose').find('.subcategory_id'));
    });
  }



  function get_products_by_category(el) {
    var category_id = $(el).val();
    console.log(category_id);
    $(el).closest('.product-choose').find('.product_id').html(null);
    $.post('{{ route('products.get_products_by_category') }}', {
      _token: '{{ csrf_token() }}',
      category_id: category_id
    }, function(response) {
      var data = response.data;
      console.log(data);
      $(el).closest('.product-choose').find('.product_id').append($('<option>', {
        value: '',
        text: 'Choose Product'
      }));
      for (var i = 0; i < data.length; i++) {
        $(el).closest('.product-choose').find('.product_id').append($('<option>', {
          value: data[i].id,
          text: data[i].title
        }));
      }
      $(el).closest('.product-choose').find('.product_id').select2();
    });
  }


  $(document).ready(function() {
    $('.demo-select2').select2();
    // Run only if #id input is empty (create mode)
    if ($('#id').length && $('#id').val() === '') {
      appendNewProductChoose();
    }
  });

  $('.category_id').on('change', function() {
    get_subcategories_by_category(this);
  });
</script>
