@php
  $configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', __('locale.Countries'))

@section('vendor-style')
  @vite(['resources/assets/css/datatables.scss'])
@endsection

@section('vendor-script')
  @vite(['resources/assets/js/datatables.js'])
@endsection

@section('content')
  <div class="row g-6">
    <div class="col-12">
      <div class="card">
        <div class="card-datatable">
          <table class="datatables-users table border-top">
            <thead>
              <tr>
                <th>#</th>
                <th></th>
                <th>{{ __('locale.Name') }}</th>
                <th>{{ __('locale.Details') }}</th>
                <th>{{ __('locale.Status') }}</th>
                <th>{{ __('locale.Actions') }}</th>
              </tr>
            </thead>
          </table>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade text-left brand-edit-modal" id="inlineForm" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <form id="edit_form" method="POST">
          @csrf
          @method('PUT')
          <div class="modal-header">
            <h4 class="modal-title">{{ __('locale.Edit Country Base Price') }}</h4>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            <input type="hidden" name="id" id="id_edit">
            <h4 class="name_edit"></h4>

            <div class="mb-4">
              <label class="form-label">{{ __('locale.Base Fare') }} (<span
                  class="currency">{{ $currency }}</span>)</label>
              <input type="number" name="base_fare" id="base_fare_edit" class="form-control"
                placeholder="{{ __('locale.Base Fare') }}" required>
            </div>
            <div class="mb-4">
              <label class="form-label">{{ __('locale.Per km Rate') }} (<span
                  class="currency">{{ $currency }}</span>)</label>
              <input type="number" name="per_km_rate" id="per_km_rate_edit" class="form-control"
                placeholder="{{ __('locale.Per km Rate') }}" required>
            </div>
            <div class="mb-4">
              <label class="form-label">{{ __('locale.Per minute Price') }} (<span
                  class="currency">{{ $currency }}</span>)</label>
              <input type="number" name="per_minute_price" id="per_minute_price_edit" class="form-control"
                placeholder="{{ __('locale.Per minute Price') }}" required>
            </div>
            <input type="hidden" name="per_minute_waiting_price" value="0" />
          </div>
          <div class="modal-footer">
            <button type="submit" class="btn btn-primary">{{ __('locale.Update') }}</button>
          </div>
        </form>
      </div>
    </div>
  </div>


  <div id="role-helper" data-add="{{ __('locale.Add New Brand') }}"></div>
@endsection

@section('page-script')
  @vite(['resources/assets/js/country.js'])
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    window.permissions = {
      canEditCountry: @json(auth()->user()->can('site_Settings-edit'))
    };


    $(function() {
      const table = $('.datatables-users').DataTable();
      let $btn = null;

      // Edit modal open
      $(document).on('click', '.edit-country-modal', function() {
        $('#id_edit').val($(this).data('id'));
        $('.name_edit').text($(this).data('name'));
        $('#base_fare_edit').val($(this).data('base_fare'));
        $('#nper_km_rate_edit').val($(this).data('per_km_rate'));
        $('#per_minute_price_edit').val($(this).data('per_minute_price'));
        $('.currency').text($(this).data('currency'));
        $('#inlineForm').modal('show');
      });
      // Edit form submit
      $('#edit_form').on('submit', function(event) {
        event.preventDefault();
        const id = $('#id_edit').val();
        $.ajax({
          type: 'POST',
          url: `${baseURL}/countries/${id}`,
          headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          data: new FormData(this),
          dataType: 'JSON',
          contentType: false,
          cache: false,
          processData: false,
          beforeSend: function() {
            toggleButtonLoading($btn, true, 'Saving...');
          },
          success: function(data) {
            if (data.status === 200 && data.data) {
              const brand = data.data;
              const existingRow = table.row(`#trRow-${brand.id}`);
              if (existingRow.node()) {
                existingRow.data(brand).draw(false);
              }
              $('#inlineForm').modal('hide');
            }
            toggleButtonLoading($btn, false);
            const toastType = data.status == 200 ? 'bg-success' : 'bg-warning';
            window.showToast({
              title: 'Brands 🗂️',
              message: data.message,
              type: toastType,
              animation: 'animate__fadeInUp',
              time: 'Just now',
              delay: 3000
            });
          },
          error: function(xhr) {
            toggleButtonLoading($btn, false);
            console.log(xhr.responseJSON);
          }
        });
      });
    });
  </script>
@endsection
