@extends('layouts/layoutMaster')

@section('title', __('locale.Car Details'))

@section('vendor-style')
  @vite(['resources/assets/css/datatables.scss', 'resources/assets/vendor/libs/apex-charts/apex-charts.scss', 'resources/assets/vendor/libs/raty-js/raty-js.scss'])
@endsection

@section('vendor-script')
  @vite(['resources/assets/js/datatables.js', 'resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/apex-charts/apexcharts.js', 'resources/assets/vendor/libs/raty-js/raty-js.js'])
@endsection

@section('page-style')
  @vite('resources/assets/vendor/scss/pages/app-ecommerce.scss')
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui@6.0/dist/fancybox/fancybox.css" />
  <style>
    .raty {
      display: inline-flex;
      align-items: center;
      gap: 2px;
    }

    .raty img {
      display: inline-block;
      vertical-align: middle;
    }
  </style>
@endsection



@section('page-script')
  @vite(['resources/assets/js/reviews.js', 'resources/assets/js/star-ratings.js'])
  <script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui@6.0/dist/fancybox/fancybox.umd.js"></script>
  <script>
    Fancybox.bind("[data-fancybox='gallery']", {
      Thumbs: false,
      Toolbar: true
    });
  </script>

@endsection

@section('content')
  <div class="row">


    <!-- User Content -->
    <div class="col-xl-12 col-lg-12 order-0 order-md-1">
      <!-- User Pills -->
      <div class="nav-align-top">
        <ul class="nav nav-tabs nav-fill" role="tablist">
          <li class="nav-item">
            <button type="button" class="nav-link active" role="tab" data-bs-toggle="tab"
              data-bs-target="#navs-justified-home" aria-controls="navs-justified-home" aria-selected="true">
              <span class="d-none d-sm-inline-flex align-items-center">
                <i class="icon-base ti tabler-car icon-sm me-1_5"></i>{{ __('locale.Vehicle Details') }}
                <span class="badge rounded-pill badge-center h-px-20 w-px-20 bg-label-danger ms-1_5"></span>
              </span>
              <i class="icon-base ti tabler-car icon-sm d-sm-none"></i>
            </button>
          </li>

        </ul>
      </div>
      <!--/ User Pills -->


      <div class="card mb-6">
        <div class="tab-content">
          <div class="tab-pane fade show active" id="navs-justified-home" role="tabpanel">
            <div class="card">
              <div class="card-body row gy-6">
                <div class="col-sm-12 col-lg-6 text-center px-4">
                  <span class="badge bg-label-primary rounded mb-4 h-px-52 w-px-52 p-2"><i
                      class="icon-base ti tabler-car icon-36px"></i></span>
                  <h4 class="card-title mb-4">{{ $car?->vehicle_model }}</h4>
                  <p class="card-text">
                  <div class="btn-group" role="group" aria-label="Basic example">
                    <button type="button"
                      class="btn btn-secondary waves-effect waves-light">{{ $car?->parent_category }}</button>
                    <button type="button"
                      class="btn btn-secondary waves-effect waves-light">{{ $car?->vehicle_category }}</button>
                    <button type="button" class="btn btn-secondary waves-effect waves-light">
                      {{ $car?->vehicle_year }}</button>
                  </div>
                  </p>
                  <div class="demo-inline-spacing mt-2">
                    <button class="btn btn-primary">{{ $car?->vehicle_brand }}</button>
                    <button class="btn" style="background:{{ $car['color']['code'] ?? '#ccc' }} ">
                      {{ __('locale.Color') }}: {{ $car['color']['name'] ?? '#ccc' }}</button>

                  </div>

                </div>
                <div class="col-12 col-md-6 col-lg-6">
                  <div class="card h-100 shadow-none border">
                    <div class="p-2 pb-0">
                      <a data-fancybox="gallery" data-caption="{{ __('locale.Insurance Image') }}"
                        href='{{ asset('storage/' . $car?->vehicle_image) }}'> <img class="img-fluid scaleX-n1-rtl"
                          src="{{ asset('storage/' . $car?->vehicle_image) }}"
                          onerror="this.onerror=null;this.src=`{{ asset('assets/img/placeholder.jpg') }}`;" /></a>
                    </div>
                    <div class="card-body">
                      <h5 class="card-title">{{ $car?->license_plate }}</h5>
                      <p class="card-text">
                        {{ $car?->registration_number }}</p>
                    </div>
                  </div>
                </div>

              </div>
            </div>
            <div class="card">
              <div class="card-body row gy-6">
                <div class="col-md-6 col-lg-4">
                  <h6 class="mt-2 text-body-secondary"> {{ __('locale.Insurance Image') }}</h6>
                  <div class="card">
                    <a data-fancybox="gallery" data-caption="{{ __('locale.Insurance Image') }}"
                      href='{{ asset('storage/' . $car?->insurance_image) }}'><img class="card-img-top"
                        src="{{ asset('storage/' . $car?->insurance_image) }}" alt="{{ __('locale.Insurance Image') }}"
                        onerror="this.onerror=null;this.src=`{{ asset('assets/img/placeholder.jpg') }}`;">
                    </a>
                  </div>
                </div>
                <div class="col-md-6 col-lg-4">
                  <h6 class="mt-2 text-body-secondary"> {{ __('locale.Road Worthiness') }}</h6>
                  <div class="card">
                    <a data-fancybox="gallery" data-caption="{{ __('locale.Road Worthiness') }}"
                      href='{{ asset('storage/' . $car?->road_worthiness_image) }}'><img class="card-img-top"
                        src="{{ asset('storage/' . $car?->road_worthiness_image) }}"
                        alt="{{ __('locale.Road Worthiness') }}"
                        onerror="this.onerror=null;this.src=`{{ asset('assets/img/placeholder.jpg') }}`;">
                    </a>
                  </div>
                </div>
                <div class="col-md-6 col-lg-4">
                  <h6 class="mt-2 text-body-secondary"> {{ __('locale.Vehicle Registration') }}</h6>
                  <div class="card">
                    <a data-fancybox="gallery" data-caption="{{ __('locale.Vehicle Registration') }}"
                      href='{{ asset('storage/' . $car?->vehicle_registration_image) }}'><img class="card-img-top"
                        src="{{ asset('storage/' . $car?->vehicle_registration_image) }}"
                        alt="{{ __('locale.Vehicle Registration') }}"
                        onerror="this.onerror=null;this.src=`{{ asset('assets/img/placeholder.jpg') }}`;">
                    </a>
                  </div>
                </div>
              </div>
            </div>
          </div>

        </div>
      </div>


    </div>
    <!--/ User Content -->
  </div>
  <!-- /Modal -->
@endsection
