<section class="section-py pricing-plans-comparison">
  <div class="container">
    <div class="col-12 text-center mb-1">
      <h3 class="mb-0">{{ $category->name }} - {{ __('locale.Pricing Chart') }}</h3>
    </div>
    @php $currency=Helper::setting('currency_symbol', 'currency'); @endphp

    @foreach ($countries as $country)
      <div class="row mb-4">
        <div class="col-12">
          <div class="table-responsive border border-top-0 rounded">
            <table class="table text-center mb-0" style="background: #353a54">
              <thead>
                <tr>
                  <th scope="col" class="text-start">
                    <p class="mb-0 "><span class="badge text-nowrap bg-label-primary">{{ $country['name'] }}</span></p>
                    <small class="text-body fw-normal text-capitalize">{{ __('locale.Pricing Rules') }}</small>
                  </th>
                  <th scope="col">
                    <p class="mb-0">{{ __('locale.Base Fare') }} </p>
                    <span
                      class="badge bg-label-success p-1">{{ $currency }}{{ number_format($country['base_fare'], 2) }}</span>
                  </th>
                  <th scope="col">
                    <p class="mb-0 position-relative">
                      {{ __('locale.Per Km') }}

                    </p>
                    <span
                      class="badge bg-label-success p-1">{{ $currency }}{{ number_format($country['per_km'], 2) }}</span>
                  </th>
                  <th scope="col">
                    <p class="mb-0">{{ __('locale.Per Minute') }}</p>
                    <span
                      class="badge bg-label-success p-1">{{ $currency }}{{ number_format($country['per_minute'], 2) }}</span>
                  </th>
                </tr>
              </thead>
              <tbody>
                @if ($country['rules']->count())
                  @foreach ($country['rules'] as $rule)
                    <tr>
                      <td class="text-heading text-start">{{ $rule['name'] }}
                        @if ($rule['conditions']->count())
                          <ul class="mt-1 mb-0">
                            @foreach ($rule['conditions'] as $cond)
                              <li>
                                <span class="badge bg-label-info badge-sm mb-1">
                                  <strong>{{ ucfirst(str_replace('_', ' ', $cond->condition_type)) }}:</strong>
                                  {{ $cond->formatted_value }}</span>

                              </li>
                            @endforeach
                          </ul>
                        @else
                          <em>No conditions</em>
                        @endif
                      </td>
                      <td>
                        <span class="badge bg-label-primary p-1">
                          {{ $currency }}{{ number_format($rule['new_prices']['base_fare'], 2) }}
                        </span>
                      </td>
                      <td>
                        <span class="badge bg-label-primary p-1">
                          {{ $currency }}{{ number_format($rule['new_prices']['per_km'], 2) }} /
                          {{ __('locale.Per Km') }}
                        </span>
                      </td>
                      <td>
                        <span class="badge bg-label-primary p-1">
                          {{ $currency }}{{ number_format($rule['new_prices']['per_minute'], 2) }}
                          / {{ __('locale.Per Minute') }}
                        </span>
                      </td>
                    </tr>
                  @endforeach
                @else
                @endif
              </tbody>
            </table>
          </div>
        </div>
      </div>
    @endforeach
  </div>
</section>
