<!-- Country Price Modal -->
<div class="modal fade" id="countryPriceModal" tabindex="-1" aria-labelledby="countryPriceModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <form id="countryPriceForm" method="POST">
      @csrf
      <input type="hidden" name="vehicle_category_id" id="vehicle_category_id">

      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">{{ __('locale.Set Country Pricing') }}</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>

        <div class="modal-body">
          <div class="mb-3">
            <label for="countries" class="form-label">{{ __('locale.Select Countries') }}</label>
            <select name="countries[]" id="countries" class="select2-multiple form-select" multiple>
              @foreach ($countries as $country)
                <option value="{{ $country->id }}">{{ $country->name }} ({{ $country->currency_symbol }})</option>
              @endforeach
            </select>
          </div>

          <div id="pricing-fields" class="row gy-2">
            <!-- Dynamic rows appended here based on selected countries -->
          </div>
        </div>

        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">{{ __('locale.Save Prices') }}</button>
        </div>
      </div>
    </form>
  </div>
</div>
