<!-- Add Role Modal -->
<div class="modal fade" id="addRoleModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-simple modal-dialog-centered modal-add-new-role">
    <div class="modal-content">
      <div class="modal-body">
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        <div class="text-center mb-6">
          <h4 class="role-title">{{ __('locale.Add New Role') }}</h4>
        </div>
        <!-- Add role form -->
        <form method="POST" action="{{ route('roles.store') }}" id="rolesForm" class="row">
          @csrf
          <div class="col-12">
            <label class="form-label" for="modalRoleName">{{ __('locale.Role Name') }}</label>
            <input type="text" id="modalRoleName" name="name" class="form-control"
              placeholder="{{ __('locale.Role Name') }}" tabindex="-1" data-msg="Please enter role name" />
          </div>

          <div class="col-12">
            <label class="form-label" for="color_code">{{ __('locale.Color') }}</label>
            <select class="select2 form-select color-code" name="color" id="color_code" required>
              @foreach (\App\Models\Color::orderBy('name', 'asc')->get() as $key => $color)
                <option value="{{ $color->code }}" data-color="{{ $color->code }}">{{ $color->name }}</option>
              @endforeach
            </select>
          </div>

          <div class="col-12">
            <h4 class="mt-2 pt-50">{{ __('locale.Role Permissions') }}</h4>
            <!-- Permission table -->
            <div class="table-responsive">
              <table class="table table-flush-spacing">
                <tbody>
                  <tr>
                    <td class="text-nowrap fw-bolder">
                      {{ __('locale.Administrator Access') }}
                      <span data-bs-toggle="tooltip" data-bs-placement="top" title="Allows a full access to the system">
                        <i class='icon-base ti tabler-info'></i>
                      </span>
                    </td>
                    <td>
                      <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="selectAll" />
                        <label class="form-check-label" for="selectAll"> {{ __('locale.Select All') }} </label>
                      </div>
                    </td>
                  </tr>
                  @foreach ($permission as $key => $value)
                    <tr>
                      <td class="text-nowrap fw-bolder">{{ ucfirst($key) }} {{ __('locale.Management') }}</td>
                      <td>
                        <div class="d-flex">
                          @foreach ($value as $val)
                            @switch($val)
                              @case($val == 'list')
                                <?php $nm = 'Read'; ?>
                              @break

                              @case($val == 'delete')
                                <?php $nm = 'Delete'; ?>
                              @break

                              @case($val == 'create')
                                <?php $nm = 'Create'; ?>
                              @break

                              @case($val == 'edit')
                                <?php $nm = 'Write'; ?>
                              @break

                              @default
                                <span>{{ __('locale.Something went wrong, please try again') }}</span>
                            @endswitch
                            <div class="form-check me-3 me-lg-3">
                              <input class="form-check-input permissions" type="checkbox" name=permissions[]
                                value="{{ $key }}-{{ $val }}"
                                id="{{ $key }}-{{ $val }}" data-ddd="" />
                              <label class="form-check-label" for="{{ $key }}-{{ $val }}">
                                {{ $nm }} </label>
                            </div>
                          @endforeach

                        </div>
                      </td>
                    </tr>
                  @endforeach


                </tbody>
              </table>
            </div>
            <!-- Permission table -->
          </div>
          <div class="col-12 text-center mt-2">
            <button type="submit" class="btn btn-primary me-1">{{ __('locale.Submit') }}</button>
            <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close">
              {{ __('locale.Discard') }}
            </button>
          </div>
        </form>
        <!--/ Add role form -->
      </div>
    </div>
  </div>
</div>
<!--/ Add Role Modal -->
