import Echo from 'laravel-echo';

import Pusher from 'pusher-js';
Pusher.logToConsole = true;
window.Pusher = Pusher;

window.Echo = new Echo({
  broadcaster: 'reverb',
  key: import.meta.env.VITE_REVERB_APP_KEY,
  wsHost: import.meta.env.VITE_REVERB_HOST,
  wsPort: import.meta.env.VITE_REVERB_PORT ?? 6001,
  wssPort: import.meta.env.VITE_REVERB_PORT ?? 6001,
  forceTLS: false, //(import.meta.env.VITE_REVERB_SCHEME ?? 'https') === 'https',
  enabledTransports: ['ws', 'wss'],
  withCredentials: true,
  authEndpoint: '/topsyapp/broadcasting/auth' // ✅ Correct line here
});
/* window.Echo.private('mc-chat-conversation.1')
  .notification(e => {
    console.log('🔔 Notification event:', e);
  })
  .listenForWhisper('MessageWasSent', e => {
    console.log('🌀 Whispered event:', e);
  })
  .listen('.Musonza\\Chat\\Eventing\\MessageWasSent', function (e) {
    console.log('New message:', e.message);
  }); */
if (authID) {
  window.Echo.private(`chat.user.${authID}`).listen('.new.chat.message', e => {
    // 1️⃣ Badge Update chat icon badge with unread count for this user
    const countTotal = e.unread_count_total ? (e.unread_count_total[String(authID)] ?? 0) : 0;
    const count = e.unread_count ? (e.unread_count[String(authID)] ?? 0) : 0;
    const chatCounter = document.getElementById('chatCounter');
    const chatMessageCount = document.getElementById('chatMessageCount');
    const conversationId = e.conversation_id ?? 0;
    const countConversation = document.getElementById('countConversation' + conversationId);

    if (chatCounter) chatCounter.innerText = countTotal;
    if (chatMessageCount) chatMessageCount.innerText = countTotal;
    if (countConversation) countConversation.innerText = count;

    // 2️⃣ Toast message (optional)
    window.showToast({
      title: 'New Message 💬',
      message: e.body ?? 'Message',
      type: 'bg-primary',
      animation: 'animate__fadeInUp',
      time: 'Just now',
      delay: 3000
    });

    // 3️⃣ Play notification sound
    const sound = document.getElementById('notificationSound');
    if (sound) {
      sound.currentTime = 0; // restart sound if already playing
      const playPromise = sound.play();
      if (playPromise !== undefined) {
        playPromise.catch(err => {
          console.log('Notification sound play blocked:', err);
        });
      }
    }

    // 4️⃣ Fire system notification via Service Worker
    if ('serviceWorker' in navigator && Notification.permission === 'granted') {
      navigator.serviceWorker.ready.then(reg => {
        reg.showNotification(e.title || 'New Notification', {
          body: e.body,
          icon: e.icon || '/assets/img/branding/logo.png',
          badge: e.icon || '/assets/img/branding/logo.png',
          data: e.url || '/'
        });
      });
    }
  });
}

//order Placed event
if (authTYPE == 'Store') {
  window.Echo.private('order.' + authID).listen('.order.placed', e => {
    const order = e;
    console.log(order);
    // ✅ Show toast
    window.showToast({
      title: '🛒 New Order',
      message: `Order #${order.orderId} placed by ${order.customer}`,
      type: 'bg-info',
      animation: 'animate__fadeInUp',
      time: 'Just now',
      delay: 4000
    });

    // ✅ Add row into DataTable
    const avatarHtml = order.avatar
      ? `<img src="${order.avatar}" alt="Avatar" class="rounded-circle">`
      : (() => {
          const states = ['success', 'danger', 'warning', 'info', 'dark', 'primary', 'secondary'];
          const state = states[Math.floor(Math.random() * states.length)];
          const initials = (order.customer?.substring(0, 2) ?? '').toUpperCase();
          return `<span class="avatar-initial rounded-circle bg-label-${state}">${initials}</span>`;
        })();

    const prescriptionButton = order.prescriptions
      ? `<br><button class="btn btn-sm btn-primary mt-1 view-prescription" title="Prescriptions" data-image="${order.prescriptionImage}">
                <i class="icon-base ti tabler-prescription"></i>
               </button>`
      : '';

    const rowHtml = `
<tr id="row${order.id}">
    <td><a href="${baseURL}/store/orders/${order.id}">${order.orderId}</a></td>
    <td><span class="text-nowrap">${new Date(order.createdAt).toLocaleDateString()}<br><small>${new Date(order.createdAt).toLocaleTimeString([], { hour: '2-digit', minute: '2-digit' })}</small></span></td>
    <td>
        <div class="d-flex justify-content-start align-items-center order-name text-nowrap">
            <div class="avatar-wrapper">
                <div class="avatar avatar-sm me-3">${avatarHtml}</div>
            </div>
            <div class="d-flex flex-column">
                <h6 class="m-0"><span class="text-heading">${order.customer}</span></h6>
                <small>${order.email}</small>
            </div>
        </div>
    </td>
    <td>
        <h6 class="mb-0 align-items-center d-flex w-px-100">${order.paymentStatus}</h6>
        ${order.currency}${order.grandTotal}<br><small>${order.paymentType}</small>
    </td>
    <td>
        <span class="badge px-2 text-capitalized">${order.status}</span>
        ${prescriptionButton}
    </td>
    <td>
        <div class="d-flex align-items-center text-nowrap"><span>${order.paymentType}</span></div>
    </td>
    <td>
        <div class="d-flex justify-content-sm-start align-items-sm-center">
            <button title="Accept Order" class="btn btn-text-primary rounded-pill waves-effect btn-icon acceptOrder" data-order-id="${order.id}">
                <i class="icon-base ti tabler-check"></i>
            </button>
            <button class="btn btn-text-secondary rounded-pill waves-effect btn-icon dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                <i class="icon-base ti tabler-dots-vertical"></i>
            </button>
            <div class="dropdown-menu dropdown-menu-end m-0">
                <a href="${baseURL}/store/orders/${order.id}" class="dropdown-item">View</a>
            </div>
        </div>
    </td>
</tr>`;

    // Add new row to DataTable
    const table = $('#orders-table').DataTable();
    table.row.add($(rowHtml)).draw(false);
  });
}

//order placed event
