/**
 * app-ecommerce-wallet-list Script
 */

'use strict';

// Datatable (js)

document.addEventListener('DOMContentLoaded', function (e) {
  let borderColor, bodyBg, headingColor;

  borderColor = config.colors.borderColor;
  bodyBg = config.colors.bodyBg;
  headingColor = config.colors.headingColor;

  // Variable declaration for table
  const offCanvasForm = document.getElementById('offcanvasAddRequest');
  const dt_wallet_table = document.querySelector('.datatables-wallet'),
    statusObj = {
      Pending: { title: 'Pending', class: 'bg-label-primary' },
      Approved: { title: 'Approved', class: 'bg-label-success' },
      Rejected: { title: 'Rejected', class: 'bg-label-danger' },
      Cancelled: { title: 'Cancelled', class: 'bg-label-danger' }
    };
  // Helper to populate dropdown from JS object
  function populateDropdown(obj, containerSelector, labelText, selectId) {
    const container = document.querySelector(containerSelector);
    // Clear container
    container.innerHTML = '';
    // Create label
    if (labelText) {
      const label = document.createElement('label');
      label.setAttribute('for', selectId);
      label.className = 'form-label';
      label.textContent = labelText;
      container.appendChild(label);
    }
    // Create select element
    const select = document.createElement('select');
    select.className = 'form-select';
    if (selectId) select.id = selectId;
    // Add first option "All"
    const allOption = document.createElement('option');
    allOption.value = '';
    allOption.textContent = 'All';
    select.appendChild(allOption);
    // Add options from object
    Object.keys(obj).forEach(key => {
      const opt = document.createElement('option');
      opt.value = key;
      opt.textContent = obj[key].title;
      select.appendChild(opt);
    });

    // Append select to container
    container.appendChild(select);
  }
  // Usage
  populateDropdown(statusObj, '.wallet_status', 'Status', 'WalletStatus');
  // E-commerce Products datatable

  if (dt_wallet_table) {
    const dt_wallet = new DataTable(dt_wallet_table, {
      processing: true,
      serverSide: true,
      ajax: {
        url: baseURL + '/withdrawal-list-all',
        type: 'GET',
        data: function (d) {
          d.customer = $('#Customer').length ? $('#Customer').val() : null;
          d.status = $('#WalletStatus').length ? $('#WalletStatus').val() : null;
          d.user_type = $('#userType').length ? $('#userType').val() : null;
          let dateRange = $('#bs-rangepicker-range').val();
          if (dateRange && dateRange.includes(' to ')) {
            let dates = dateRange.split(' to ');
            d.start_date = dates[0];
            d.end_date = dates[1];
          } else if (dateRange && dateRange.includes(' - ')) {
            let dates = dateRange.split(' - ');
            d.start_date = dates[0];
            d.end_date = dates[1];
          }
        }
      },
      columns: [
        // columns according to JSON
        { data: 'id' },
        { data: 'id', orderable: false, render: DataTable.render.select() },
        { data: 'id' },
        { data: 'user_id' },
        { data: 'customer' }, //email //avatar
        { data: 'notes' },
        { data: 'status' },
        { data: 'details' }, //method_number
        { data: 'txn_id' }
      ],
      columnDefs: [
        {
          // For Responsive
          className: 'control',
          searchable: false,
          orderable: false,
          responsivePriority: 2,
          targets: 0,
          render: function (data, type, full, meta) {
            return '';
          }
        },
        {
          // For Checkboxes
          targets: 1,
          orderable: false,
          searchable: false,
          responsivePriority: 3,
          checkboxes: true,
          visible: false,
          render: function () {
            return '<input type="checkbox" class="dt-checkboxes form-check-input">';
          },
          checkboxes: {
            selectAllRender: '<input type="checkbox" class="form-check-input">'
          }
        },
        {
          targets: 2,
          render: function (data, type, full, meta) {
            const name = full['customer'];
            const email = full['email'];
            const avatar = full['avatar'];
            let output;

            if (avatar) {
              // For Avatar image
              output = `<img src="${avatar}" alt="Avatar" class="rounded-circle">`;
            } else {
              // For Avatar badge
              const stateNum = Math.floor(Math.random() * 6);
              const states = ['success', 'danger', 'warning', 'info', 'dark', 'primary', 'secondary'];
              const state = states[stateNum];
              const initials = (name.match(/\b\w/g) || []).slice(0, 2).join('').toUpperCase();

              output = `<span class="avatar-initial rounded-circle bg-label-${state}">${initials}</span>`;
            }

            // Creates full output for row
            let profileUrl = '';
            if (full.user_type === 'user') {
              profileUrl = `${baseURL}/users/${full.user_id}`;
            } else if (full.user_type === 'store') {
              profileUrl = `${baseURL}/stores/${full.user_id}`;
            } else if (full.user_type === 'driver') {
              profileUrl = `${baseURL}/drivers/${full.user_id}`;
            }
            const rowOutput = `
              <div class="d-flex justify-content-start align-items-center wallet-name text-nowrap">
                <div class="avatar-wrapper">
                  <div class="avatar avatar-sm me-3">
                    ${output}
                  </div>
                </div>
                <div class="d-flex flex-column">
                  <h6 class="m-0">
        ${
          full.userType === 'Admin'
            ? `<a href="${profileUrl}" class="text-heading">${name}</a>`
            : `<span class="text-heading">${name}</span>`
        }
      </h6>
                  <small>${email}<br><span class="text-info">${full.user_type}</span></small>
                </div>
              </div>`;

            return rowOutput;
          }
        },
        {
          // Withdrawal Request ID
          targets: 3,
          render: function (data, type, full, meta) {
            const dateObj = new Date(full.created_at);
            const formattedDate = dateObj.toLocaleDateString('en-US', {
              month: 'short',
              day: 'numeric',
              year: 'numeric'
            });

            const formattedTime = dateObj.toLocaleTimeString('en-US', {
              hour: '2-digit',
              minute: '2-digit',
              hour12: true
            });
            const row_output = `<span class="text-nowrap"> Amount: ${full.amount}<br><small>Tran Fee: ${full.currency}${full.processing_fees}<br>${formattedDate}</small></span>`;
            return row_output;
          }
        },
        {
          targets: 4,
          render: function (data, type, full, meta) {
            let bankName = full.bank_details?.bank_name ?? '—';
            let accountNumber = full.bank_details?.account_number ?? '—';
            return `<div><strong>${bankName}</strong><br><small>${accountNumber}</small></div>`;
          }
        },

        {
          targets: 5,
          render: function (data, type, full, meta) {
            const reason = full['processed_at'];
            if (reason && (full.status == 'Cancelled' || full.status == 'Rejected')) {
              return `
                <span class="text-nowrap"> Reason: ${full.notes}<br><small>Date Reason: ${reason}</small></span>`;
            }
            return data;
          }
        },
        {
          targets: -3,
          render: function (data, type, full, meta) {
            return `
                <span class="text-nowrap"> <small>Tran ID: ${full.txn_id ?? ''}<br>Txn Detail: ${full.details ?? ''}</small></span>`;
          }
        },
        {
          targets: -2,
          render: function (data, type, full, meta) {
            return (
              `
              <button type="button" class="btn ` +
              statusObj[full.status].class +
              ` waves-effect" id="status-${full.id}">` +
              statusObj[full.status].title +
              `</button>`
            );
          }
        },
        {
          targets: -1,
          title: 'Actions',
          searchable: false,
          orderable: false,
          render: function (data, type, full, meta) {
            let btn = '';

            if (full['status'] === 'Pending' && full['edit'] == true) {
              btn = `
      <div class="d-flex justify-content-sm-start align-items-sm-center hide-${full.id}">
        <button class="btn btn-text-secondary rounded-pill waves-effect btn-icon dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
          <i class="icon-base ti tabler-dots-vertical"></i>
        </button>
        <div class="dropdown-menu dropdown-menu-end m-0">
          <button type="button" class="dropdown-item accept-modal hide-${full.id}"
            data-id="${full['id']}"
            data-title="${full['customer']} (${full['email']})"
            data-image=""
            data-status="Approved">
           <i class="icon-base ti tabler-credit-card"></i>
            Withdrawn
          </button>

          <button type="button" class="dropdown-item cancel-modal hide-${full.id}"
            data-id="${full['id']}"
            data-title="${full['customer']} (${full['email']})"
            data-image=""
            data-status="Rejected">
           <i class="icon-base ti tabler-x"></i>
            Cancelled
          </button>
        </div>
      </div>
    `;
            }

            return btn;
          }
        }
      ],
      select: {
        style: 'multi',
        selector: 'td:nth-child(2)'
      },
      order: [2, 'desc'],
      layout: {
        topStart: {
          search: {
            placeholder: 'Search Withdrawal Request',
            text: '_INPUT_'
          }
        },
        topEnd: {
          rowClass: 'row mx-3 my-0 justify-content-between',
          features: [
            {
              pageLength: {
                menu: [7, 10, 25, 50, 100],
                text: '_MENU_'
              }
            },
            {
              buttons: [
                {
                  extend: 'collection',
                  className: 'btn btn-label-primary dropdown-toggle',
                  text: '<span class="d-flex align-items-center gap-1"><i class="icon-base ti tabler-upload icon-xs"></i> <span class="d-none d-sm-inline-block">Export</span></span>',
                  buttons: [
                    {
                      extend: 'print',
                      text: `<span class="d-flex align-items-center"><i class="icon-base ti tabler-printer me-1"></i>Print</span>`,
                      className: 'dropdown-item',
                      exportOptions: {
                        columns: [2, 3, 4, 5, 6, 7],
                        format: {
                          body: function (inner, coldex, rowdex) {
                            if (inner.length <= 0) return inner;
                            const el = new DOMParser().parseFromString(inner, 'text/html').body.childNodes;
                            let result = '';
                            el.forEach(item => {
                              if (item.classList && item.classList.contains('user-name')) {
                                result += item.lastChild.firstChild.textContent;
                              } else {
                                result += item.textContent || item.innerText || '';
                              }
                            });
                            return result;
                          }
                        }
                      },
                      customize: function (win) {
                        win.document.body.style.color = headingColor;
                        win.document.body.style.borderColor = borderColor;
                        win.document.body.style.backgroundColor = bodyBg;
                        const table = win.document.body.querySelector('table');
                        table.classList.add('compact');
                        table.style.color = 'inherit';
                        table.style.borderColor = 'inherit';
                        table.style.backgroundColor = 'inherit';
                      }
                    },
                    {
                      extend: 'csv',
                      text: `<span class="d-flex align-items-center"><i class="icon-base ti tabler-file me-1"></i>Csv</span>`,
                      className: 'dropdown-item',
                      exportOptions: {
                        columns: [2, 3, 4, 5, 6, 7],
                        format: {
                          body: function (inner, coldex, rowdex) {
                            if (inner.length <= 0) return inner;
                            const el = new DOMParser().parseFromString(inner, 'text/html').body.childNodes;
                            let result = '';
                            el.forEach(item => {
                              if (item.classList && item.classList.contains('user-name')) {
                                result += item.lastChild.firstChild.textContent;
                              } else {
                                result += item.textContent || item.innerText || '';
                              }
                            });
                            return result;
                          }
                        }
                      }
                    },
                    {
                      extend: 'excel',
                      text: `<span class="d-flex align-items-center"><i class="icon-base ti tabler-upload me-1"></i>Excel</span>`,
                      className: 'dropdown-item',
                      exportOptions: {
                        columns: [2, 3, 4, 5, 6, 7],
                        format: {
                          body: function (inner, coldex, rowdex) {
                            if (inner.length <= 0) return inner;
                            const el = new DOMParser().parseFromString(inner, 'text/html').body.childNodes;
                            let result = '';
                            el.forEach(item => {
                              if (item.classList && item.classList.contains('user-name')) {
                                result += item.lastChild.firstChild.textContent;
                              } else {
                                result += item.textContent || item.innerText || '';
                              }
                            });
                            return result;
                          }
                        }
                      }
                    },
                    {
                      extend: 'pdf',
                      text: `<span class="d-flex align-items-center"><i class="icon-base ti tabler-file-text me-1"></i>Pdf</span>`,
                      className: 'dropdown-item',
                      exportOptions: {
                        columns: [2, 3, 4, 5, 6, 7],
                        format: {
                          body: function (inner, coldex, rowdex) {
                            if (inner.length <= 0) return inner;
                            const el = new DOMParser().parseFromString(inner, 'text/html').body.childNodes;
                            let result = '';
                            el.forEach(item => {
                              if (item.classList && item.classList.contains('user-name')) {
                                result += item.lastChild.firstChild.textContent;
                              } else {
                                result += item.textContent || item.innerText || '';
                              }
                            });
                            return result;
                          }
                        }
                      }
                    },
                    {
                      extend: 'copy',
                      text: `<i class="icon-base ti tabler-copy me-1"></i>Copy`,
                      className: 'dropdown-item',
                      exportOptions: {
                        columns: [2, 3, 4, 5, 6, 7],
                        format: {
                          body: function (inner, coldex, rowdex) {
                            if (inner.length <= 0) return inner;
                            const el = new DOMParser().parseFromString(inner, 'text/html').body.childNodes;
                            let result = '';
                            el.forEach(item => {
                              if (item.classList && item.classList.contains('user-name')) {
                                result += item.lastChild.firstChild.textContent;
                              } else {
                                result += item.textContent || item.innerText || '';
                              }
                            });
                            return result;
                          }
                        }
                      }
                    }
                  ]
                },
                {
                  text: '<i class="icon-base ti tabler-plus icon-sm me-0 me-sm-2"></i><span class="d-none d-sm-inline-block">Add Withdrawal Request</span>',
                  className: `add-new btn btn-primary`,
                  attr: {
                    'data-bs-toggle': 'offcanvas',
                    'data-bs-target': '#offcanvasAddRequest'
                  },
                  action: function () {
                    // Reset form when opening Add modal/offcanvas
                    const form = document.querySelector('#offcanvasAddRequest form'); // assuming your form is inside the offcanvas
                    if (form instanceof HTMLFormElement) {
                      form.reset(); // now this works
                    } else {
                      console.warn('Form element not found inside #offcanvasAddRequest');
                    }
                  }
                }
              ]
            }
          ]
        },
        bottomStart: {
          rowClass: 'row mx-3 justify-content-between',
          features: ['info']
        },
        bottomEnd: 'paging'
      },
      language: {
        paginate: {
          next: '<i class="icon-base ti tabler-chevron-right scaleX-n1-rtl icon-18px"></i>',
          previous: '<i class="icon-base ti tabler-chevron-left scaleX-n1-rtl icon-18px"></i>',
          first: '<i class="icon-base ti tabler-chevrons-left scaleX-n1-rtl icon-18px"></i>',
          last: '<i class="icon-base ti tabler-chevrons-right scaleX-n1-rtl icon-18px"></i>'
        }
      },
      // For responsive popup
      responsive: {
        details: {
          display: DataTable.Responsive.display.modal({
            header: function (row) {
              const data = row.data();
              return 'Details of ' + data['customer'];
            }
          }),
          type: 'column',
          renderer: function (api, rowIdx, columns) {
            const data = columns
              .map(function (col) {
                return col.title !== '' // Do not show row in modal popup if title is blank (for check box)
                  ? `<tr data-dt-row="${col.rowIndex}" data-dt-column="${col.columnIndex}">
                      <td>${col.title}:</td>
                      <td>${col.data}</td>
                    </tr>`
                  : '';
              })
              .join('');

            if (data) {
              const div = document.createElement('div');
              div.classList.add('table-responsive');
              const table = document.createElement('table');
              div.appendChild(table);
              table.classList.add('table');
              const tbody = document.createElement('tbody');
              tbody.innerHTML = data;
              table.appendChild(tbody);
              return div;
            }
            return false;
          }
        }
      },
      initComplete: function (settings, json) {
        // Remove btn-secondary from export buttons
        document.querySelectorAll('.dt-buttons .btn').forEach(btn => {
          btn.classList.remove('btn-secondary');

          if (authTYPE !== 'Store') {
            $('.add-new').addClass('d-none');
          }
          if (authTYPE === 'Store') {
            $('.wallet_status').addClass('d-none');
            $('.customer').addClass('d-none');
          }
        });
      }
    });

    $('#bs-rangepicker-range, #WalletStatus, #Customer, #userType').on('change', function () {
      dt_wallet.ajax.reload();
    });
    const bsRangePicker = $('#bs-rangepicker-range');
    bsRangePicker.attr('autocomplete', 'off');
    // Apply event: update input and redraw DataTable
    bsRangePicker.on('apply.daterangepicker', function (ev, picker) {
      $(this).val(picker.startDate.format('YYYY-MM-DD') + ' to ' + picker.endDate.format('YYYY-MM-DD'));
      dt_wallet.ajax.reload();
    });
    // Cancel event: clear input and redraw
    bsRangePicker.on('cancel.daterangepicker', function (ev, picker) {
      $(this).val('');
      dt_wallet.ajax.reload();
    });
    // Fixed header
    if (window.Helpers.isNavbarFixed()) {
      const navHeight = document.getElementById('layout-navbar').offsetHeight;
      new DataTable.FixedHeader(dt_wallet).headerOffset(navHeight);
    } else {
      new DataTable.FixedHeader(dt_wallet);
    }

    //? The 'delete-record' class is necessary for the functionality of the following code.
    document.addEventListener('click', function (e) {
      if (e.target.classList.contains('delete-record')) {
        dt_wallet.row(e.target.closest('tr')).remove().draw();
        const modalEl = document.querySelector('.dtr-bs-modal');
        if (modalEl && modalEl.classList.contains('show')) {
          const modal = bootstrap.Modal.getInstance(modalEl);
          modal?.hide();
        }
      }
    });
  }

  // Filter form control to default size
  // ? setTimeout used for wallet-list table initialization
  setTimeout(() => {
    const elementsToModify = [
      { selector: '.dt-buttons .btn', classToRemove: 'btn-secondary' },
      { selector: '.dt-search .form-control', classToRemove: 'form-control-sm' },
      { selector: '.dt-length .form-select', classToRemove: 'form-select-sm', classToAdd: 'ms-0' },
      { selector: '.dt-length', classToAdd: 'mb-md-6 mb-0' },
      {
        selector: '.dt-layout-end',
        classToRemove: 'justify-content-between',
        classToAdd: 'd-flex gap-md-4 justify-content-md-between justify-content-center gap-2 flex-wrap'
      },
      { selector: '.dt-buttons', classToAdd: 'd-flex gap-4 mb-md-0 mb-4' },
      { selector: '.dt-layout-table', classToRemove: 'row mt-2' },
      { selector: '.dt-layout-full', classToRemove: 'col-md col-12', classToAdd: 'table-responsive' }
    ];

    // Delete record
    elementsToModify.forEach(({ selector, classToRemove, classToAdd }) => {
      document.querySelectorAll(selector).forEach(element => {
        if (classToRemove) {
          classToRemove.split(' ').forEach(className => element.classList.remove(className));
        }
        if (classToAdd) {
          classToAdd.split(' ').forEach(className => element.classList.add(className));
        }
      });
    });
  }, 100);
  // validating form and updating user's data
  const addNewRequestForm = document.getElementById('addNewRequestForm');

  // user form validation
  if (addNewRequestForm) {
    const fv = FormValidation.formValidation(addNewRequestForm, {
      fields: {
        amount: {
          validators: {
            notEmpty: {
              message: 'Please enter amount'
            },
            callback: {
              message: 'Amount cannot exceed the maximum allowed',
              callback: function (input) {
                const max = parseFloat(input.getAttribute('data-max'));
                const value = parseFloat(input.value);

                if (isNaN(value) || isNaN(max)) {
                  return true; // skip validation if not a number
                }
                return value <= max;
              }
            }
          }
        }
      },
      plugins: {
        trigger: new FormValidation.plugins.Trigger(),
        bootstrap5: new FormValidation.plugins.Bootstrap5({
          // Use this for enabling/changing valid/invalid class
          eleValidClass: '',
          rowSelector: function (field, ele) {
            // field is the field name & ele is the field element
            return '.mb-6';
          }
        }),
        submitButton: new FormValidation.plugins.SubmitButton(),
        autoFocus: new FormValidation.plugins.AutoFocus()
      }
    }).on('core.form.valid', function () {
      // adding or updating user when form successfully validate
      const formData = new FormData(addNewRequestForm);
      const formDataObj = {};

      // Convert FormData to URL-encoded string
      formData.forEach((value, key) => {
        formDataObj[key] = value;
      });

      const searchParams = new URLSearchParams();
      for (const [key, value] of Object.entries(formDataObj)) {
        searchParams.append(key, value);
      }

      fetch(`${baseURL}/withdrawal_requests`, {
        method: 'POST',
        headers: {
          'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
          'Content-Type': 'application/x-www-form-urlencoded'
        },
        body: searchParams.toString()
      })
        .then(async response => {
          const text = await response.text();
          const data = JSON.parse(text);
          if (!response.ok) throw new Error(data.message || 'Something went wrong');
          if (dt_wallet_table) {
            const table = new DataTable(dt_wallet_table);
            table.order([2, 'desc']).draw(false); // Column 0 ordered descending
          }
          if (data.data && data.data.balance) {
            $('#walletAmount').text(data.data.balance);
          }

          // Hide offcanvas
          const offcanvasInstance = bootstrap.Offcanvas.getInstance(offCanvasForm);
          offcanvasInstance && offcanvasInstance.hide();
          if (data.status == 200) {
            const type = data.status == 200 ? 'success' : 'warning';
            // sweetalert
            Swal.fire({
              icon: type,
              title: 'Wallet 💰',
              text: `${data.message}`,
              customClass: {
                confirmButton: 'btn btn-success'
              }
            });
          } else {
            window.showToast({
              title: 'Wallet 💰',
              message: `${data.message}`,
              type: 'bg-danger',
              animation: 'animate__fadeInUp',
              time: 'Just now',
              delay: 3000
            });
          }
        })
        .catch(async err => {
          let message = 'Something went wrong';
          if (err instanceof Response) {
            const text = await err.text();
            try {
              const res = JSON.parse(text);
              message = res.message || message;
            } catch {
              message = text || message;
            }
          } else if (err.message) {
            message = err.message;
          }
          window.showToast({
            title: 'Wallet 💰',
            message: message,
            type: 'bg-danger',
            animation: 'animate__fadeInUp',
            time: 'Just now',
            delay: 3000
          });
        });
    });

    // clearing form data when offcanvas hidden
    offCanvasForm.addEventListener('hidden.bs.offcanvas', function () {
      fv.resetForm(true);
    });
  }
});
