/**
 * Page User management
 */

'use strict';

// Datatable (js)
document.addEventListener('DOMContentLoaded', function (e) {
  let borderColor, bodyBg, headingColor;
  let countryDrop = null;
  borderColor = config.colors.borderColor;
  bodyBg = config.colors.bodyBg;
  headingColor = config.colors.headingColor;

  // Variable declaration for table
  const dt_user_table = document.querySelector('.datatables-users'),
    userView = baseUrl + 'admin/users',
    offCanvasForm = document.getElementById('offcanvasAddUser');
  var statusObj = {
    0: { title: 'Inactive', class: 'bg-label-primary' },
    1: { title: 'Active', class: 'bg-label-success' },
    2: { title: 'Deleted', class: 'bg-label-danger' }
  };
  // Select2 initialization
  var select2 = $('.select2');
  if (select2.length) {
    var $this = select2;
    $this.wrap('<div class="position-relative"></div>').select2({
      placeholder: 'Select Country',
      dropdownParent: $this.parent()
    });
  }

  // ajax setup
  $.ajaxSetup({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
  });

  // Users datatable
  if (dt_user_table) {
    const dt_user = new DataTable(dt_user_table, {
      processing: true,
      serverSide: true,
      ajax: {
        url: baseUrl + 'admin/users/user-list',
        dataSrc: function (json) {
          json.recordsTotal = Number(json.recordsTotal) || 0;
          json.recordsFiltered = Number(json.recordsFiltered) || 0;
          json.data = Array.isArray(json.data) ? json.data : [];
          return json.data;
        },
        data: function (d) {
          const verified = $('#filter_verified').val();
          const status = $('#filter_status').val();
          d.verified = verified === '' ? null : verified; // backend handles as string "1"/"0"
          d.status = status === '' ? null : status;
        }
      },
      columns: [
        // columns according to JSON
        { data: 'id' },
        { data: 'id' },
        { data: 'name' },
        { data: 'email' },
        { data: 'phone' },
        { data: 'action' }
      ],
      drawCallback: function () {
        this.api()
          .table()
          .rows({ page: 'current' })
          .every(function () {
            const data = this.data();
            const ratingEl = document.getElementById(`rating-${data.id}`);
            let r = parseInt(window.Helpers.getCssVar('gray-200', true).slice(1, 3), 16);
            let g = parseInt(window.Helpers.getCssVar('gray-200', true).slice(3, 5), 16);
            let b = parseInt(window.Helpers.getCssVar('gray-200', true).slice(5, 7), 16);
            if (ratingEl && !ratingEl.dataset.initialized) {
              new Raty(ratingEl, {
                score: data.rating ?? 0,
                readOnly: true,
                precision: true, // enables precise score handling (also enables half)
                half: true, // show half stars
                halfShow: true,
                starOn:
                  "data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' width='16' %3E%3Cpath fill='%23FFD700' d='M21.947 9.179a1 1 0 0 0-.868-.676l-5.701-.453l-2.467-5.461a.998.998 0 0 0-1.822-.001L8.622 8.05l-5.701.453a1 1 0 0 0-.619 1.713l4.213 4.107l-1.49 6.452a1 1 0 0 0 1.53 1.057L12 18.202l5.445 3.63a1.001 1.001 0 0 0 1.517-1.106l-1.829-6.4l4.536-4.082c.297-.268.406-.686.278-1.065'/%3E%3C/svg%3E",
                starOff: `data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' width='16' %3E%3Cpath fill='rgb(${r},${g},${b})' d='M21.947 9.179a1 1 0 0 0-.868-.676l-5.701-.453l-2.467-5.461a.998.998 0 0 0-1.822-.001L8.622 8.05l-5.701.453a1 1 0 0 0-.619 1.713l4.213 4.107l-1.49 6.452a1 1 0 0 0 1.53 1.057L12 18.202l5.445 3.63a1.001 1.001 0 0 0 1.517-1.106l-1.829-6.4l4.536-4.082c.297-.268.406-.686.278-1.065'/%3E%3C/svg%3E`,
                starHalf:
                  "data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' width='16'%3E%3Cdefs%3E%3CclipPath id='halfStar'%3E%3Crect x='0' y='0' width='12' height='24'/%3E%3C/clipPath%3E%3C/defs%3E%3Cpath fill='%23FFD700' clip-path='url(%23halfStar)' d='M21.947 9.179a1 1 0 0 0-.868-.676l-5.701-.453l-2.467-5.461a.998.998 0 0 0-1.822-.001L8.622 8.05l-5.701.453a1 1 0 0 0-.619 1.713l4.213 4.107l-1.49 6.452a1 1 0 0 0 1.53 1.057L12 18.202l5.445 3.63a1.001 1.001 0 0 0 1.517-1.106l-1.829-6.4l4.536-4.082c.297-.268.406-.686.278-1.065'/%3E%3Cpath fill='none' stroke='%23FFD700' stroke-width='0' d='M0 0h24v24H0z'/%3E%3C/svg%3E"
              }).init();
              ratingEl.dataset.initialized = true;
            }
          });
      },
      columnDefs: [
        {
          // For Responsive
          className: 'control',
          searchable: false,
          orderable: false,
          responsivePriority: 2,
          targets: 0,
          render: function (data, type, full, meta) {
            return '';
          }
        },
        {
          searchable: false,
          orderable: false,
          targets: 1,
          render: function (data, type, full, meta) {
            return meta.row + meta.settings._iDisplayStart + 1;
          }
        },
        {
          // User full name
          targets: 2,
          responsivePriority: 4,
          render: function (data, type, full, meta) {
            const { name } = full; // Destructuring to get 'name' from the 'full' object
            const imageUrl = full.profile_photo_path ? `${baseUrl}storage/${full.profile_photo_path}` : ``;
            if (imageUrl) {
              var avatar = `<img src="${imageUrl}" alt="${full.name}" class="rounded-circle">`;
            } else {
              // For Avatar badge
              const stateNum = Math.floor(Math.random() * 6);
              const states = ['success', 'danger', 'warning', 'info', 'dark', 'primary', 'secondary'];
              const state = states[stateNum];

              // Extract initials from the name
              const initials = (name.match(/\b\w/g) || []).shift() + (name.match(/\b\w/g) || []).pop();
              const initialsUpper = initials.toUpperCase();

              // Create avatar badge using template literals
              var avatar = `<span class="avatar-initial rounded-circle bg-label-${state}">${initialsUpper}</span>`;
            }
            // Create full output for row using template literals
            const rowOutput = `
            <div class="d-flex justify-content-start align-items-center user-name">
              <div class="avatar-wrapper">
                <div class="avatar avatar-sm me-4">
                  ${avatar}
                </div>
              </div>
              <div class="d-flex flex-column">
                <a href="${userView}/${full.id}" class="text-truncate text-heading">
                  <span class="fw-medium">
                    ${name}<br>
                    ${
                      full['wallet']
                        ? `<i class="icon-base ti tabler-wallet text-primary"></i>
                        ${full['currency'] || full['default_currency']} ${full['wallet']}`
                        : ''
                    }
                  </span>
                </a> <div class="rating read-only-ratings raty d-flex" data-score="${full.rating ?? 0}" id="rating-${full.id}"></small></div>
              </div>
            </div>
          `;

            // Return the final output as HTML string
            return rowOutput;
          }
        },
        {
          // User email
          targets: 3,
          render: function (data, type, full, meta) {
            const email = full['email'];
            const dial = full['dial_code'] ? `${full.dial_code} ` : '';
            // Check verification
            const emailIcon = full['email_verified_at']
              ? '<i class="icon-base ti tabler-mail-check text-success me-1" title="Verified"></i>'
              : '<i class="icon-base ti tabler-mail-exclamation text-danger me-1" title="Not Verified"></i>';
            return (
              '<span class="user-email">' +
              emailIcon +
              email +
              '</span>' +
              (full['phone'] ? '<br><i class="icon-base ti tabler-device-mobile"></i> ' + dial + full['phone'] : '')
            );
          }
        },
        {
          // email verify
          targets: 4,
          className: 'text-center',
          render: function (data, type, full, meta) {
            const checked = full.status === 1 ? 'checked' : '';
            if (full.edit) {
              var status = `
              <label class="switch switch-square">
                <input type="checkbox" class="switch-input changestatus" ${checked}
                  data-id="${full.id}" data-status="${full.status}" data-url="${full['status-url']}">
                <span class="switch-toggle-slider">
                  <span class="switch-on"><i class="icon-base ti tabler-check"></i></span>
                  <span class="switch-off"><i class="icon-base ti tabler-x"></i></span>
                </span>
                <span class="switch-label"></span>
              </label>`;
            } else {
              var status = `<span class="badge ${statusObj[full.status].class}">${statusObj[full.status].title}</span>`;
            }
            const verified = full['is_verified'];
            return `${status}${
              verified
                ? '<i class="icon-base ti fs-4 tabler-shield-check text-success"></i>'
                : '<i class="icon-base ti fs-4 tabler-shield-x text-danger" ></i>'
            }`;
          }
        },
        {
          // Actions
          targets: -1,
          title: 'Actions',
          searchable: false,
          orderable: false,
          render: function (data, type, full, meta) {
            let actions = '<div class="d-flex align-items-center gap-1">';

            if (full.edit) {
              actions += `<button class="btn btn-sm btn-icon edit-record" data-id="${full['id']}" data-bs-toggle="offcanvas" data-bs-target="#offcanvasAddUser">
      <i class="icon-base ti tabler-edit icon-22px"></i>
    </button>`;
            }

            if (full.delete) {
              actions += `<button class="btn btn-sm btn-icon delete-record" data-url="${full['delete-url']}" data-id="${full.id}" data-title="${full.name}">
      <i class="icon-base ti tabler-trash icon-22px"></i>
    </button>`;
            }

            actions += `<button class="btn btn-sm btn-icon dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
            <i class="icon-base ti tabler-dots-vertical icon-22px"></i>
          </button>
          <div class="dropdown-menu dropdown-menu-end m-0">
            <a href="${userView}/${full.id}" class="dropdown-item"><i class="icon-base ti tabler-eye icon-md"></i> View</a>
        ${
          full.edit
            ? `
                        <a href="javascript:;" class="dropdown-item set-password"
                        data-url="${full['url']}"
                        data-id="${full['id']}"
                        data-title="${full['name']}">
                        <i class="icon-base ti tabler-key icon-md"></i> Set Password
                      </a>`
            : ''
        }
          </div>
          </div>`;

            return actions;
          }
        }
      ],
      order: [[0, 'desc']],
      layout: {
        topStart: {
          rowClass: 'row m-3 my-0 justify-content-between',
          features: [
            {
              pageLength: {
                menu: [10, 20, 50, 70, 100],
                text: '_MENU_'
              }
            }
          ]
        },
        topEnd: {
          features: [
            {
              search: {
                placeholder: 'Search User',
                text: '_INPUT_'
              }
            },
            {
              buttons: [
                {
                  extend: 'collection',
                  className: 'btn btn-label-secondary dropdown-toggle',
                  text: '<i class="icon-base ti tabler-upload me-2 icon-sm"></i>Export',
                  buttons: [
                    {
                      extend: 'print',
                      title: 'Users',
                      text: '<i class="icon-base ti tabler-printer me-2" ></i>Print',
                      className: 'dropdown-item',
                      exportOptions: {
                        columns: [1, 2, 3, 4, 5],
                        // prevent avatar to be print
                        format: {
                          body: function (inner, coldex, rowdex) {
                            if (inner.length <= 0) return inner;

                            // Check if inner is HTML content
                            if (typeof inner === 'string' && inner.indexOf('<') > -1) {
                              const parser = new DOMParser();
                              const doc = parser.parseFromString(inner, 'text/html');

                              // Get all text content
                              let text = '';

                              // Handle specific elements
                              const userNameElements = doc.querySelectorAll('.user-name');
                              if (userNameElements.length > 0) {
                                userNameElements.forEach(el => {
                                  // Get text from nested structure
                                  const nameText =
                                    el.querySelector('.fw-medium')?.textContent ||
                                    el.querySelector('.d-block')?.textContent ||
                                    el.textContent;
                                  text += nameText.trim() + ' ';
                                });
                              } else {
                                // Get regular text content
                                text = doc.body.textContent || doc.body.innerText;
                              }

                              return text.trim();
                            }

                            return inner;
                          }
                        }
                      },
                      customize: function (win) {
                        win.document.body.style.color = config.colors.headingColor;
                        win.document.body.style.borderColor = config.colors.borderColor;
                        win.document.body.style.backgroundColor = config.colors.bodyBg;
                        const table = win.document.body.querySelector('table');
                        table.classList.add('compact');
                        table.style.color = 'inherit';
                        table.style.borderColor = 'inherit';
                        table.style.backgroundColor = 'inherit';
                      }
                    },
                    {
                      extend: 'csv',
                      title: 'Users',
                      text: '<i class="icon-base ti tabler-file-text me-2" ></i>Csv',
                      className: 'dropdown-item',
                      exportOptions: {
                        columns: [1, 2, 3, 4, 5],
                        format: {
                          body: function (inner, coldex, rowdex) {
                            if (inner.length <= 0) return inner;

                            // Parse HTML content
                            const parser = new DOMParser();
                            const doc = parser.parseFromString(inner, 'text/html');

                            let text = '';

                            // Handle user-name elements specifically
                            const userNameElements = doc.querySelectorAll('.user-name');
                            if (userNameElements.length > 0) {
                              userNameElements.forEach(el => {
                                // Get text from nested structure - try different selectors
                                const nameText =
                                  el.querySelector('.fw-medium')?.textContent ||
                                  el.querySelector('.d-block')?.textContent ||
                                  el.textContent;
                                text += nameText.trim() + ' ';
                              });
                            } else {
                              // Handle other elements (status, role, etc)
                              text = doc.body.textContent || doc.body.innerText;
                            }

                            return text.trim();
                          }
                        }
                      }
                    },
                    {
                      extend: 'excel',
                      text: '<i class="icon-base ti tabler-file-spreadsheet me-2"></i>Excel',
                      className: 'dropdown-item',
                      exportOptions: {
                        columns: [1, 2, 3, 4, 5],
                        format: {
                          body: function (inner, coldex, rowdex) {
                            if (inner.length <= 0) return inner;

                            // Parse HTML content
                            const parser = new DOMParser();
                            const doc = parser.parseFromString(inner, 'text/html');

                            let text = '';

                            // Handle user-name elements specifically
                            const userNameElements = doc.querySelectorAll('.user-name');
                            if (userNameElements.length > 0) {
                              userNameElements.forEach(el => {
                                // Get text from nested structure - try different selectors
                                const nameText =
                                  el.querySelector('.fw-medium')?.textContent ||
                                  el.querySelector('.d-block')?.textContent ||
                                  el.textContent;
                                text += nameText.trim() + ' ';
                              });
                            } else {
                              // Handle other elements (status, role, etc)
                              text = doc.body.textContent || doc.body.innerText;
                            }

                            return text.trim();
                          }
                        }
                      }
                    },
                    {
                      extend: 'pdf',
                      title: 'Users',
                      text: '<i class="icon-base ti tabler-file-code-2 me-2"></i>Pdf',
                      className: 'dropdown-item',
                      exportOptions: {
                        columns: [1, 2, 3, 4, 5],
                        format: {
                          body: function (inner, coldex, rowdex) {
                            if (inner.length <= 0) return inner;

                            // Parse HTML content
                            const parser = new DOMParser();
                            const doc = parser.parseFromString(inner, 'text/html');

                            let text = '';

                            // Handle user-name elements specifically
                            const userNameElements = doc.querySelectorAll('.user-name');
                            if (userNameElements.length > 0) {
                              userNameElements.forEach(el => {
                                // Get text from nested structure - try different selectors
                                const nameText =
                                  el.querySelector('.fw-medium')?.textContent ||
                                  el.querySelector('.d-block')?.textContent ||
                                  el.textContent;
                                text += nameText.trim() + ' ';
                              });
                            } else {
                              // Handle other elements (status, role, etc)
                              text = doc.body.textContent || doc.body.innerText;
                            }

                            return text.trim();
                          }
                        }
                      }
                    },
                    {
                      extend: 'copy',
                      title: 'Users',
                      text: '<i class="icon-base ti tabler-copy me-2" ></i>Copy',
                      className: 'dropdown-item',
                      exportOptions: {
                        columns: [1, 2, 3, 4, 5],
                        format: {
                          body: function (inner, coldex, rowdex) {
                            if (inner.length <= 0) return inner;

                            // Parse HTML content
                            const parser = new DOMParser();
                            const doc = parser.parseFromString(inner, 'text/html');

                            let text = '';

                            // Handle user-name elements specifically
                            const userNameElements = doc.querySelectorAll('.user-name');
                            if (userNameElements.length > 0) {
                              userNameElements.forEach(el => {
                                // Get text from nested structure - try different selectors
                                const nameText =
                                  el.querySelector('.fw-medium')?.textContent ||
                                  el.querySelector('.d-block')?.textContent ||
                                  el.textContent;
                                text += nameText.trim() + ' ';
                              });
                            } else {
                              // Handle other elements (status, role, etc)
                              text = doc.body.textContent || doc.body.innerText;
                            }

                            return text.trim();
                          }
                        }
                      }
                    }
                  ]
                },
                {
                  text: '<i class="icon-base ti tabler-plus icon-sm me-0 me-sm-2"></i><span class="d-none d-sm-inline-block">Add New User</span>',
                  className: `add-new btn btn-primary`,
                  attr: {
                    'data-bs-toggle': 'offcanvas',
                    'data-bs-target': '#offcanvasAddUser'
                  },
                  action: function () {
                    // Reset form when opening Add modal/offcanvas
                    const form = document.querySelector('#offcanvasAddUser form'); // assuming your form is inside the offcanvas
                    if (form instanceof HTMLFormElement) {
                      form.reset(); // now this works
                    } else {
                      console.warn('Form element not found inside #offcanvasAddUser');
                    }
                  }
                }
              ]
            }
          ]
        },
        bottomStart: {
          rowClass: 'row mx-3 justify-content-between',
          features: [
            {
              info: {
                text: 'Showing _START_ to _END_ of _TOTAL_ entries'
              }
            }
          ]
        },
        bottomEnd: 'paging'
      },
      displayLength: 10,
      language: {
        paginate: {
          first: '<i class="icon-base ti tabler-chevrons-left scaleX-n1-rtl icon-18px"></i>',
          last: '<i class="icon-base ti tabler-chevrons-right scaleX-n1-rtl icon-18px"></i>',
          next: '<i class="icon-base ti tabler-chevron-right scaleX-n1-rtl icon-18px"></i>',
          previous: '<i class="icon-base ti tabler-chevron-left scaleX-n1-rtl icon-18px"></i>'
        }
      },
      // For responsive popup
      responsive: {
        details: {
          display: DataTable.Responsive.display.modal({
            header: function (row) {
              const data = row.data();
              return 'Details of ' + data['name'];
            }
          }),
          type: 'column',
          renderer: function (api, rowIdx, columns) {
            const data = columns
              .map(function (col) {
                return col.title !== '' // Do not show row in modal popup if title is blank (for check box)
                  ? `<tr data-dt-row="${col.rowIndex}" data-dt-column="${col.columnIndex}">
                      <td>${col.title}:</td>
                      <td>${col.data}</td>
                    </tr>`
                  : '';
              })
              .join('');

            if (data) {
              const div = document.createElement('div');
              div.classList.add('table-responsive');
              const table = document.createElement('table');
              div.appendChild(table);
              table.classList.add('table');
              const tbody = document.createElement('tbody');
              tbody.innerHTML = data;
              table.appendChild(tbody);
              return div;
            }
            return false;
          }
        }
      },
      initComplete: function (settings, json) {
        // Remove btn-secondary from export buttons
        document.querySelectorAll('.dt-buttons .btn').forEach(btn => {
          btn.classList.remove('btn-secondary');
          if (!json.create) {
            $('.add-new').addClass('d-none');
          }
        });
      }
    });
    // Refresh table on filter change
    $('#filter_verified, #filter_status').on('change', function () {
      dt_user.draw();
    });
    // Fixed header
    if (window.Helpers.isNavbarFixed()) {
      const navHeight = document.getElementById('layout-navbar').offsetHeight;
      new DataTable.FixedHeader(dt_user).headerOffset(navHeight);
    } else {
      new DataTable.FixedHeader(dt_user);
    }

    // Delete Record
    document.addEventListener('click', function (e) {
      if (e.target.closest('.delete-record')) {
        const deleteBtn = e.target.closest('.delete-record');
        const user_id = deleteBtn.dataset.id;
        const dtrModal = document.querySelector('.dtr-bs-modal.show');

        // hide responsive modal in small screen
        if (dtrModal) {
          const bsModal = bootstrap.Modal.getInstance(dtrModal);
          bsModal.hide();
        }

        // sweetalert for confirmation of delete
        Swal.fire({
          title: 'Are you sure?',
          text: "You won't be able to revert this!",
          icon: 'warning',
          showCancelButton: true,
          confirmButtonText: 'Yes, delete it!',
          customClass: {
            confirmButton: 'btn btn-primary me-3',
            cancelButton: 'btn btn-label-secondary'
          },
          buttonsStyling: false
        }).then(function (result) {
          if (result.value) {
            // delete the data
            fetch(`${baseURL}/users/${user_id}`, {
              method: 'DELETE',
              headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Content-Type': 'application/json'
              }
            })
              .then(response => {
                if (response.ok) {
                  dt_user.draw();

                  // success sweetalert
                  Swal.fire({
                    icon: 'success',
                    title: 'Deleted!',
                    text: 'The user has been deleted!',
                    customClass: {
                      confirmButton: 'btn btn-success'
                    }
                  });
                } else {
                  throw new Error('Delete failed');
                }
              })
              .catch(error => {
                console.log(error);
              });
          }
          /*           else if (result.dismiss === Swal.DismissReason.cancel) {
            Swal.fire({
              title: 'Cancelled',
              text: 'The User is not deleted!',
              icon: 'error',
              customClass: {
                confirmButton: 'btn btn-success'
              }
            });
          } */
        });
      }
    });

    // edit record
    document.addEventListener('click', function (e) {
      if (e.target.closest('.edit-record')) {
        const editBtn = e.target.closest('.edit-record');
        const user_id = editBtn.dataset.id;
        const dtrModal = document.querySelector('.dtr-bs-modal.show');
        // hide responsive modal in small screen
        if (dtrModal) {
          const bsModal = bootstrap.Modal.getInstance(dtrModal);
          bsModal.hide();
        }

        // changing the title of offcanvas
        document.getElementById('offcanvasAddUserLabel').innerHTML = 'Edit User';
        document.getElementById('add-user-password')?.closest('.form-group')?.classList.add('d-none');
        // get data
        fetch(`${baseURL}/users/${user_id}/edit`)
          .then(response => response.json())
          .then(data => {
            document.getElementById('user_id').value = data.id;
            document.getElementById('add-user-fullname').value = data.name;
            document.getElementById('add-user-email').value = data.email;
            document.getElementById('add-user-contact').value = data.phone;
            document.getElementById('country_iso').value = data.dial_code_iso;
            document.getElementById('dial_code').value = data.dial_code;

            // Set phone and country info
            if (!countryDrop) {
              countryDrop = initCountryDrop('#add-user-contact', '#dial_code', '#country_iso');
            }
            if (countryDrop) {
              const fullNumber = data.phone || ''; // +91xxxxxxxxxx
              const iso = data.dial_code_iso || 'IN'; // IN
              countryDrop.set(fullNumber, iso);
            }
            // Update hidden fields manually
            const dialInput = document.getElementById('dial_code');
            const isoInput = document.getElementById('country_iso');
            if (dialInput) dialInput.value = data.dial_code || '';
            if (isoInput) isoInput.value = data.dial_code_iso || '';
          });
      }
    });

    document.addEventListener('DOMContentLoaded', function () {
      initCountryDrop('#phone', '#dial_code', '#country_iso');
    });
    // changing the title
    const addNewBtn = document.querySelector('.add-new');
    if (addNewBtn) {
      addNewBtn.addEventListener('click', function () {
        if (!countryDrop) {
          countryDrop = initCountryDrop('#add-user-contact', '#dial_code', '#country_iso');
        }
        if (countryDrop) countryDrop.reset('IN');
        document.getElementById('add-user-contact').value = '';
        document.getElementById('user_id').value = '';
        document.getElementById('user_id').value = ''; //resetting input field
        document.getElementById('offcanvasAddUserLabel').innerHTML = 'Add User';
        document.getElementById('add-user-password')?.closest('.form-group')?.classList.remove('d-none');
      });
    }

    // Filter form control to default size
    setTimeout(() => {
      const elementsToModify = [
        { selector: '.dt-buttons .btn', classToRemove: 'btn-secondary' },
        { selector: '.dt-search .form-control', classToRemove: 'form-control-sm' },
        { selector: '.dt-length .form-select', classToRemove: 'form-select-sm', classToAdd: 'ms-0' },
        { selector: '.dt-length', classToAdd: 'mb-md-6 mb-0' },
        {
          selector: '.dt-layout-end',
          classToRemove: 'justify-content-between',
          classToAdd: 'd-flex gap-md-4 justify-content-md-between justify-content-center gap-2 flex-wrap'
        },
        { selector: '.dt-buttons', classToAdd: 'd-flex gap-4 mb-md-0 mb-4' },
        { selector: '.dt-layout-table', classToRemove: 'row mt-2' },
        { selector: '.dt-layout-full', classToRemove: 'col-md col-12', classToAdd: 'table-responsive' }
      ];

      // Delete record
      elementsToModify.forEach(({ selector, classToRemove, classToAdd }) => {
        document.querySelectorAll(selector).forEach(element => {
          if (classToRemove) {
            classToRemove.split(' ').forEach(className => element.classList.remove(className));
          }
          if (classToAdd) {
            classToAdd.split(' ').forEach(className => element.classList.add(className));
          }
        });
      });
    }, 100);
  }

  // validating form and updating user's data
  const addNewUserForm = document.getElementById('addNewUserForm');

  // user form validation
  if (addNewUserForm) {
    const fv = FormValidation.formValidation(addNewUserForm, {
      fields: {
        name: {
          validators: {
            notEmpty: {
              message: 'Please enter fullname'
            }
          }
        },
        email: {
          validators: {
            notEmpty: {
              message: 'Please enter your email'
            },
            emailAddress: {
              message: 'The value is not a valid email address'
            }
          }
        },
        phone: {
          validators: {
            notEmpty: {
              message: 'Please enter your contact'
            }
          }
        }
      },
      plugins: {
        trigger: new FormValidation.plugins.Trigger(),
        bootstrap5: new FormValidation.plugins.Bootstrap5({
          // Use this for enabling/changing valid/invalid class
          eleValidClass: '',
          rowSelector: function (field, ele) {
            // field is the field name & ele is the field element
            return '.mb-6';
          }
        }),
        submitButton: new FormValidation.plugins.SubmitButton(),
        autoFocus: new FormValidation.plugins.AutoFocus()
      }
    }).on('core.form.valid', function () {
      // adding or updating user when form successfully validate
      const formData = new FormData(addNewUserForm);
      const formDataObj = {};

      // Convert FormData to URL-encoded string
      formData.forEach((value, key) => {
        formDataObj[key] = value;
      });

      const searchParams = new URLSearchParams();
      for (const [key, value] of Object.entries(formDataObj)) {
        searchParams.append(key, value);
      }

      fetch(`${baseURL}/users`, {
        method: 'POST',
        headers: {
          'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
          'Content-Type': 'application/x-www-form-urlencoded'
        },
        body: searchParams.toString()
      })
        .then(async response => {
          const text = await response.text();
          const data = JSON.parse(text);
          if (!response.ok) throw new Error(data.message || 'Something went wrong');
          if (dt_user_table) {
            const table = new DataTable(dt_user_table);
            table.order([0, 'desc']).draw(false); // Column 0 ordered descending
          }

          // Hide offcanvas
          const offcanvasInstance = bootstrap.Offcanvas.getInstance(offCanvasForm);
          offcanvasInstance && offcanvasInstance.hide();
          const type = data.status == 200 ? 'success' : 'warning';
          // sweetalert
          Swal.fire({
            icon: type,
            title: `Users 🙍‍♂️`,
            text: `${data.message}`,
            customClass: {
              confirmButton: 'btn btn-success'
            }
          });
        })
        .catch(async err => {
          let message = 'Something went wrong';
          if (err instanceof Response) {
            const text = await err.text();
            try {
              const res = JSON.parse(text);
              message = res.message || message;
            } catch {
              message = text || message;
            }
          } else if (err.message) {
            message = err.message;
          }
          window.showToast({
            title: 'Users 🙍‍♂️',
            message: message,
            type: 'bg-danger',
            animation: 'animate__fadeInUp',
            time: 'Just now',
            delay: 3000
          });
        });
    });

    // clearing form data when offcanvas hidden
    offCanvasForm.addEventListener('hidden.bs.offcanvas', function () {
      fv.resetForm(true);
    });
  }

  // Phone mask initialization
  const phoneMaskList = document.querySelectorAll('.phone-mask');

  if (phoneMaskList) {
    phoneMaskList.forEach(function (phoneMask) {
      phoneMask.addEventListener('input', event => {
        let input = event.target.value.replace(/[^+\d]/g, ''); // allow + and digits only
        input = input.substring(0, 10);
        // Format phone digits as 3-3-4
        let formattedPhone = input;
        if (input.length > 6) {
          formattedPhone = input.replace(/(\d{3})(\d{3})(\d{0,4})/, '$1 $2 $3');
        } else if (input.length > 3) {
          formattedPhone = input.replace(/(\d{3})(\d{0,3})/, '$1 $2');
        }

        phoneMask.value = formattedPhone.trim();
      });
    });
  }
});
