/**
 * app-ecommerce-order-list Script
 */

'use strict';

// Datatable (js)

document.addEventListener('DOMContentLoaded', function (e) {
  let borderColor, bodyBg, headingColor;

  borderColor = config.colors.borderColor;
  bodyBg = config.colors.bodyBg;
  headingColor = config.colors.headingColor;

  // Variable declaration for table

  const dt_order_table = document.querySelector('.datatables-order'),
    statusObj = {
      Placed: { title: 'Placed', class: 'bg-label-warning' },
      Accepted: { title: 'Accepted', class: 'bg-label-primary' },
      Preparing: { title: 'Preparing', class: 'bg-label-info' },
      Cancelled: { title: 'Cancelled', class: 'bg-label-danger' },
      Dispatched: { title: 'Dispatched', class: 'bg-label-secondary' },
      Delivered: { title: 'Delivered', class: 'bg-label-success' },
      'Out for Delivery': { title: 'Out for Delivery', class: 'bg-label-primary' },
      Ready: { title: 'Ready to Pickup', class: 'bg-label-info' }
    },
    paymentObj = {
      Paid: { title: 'Paid', class: 'text-success' },
      Pending: { title: 'Pending', class: 'text-warning' },
      Failed: { title: 'Failed', class: 'text-danger' },
      Cancelled: { title: 'Cancelled', class: 'text-secondary' }
    },
    paymentType = {
      Cash: { title: 'Cash', class: 'text-info' },
      Online: { title: 'Online', class: 'text-success' },
      Wallet: { title: 'Wallet', class: 'text-primary' }
    };
  // Helper to populate dropdown from JS object
  function populateDropdown(obj, containerSelector, labelText, selectId) {
    const container = document.querySelector(containerSelector);

    // Clear container
    container.innerHTML = '';

    // Create label
    if (labelText) {
      const label = document.createElement('label');
      label.setAttribute('for', selectId);
      label.className = 'form-label';
      label.textContent = labelText;
      container.appendChild(label);
    }

    // Create select element
    const select = document.createElement('select');
    select.className = 'form-select';
    if (selectId) select.id = selectId;

    // Add first option "All"
    const allOption = document.createElement('option');
    allOption.value = '';
    allOption.textContent = 'All';
    select.appendChild(allOption);

    // Add options from object
    Object.keys(obj).forEach(key => {
      const opt = document.createElement('option');
      opt.value = key;
      opt.textContent = obj[key].title;
      select.appendChild(opt);
    });

    // Append select to container
    container.appendChild(select);
  }

  // Usage
  populateDropdown(statusObj, '.order_status', 'Order Status', 'OrderStatus');
  populateDropdown(paymentType, '.payment_type', 'Payment Type', 'PaymentType');
  populateDropdown(paymentObj, '.payment_status', 'Payment Status', 'PaymentStatus');

  function getUserId() {
    return (
      (window.permissions && window.permissions.UserId) ||
      $('.datatables-order').data('user-id') ||
      $('#user_id').val() ||
      new URLSearchParams(location.search).get('user_id') ||
      null
    );
  }
  function getDriverId() {
    return (
      (window.permissions && window.permissions.DriverId) ||
      $('.datatables-order').data('driver-id') ||
      $('#driver_id').val() ||
      new URLSearchParams(location.search).get('driver_id') ||
      null
    );
  }
  function getStoreId() {
    return (
      (window.permissions && window.permissions.StoreId) ||
      $('.datatables-order').data('store-id') ||
      $('#store_id').val() ||
      new URLSearchParams(location.search).get('store_id') ||
      null
    );
  }

  // E-commerce Products datatable

  if (dt_order_table) {
    const dt_order = new DataTable(dt_order_table, {
      processing: true,
      serverSide: true,
      ajax: {
        url: baseURL + '/order-list',
        type: 'GET',
        data: function (d) {
          d.status = $('#OrderStatus').length ? $('#OrderStatus').val() : null;
          d.payment_type = $('#PaymentType').length ? $('#PaymentType').val() : null;
          d.payment_status = $('#PaymentStatus').length ? $('#PaymentStatus').val() : null;
          d.customer_id = $('#Customer').length ? $('#Customer').val() : null;

          const uid = getUserId();
          if (uid) {
            d.user_id = uid;
          }
          const sid = getStoreId();
          if (sid) {
            d.store_id = sid;
          }
          const did = getDriverId();
          if (did) {
            d.driver_id = did;
          }
        }
      },
      columns: [
        // columns according to JSON
        { data: 'id' },
        { data: 'id', orderable: false, render: DataTable.render.select() },
        { data: 'order_id' },
        { data: 'user_id' },
        { data: 'customer' }, //email //avatar
        { data: 'payment_status' },
        { data: 'status' },
        { data: 'payment_type' }, //method_number
        { data: 'id' }
      ],
      createdRow: function (row, data) {
        $(row).attr('id', `trRow-${data.id}`);
      },
      drawCallback: function () {
        this.api()
          .table()
          .rows({ page: 'current' })
          .every(function () {
            const data = this.data();
            const ratingEl = document.getElementById(`rating-${data.id}`);
            let r = parseInt(window.Helpers.getCssVar('gray-200', true).slice(1, 3), 16);
            let g = parseInt(window.Helpers.getCssVar('gray-200', true).slice(3, 5), 16);
            let b = parseInt(window.Helpers.getCssVar('gray-200', true).slice(5, 7), 16);
            if (ratingEl && !ratingEl.dataset.initialized) {
              new Raty(ratingEl, {
                score: data.rating ?? 0,
                readOnly: true,
                starOn:
                  "data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' width='16' %3E%3Cpath fill='%23FFD700' d='M21.947 9.179a1 1 0 0 0-.868-.676l-5.701-.453l-2.467-5.461a.998.998 0 0 0-1.822-.001L8.622 8.05l-5.701.453a1 1 0 0 0-.619 1.713l4.213 4.107l-1.49 6.452a1 1 0 0 0 1.53 1.057L12 18.202l5.445 3.63a1.001 1.001 0 0 0 1.517-1.106l-1.829-6.4l4.536-4.082c.297-.268.406-.686.278-1.065'/%3E%3C/svg%3E",
                starOff: `data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' width='16' %3E%3Cpath fill='rgb(${r},${g},${b})' d='M21.947 9.179a1 1 0 0 0-.868-.676l-5.701-.453l-2.467-5.461a.998.998 0 0 0-1.822-.001L8.622 8.05l-5.701.453a1 1 0 0 0-.619 1.713l4.213 4.107l-1.49 6.452a1 1 0 0 0 1.53 1.057L12 18.202l5.445 3.63a1.001 1.001 0 0 0 1.517-1.106l-1.829-6.4l4.536-4.082c.297-.268.406-.686.278-1.065'/%3E%3C/svg%3E`,
                starHalf:
                  "data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' width='16'%3E%3Cdefs%3E%3CclipPath id='halfStar'%3E%3Crect x='0' y='0' width='12' height='24'/%3E%3C/clipPath%3E%3C/defs%3E%3Cpath fill='%23FFD700' clip-path='url(%23halfStar)' d='M21.947 9.179a1 1 0 0 0-.868-.676l-5.701-.453l-2.467-5.461a.998.998 0 0 0-1.822-.001L8.622 8.05l-5.701.453a1 1 0 0 0-.619 1.713l4.213 4.107l-1.49 6.452a1 1 0 0 0 1.53 1.057L12 18.202l5.445 3.63a1.001 1.001 0 0 0 1.517-1.106l-1.829-6.4l4.536-4.082c.297-.268.406-.686.278-1.065'/%3E%3Cpath fill='none' stroke='%23FFD700' stroke-width='0' d='M0 0h24v24H0z'/%3E%3C/svg%3E"
              }).init();
              ratingEl.dataset.initialized = true;
            }
          });
      },
      columnDefs: [
        {
          // For Responsive
          className: 'control',
          searchable: false,
          orderable: true,
          responsivePriority: 2,
          targets: 0,
          render: function (data, type, full, meta) {
            return meta.row + meta.settings._iDisplayStart + 1;
          }
        },
        {
          // For Checkboxes
          targets: 1,
          orderable: false,
          searchable: false,
          responsivePriority: 3,
          checkboxes: true,
          visible: false,
          render: function () {
            return '<input type="checkbox" class="dt-checkboxes form-check-input">';
          },
          checkboxes: {
            selectAllRender: '<input type="checkbox" class="form-check-input">'
          }
        },
        {
          // Order ID
          targets: 2,
          render: function (data, type, full, meta) {
            return `  <a href="${baseURL}/orders/${full.id}">${full.order_id}</a><div class="rating read-only-ratings raty d-flex" data-score="${full.rating ?? 0}" id="rating-${full.id}"></small></div>`;
          }
        },
        {
          targets: 3,
          render: function (data, type, full, meta) {
            const dateObj = new Date(full.created_at);

            const formattedDate = dateObj.toLocaleDateString('en-US', {
              month: 'short',
              day: 'numeric',
              year: 'numeric'
            });

            const formattedTime = dateObj.toLocaleTimeString('en-US', {
              hour: '2-digit',
              minute: '2-digit',
              hour12: true
            });

            return `<span class="text-nowrap">${formattedDate}<br><small> ${formattedTime}</small></span>`;
          }
        },

        {
          targets: 4,
          responsivePriority: 1,
          render: function (data, type, full, meta) {
            const name = full['customer'];
            const email = full['email'];
            const avatar = full['avatar'];
            let output;

            if (avatar) {
              // For Avatar image
              output = `<img src="${avatar}" alt="Avatar" class="rounded-circle">`;
            } else {
              // For Avatar badge
              const stateNum = Math.floor(Math.random() * 6);
              const states = ['success', 'danger', 'warning', 'info', 'dark', 'primary', 'secondary'];
              const state = states[stateNum];
              const initials = (name.match(/\b\w/g) || []).slice(0, 2).join('').toUpperCase();

              output = `<span class="avatar-initial rounded-circle bg-label-${state}">${initials}</span>`;
            }

            // Creates full output for row
            const rowOutput = `
              <div class="d-flex justify-content-start align-items-center order-name text-nowrap">
                <div class="avatar-wrapper">
                  <div class="avatar avatar-sm me-3">
                    ${output}
                  </div>
                </div>
                <div class="d-flex flex-column">
                  <h6 class="m-0">
        ${
          full.user_type === 'Admin'
            ? `<a href="${baseURL}/users/${full.user_id}" class="text-heading">${name}</a>`
            : `<span class="text-heading">${name}</span>`
        }
      </h6>
                  <small>${email}</small>
                </div>
              </div>`;

            return rowOutput;
          }
        },
        {
          targets: 5,
          render: function (data, type, full, meta) {
            const payment = full['payment_status'];
            const paymentStatus = paymentObj[payment];
            if (paymentStatus) {
              return `
                <h6 class="mb-0 align-items-center d-flex w-px-100 ${paymentStatus.class}">
                  ${paymentStatus.title}
                </h6>${full.currency}${full.grand_total}<br><small>Txn:  <span title="${full.txn ?? 'N/A'}">
          ${full.txn && full.txn.length > 10 ? full.txn.substring(0, 10) + '...' : (full.txn ?? 'N/A')}
        </span></small>`;
            }
            return data;
          }
        },
        {
          targets: -3,
          render: function (data, type, full, meta) {
            const status = full['status'];
            const statusInfo = statusObj[status];
            if (statusInfo) {
              let html = `
        <span class="badge px-2 ${statusInfo.class} text-capitalized">
          ${statusInfo.title}
        </span>`;
              if (full.prescriptions) {
                html += `<br>
          <button class="btn btn-sm btn-primary mt-1 view-prescription" title="Prescriptions" data-image="${full.prescription_image}">
            <i class="icon-base ti tabler-prescription"></i>
          </button>
        `;
              }
              return html;
            }
            return data;
          }
        },

        {
          targets: -2,
          visible: false,
          render: function (data, type, full, meta) {
            let method = full['payment_type'];
            return `
              <div class="d-flex align-items-center text-nowrap">
                <span>${method}</span>
              </div>`;
          }
        },
        {
          targets: -1,
          title: 'Actions',
          searchable: false,
          orderable: false,
          render: function (data, type, full, meta) {
            if (!full.is_ride && authTYPE == 'Admin') {
              var ride = `<button title="Assign Driver Manually" class="btn btn-text-secondary rounded-pill waves-effect btn-icon assignDriver hideCar-${full.id}" data-order-id="${full.id}">
                  <i class="icon-base ti tabler-car"></i>
                </button>`;
            } else {
              var ride = '';
            }
            return `
              <div class="d-flex justify-content-sm-start align-items-sm-center">${ride}
                <button class="btn btn-text-secondary rounded-pill waves-effect btn-icon dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                  <i class="icon-base ti tabler-dots-vertical"></i>
                </button>
                <div class="dropdown-menu dropdown-menu-end m-0">
                  <a href="${baseURL}/orders/${full.id}" class="dropdown-item">View</a>
                </div>
              </div>`;
          }
        }
      ],
      select: {
        style: 'multi',
        selector: 'td:nth-child(2)'
      },
      order: [[0, 'desc']],
      layout: {
        topStart: {
          search: {
            placeholder: 'Search Order',
            text: '_INPUT_'
          }
        },
        topEnd: {
          rowClass: 'row mx-3 my-0 justify-content-between',
          features: [
            {
              pageLength: {
                menu: [7, 10, 25, 50, 100],
                text: '_MENU_'
              }
            },
            {
              buttons: [
                {
                  extend: 'collection',
                  className: 'btn btn-label-primary dropdown-toggle',
                  text: '<span class="d-flex align-items-center gap-1"><i class="icon-base ti tabler-upload icon-xs"></i> <span class="d-none d-sm-inline-block">Export</span></span>',
                  buttons: [
                    {
                      extend: 'print',
                      text: `<span class="d-flex align-items-center"><i class="icon-base ti tabler-printer me-1"></i>Print</span>`,
                      className: 'dropdown-item',
                      exportOptions: {
                        columns: [2, 3, 4, 5, 6, 7],
                        format: {
                          body: function (inner, coldex, rowdex) {
                            if (inner.length <= 0) return inner;
                            const el = new DOMParser().parseFromString(inner, 'text/html').body.childNodes;
                            let result = '';
                            el.forEach(item => {
                              if (item.classList && item.classList.contains('user-name')) {
                                result += item.lastChild.firstChild.textContent;
                              } else {
                                result += item.textContent || item.innerText || '';
                              }
                            });
                            return result;
                          }
                        }
                      },
                      customize: function (win) {
                        win.document.body.style.color = headingColor;
                        win.document.body.style.borderColor = borderColor;
                        win.document.body.style.backgroundColor = bodyBg;
                        const table = win.document.body.querySelector('table');
                        table.classList.add('compact');
                        table.style.color = 'inherit';
                        table.style.borderColor = 'inherit';
                        table.style.backgroundColor = 'inherit';
                      }
                    },
                    {
                      extend: 'csv',
                      text: `<span class="d-flex align-items-center"><i class="icon-base ti tabler-file me-1"></i>Csv</span>`,
                      className: 'dropdown-item',
                      exportOptions: {
                        columns: [2, 3, 4, 5, 6, 7],
                        format: {
                          body: function (inner, coldex, rowdex) {
                            if (inner.length <= 0) return inner;
                            const el = new DOMParser().parseFromString(inner, 'text/html').body.childNodes;
                            let result = '';
                            el.forEach(item => {
                              if (item.classList && item.classList.contains('user-name')) {
                                result += item.lastChild.firstChild.textContent;
                              } else {
                                result += item.textContent || item.innerText || '';
                              }
                            });
                            return result;
                          }
                        }
                      }
                    },
                    {
                      extend: 'excel',
                      text: `<span class="d-flex align-items-center"><i class="icon-base ti tabler-upload me-1"></i>Excel</span>`,
                      className: 'dropdown-item',
                      exportOptions: {
                        columns: [2, 3, 4, 5, 6, 7],
                        format: {
                          body: function (inner, coldex, rowdex) {
                            if (inner.length <= 0) return inner;
                            const el = new DOMParser().parseFromString(inner, 'text/html').body.childNodes;
                            let result = '';
                            el.forEach(item => {
                              if (item.classList && item.classList.contains('user-name')) {
                                result += item.lastChild.firstChild.textContent;
                              } else {
                                result += item.textContent || item.innerText || '';
                              }
                            });
                            return result;
                          }
                        }
                      }
                    },
                    {
                      extend: 'pdf',
                      text: `<span class="d-flex align-items-center"><i class="icon-base ti tabler-file-text me-1"></i>Pdf</span>`,
                      className: 'dropdown-item',
                      exportOptions: {
                        columns: [2, 3, 4, 5, 6, 7],
                        format: {
                          body: function (inner, coldex, rowdex) {
                            if (inner.length <= 0) return inner;
                            const el = new DOMParser().parseFromString(inner, 'text/html').body.childNodes;
                            let result = '';
                            el.forEach(item => {
                              if (item.classList && item.classList.contains('user-name')) {
                                result += item.lastChild.firstChild.textContent;
                              } else {
                                result += item.textContent || item.innerText || '';
                              }
                            });
                            return result;
                          }
                        }
                      }
                    },
                    {
                      extend: 'copy',
                      text: `<i class="icon-base ti tabler-copy me-1"></i>Copy`,
                      className: 'dropdown-item',
                      exportOptions: {
                        columns: [2, 3, 4, 5, 6, 7],
                        format: {
                          body: function (inner, coldex, rowdex) {
                            if (inner.length <= 0) return inner;
                            const el = new DOMParser().parseFromString(inner, 'text/html').body.childNodes;
                            let result = '';
                            el.forEach(item => {
                              if (item.classList && item.classList.contains('user-name')) {
                                result += item.lastChild.firstChild.textContent;
                              } else {
                                result += item.textContent || item.innerText || '';
                              }
                            });
                            return result;
                          }
                        }
                      }
                    }
                  ]
                }
              ]
            }
          ]
        },
        bottomStart: {
          rowClass: 'row mx-3 justify-content-between',
          features: ['info']
        },
        bottomEnd: 'paging'
      },
      language: {
        paginate: {
          next: '<i class="icon-base ti tabler-chevron-right scaleX-n1-rtl icon-18px"></i>',
          previous: '<i class="icon-base ti tabler-chevron-left scaleX-n1-rtl icon-18px"></i>',
          first: '<i class="icon-base ti tabler-chevrons-left scaleX-n1-rtl icon-18px"></i>',
          last: '<i class="icon-base ti tabler-chevrons-right scaleX-n1-rtl icon-18px"></i>'
        }
      },
      // For responsive popup
      responsive: {
        details: {
          display: DataTable.Responsive.display.modal({
            header: function (row) {
              const data = row.data();
              return 'Details of ' + data['customer'];
            }
          }),
          type: 'column',
          renderer: function (api, rowIdx, columns) {
            const data = columns
              .map(function (col) {
                return col.title !== '' // Do not show row in modal popup if title is blank (for check box)
                  ? `<tr data-dt-row="${col.rowIndex}" data-dt-column="${col.columnIndex}">
                      <td>${col.title}:</td>
                      <td>${col.data}</td>
                    </tr>`
                  : '';
              })
              .join('');

            if (data) {
              const div = document.createElement('div');
              div.classList.add('table-responsive');
              const table = document.createElement('table');
              div.appendChild(table);
              table.classList.add('table');
              const tbody = document.createElement('tbody');
              tbody.innerHTML = data;
              table.appendChild(tbody);
              return div;
            }
            return false;
          }
        }
      }
    });

    // Trigger server-side reload on filter change
    $('#OrderStatus, #PaymentType, #PaymentStatus, #Customer').on('change', function () {
      dt_order.draw();
    });

    // Fixed header
    if (window.Helpers.isNavbarFixed()) {
      const navHeight = document.getElementById('layout-navbar').offsetHeight;
      new DataTable.FixedHeader(dt_order).headerOffset(navHeight);
    } else {
      new DataTable.FixedHeader(dt_order);
    }
    //? The 'delete-record' class is necessary for the functionality of the following code.
    document.addEventListener('click', function (e) {
      if (e.target.classList.contains('delete-record')) {
        dt_order.row(e.target.closest('tr')).remove().draw();
        const modalEl = document.querySelector('.dtr-bs-modal');
        if (modalEl && modalEl.classList.contains('show')) {
          const modal = bootstrap.Modal.getInstance(modalEl);
          modal?.hide();
        }
      }
    });
    $(document).on('click', '.view-prescription', function () {
      const imageUrl = $(this).data('image');
      // Set image source in modal
      $('#prescriptionImage').attr('src', imageUrl);
      // Show modal
      $('#prescriptionModal').modal('show');
    });
  }

  // Filter form control to default size
  // ? setTimeout used for order-list table initialization
  setTimeout(() => {
    const elementsToModify = [
      { selector: '.dt-buttons .btn', classToRemove: 'btn-secondary', classToAdd: 'btn-label-secondary' },
      { selector: '.dt-search .form-control', classToRemove: 'form-control-sm', classToAdd: 'ms-0' },
      { selector: '.dt-length .form-select', classToRemove: 'form-select-sm' },
      { selector: '.dt-layout-table', classToRemove: 'row mt-2' },
      { selector: '.dt-layout-end', classToAdd: 'gap-md-2 gap-0' },
      { selector: '.dt-layout-full', classToRemove: 'col-md col-12', classToAdd: 'table-responsive' }
    ];

    // Delete record
    elementsToModify.forEach(({ selector, classToRemove, classToAdd }) => {
      document.querySelectorAll(selector).forEach(element => {
        if (classToRemove) {
          classToRemove.split(' ').forEach(className => element.classList.remove(className));
        }
        if (classToAdd) {
          classToAdd.split(' ').forEach(className => element.classList.add(className));
        }
      });
    });
  }, 100);
});
