/**
 *  Form Wizard
 */

'use strict';

$(function () {
  const select2 = $('.select2'),
    selectPicker = $('.selectpicker');

  // Bootstrap select
  if (selectPicker.length) {
    selectPicker.selectpicker();
  }

  // select2
  if (select2.length) {
    select2.each(function () {
      var $this = $(this);
      $this.wrap('<div class="position-relative"></div>');
      $this.select2({
        placeholder: 'Select value',
        dropdownParent: $this.parent()
      });
    });
  }
});

(function () {
  // Icons Modern Wizard
  // --------------------------------------------------------------------
  const wizardIconsModern = document.querySelector('.wizard-modern-icons-example');

  if (typeof wizardIconsModern !== undefined && wizardIconsModern !== null) {
    const wizardIconsModernBtnNextList = [].slice.call(wizardIconsModern.querySelectorAll('.btn-next')),
      wizardIconsModernBtnPrevList = [].slice.call(wizardIconsModern.querySelectorAll('.btn-prev')),
      wizardIconsModernBtnSubmit = wizardIconsModern.querySelector('.btn-submit');

    const modernIconsStepper = new Stepper(wizardIconsModern, {
      linear: false
    });
    // Reusable validation function
    function validateCurrentStep(stepper) {
      const currentStep = stepper.querySelector('.content.active');
      const inputs = currentStep.querySelectorAll('input, select, textarea');
      let isValid = true;

      inputs.forEach(input => {
        if (!input.checkValidity()) {
          isValid = false;
          input.classList.add('is-invalid');
        } else {
          input.classList.remove('is-invalid');
        }
      });

      if (!isValid) {
        const firstInvalid = currentStep.querySelector('.is-invalid');
        if (firstInvalid) {
          firstInvalid.scrollIntoView({ behavior: 'smooth', block: 'center' });
          firstInvalid.focus();
        }
      }

      return isValid;
    }

    // Step icon click navigation with validation
    wizardIconsModern.addEventListener('show.bs-stepper', function (event) {
      const currentIndex = modernIconsStepper._currentIndex;
      const nextIndex = event.detail.indexStep;
      //console.log(`Current Index: ${currentIndex}, Next Index: ${nextIndex}`);
      if (nextIndex > currentIndex) {
        const isValid = validateCurrentStep(wizardIconsModern);
        if (!isValid) {
          event.preventDefault(); // Stop step change
        }
      }
    });

    if (wizardIconsModernBtnNextList) {
      wizardIconsModernBtnNextList.forEach(wizardIconsModernBtnNext => {
        wizardIconsModernBtnNext.addEventListener('click', event => {
          if (validateCurrentStep(wizardIconsModern)) {
            modernIconsStepper.next();
          }
        });
      });
    }
    if (wizardIconsModernBtnPrevList) {
      wizardIconsModernBtnPrevList.forEach(wizardIconsModernBtnPrev => {
        wizardIconsModernBtnPrev.addEventListener('click', event => {
          modernIconsStepper.previous();
        });
      });
    }
    if (wizardIconsModernBtnSubmit) {
      wizardIconsModernBtnSubmit.addEventListener('click', event => {
        event.preventDefault(); // Prevent default submission
        const form = document.querySelector('.wizard-modern-icons-example form');
        const formData = new FormData(form);

        const carId = $('#car_id').val(); // Hidden input for edit mode
        if (carId) {
          formData.append('_method', 'PUT');
        }
        $.ajax({
          url: carId ? `${baseURL}/cars/${carId}` : `${baseURL}/cars`,
          method: carId ? 'POST' : 'POST', // or use 'PUT' for edit if supported
          data: formData,
          processData: false,
          contentType: false,
          headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          success(response) {
            if (response.status === 200 || response.success) {
              Swal.fire({
                icon: 'success',
                title: 'Success',
                text: response.message || 'Car saved successfully',
                customClass: {
                  confirmButton: 'btn btn-success'
                }
              }).then(() => {
                // optional redirect:
                window.location.href = `${baseURL}/cars`;
              });
            } else {
              Swal.fire({
                icon: 'error',
                title: 'Error',
                text: response.message || 'Something went wrong',
                customClass: {
                  confirmButton: 'btn btn-danger'
                }
              });
            }
          },
          error(xhr) {
            const msg = xhr.responseJSON?.message || 'Something went wrong';
            Swal.fire({
              icon: 'error',
              title: 'Error',
              text: msg,
              customClass: {
                confirmButton: 'btn btn-danger'
              }
            });
          }
        });
      });
    }
  }
})();
