<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
use Illuminate\Http\Request;

$app = Application::configure(basePath: dirname(__DIR__))
  ->withRouting(
    web: __DIR__ . '/../routes/web.php',
    api: __DIR__ . '/../routes/api.php',
    commands: __DIR__ . '/../routes/console.php',
    health: '/up',
  )
  ->withMiddleware(function (Middleware $middleware) {
    $middleware->alias([
      'admin' => \App\Http\Middleware\RedirectIfNotAdmin::class,
      'store' => \App\Http\Middleware\RedirectIfNotStore::class,
      'redirectAuthenticated' => \App\Http\Middleware\RedirectIfAuthenticated::class,
      'localization' => \App\Http\Middleware\Localization::class,
      'locale' => \App\Http\Middleware\LocaleMiddleware::class,
      'role' => \Spatie\Permission\Middleware\RoleMiddleware::class,
      'permission' => \Spatie\Permission\Middleware\PermissionMiddleware::class,
      'role_or_permission' => \Spatie\Permission\Middleware\RoleOrPermissionMiddleware::class,
      'abilities' => \Laravel\Sanctum\Http\Middleware\CheckAbilities::class,
      'ability' => \Laravel\Sanctum\Http\Middleware\CheckForAnyAbility::class, // Removed duplicate key
      'checkUserStatus' => \App\Http\Middleware\CheckUserStatus::class,
      'blockIfHighDues' => \App\Http\Middleware\BlockIfHighDues::class,
      'verified' => \App\Http\Middleware\EnsureEmailIsVerified::class,
    ]);


    // Web Middleware Group
    $middleware->web([
      \App\Http\Middleware\EncryptCookies::class,
      \Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse::class,
      \Illuminate\Session\Middleware\StartSession::class,
      \Laravel\Jetstream\Http\Middleware\AuthenticateSession::class,
      \Illuminate\View\Middleware\ShareErrorsFromSession::class,
      \Illuminate\Routing\Middleware\SubstituteBindings::class,
      \App\Http\Middleware\ActivityByUser::class,
    ]);

    // API Middleware Group
    $middleware->api([
      \Laravel\Sanctum\Http\Middleware\EnsureFrontendRequestsAreStateful::class,  // important for SPA, you can skip if using API tokens
      'throttle:api',
      \Illuminate\Routing\Middleware\SubstituteBindings::class,
    ]);

    $middleware->validateCsrfTokens(except: [
      'api/broadcasting/*',
    ]);
  })
  ->withExceptions(function (Exceptions $exceptions) {
    $exceptions->render(function (Throwable $exception, Request $request) {
      if ($exception instanceof \Illuminate\Auth\AuthenticationException) {
        if ($request->is('api/*')) {
          return response()->json([
            'message' => 'Not authenticated',
            'success' => false,
            'status' => 401,
          ], 401);
        } else {
          return redirect('login');
        }
      }
      // Handle other exceptions or fallback to default
      // return app(ExceptionHandler::class)->render($request, $exception);
    });
  })
  ->create();


return $app;
