<?php
namespace App\Traits;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\Storage;
trait ImageUploadTrait
{
  public function uploadImage(?UploadedFile $file, string $folder, ?string $oldPath = null): ?string
  {
    if (!$file) {
      return $oldPath;
    }
    // Delete old image if exists
    if ($oldPath && Storage::disk('public')->exists($oldPath)) {
      Storage::disk('public')->delete($oldPath);
    }
    return $file->store($folder, 'public');
  }

  public function uploadMultipleImages(array $fields, $request, string $baseFolder, ?object $model = null): array
  {
    $uploadedPaths = [];
    foreach ($fields as $field) {
      if ($request->hasFile($field)) {
        $oldPath = $model->$field ?? null;
        $uploadedPaths[$field] = $this->uploadImage(
          $request->file($field),
          "{$baseFolder}/{$field}",
          $oldPath
        );
      }
    }
    return $uploadedPaths;
  }
}
