<?php
namespace App\Services;
use Twilio\Rest\Client;
class SmsService
{
  public static function send($phone, $message)
  {
    try {
      $client = new Client(env('TWILIO_SID'), env('TWILIO_TOKEN'));

      $client->messages->create($phone, [
        'from' => env('TWILIO_FROM'),
        'body' => $message,
      ]);

    } catch (\Exception $e) {
      \Log::error("Twilio SMS failed for {$phone}: " . $e->getMessage());
    }
  }
}
