<?php
namespace App\Services;
use Illuminate\Support\Facades\Http;
class MoMoService
{
  protected $base;
  protected $clientId;
  protected $clientSecret;
  protected $callbackUrl;
  public function __construct()
  {
    $this->base = config('momo.base');
    $this->clientId = config('momo.client_id');
    $this->clientSecret = config('momo.client_secret');
    $this->callbackUrl = config('momo.callback_url');
  }

  public function requestToPay($amount, $msisdn, $externalId, $currency = 'GHS')
  {
    // build payload as per MoMo documentation
    $response = Http::withHeaders([
      'Authorization' => "Bearer " . $this->getAccessToken(),
      'X-Callback-URL' => $this->callbackUrl,
      'X-Reference-Id' => $externalId,
      'X-Currency' => $currency,
    ])->post($this->base . '/v1_0/requesttopay', [
          'amount' => $amount,
          'payer' => [
            'partyIdType' => 'MSISDN',
            'partyId' => $msisdn,
          ],
          'payerMessage' => 'Payment for order ' . $externalId,
          'payeeNote' => 'Ride payment',
        ]);

    return $response->json();
  }

  public function getRequestToPayStatus($externalId)
  {
    $response = Http::withHeaders([
      'Authorization' => "Bearer " . $this->getAccessToken(),
    ])->get($this->base . "/v1_0/requesttopay/{$externalId}");

    return $response->json();
  }

  protected function getAccessToken()
  {
    // Usually, you call the token endpoint once, cache token
    // Example:
    $resp = Http::withBasicAuth($this->clientId, $this->clientSecret)
      ->post($this->base . '/collection/token/');
    $data = $resp->json();
    return $data['access_token'] ?? null;
  }
}
